/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class CollectionExpression
extends ConstantExpression {
    public CollectionExpression() {
    }

    public CollectionExpression(Object object, Expression expression) {
        super(object, expression);
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter) {
        Object object = this.getLocalBase().getFieldValue(this.getValue(), this.getSession());
        expressionSQLPrinter.printList((Collection)object);
    }

    public Object valueFromObject(Object object, AbstractSession abstractSession, AbstractRecord abstractRecord, int n, boolean bl) {
        if (this.value instanceof Collection) {
            Collection collection = (Collection)this.value;
            Vector vector = new Vector(collection.size());
            for (Object object2 : collection) {
                object2 = object2 instanceof Expression ? ((Expression)object2).valueFromObject(object, abstractSession, abstractRecord, n, bl) : this.getLocalBase().getFieldValue(object2, abstractSession);
                vector.add(object2);
            }
            return vector;
        }
        return this.getLocalBase().getFieldValue(this.getValue(), abstractSession);
    }

    public void setLocalBase(Expression expression) {
        super.setLocalBase(expression);
        if (this.value instanceof Collection) {
            Collection collection = (Collection)this.value;
            for (Object e : collection) {
                if (!(e instanceof Expression)) continue;
                ((Expression)e).setLocalBase(expression);
            }
        }
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        if (this.value instanceof Collection) {
            Collection collection = (Collection)this.value;
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(collection.size());
            for (Object e : collection) {
                if (e instanceof Expression) {
                    ((Vector)nonSynchronizedVector).add(((Expression)e).copiedVersionFrom(map));
                    continue;
                }
                ((Vector)nonSynchronizedVector).add(e);
            }
            this.value = nonSynchronizedVector;
        }
    }
}

