/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class SQLInsertStatement
extends SQLModifyStatement {
    protected SQLCall buildCallWithoutReturning(AbstractSession abstractSession) {
        SQLCall sQLCall = new SQLCall();
        sQLCall.returnNothing();
        CharArrayWriter charArrayWriter = new CharArrayWriter(200);
        try {
            int n;
            DatabaseField databaseField;
            charArrayWriter.write("INSERT ");
            if (this.getHintString() != null) {
                charArrayWriter.write(this.getHintString());
                charArrayWriter.write(" ");
            }
            charArrayWriter.write("INTO ");
            charArrayWriter.write(this.getTable().getQualifiedName());
            charArrayWriter.write(" (");
            Vector<DatabaseField> vector = new Vector<DatabaseField>();
            Enumeration enumeration = this.getModifyRow().keys();
            while (enumeration.hasMoreElements()) {
                databaseField = (DatabaseField)enumeration.nextElement();
                if (!databaseField.getTable().equals(this.getTable()) && databaseField.hasTableName()) continue;
                vector.addElement(databaseField);
            }
            if (vector.isEmpty()) {
                throw QueryException.objectToInsertIsEmpty(this.getTable());
            }
            for (n = 0; n < vector.size(); ++n) {
                charArrayWriter.write(((DatabaseField)vector.elementAt(n)).getName());
                if (n + 1 >= vector.size()) continue;
                charArrayWriter.write(", ");
            }
            charArrayWriter.write(") VALUES (");
            for (n = 0; n < vector.size(); ++n) {
                databaseField = (DatabaseField)vector.elementAt(n);
                sQLCall.appendModify(charArrayWriter, databaseField);
                if (n + 1 >= vector.size()) continue;
                charArrayWriter.write(", ");
            }
            charArrayWriter.write(")");
            sQLCall.setSQLString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return sQLCall;
    }
}

