/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;

public class IdentityMapKeyEnumeration
implements Enumeration {
    protected FullIdentityMap map;
    protected Iterator cacheKeysIterator;
    protected CacheKey nextKey;

    public IdentityMapKeyEnumeration(FullIdentityMap fullIdentityMap) {
        this.map = fullIdentityMap;
        this.cacheKeysIterator = fullIdentityMap.getCacheKeys().values().iterator();
    }

    public boolean hasMoreElements() {
        this.nextKey = this.getNextCacheKey();
        return this.nextKey != null;
    }

    public Object nextElement() {
        if (this.nextKey == null) {
            throw new NoSuchElementException("IdentityMapKeyEnumeration nextElement");
        }
        this.nextKey.checkReadLock();
        return this.nextKey;
    }

    protected CacheKey getNextCacheKey() {
        CacheKey cacheKey = null;
        while (this.cacheKeysIterator.hasNext() && cacheKey == null) {
            cacheKey = (CacheKey)this.cacheKeysIterator.next();
        }
        return cacheKey;
    }
}

