/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakUnitOfWorkIdentityMap;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityMapManager
implements Serializable,
Cloneable {
    protected Map<Class, IdentityMap> identityMaps;
    protected Map queryResults;
    protected AbstractSession session;
    protected transient ConcurrencyManager cacheMutex;
    protected IdentityMap lastAccessedIdentityMap = null;
    protected transient WriteLockManager writeLockManager;
    protected Boolean isCacheAccessPreCheckRequired;

    public IdentityMapManager(AbstractSession abstractSession) {
        this.session = abstractSession;
        this.cacheMutex = new ConcurrencyManager();
        if (abstractSession.isUnitOfWork()) {
            this.identityMaps = new HashMap<Class, IdentityMap>();
        } else if (abstractSession.isIsolatedClientSession()) {
            this.identityMaps = new HashMap<Class, IdentityMap>();
            this.queryResults = new HashMap();
        } else {
            this.identityMaps = new ConcurrentHashMap<Class, IdentityMap>();
            this.queryResults = new ConcurrentHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireDeferredLock(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(classDescriptor).acquireDeferredLock(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(classDescriptor).acquireDeferredLock(vector);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLock(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(classDescriptor).acquireLock(vector, bl);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(classDescriptor).acquireLock(vector, bl);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLockNoWait(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(classDescriptor).acquireLockNoWait(vector, bl);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(classDescriptor).acquireLockNoWait(vector, bl);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLockWithWait(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor, int n) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(classDescriptor).acquireLockWithWait(vector, bl, n);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(classDescriptor).acquireLockWithWait(vector, bl, n);
        }
        return cacheKey;
    }

    protected boolean isCacheAccessPreCheckRequired() {
        if (this.isCacheAccessPreCheckRequired == null) {
            this.isCacheAccessPreCheckRequired = this.getSession().getProfiler() != null || this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCacheAccessPreCheckRequired;
    }

    public void clearCacheAccessPreCheck() {
        this.isCacheAccessPreCheckRequired = null;
    }

    public void acquireReadLock() {
        this.getSession().startOperationProfile("cache");
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().acquireReadLock();
        }
        this.getSession().endOperationProfile("cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKey(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(classDescriptor).acquireReadLockOnCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(classDescriptor).acquireReadLockOnCacheKey(vector);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(classDescriptor).acquireReadLockOnCacheKeyNoWait(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(classDescriptor).acquireReadLockOnCacheKeyNoWait(vector);
        }
        return cacheKey;
    }

    public boolean acquireWriteLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getSession().getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().acquire();
            return true;
        }
        return false;
    }

    public IdentityMap buildNewIdentityMapForUnitOfWork(UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        ReferenceMode referenceMode = unitOfWorkImpl.getReferenceMode();
        if (referenceMode == ReferenceMode.FORCE_WEAK) {
            return new WeakUnitOfWorkIdentityMap(32, classDescriptor);
        }
        if (referenceMode == ReferenceMode.WEAK && classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            return new WeakUnitOfWorkIdentityMap(32, classDescriptor);
        }
        return new UnitOfWorkIdentityMap(32, classDescriptor);
    }

    public IdentityMap buildNewIdentityMap(ClassDescriptor classDescriptor) throws ValidationException, DescriptorException {
        if (this.getSession().isUnitOfWork()) {
            if (((UnitOfWorkImpl)this.getSession()).getReferenceMode() == ReferenceMode.FORCE_WEAK) {
                return new WeakUnitOfWorkIdentityMap(32, classDescriptor);
            }
            if (((UnitOfWorkImpl)this.getSession()).getReferenceMode() == ReferenceMode.WEAK && classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                return new WeakUnitOfWorkIdentityMap(32, classDescriptor);
            }
            return new UnitOfWorkIdentityMap(32, classDescriptor);
        }
        try {
            if (this.getSession().isRemoteSession()) {
                Constructor constructor = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(classDescriptor.getRemoteIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false));
                        IdentityMap identityMap = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{new Integer(classDescriptor.getRemoteIdentityMapSize()), classDescriptor}));
                        if (classDescriptor.getCacheInterceptorClass() != null) {
                            constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(classDescriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false));
                            Object[] objectArray = new Object[]{identityMap, this.getSession()};
                            identityMap = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, objectArray));
                        }
                        return identityMap;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw DescriptorException.invalidIdentityMap(classDescriptor, privilegedActionException.getException());
                    }
                }
                constructor = PrivilegedAccessHelper.getConstructorFor(classDescriptor.getRemoteIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false);
                IdentityMap identityMap = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{new Integer(classDescriptor.getRemoteIdentityMapSize()), classDescriptor});
                if (classDescriptor.getCacheInterceptorClass() != null) {
                    constructor = PrivilegedAccessHelper.getConstructorFor(classDescriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false);
                    Object[] objectArray = new Object[]{identityMap, this.getSession()};
                    identityMap = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, objectArray);
                }
                return identityMap;
            }
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(classDescriptor.getIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false));
                    IdentityMap identityMap = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{new Integer(classDescriptor.getIdentityMapSize()), classDescriptor}));
                    if (classDescriptor.getCacheInterceptorClass() != null) {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(classDescriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false));
                        Object[] objectArray = new Object[]{identityMap, this.getSession()};
                        identityMap = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, objectArray));
                    }
                    return identityMap;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw DescriptorException.invalidIdentityMap(classDescriptor, privilegedActionException.getException());
                }
            }
            constructor = PrivilegedAccessHelper.getConstructorFor(classDescriptor.getIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false);
            IdentityMap identityMap = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{new Integer(classDescriptor.getIdentityMapSize()), classDescriptor});
            if (classDescriptor.getCacheInterceptorClass() != null) {
                constructor = PrivilegedAccessHelper.getConstructorFor(classDescriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false);
                Object[] objectArray = new Object[]{identityMap, this.getSession()};
                identityMap = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, objectArray);
            }
            return identityMap;
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIdentityMap(classDescriptor, exception);
        }
    }

    public void clearLastAccessedIdentityMap() {
        this.lastAccessedIdentityMap = null;
    }

    public Object clone() {
        IdentityMapManager identityMapManager = null;
        try {
            identityMapManager = (IdentityMapManager)super.clone();
            identityMapManager.setIdentityMaps(new ConcurrentHashMap());
            for (Map.Entry<Class, IdentityMap> entry : this.identityMaps.entrySet()) {
                identityMapManager.identityMaps.put(entry.getKey(), (IdentityMap)entry.getValue().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        return identityMapManager;
    }

    public void clearQueryCache() {
        this.queryResults = new ConcurrentHashMap();
    }

    public void clearQueryCache(ReadQuery readQuery) {
        if (readQuery != null) {
            this.queryResults.remove(readQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (vector.get(i) != null) continue;
            return false;
        }
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                boolean bl = identityMap.containsKey(vector);
                return bl;
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        }
        return identityMap.containsKey(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, int n, boolean bl) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        this.getSession().startOperationProfile("cache");
        Vector<Object> vector = null;
        try {
            Cloneable cloneable;
            if (expression != null && ((ExpressionBuilder)(cloneable = expression.getBuilder())).getSession() == null) {
                ((ExpressionBuilder)cloneable).setSession(this.getSession().getRootSession(null));
                ((ExpressionBuilder)cloneable).setQueryClass(clazz);
            }
            vector = new Vector<Object>();
            cloneable = this.getIdentityMap(classDescriptor);
            long l = System.currentTimeMillis();
            Enumeration enumeration = cloneable.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                CacheKey cacheKey = (CacheKey)enumeration.nextElement();
                if (cacheKey.getObject() == null || !bl && classDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, l) || (object = cacheKey.getObject()) == null || object.getClass() != clazz && !clazz.isInstance(object)) continue;
                if (expression == null) {
                    vector.add(object);
                    this.getSession().incrementProfile("CacheHits");
                    continue;
                }
                try {
                    if (!expression.doesConform(object, this.getSession(), (AbstractRecord)record, n)) continue;
                    vector.addElement(object);
                    this.getSession().incrementProfile("CacheHits");
                }
                catch (QueryException queryException) {
                    if (queryException.getErrorCode() != 6092) throw queryException;
                    if (n == 2) {
                        vector.add(object);
                        this.getSession().incrementProfile("CacheHits");
                        continue;
                    }
                    if (n != 0) continue;
                    throw queryException;
                    return vector;
                }
            }
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey getCacheKeyForObjectForLock(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.getCacheKeyForLock(vector);
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        } else {
            cacheKey = identityMap.getCacheKeyForLock(vector);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey getCacheKeyForObject(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.getCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        } else {
            cacheKey = identityMap.getCacheKey(vector);
        }
        return cacheKey;
    }

    public ConcurrencyManager getCacheMutex() {
        return this.cacheMutex;
    }

    public Vector getClassesRegistered() {
        Iterator<Class> iterator = this.getIdentityMaps().keySet().iterator();
        Vector<String> vector = new Vector<String>(this.getIdentityMaps().size());
        while (iterator.hasNext()) {
            vector.add(iterator.next().getName());
        }
        return vector;
    }

    public Object getFromIdentityMap(Object object) {
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(object);
        Vector vector = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        return this.getFromIdentityMap(vector, object.getClass(), classDescriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        return this.getFromIdentityMap(vector, clazz, true, classDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        CacheKey cacheKey;
        if (vector == null) {
            return null;
        }
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        Object object = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.getCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = identityMap.getCacheKey(vector);
        }
        if (cacheKey != null && (bl || !classDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            object = cacheKey.getObject();
            cacheKey.checkReadLock();
            object = this.checkForInheritance(object, clazz, classDescriptor);
        }
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (object == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, int n, boolean bl, boolean bl2, ClassDescriptor classDescriptor) {
        UnitOfWorkImpl unitOfWorkImpl = bl ? (UnitOfWorkImpl)this.getSession() : null;
        this.getSession().startOperationProfile("cache");
        try {
            Cloneable cloneable;
            if (expression != null && ((ExpressionBuilder)(cloneable = expression.getBuilder())).getSession() == null) {
                ((ExpressionBuilder)cloneable).setSession(this.getSession().getRootSession(null));
                ((ExpressionBuilder)cloneable).setQueryClass(clazz);
            }
            cloneable = this.getIdentityMap(classDescriptor);
            long l = System.currentTimeMillis();
            Enumeration enumeration = cloneable.keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                CacheKey cacheKey = (CacheKey)enumeration.nextElement();
                if (!bl2 && classDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, l) || (object = cacheKey.getObject()) == null || object.getClass() != clazz && !clazz.isInstance(object)) continue;
                if (!(expression != null || bl && unitOfWorkImpl.isObjectDeleted(object))) {
                    this.getSession().incrementProfile("CacheHits");
                    Object object2 = object;
                    this.getSession().endOperationProfile("cache");
                    return object2;
                }
                if (!expression.doesConform(object, this.getSession(), (AbstractRecord)record, n) || bl && unitOfWorkImpl.isObjectDeleted(object)) continue;
                this.getSession().incrementProfile("CacheHits");
                Object object3 = object;
                this.getSession().endOperationProfile("cache");
                return object3;
            }
            return null;
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, boolean bl, ClassDescriptor classDescriptor) {
        CacheKey cacheKey;
        if (vector == null) {
            this.getSession().incrementProfile("CacheMisses");
            return null;
        }
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        Object object = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.getCacheKey(vector);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = identityMap.getCacheKey(vector);
        }
        if (cacheKey != null && (bl || !classDescriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            object = cacheKey.getObject();
            cacheKey.checkDeferredLock();
            object = this.checkForInheritance(object, clazz, classDescriptor);
        }
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (object == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return object;
    }

    public IdentityMap getIdentityMap(ClassDescriptor classDescriptor) {
        if (classDescriptor.hasInheritance()) {
            classDescriptor = classDescriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        Class clazz = classDescriptor.getJavaClass();
        IdentityMap identityMap = this.lastAccessedIdentityMap;
        if (identityMap != null && identityMap.getDescriptorClass() == clazz) {
            return identityMap;
        }
        IdentityMap identityMap2 = this.identityMaps.get(clazz);
        if (identityMap2 == null) {
            IdentityMap identityMap3 = null;
            if (this.session.isUnitOfWork()) {
                identityMap3 = this.buildNewIdentityMapForUnitOfWork((UnitOfWorkImpl)this.session, classDescriptor);
                identityMap2 = this.identityMaps.put(clazz, identityMap3);
            } else if (this.session.isIsolatedClientSession()) {
                identityMap3 = this.buildNewIdentityMap(classDescriptor);
                identityMap2 = this.identityMaps.put(clazz, identityMap3);
            } else {
                identityMap3 = this.buildNewIdentityMap(classDescriptor);
                identityMap2 = ((ConcurrentMap)this.identityMaps).putIfAbsent(clazz, identityMap3);
            }
            if (identityMap2 == null) {
                identityMap2 = identityMap3;
            }
        }
        this.lastAccessedIdentityMap = identityMap2;
        return identityMap2;
    }

    protected Map<Class, IdentityMap> getIdentityMaps() {
        return this.identityMaps;
    }

    public Iterator getIdentityMapClasses() {
        return this.getIdentityMaps().keySet().iterator();
    }

    public Object getQueryResult(ReadQuery readQuery, Vector vector, boolean bl) {
        CacheKey cacheKey;
        if (readQuery.getQueryResultsCachePolicy() == null) {
            return null;
        }
        IdentityMap identityMap = (IdentityMap)this.queryResults.get(readQuery);
        if (identityMap == null) {
            return null;
        }
        Vector vector2 = vector;
        if (vector2 == null) {
            vector2 = new Vector();
        }
        if ((cacheKey = identityMap.getCacheKey(vector2)) == null || bl && readQuery.getQueryResultsCachePolicy().getCacheInvalidationPolicy().isInvalidated(cacheKey)) {
            return null;
        }
        return cacheKey.getObject();
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWrapper(Vector vector, Class clazz) {
        Object object;
        ClassDescriptor classDescriptor = this.session.getDescriptor(clazz);
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.session.startOperationProfile("cache");
            this.acquireReadLock();
            try {
                object = identityMap.getWrapper(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("cache");
        } else {
            object = identityMap.getWrapper(vector);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteLockManager getWriteLockManager() {
        IdentityMapManager identityMapManager = this;
        synchronized (identityMapManager) {
            if (this.writeLockManager == null) {
                this.writeLockManager = new WriteLockManager();
            }
        }
        return this.writeLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWriteLockValue(Vector vector, Class clazz, ClassDescriptor classDescriptor) {
        Object object;
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.session.startOperationProfile("cache");
            this.acquireReadLock();
            try {
                object = identityMap.getWriteLockValue(vector);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("cache");
        } else {
            object = identityMap.getWriteLockValue(vector);
        }
        return object;
    }

    public void initializeIdentityMap(Class clazz) throws EclipseLinkException {
        ClassDescriptor classDescriptor = this.session.getDescriptor(clazz);
        if (classDescriptor == null) {
            throw ValidationException.missingDescriptor(String.valueOf(clazz));
        }
        if (classDescriptor.isChildDescriptor()) {
            throw ValidationException.childDescriptorsDoNotHaveIdentityMap();
        }
        Class clazz2 = classDescriptor.getJavaClass();
        IdentityMap identityMap = this.buildNewIdentityMap(classDescriptor);
        this.getIdentityMaps().put(clazz2, identityMap);
        this.clearLastAccessedIdentityMap();
    }

    public void initializeIdentityMaps() {
        this.clearLastAccessedIdentityMap();
        this.setIdentityMaps(new ConcurrentHashMap());
        this.clearQueryCache();
    }

    public void printIdentityMap(Class clazz) {
        Object object;
        Object object2;
        String string = Helper.cr();
        ClassDescriptor classDescriptor = this.session.getDescriptor(clazz);
        int n = 0;
        StringWriter stringWriter = new StringWriter();
        if (classDescriptor.isAggregateDescriptor()) {
            return;
        }
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        stringWriter.write(LoggingLocalization.buildMessage("identitymap_for", new Object[]{string, Helper.getShortClassName(identityMap.getClass()), Helper.getShortClassName(clazz)}));
        if (classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().isRootParentDescriptor()) {
            stringWriter.write(LoggingLocalization.buildMessage("includes"));
            object2 = classDescriptor.getInheritancePolicy().getChildDescriptors();
            if (object2 != null && ((Vector)object2).size() != 0) {
                object = ((Vector)object2).elements();
                stringWriter.write(Helper.getShortClassName(((ClassDescriptor)object.nextElement()).getJavaClass()));
                while (object.hasMoreElements()) {
                    stringWriter.write(", " + Helper.getShortClassName(((ClassDescriptor)object.nextElement()).getJavaClass()));
                }
            }
            stringWriter.write(")");
        }
        object2 = identityMap.keys();
        while (object2.hasMoreElements()) {
            object = (CacheKey)object2.nextElement();
            Object object3 = ((CacheKey)object).getObject();
            if (!clazz.isInstance(object3)) continue;
            ++n;
            if (object3 == null) {
                stringWriter.write(LoggingLocalization.buildMessage("key_object_null", new Object[]{string, ((CacheKey)object).getKey(), "\t"}));
                continue;
            }
            stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, ((CacheKey)object).getKey(), "\t", String.valueOf(System.identityHashCode(object3)), object3}));
        }
        stringWriter.write(LoggingLocalization.buildMessage("elements", new Object[]{string, String.valueOf(n)}));
        this.session.log(7, "cache", stringWriter.toString(), null, null, false);
    }

    public void printIdentityMaps() {
        for (Class clazz : this.session.getDescriptors().keySet()) {
            ClassDescriptor classDescriptor = this.session.getDescriptor(clazz);
            if (classDescriptor.hasInheritance()) {
                if (!classDescriptor.getInheritancePolicy().isRootParentDescriptor()) continue;
                this.printIdentityMap(clazz);
                continue;
            }
            this.printIdentityMap(clazz);
        }
    }

    public void printLocks() {
        StringWriter stringWriter = new StringWriter();
        HashMap hashMap = new HashMap();
        stringWriter.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        for (IdentityMap object2 : this.session.getIdentityMapAccessorInstance().getIdentityMapManager().getIdentityMaps().values()) {
            object2.collectLocks(hashMap);
        }
        Object[] objectArray = new Object[1];
        for (Thread thread : hashMap.keySet()) {
            Object object2;
            objectArray[0] = thread.getName();
            stringWriter.write(TraceLocalization.buildMessage("active_thread", objectArray) + Helper.cr());
            for (Object object2 : (HashSet)hashMap.get(thread)) {
                objectArray[0] = ((CacheKey)object2).getObject();
                stringWriter.write(TraceLocalization.buildMessage("locked_object", objectArray) + Helper.cr());
                objectArray[0] = new Integer(((CacheKey)object2).getMutex().getDepth());
                stringWriter.write(TraceLocalization.buildMessage("depth", objectArray) + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
            if (deferredLockManager == null) continue;
            object2 = deferredLockManager.getDeferredLocks().iterator();
            while (object2.hasNext()) {
                ConcurrencyManager concurrencyManager = (ConcurrencyManager)object2.next();
                objectArray[0] = concurrencyManager.getOwnerCacheKey().getObject();
                stringWriter.write(TraceLocalization.buildMessage("deferred_locks", objectArray) + Helper.cr());
            }
        }
        stringWriter.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.session.log(1, "cache", stringWriter.toString(), null, null, false);
    }

    public void printLocks(Class clazz) {
        ClassDescriptor classDescriptor = this.session.getDescriptor(clazz);
        StringWriter stringWriter = new StringWriter();
        HashMap hashMap = new HashMap();
        stringWriter.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        identityMap.collectLocks(hashMap);
        Object[] objectArray = new Object[1];
        for (Thread thread : hashMap.keySet()) {
            Object object2;
            objectArray[0] = thread.getName();
            stringWriter.write(TraceLocalization.buildMessage("active_thread", objectArray) + Helper.cr());
            for (Object object2 : (HashSet)hashMap.get(thread)) {
                objectArray[0] = ((CacheKey)object2).getObject();
                stringWriter.write(TraceLocalization.buildMessage("locked_object", objectArray) + Helper.cr());
                objectArray[0] = new Integer(((CacheKey)object2).getMutex().getDepth());
                stringWriter.write(TraceLocalization.buildMessage("depth", objectArray) + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(thread);
            if (deferredLockManager == null) continue;
            object2 = deferredLockManager.getDeferredLocks().iterator();
            while (object2.hasNext()) {
                ConcurrencyManager concurrencyManager = (ConcurrencyManager)object2.next();
                objectArray[0] = concurrencyManager.getOwnerCacheKey().getObject();
                stringWriter.write(TraceLocalization.buildMessage("deferred_locks", objectArray) + Helper.cr());
            }
        }
        stringWriter.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.session.log(1, "cache", stringWriter.toString(), null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey putInIdentityMap(Object object, Vector vector, Object object2, long l, ClassDescriptor classDescriptor) {
        CacheKey cacheKey;
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object3 = objectBuilder.unwrapObject(object, this.session);
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.session.startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = identityMap.put(vector, object3, object2, l);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("cache");
        } else {
            cacheKey = identityMap.put(vector, object3, object2, l);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putQueryResult(ReadQuery readQuery, Vector vector, Object object) {
        Vector vector2;
        IdentityMap identityMap = (IdentityMap)this.queryResults.get(readQuery);
        if (identityMap == null) {
            vector2 = this.queryResults;
            synchronized (vector2) {
                identityMap = (IdentityMap)this.queryResults.get(readQuery);
                if (identityMap == null) {
                    identityMap = new CacheIdentityMap(readQuery.getQueryResultsCachePolicy().getMaximumCachedResults());
                    this.queryResults.put(readQuery, identityMap);
                }
            }
        }
        if ((vector2 = vector) == null) {
            vector2 = new Vector();
        }
        long l = 0L;
        if (readQuery.isObjectLevelReadQuery()) {
            l = ((ObjectLevelReadQuery)readQuery).getExecutionTime();
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        if (object == null) {
            object = InvalidObject.instance();
        }
        identityMap.put(vector2, object, null, l);
    }

    protected void releaseReadLock() {
        if (this.session.getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().releaseReadLock();
        }
    }

    public void releaseWriteLock() {
        if (this.session.getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.session.getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromIdentityMap(Vector vector, Class clazz, ClassDescriptor classDescriptor, Object object) {
        Object object2;
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.session.startOperationProfile("cache");
            this.acquireReadLock();
            try {
                object2 = identityMap.remove(vector, object);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("cache");
        } else {
            object2 = identityMap.remove(vector, object);
        }
        return object2;
    }

    protected void setCacheMutex(ConcurrencyManager concurrencyManager) {
        this.cacheMutex = concurrencyManager;
    }

    public void setIdentityMaps(ConcurrentMap concurrentMap) {
        this.clearLastAccessedIdentityMap();
        this.identityMaps = concurrentMap;
    }

    protected void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrapper(Vector vector, Class clazz, Object object) {
        ClassDescriptor classDescriptor = this.session.getDescriptor(clazz);
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.session.startOperationProfile("cache");
            this.acquireReadLock();
            try {
                identityMap.setWrapper(vector, object);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("cache");
        } else {
            identityMap.setWrapper(vector, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteLockValue(Vector vector, Class clazz, Object object) {
        ClassDescriptor classDescriptor = this.session.getDescriptor(clazz);
        IdentityMap identityMap = this.getIdentityMap(classDescriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.session.startOperationProfile("cache");
            this.acquireReadLock();
            try {
                identityMap.setWriteLockValue(vector, object);
            }
            finally {
                this.releaseReadLock();
            }
            this.session.endOperationProfile("cache");
        } else {
            identityMap.setWriteLockValue(vector, object);
        }
    }

    protected Object checkForInheritance(Object object, Class clazz, ClassDescriptor classDescriptor) {
        if (object != null && object.getClass() != clazz && !clazz.isInstance(object)) {
            if (classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().getUseDescriptorsToValidateInheritedObjects()) {
                if (classDescriptor.getInheritancePolicy().getSubclassDescriptor(object.getClass()) == null) {
                    return null;
                }
                return object;
            }
            return null;
        }
        return object;
    }
}

