/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.GroupByNode;
import org.eclipse.persistence.internal.jpa.parsing.MajorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class HavingNode
extends MajorNode {
    private Node having = null;

    public void validate(ParseTreeContext parseTreeContext, GroupByNode groupByNode) {
        if (this.having != null) {
            this.having.validate(parseTreeContext);
            if (groupByNode != null && !groupByNode.isValidHavingExpr(this.having)) {
                throw JPQLException.invalidHavingExpression(parseTreeContext.getQueryInfo(), this.having.getLine(), this.having.getColumn(), this.having.getAsString(), groupByNode.getAsString());
            }
        }
    }

    public void addHavingToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            Expression expression = this.getHaving().generateExpression(generationContext);
            ((ReportQuery)objectLevelReadQuery).setHavingExpression(expression);
        }
    }

    public Node getHaving() {
        return this.having;
    }

    public void setHaving(Node node) {
        this.having = node;
    }
}

