/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.documentpreservation;

import java.util.WeakHashMap;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderCacheEntry;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.documentpreservation.RelativePositionOrderingPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.w3c.dom.Node;

public class XMLBinderPolicy
extends DocumentPreservationPolicy {
    private WeakHashMap nodesToObjects = new WeakHashMap();
    private WeakHashMap objectsToNodes = new WeakHashMap();

    public XMLBinderPolicy() {
        this.setNodeOrderingPolicy(new RelativePositionOrderingPolicy());
    }

    public void addObjectToCache(Object object, Node node) {
        this.addObjectToCache(object, node, null);
    }

    public void addObjectToCache(Object object, Node node, XMLMapping xMLMapping) {
        this.objectsToNodes.put(object, node);
        if (xMLMapping != null) {
            XMLBinderCacheEntry xMLBinderCacheEntry = (XMLBinderCacheEntry)this.nodesToObjects.get(node);
            if (xMLBinderCacheEntry != null) {
                xMLBinderCacheEntry.addSelfMappingObject(xMLMapping, object);
            }
        } else {
            XMLBinderCacheEntry xMLBinderCacheEntry = new XMLBinderCacheEntry(object);
            this.nodesToObjects.put(node, xMLBinderCacheEntry);
        }
    }

    public Node getNodeForObject(Object object) {
        return (Node)this.objectsToNodes.get(object);
    }

    public Object getObjectForNode(Node node) {
        return this.getObjectForNode(node, null);
    }

    public Object getObjectForNode(Node node, XMLMapping xMLMapping) {
        XMLBinderCacheEntry xMLBinderCacheEntry = (XMLBinderCacheEntry)this.nodesToObjects.get(node);
        if (xMLBinderCacheEntry != null) {
            if (xMLMapping != null) {
                return xMLBinderCacheEntry.getSelfMappingObject(xMLMapping);
            }
            return xMLBinderCacheEntry.getRootObject();
        }
        return null;
    }

    public boolean shouldPreserveDocument() {
        return true;
    }
}

