/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class TypeConversionConverter
implements Converter {
    protected DatabaseMapping mapping;
    protected Class dataClass;
    protected String dataClassName;
    protected Class objectClass;
    protected String objectClassName;

    public TypeConversionConverter() {
    }

    public TypeConversionConverter(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz = null;
        Class clazz2 = null;
        try {
            if (this.dataClassName != null) {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.dataClassName, true, classLoader));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.dataClassName, privilegedActionException.getException());
                    }
                } else {
                    clazz = PrivilegedAccessHelper.getClassForName(this.dataClassName, true, classLoader);
                }
                this.setDataClass(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.dataClassName, classNotFoundException);
        }
        try {
            if (this.objectClassName != null) {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz2 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.objectClassName, true, classLoader));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.objectClassName, privilegedActionException.getException());
                    }
                } else {
                    clazz2 = PrivilegedAccessHelper.getClassForName(this.objectClassName, true, classLoader);
                }
                this.setObjectClass(clazz2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.objectClassName, classNotFoundException);
        }
    }

    public Object convertDataValueToObjectValue(Object object, Session session) {
        Object object2 = object;
        if (object2 != null) {
            try {
                object2 = ((AbstractSession)session).getDatasourcePlatform().convertObject(object2, this.getDataClass());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
            }
            try {
                object2 = ((AbstractSession)session).getDatasourcePlatform().convertObject(object2, this.getObjectClass());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
            }
        }
        return object2;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        if (this.objectClassName == null && this.objectClass != null) {
            this.objectClassName = this.objectClass.getName();
        }
        return this.objectClassName;
    }

    public Class getDataClass() {
        return this.dataClass;
    }

    public String getDataClassName() {
        if (this.dataClassName == null && this.dataClass != null) {
            this.dataClassName = this.dataClass.getName();
        }
        return this.dataClassName;
    }

    public void setDataClass(Class clazz) {
        this.dataClass = clazz;
    }

    public void setDataClassName(String string) {
        this.dataClassName = string;
    }

    public void setObjectClass(Class clazz) {
        this.objectClass = clazz;
    }

    public void setObjectClassName(String string) {
        this.objectClassName = string;
    }

    public Object convertObjectValueToDataValue(Object object, Session session) {
        try {
            return ((AbstractSession)session).getDatasourcePlatform().convertObject(object, this.getDataClass());
        }
        catch (ConversionException conversionException) {
            throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
        }
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        this.mapping = databaseMapping;
        if (this.getMapping().isDirectToFieldMapping()) {
            AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)this.getMapping();
            if (abstractDirectMapping.getFieldClassification() == null) {
                abstractDirectMapping.setFieldClassification(this.getDataClass());
            }
            if (this.getObjectClass() == null) {
                this.setObjectClass(abstractDirectMapping.getAttributeClassification());
            }
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    public boolean isMutable() {
        return false;
    }
}

