/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public class XMLValidator {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;
    private XMLContext xmlContext;
    private XMLMarshaller marshaller;
    private ErrorHandler errorHandler;

    protected XMLValidator(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
        this.marshaller = new XMLMarshaller(xMLContext);
    }

    public boolean validateRoot(Object object) throws XMLMarshalException {
        if (object == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        XMLDescriptor xMLDescriptor = (XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object);
        Document document = this.marshaller.objectToXML(object, xMLDescriptor, false);
        if (xMLDescriptor.getSchemaReference() == null) {
            throw XMLMarshalException.schemaReferenceNotSet(xMLDescriptor);
        }
        return xMLDescriptor.getSchemaReference().isValid(document, this.getErrorHandler());
    }

    public boolean validate(Object object) throws XMLMarshalException {
        if (object == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            Object object2;
            String string = ((XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object)).getDefaultRootElement();
            if (string == null) {
                object2 = object.getClass().getName();
                int n = ((String)object2).lastIndexOf(46);
                string = ((String)object2).substring(n + 1);
            }
            object2 = this.marshaller.getDescriptor(object);
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setObject(object);
            xMLRoot.setLocalName(string);
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            Document document = xMLPlatform.createDocument();
            this.marshaller.marshal((Object)xMLRoot, document);
            return xMLPlatform.validate(document.getDocumentElement(), (XMLDescriptor)object2, this.getErrorHandler());
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.validateException(xMLPlatformException);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

