/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseType;

public class PLSQLargument
implements Cloneable {
    public String name;
    public int direction = DatasourceCall.IN;
    public int originalIndex = Integer.MIN_VALUE;
    public int inIndex = Integer.MIN_VALUE;
    public int outIndex = Integer.MIN_VALUE;
    public DatabaseType databaseType;
    public int length = 255;
    public int precision = Integer.MIN_VALUE;
    public int scale = Integer.MIN_VALUE;
    public boolean cursorOutput = false;

    public PLSQLargument() {
    }

    public PLSQLargument(String string, int n, int n2, DatabaseType databaseType) {
        this();
        this.name = string;
        this.databaseType = databaseType;
        this.originalIndex = n;
        this.direction = n2;
    }

    public PLSQLargument(String string, int n, int n2, DatabaseType databaseType, int n3) {
        this(string, n, n2, databaseType);
        this.length = n3;
    }

    public PLSQLargument(String string, int n, int n2, DatabaseType databaseType, int n3, int n4) {
        this(string, n, n2, databaseType);
        this.precision = n3;
        this.scale = n4;
    }

    protected PLSQLargument clone() {
        try {
            return (PLSQLargument)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void useNamedCursorOutputAsResultSet() {
        this.cursorOutput = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append('{');
        if (this.direction == DatasourceCall.IN) {
            stringBuilder.append("IN");
        } else if (this.direction == DatasourceCall.INOUT) {
            stringBuilder.append("IN");
        } else if (this.direction == DatasourceCall.OUT) {
            stringBuilder.append("OUT");
        } else if (this.direction == DatasourceCall.OUT_CURSOR) {
            stringBuilder.append("OUT CURSOR");
        }
        stringBuilder.append(',');
        stringBuilder.append(this.originalIndex);
        stringBuilder.append(',');
        if (this.inIndex != Integer.MIN_VALUE) {
            stringBuilder.append(this.inIndex);
        }
        stringBuilder.append(',');
        if (this.outIndex != Integer.MIN_VALUE) {
            stringBuilder.append(this.outIndex);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

