/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.services.weblogic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.JavaLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.wls.WebLogicPlatform;
import org.eclipse.persistence.services.RuntimeServices;
import org.eclipse.persistence.services.weblogic.ClassSummaryDetail;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicRuntimeServices
extends RuntimeServices {
    private int deployedSessionProfileWeight;
    private SessionLog deployedSessionLog;
    public String objectName;
    private static final String EclipseLink_Product_Name = "EclipseLink";

    public WebLogicRuntimeServices() {
    }

    public WebLogicRuntimeServices(AbstractSession abstractSession) {
        this.session = abstractSession;
        this.updateDeploymentTimeData();
    }

    public WebLogicRuntimeServices(Locale locale) {
    }

    protected void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
        this.updateDeploymentTimeData();
    }

    protected void updateDeploymentTimeData() {
        this.deployedSessionLog = (SessionLog)((AbstractSessionLog)this.session.getSessionLog()).clone();
        this.deployedSessionProfileWeight = this.session.getProfiler() == null ? -1 : this.session.getProfiler().getProfileWeight();
    }

    public String getSessionName() {
        return this.getSession().getName();
    }

    public String getSessionType() {
        return Helper.getShortClassName(this.getSession().getClass());
    }

    public Object[][] getClassSummaryDetailsUsingFilter(String string) {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetailsUsingFilter(string), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    public ArrayList<ClassSummaryDetail> getClassSummaryDetailsUsingFilterArray(String string) {
        if (string == null) {
            return this.getClassSummaryDetailsArray();
        }
        try {
            Vector vector = this.getMappedClassNamesUsingFilter(string);
            ArrayList<ClassSummaryDetail> arrayList = new ArrayList<ClassSummaryDetail>();
            if (vector.size() == 0) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                String[] stringArray = new String[]{string2};
                arrayList.add((ClassSummaryDetail)((Object)this.buildLowlevelDetailsFor(string2)));
            }
            return arrayList;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            exception.printStackTrace();
            return null;
        }
    }

    public ArrayList<ClassSummaryDetail> getClassSummaryDetailsArray() {
        try {
            Vector vector = this.getMappedClassNames();
            ArrayList<ClassSummaryDetail> arrayList = new ArrayList<ClassSummaryDetail>();
            if (vector.size() == 0) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                arrayList.add((ClassSummaryDetail)((Object)this.buildLowlevelDetailsFor(string)));
            }
            return arrayList;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            exception.printStackTrace();
            return null;
        }
    }

    public Object[][] getClassSummaryDetails() {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetails(), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    private TabularData buildClassSummaryDetailsUsingFilter(String string) {
        if (string == null) {
            return this.buildClassSummaryDetails();
        }
        try {
            Vector vector = this.getMappedClassNamesUsingFilter(string);
            TabularDataSupport tabularDataSupport = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (vector.size() == 0) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.elementAt(i);
                String[] stringArray = new String[]{string2};
                tabularDataSupport.put(stringArray, this.buildDetailsFor(string2, tabularDataSupport.getTabularType().getRowType()));
            }
            return tabularDataSupport;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    private TabularData buildClassSummaryDetails() {
        try {
            Vector vector = this.getMappedClassNames();
            TabularDataSupport tabularDataSupport = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (vector.size() == 0) {
                return null;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String[] stringArray = new String[]{string};
                tabularDataSupport.put(stringArray, this.buildDetailsFor(string, tabularDataSupport.getTabularType().getRowType()));
            }
            return tabularDataSupport;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    private Vector getMappedClassNames() {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        Vector<String> vector = new Vector<String>();
        String string = null;
        for (ClassDescriptor classDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (classDescriptor.getCMPPolicy() != null && classDescriptor.getCMPPolicy().getMappedClass() != null) {
                string = classDescriptor.getCMPPolicy().getMappedClass().getName();
            }
            if (string == null) {
                string = classDescriptor.getJavaClassName();
            }
            if (hashtable.get(string) == null) {
                hashtable.put(string, Boolean.TRUE);
                vector.addElement(string);
            }
            string = null;
        }
        return vector;
    }

    public Vector getMappedClassNamesUsingFilter(String string) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this.getMappedClassNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = (String)vector2.get(i);
            String string3 = ((String)vector2.get(i)).toLowerCase();
            for (int j = 0; j < arrayList.size(); ++j) {
                String string4 = Helper.rightTrimString((String)arrayList.get(j)).trim().toLowerCase();
                if (string4.indexOf(42) == 0) {
                    string4 = string4.substring(1);
                }
                try {
                    if (!string3.matches(new StringBuffer().append("^.*").append(string4).append(".*$").toString()) || vector.contains(string2)) continue;
                    vector.add(string2);
                    continue;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    AbstractSessionLog.getLog().log(1, "pattern_syntax_error", patternSyntaxException);
                }
            }
        }
        Collections.sort(vector);
        return vector;
    }

    private TabularType buildTabularTypeForClassSummaryDetails() throws OpenDataException {
        return new TabularType(this.getSessionName(), "Session description", this.buildCompositeTypeForClassSummaryDetails(), new String[]{"Class Name"});
    }

    private CompositeType buildCompositeTypeForClassSummaryDetails() throws OpenDataException {
        return new CompositeType("Class Details", "Details of class for Class Summary", new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
    }

    private CompositeData buildDetailsFor(String string, CompositeType compositeType) throws Exception {
        return new CompositeDataSupport(compositeType, this.buildLowlevelDetailsFor(string));
    }

    private HashMap buildLowlevelDetailsFor(String string) {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz);
        ClassDescriptor classDescriptor = this.getSession().getProject().getDescriptor(clazz);
        String string2 = this.getCacheTypeFor(identityMap.getClass());
        String string3 = "" + identityMap.getMaxSize();
        String string4 = "";
        string4 = "" + identityMap.getSize(clazz, true);
        String string5 = "";
        boolean bl = classDescriptor.isChildDescriptor();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Class Name", string);
        hashMap.put("Cache Type", bl ? "" : string2);
        hashMap.put("Configured Size", bl ? "" : string3);
        hashMap.put("Current Size", string4);
        if (classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().getParentDescriptor() != null) {
            string5 = classDescriptor.getInheritancePolicy().getParentClassName();
        }
        hashMap.put("Parent Class Name", string5);
        return hashMap;
    }

    private ClassSummaryDetail buildLowlevelDetailsForNew(String string) {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz);
        ClassDescriptor classDescriptor = this.getSession().getProject().getDescriptor(clazz);
        String string2 = this.getCacheTypeFor(identityMap.getClass());
        String string3 = "" + identityMap.getMaxSize();
        String string4 = "";
        string4 = "" + identityMap.getSize(clazz, true);
        String string5 = "";
        boolean bl = classDescriptor.isChildDescriptor();
        ClassSummaryDetail classSummaryDetail = new ClassSummaryDetail(string, bl ? "" : string2, bl ? "" : string3, string4, string5);
        return classSummaryDetail;
    }

    private String getCacheTypeFor(Class clazz) {
        if (clazz == CacheIdentityMap.class) {
            return "Cache";
        }
        if (clazz == FullIdentityMap.class) {
            return "Full";
        }
        if (clazz == HardCacheWeakIdentityMap.class) {
            return "HardWeak";
        }
        if (clazz == NoIdentityMap.class) {
            return "None";
        }
        if (clazz == SoftCacheWeakIdentityMap.class) {
            return "SoftWeak";
        }
        if (clazz == WeakIdentityMap.class) {
            return "Weak";
        }
        if (clazz == SoftIdentityMap.class) {
            return "Soft";
        }
        return "N/A";
    }

    public String getModuleName() {
        String string = null;
        DatabaseSessionImpl databaseSessionImpl = (DatabaseSessionImpl)this.getSession();
        ServerPlatform serverPlatform = databaseSessionImpl.getServerPlatform();
        string = serverPlatform.getModuleName();
        return ((DatabaseSessionImpl)this.getSession()).getServerPlatform().getModuleName();
    }

    public String getApplicationName() {
        String string = null;
        DatabaseSessionImpl databaseSessionImpl = (DatabaseSessionImpl)this.getSession();
        ServerPlatform serverPlatform = databaseSessionImpl.getServerPlatform();
        string = serverPlatform.getModuleName();
        return ((WebLogicPlatform)((DatabaseSessionImpl)this.getSession()).getServerPlatform()).getApplicationName();
    }

    public String getDeployedEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.deployedSessionLog.getLevel());
    }

    public String getCurrentEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.getSession().getSessionLog().getLevel());
    }

    public synchronized void setCurrentEclipseLinkLogLevel(String string) {
        this.getSession().setLogLevel(this.getLogLevelForName(string));
    }

    private String getNameForLogLevel(int n) {
        switch (n) {
            case 0: {
                return "ALL";
            }
            case 7: {
                return "SEVERE";
            }
            case 6: {
                return "WARNING";
            }
            case 5: {
                return "INFO";
            }
            case 4: {
                return "CONFIG";
            }
            case 3: {
                return "FINE";
            }
            case 2: {
                return "FINER";
            }
            case 1: {
                return "FINEST";
            }
            case 8: {
                return "OFF";
            }
        }
        return "N/A";
    }

    private int getLogLevelForName(String string) {
        if (string.equals("ALL")) {
            return 0;
        }
        if (string.equals("SEVERE")) {
            return 7;
        }
        if (string.equals("WARNING")) {
            return 6;
        }
        if (string.equals("INFO")) {
            return 5;
        }
        if (string.equals("CONFIG")) {
            return 4;
        }
        if (string.equals("FINE")) {
            return 3;
        }
        if (string.equals("FINER")) {
            return 2;
        }
        if (string.equals("FINEST")) {
            return 1;
        }
        return 8;
    }

    public synchronized String getProfilingType() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return EclipseLink_Product_Name;
        }
        return "None";
    }

    public synchronized void setProfilingType(String string) {
        if (string == null || string.compareToIgnoreCase("None") == 0) {
            this.setUseNoProfiling();
        } else if (string.compareToIgnoreCase(EclipseLink_Product_Name) == 0) {
            this.setUseEclipseLinkProfiling();
        }
    }

    public void setUseEclipseLinkProfiling() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        this.getSession().setProfiler(new PerformanceProfiler());
    }

    public Boolean getUsesEclipseLinkProfiling() {
        return this.getSession().getProfiler() instanceof PerformanceProfiler;
    }

    public void setUseNoProfiling() {
        this.getSession().setProfiler(null);
    }

    public Boolean getShouldBindAllParameters() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldBindAllParameters();
    }

    public Integer getStringBindingSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return new Integer(0);
        }
        if (!((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding()) {
            return new Integer(0);
        }
        return new Integer(((DatabaseLogin)this.getSession().getDatasourceLogin()).getStringBindingSize());
    }

    public Boolean getUsesBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesBatchWriting();
    }

    public Long getTimeConnectionEstablished() {
        return new Long(((DatabaseSessionImpl)this.getSession()).getConnectedTime());
    }

    public Boolean getUsesJDBCBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesJDBCBatchWriting();
    }

    public Boolean getUsesByteArrayBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesByteArrayBinding();
    }

    public Boolean getUsesNativeSQL() {
        return this.getSession().getDatasourceLogin().getPlatform().usesNativeSQL();
    }

    public Boolean getUsesStreamsForBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesStreamsForBinding();
    }

    public Boolean getUsesStringBinding() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding();
    }

    @Override
    public boolean getShouldCacheAllStatements() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldCacheAllStatements();
    }

    @Override
    public int getStatementCacheSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return new Integer(0);
        }
        return new Integer(((DatabaseLogin)this.getSession().getDatasourceLogin()).getStatementCacheSize());
    }

    public synchronized void clearStatementCache() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseAccessor)this.getSession().getAccessor()).clearStatementCache(this.getSession());
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_statement_cache_cleared");
    }

    @Override
    public int getSequencePreallocationSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return new Integer(0);
        }
        return ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).getSequencePreallocationSize();
    }

    public void printAvailableConnectionPools() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map map = ((ServerSession)this.getSession()).getConnectionPools();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_pool_name", string);
            }
        } else {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_connection_pools_available");
        }
    }

    public Integer getMaxSizeForPool(String string) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(string)) != null) {
            return new Integer(connectionPool.getMaxNumberOfConnections());
        }
        return new Integer(-1);
    }

    public Integer getMinSizeForPool(String string) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(string)) != null) {
            return new Integer(connectionPool.getMinNumberOfConnections());
        }
        return new Integer(-1);
    }

    @Override
    public synchronized void resetAllConnections() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            for (ConnectionPool connectionPool : ((ServerSession)this.getSession()).getConnectionPools().values()) {
                connectionPool.shutDown();
                connectionPool.startUp();
            }
        } else if (ClassConstants.PublicInterfaceDatabaseSession_Class.isAssignableFrom(this.getSession().getClass())) {
            this.getSession().getAccessor().reestablishConnection(this.getSession());
        }
    }

    public void printClassesInSession() {
        Vector vector = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (vector.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_classes_in_session");
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.getSession().getSessionLog().log(1, (String)vector.elementAt(i));
        }
    }

    public void printObjectsInIdentityMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz);
        if (null == identityMap) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_non_existent", string);
            return;
        }
        Enumeration enumeration = identityMap.keys();
        if (!enumeration.hasMoreElements()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_empty", string);
        }
        while (enumeration.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)enumeration.nextElement();
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_print_cache_key_value", cacheKey.getKey().toString(), cacheKey.getObject().toString());
        }
    }

    public void printAllIdentityMapTypes() {
        Vector vector = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (vector.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
            IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_class", string, identityMap.getClass());
        }
    }

    public void printObjectsInIdentityMaps() {
        Vector vector = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (vector.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            try {
                this.printObjectsInIdentityMap(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", classNotFoundException);
            }
        }
    }

    @Override
    public Integer getNumberOfObjectsInIdentityMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        Class clazz2 = null;
        ClassDescriptor classDescriptor = this.getSession().getDescriptor(clazz);
        ClassDescriptor classDescriptor2 = classDescriptor.hasInheritance() ? classDescriptor.getInheritancePolicy().getRootParentDescriptor() : classDescriptor;
        if (classDescriptor2.getCMPPolicy() != null && classDescriptor2.getCMPPolicy().getMappedClass() != null) {
            clazz2 = classDescriptor2.getCMPPolicy().getMappedClass();
        }
        if (clazz2 == null) {
            clazz2 = classDescriptor2.getJavaClass();
        }
        return new Integer(this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz2).getSize(clazz2, true));
    }

    public Integer getNumberOfObjectsInAllIdentityMaps() {
        Vector vector = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        int n = 0;
        if (vector.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return new Integer(0);
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            try {
                n += this.getNumberOfObjectsInIdentityMap(string).intValue();
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", classNotFoundException);
            }
        }
        return new Integer(n);
    }

    public Integer getNumberOfPersistentClasses() {
        boolean bl = false;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        for (ClassDescriptor classDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (classDescriptor.isAggregateDescriptor()) continue;
            hashtable.put(classDescriptor.getJavaClassName(), Boolean.TRUE);
        }
        return new Integer(hashtable.size());
    }

    public void printIdentityMapLocks() {
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks();
    }

    public void printIdentityMapLocks(String string) {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks(clazz);
    }

    public void printProfileSummary() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(performanceProfiler.buildProfileSummary().toString());
    }

    private String trimProfileString(String string) {
        if (string.length() > 1) {
            String string2 = string.substring(0, string.length());
            if (string2.charAt(0) == '{' && string2.charAt(string2.length() - 1) == '}') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string2;
        }
        return string;
    }

    public void printProfileSummaryByClass() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByClass().toString()));
    }

    public void printProfileSummaryByQuery() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByQuery().toString()));
    }

    public String getLogType() {
        if (this.getSession().getSessionLog().getClass() == JavaLog.class) {
            return "Java";
        }
        return EclipseLink_Product_Name;
    }

    public String getDatabasePlatform() {
        return this.getSession().getDatasourcePlatform().getClass().getName();
    }

    public synchronized String getJdbcConnectionDetails() {
        return this.getSession().getLogin().getConnector().getConnectionDetails();
    }

    public synchronized String getConnectionPoolType() {
        if (this.getSession().getLogin().shouldUseExternalConnectionPooling()) {
            return "External";
        }
        return "N/A";
    }

    public synchronized String getDriver() {
        if (this.getSession().getLogin().getConnector() instanceof DefaultConnector) {
            return this.getSession().getLogin().getDriverClassName();
        }
        return "N/A";
    }

    public String getLogFilename() {
        if (this.getLogType().equals(EclipseLink_Product_Name) && this.session.getSessionLog() instanceof DefaultSessionLog) {
            return ((DefaultSessionLog)this.session.getSessionLog()).getWriterFilename();
        }
        return null;
    }

    public synchronized void initializeAllIdentityMaps() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public synchronized void initializeIdentityMaps(String[] stringArray) throws ClassNotFoundException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.initializeIdentityMap(stringArray[i]);
        }
    }

    public synchronized void initializeIdentityMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().initializeIdentityMap(clazz);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_initialized", string);
    }

    public synchronized void invalidateAllIdentityMaps() {
        Vector vector = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (vector.isEmpty()) {
            this.getSession().getSessionLog().info("There are no Identity Maps in this session");
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
            this.getSession().getIdentityMapAccessor().invalidateClass(clazz);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", string);
        }
    }

    public synchronized void invalidateIdentityMaps(String[] stringArray, Boolean bl) throws ClassNotFoundException {
        String[] stringArray2 = stringArray;
        for (int i = 0; i < stringArray2.length; ++i) {
            this.invalidateIdentityMap(stringArray2[i], bl);
        }
    }

    public synchronized void invalidateIdentityMap(String string) throws ClassNotFoundException {
        this.invalidateIdentityMap(string, Boolean.FALSE);
    }

    public synchronized void invalidateIdentityMap(String string, Boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().invalidateClass(clazz);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", string);
    }

    private Object[][] tabularDataTo2DArray(TabularData tabularData, String[] stringArray) throws Exception {
        if (tabularData == null) {
            return null;
        }
        Object[] objectArray = tabularData.values().toArray();
        Object[][] objectArray2 = new Object[objectArray.length][];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = ((CompositeData)objectArray[i]).getAll(stringArray);
        }
        return objectArray2;
    }

    public boolean isJPASession() {
        return true;
    }
}

