/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class StoredProcedureGenerator {
    public SchemaManager schemaManager;
    private Hashtable storedProcedures;
    private Hashtable mappingStoredProcedures;
    private Hashtable intToTypeConverterHash;
    private Writer writer;
    private String prefix;
    private static final String DEFAULT_PREFIX = "";
    private Hashtable sequenceProcedures;
    private static final int MAX_NAME_SIZE = 30;

    public StoredProcedureGenerator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.sequenceProcedures = new Hashtable();
        this.storedProcedures = new Hashtable();
        this.mappingStoredProcedures = new Hashtable();
        this.buildIntToTypeConverterHash();
        this.prefix = DEFAULT_PREFIX;
        this.verify();
    }

    protected void buildIntToTypeConverterHash() {
        this.intToTypeConverterHash = new Hashtable();
        this.intToTypeConverterHash.put(new Integer(8), Double.class);
        this.intToTypeConverterHash.put(new Integer(-7), Boolean.class);
        this.intToTypeConverterHash.put(new Integer(-3), Byte[].class);
        this.intToTypeConverterHash.put(new Integer(-6), Short.class);
        this.intToTypeConverterHash.put(new Integer(5), Short.class);
        this.intToTypeConverterHash.put(new Integer(4), Integer.class);
        this.intToTypeConverterHash.put(new Integer(2), BigDecimal.class);
        this.intToTypeConverterHash.put(new Integer(6), Float.class);
        this.intToTypeConverterHash.put(new Integer(1), Character.class);
        this.intToTypeConverterHash.put(new Integer(12), String.class);
        this.intToTypeConverterHash.put(new Integer(91), Date.class);
        this.intToTypeConverterHash.put(new Integer(93), Timestamp.class);
        this.intToTypeConverterHash.put(new Integer(3), BigDecimal.class);
        this.intToTypeConverterHash.put(new Integer(-5), BigDecimal.class);
        this.intToTypeConverterHash.put(new Integer(7), Float.class);
        this.intToTypeConverterHash.put(new Integer(-1), String.class);
        this.intToTypeConverterHash.put(new Integer(92), Time.class);
        this.intToTypeConverterHash.put(new Integer(-2), Byte[].class);
        this.intToTypeConverterHash.put(new Integer(-4), Byte[].class);
    }

    protected String buildProcedureString(SQLCall sQLCall) {
        String string = sQLCall.getSQLString();
        String string2 = this.getSession().getPlatform().getStoredProcedureParameterPrefix();
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("?");
        while (n3 != -1) {
            stringWriter.write(string.substring(n, n3));
            n = n3 + 1;
            Object e = sQLCall.getParameters().elementAt(n2);
            if (e instanceof DatabaseField) {
                stringWriter.write(string2);
                stringWriter.write(((DatabaseField)e).getName());
            } else if (e instanceof ParameterExpression) {
                stringWriter.write(string2);
                stringWriter.write(((ParameterExpression)e).getField().getName());
            } else {
                this.getSession().getPlatform().appendParameter(sQLCall, stringWriter, e);
            }
            n3 = string.indexOf("?", n);
            ++n2;
        }
        stringWriter.write(string.substring(n));
        return stringWriter.toString();
    }

    public void generateAmendmentClass(Writer writer, String string, String string2) throws ValidationException {
        String string3 = "/**\n * TopLink generated method. \n * <b>WARNING</b>: This code was generated by an automated tool.\n * Any changes will be lost when the code is re-generated\n */";
        try {
            FieldDefinition fieldDefinition;
            Enumeration enumeration;
            Vector vector;
            StoredProcedureDefinition storedProcedureDefinition;
            writer.write("package ");
            writer.write(string);
            writer.write(";\n\nimport java.util.*;\nimport java.lang.reflect.*;");
            writer.write("\nimport org.eclipse.persistence.queries.*;\nimport org.eclipse.persistence.sessions.*;\nimport org.eclipse.persistence.mappings.*;\n\n/**\n * ");
            writer.write("This is a TopLink generated class to add stored procedure admendments to a project.  \n * Anychanges to this code will be lost when the class is regenerated \n */\npublic class ");
            writer.write(string2);
            writer.write("{\n");
            Enumeration enumeration2 = this.storedProcedures.keys();
            while (enumeration2.hasMoreElements()) {
                ClassDescriptor classDescriptor = (ClassDescriptor)enumeration2.nextElement();
                if (classDescriptor.isDescriptorForInterface() || classDescriptor.isAggregateDescriptor()) continue;
                writer.write(string3);
                writer.write("\npublic static void amend");
                writer.write(Helper.getShortClassName(classDescriptor.getJavaClass()));
                writer.write("ClassDescriptor(ClassDescriptor descriptor){\n\t");
                Vector vector2 = (Vector)this.storedProcedures.get(classDescriptor);
                Hashtable hashtable = (Hashtable)this.mappingStoredProcedures.get(classDescriptor);
                storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(0);
                writer.write("\n\t//INSERT QUERY\n");
                writer.write("\tInsertObjectQuery insertQuery = new InsertObjectQuery();\n\tStoredProcedureCall call = new StoredProcedureCall();\n");
                writer.write("\tcall.setProcedureName(\"");
                writer.write(storedProcedureDefinition.getName());
                writer.write("\");\n\t");
                vector = storedProcedureDefinition.getArguments();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)enumeration.nextElement();
                    writer.write("call.addNamedArgument(\"");
                    writer.write(fieldDefinition.getName());
                    writer.write("\", \"");
                    writer.write(this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                }
                writer.write("insertQuery.setCall(call);\n\tdescriptor.getQueryManager().setInsertQuery(insertQuery);\n\t");
                storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(1);
                if (storedProcedureDefinition != null) {
                    writer.write("\n\t//UPDATE QUERY\n");
                    writer.write("\tUpdateObjectQuery updateQuery = new UpdateObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    writer.write("\tcall.setProcedureName(\"");
                    writer.write(storedProcedureDefinition.getName());
                    writer.write("\");\n\t");
                    vector = storedProcedureDefinition.getArguments();
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)enumeration.nextElement();
                        writer.write("call.addNamedArgument(\"");
                        writer.write(fieldDefinition.getName());
                        writer.write("\", \"");
                        writer.write(this.getFieldName(fieldDefinition.getName()));
                        writer.write("\");\n\t");
                    }
                    writer.write("updateQuery.setCall(call);\n\tdescriptor.getQueryManager().setUpdateQuery(updateQuery);\n");
                }
                storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(2);
                writer.write("\n\t//DELETE QUERY\n");
                writer.write("\tDeleteObjectQuery deleteQuery = new DeleteObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                writer.write("\tcall.setProcedureName(\"");
                writer.write(storedProcedureDefinition.getName());
                writer.write("\");\n\t");
                vector = storedProcedureDefinition.getArguments();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)enumeration.nextElement();
                    writer.write("call.addNamedArgument(\"");
                    writer.write(fieldDefinition.getName());
                    writer.write("\", \"");
                    writer.write(this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                }
                writer.write("deleteQuery.setCall(call);\n\tdescriptor.getQueryManager().setDeleteQuery(deleteQuery);\n");
                if (vector2.size() > 3) {
                    storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(3);
                    writer.write("\n\t//READ OBJECT QUERY\n");
                    writer.write("\tReadObjectQuery readQuery = new ReadObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    writer.write("\tcall.setProcedureName(\"");
                    writer.write(storedProcedureDefinition.getName());
                    writer.write("\");\n\t");
                    vector = storedProcedureDefinition.getArguments();
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)enumeration.nextElement();
                        writer.write("call.addNamedArgument(\"");
                        writer.write(fieldDefinition.getName());
                        writer.write("\", \"");
                        writer.write(this.getFieldName(fieldDefinition.getName()));
                        writer.write("\");\n\t");
                    }
                    writer.write("readQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadObjectQuery(readQuery);\n");
                }
                if (vector2.size() > 4) {
                    storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(4);
                    writer.write("\n\t//READ ALL QUERY\n");
                    writer.write("\tReadAllQuery readAllQuery = new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                    writer.write("\tcall.setProcedureName(\"");
                    writer.write(storedProcedureDefinition.getName());
                    writer.write("\");\n\t");
                    vector = storedProcedureDefinition.getArguments();
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)enumeration.nextElement();
                        writer.write("call.addNamedArgument(\"");
                        writer.write(fieldDefinition.getName());
                        writer.write("\", \"");
                        writer.write(this.getFieldName(fieldDefinition.getName()));
                        writer.write("\");\n\t");
                    }
                    writer.write("readAllQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadAllQuery(readAllQuery);\n");
                }
                if (hashtable != null) {
                    writer.write("\n\t//MAPPING QUERIES\n");
                    writer.write("\tReadAllQuery mappingQuery; \n");
                    writer.write("\tDeleteAllQuery deleteMappingQuery; \n");
                    Enumeration enumeration3 = hashtable.keys();
                    while (enumeration3.hasMoreElements()) {
                        String string4 = (String)enumeration3.nextElement();
                        storedProcedureDefinition = (StoredProcedureDefinition)((Hashtable)hashtable.get(string4)).get("1MREAD");
                        if (storedProcedureDefinition != null) {
                            writer.write("\n\t//MAPPING READALL QUERY FOR " + string4 + "\n");
                            writer.write("\tmappingQuery= new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                            writer.write("\tcall.setProcedureName(\"");
                            writer.write(storedProcedureDefinition.getName());
                            writer.write("\");\n\t");
                            vector = storedProcedureDefinition.getArguments();
                            enumeration = vector.elements();
                            while (enumeration.hasMoreElements()) {
                                fieldDefinition = (FieldDefinition)enumeration.nextElement();
                                writer.write("call.addNamedArgument(\"");
                                writer.write(fieldDefinition.getName());
                                writer.write("\", \"");
                                writer.write(this.getFieldName(fieldDefinition.getName()));
                                writer.write("\");\n\t");
                            }
                            writer.write("mappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + string4 + "\")).setCustomSelectionQuery(mappingQuery);\n");
                        }
                        if ((storedProcedureDefinition = (StoredProcedureDefinition)((Hashtable)hashtable.get(string4)).get("1MDALL")) == null) continue;
                        writer.write("\n\t//MAPPING DELETEALL QUERY FOR " + string4 + "\n");
                        writer.write("\tdeleteMappingQuery= new DeleteAllQuery();\n\tcall = new StoredProcedureCall();\n");
                        writer.write("\tcall.setProcedureName(\"");
                        writer.write(storedProcedureDefinition.getName());
                        writer.write("\");\n\t");
                        vector = storedProcedureDefinition.getArguments();
                        enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            fieldDefinition = (FieldDefinition)enumeration.nextElement();
                            writer.write("call.addNamedArgument(\"");
                            writer.write(fieldDefinition.getName());
                            writer.write("\", \"");
                            writer.write(this.getFieldName(fieldDefinition.getName()));
                            writer.write("\");\n\t");
                        }
                        writer.write("deleteMappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + string4 + "\")).setCustomDeleteAllQuery(deleteMappingQuery);\n");
                    }
                }
                writer.write("}\n");
            }
            storedProcedureDefinition = (StoredProcedureDefinition)this.sequenceProcedures.get("SELECT");
            if (storedProcedureDefinition != null) {
                writer.write("\n\tValueReadQuery seqSelectQuery = new ValueReadQuery();\n\tcall = new StoredProcedureCall();\n");
                writer.write("\tcall.setProcedureName(\"");
                writer.write(storedProcedureDefinition.getName());
                writer.write("\");\n\t");
                vector = storedProcedureDefinition.getArguments();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)enumeration.nextElement();
                    writer.write("call.addNamedArgument(\"");
                    writer.write(fieldDefinition.getName());
                    writer.write("\", \"");
                    writer.write(this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                    writer.write("seqSelectQuery.addArgument(\"" + this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                }
                writer.write("seqSelectQuery.setCall(call);\n\tproject.getLogin().setSelectSequenceNumberQuery(seqSelectQuery);\n");
            }
            writer.write("}\n");
            writer.write(string3);
            writer.write("\npublic static void amendDescriptors(org.eclipse.persistence.sessions.Project project) throws Exception{");
            writer.write("\n\tamendSequences(project);");
            writer.write("\n\tfor(Iterator enumtr = project.getDescriptors().values().iterator(); enumtr.hasNext();) {");
            writer.write("\n\t\tDescriptor descriptor = (ClassDescriptor)enumtr.next();");
            writer.write("\n\t\tif(!(descriptor.isAggregateDescriptor() || descriptor.isDescriptorForInterface())) {");
            writer.write("\n\t\t\tMethod method = " + string2 + ".class.getMethod(\"amend\"+org.eclipse.persistence.internal.helper.Helper.getShortClassName(descriptor.getJavaClass())+\"ClassDescriptor\", new Class[] {ClassDescriptor.class});");
            writer.write("\n\t\t\tmethod.invoke(null, new Object[] {descriptor});");
            writer.write("\n\t\t}");
            writer.write("\n\t}");
            writer.write("\n}");
            writer.write("\n}\n");
            writer.flush();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected StoredProcedureDefinition generateDeleteStoredProcedure(ClassDescriptor classDescriptor) {
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setDescriptor(classDescriptor);
        deleteObjectQuery.setModifyRow(new DatabaseRecord());
        return this.generateObjectStoredProcedure(deleteObjectQuery, classDescriptor.getPrimaryKeyFields(), "DEL_");
    }

    protected StoredProcedureDefinition generateInsertStoredProcedure(ClassDescriptor classDescriptor) {
        InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
        insertObjectQuery.setDescriptor(classDescriptor);
        insertObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildTemplateInsertRow(this.getSession()));
        return this.generateObjectStoredProcedure(insertObjectQuery, classDescriptor.getFields(), "INS_");
    }

    protected Hashtable generateMappingStoredProcedures(ClassDescriptor classDescriptor) {
        Vector<DatabaseMapping> vector = classDescriptor.getMappings();
        Hashtable hashtable = new Hashtable();
        Enumeration<DatabaseMapping> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable<String, StoredProcedureDefinition> hashtable2 = new Hashtable<String, StoredProcedureDefinition>();
            DatabaseMapping databaseMapping = enumeration.nextElement();
            if (!databaseMapping.isOneToManyMapping()) continue;
            if (!this.getSession().getPlatform().isOracle()) {
                hashtable2.put("1MREAD", this.generateOneToManyMappingReadProcedure((OneToManyMapping)databaseMapping));
            }
            if (databaseMapping.isPrivateOwned()) {
                hashtable2.put("1MDALL", this.generateOneToManyMappingDeleteAllProcedure((OneToManyMapping)databaseMapping));
            }
            hashtable.put(databaseMapping.getAttributeName(), hashtable2);
        }
        return hashtable;
    }

    protected StoredProcedureDefinition generateObjectStoredProcedure(DatabaseQuery databaseQuery, List list, String string) {
        String string2 = Helper.getShortClassName(databaseQuery.getDescriptor().getJavaClass());
        return this.generateStoredProcedure(databaseQuery, list, this.getPrefix() + string + string2);
    }

    protected StoredProcedureDefinition generateOneToManyMappingDeleteAllProcedure(OneToManyMapping oneToManyMapping) {
        ClassDescriptor classDescriptor = oneToManyMapping.getReferenceDescriptor();
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setDescriptor(classDescriptor);
        deleteAllQuery.setReferenceClass(classDescriptor.getJavaClass());
        deleteAllQuery.setSelectionCriteria(oneToManyMapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(oneToManyMapping, deleteAllQuery, oneToManyMapping.getTargetForeignKeyToSourceKeys(), "D_1M_");
    }

    protected StoredProcedureDefinition generateOneToManyMappingProcedures(OneToManyMapping oneToManyMapping, DatabaseQuery databaseQuery, Map map, String string) {
        String string2 = Helper.getShortClassName(oneToManyMapping.getDescriptor().getJavaClass());
        return this.generateStoredProcedure(databaseQuery, new ArrayList(map.values()), this.getPrefix() + string + string2 + "_" + oneToManyMapping.getAttributeName());
    }

    protected StoredProcedureDefinition generateOneToManyMappingReadProcedure(OneToManyMapping oneToManyMapping) {
        ClassDescriptor classDescriptor = oneToManyMapping.getReferenceDescriptor();
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(classDescriptor);
        readAllQuery.setReferenceClass(classDescriptor.getJavaClass());
        readAllQuery.setSelectionCriteria(oneToManyMapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(oneToManyMapping, readAllQuery, oneToManyMapping.getTargetForeignKeyToSourceKeys(), "R_1M_");
    }

    protected StoredProcedureDefinition generateReadAllStoredProcedure(ClassDescriptor classDescriptor) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(classDescriptor);
        readAllQuery.setReferenceClass(classDescriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readAllQuery, classDescriptor.getPrimaryKeyFields(), "RALL_");
    }

    protected StoredProcedureDefinition generateReadStoredProcedure(ClassDescriptor classDescriptor) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setDescriptor(classDescriptor);
        readObjectQuery.setReferenceClass(classDescriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readObjectQuery, classDescriptor.getPrimaryKeyFields(), "READ_");
    }

    protected void generateSequenceStoredProcedures(Project project) {
        DatabaseLogin databaseLogin = (DatabaseLogin)project.getDatasourceLogin();
        if (databaseLogin.shouldUseNativeSequencing()) {
            return;
        }
        if (project.usesSequencing() && !this.getSession().getPlatform().isOracle()) {
            StoredProcedureDefinition storedProcedureDefinition = new StoredProcedureDefinition();
            storedProcedureDefinition.setName(Helper.truncate(project.getName() + "SEQ_SEL", 30));
            storedProcedureDefinition.addArgument("SEQ_NAME", String.class, 100);
            storedProcedureDefinition.addArgument("PREALLOC_SIZE", BigDecimal.class, 10);
            storedProcedureDefinition.addStatement("UPDATE " + ((TableSequence)databaseLogin.getDefaultSequence()).getTableName() + " SET " + ((TableSequence)databaseLogin.getDefaultSequence()).getCounterFieldName() + " = " + ((TableSequence)databaseLogin.getDefaultSequence()).getCounterFieldName() + " + " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "PREALLOC_SIZE WHERE " + ((TableSequence)databaseLogin.getDefaultSequence()).getNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            storedProcedureDefinition.addStatement("SELECT " + ((TableSequence)databaseLogin.getDefaultSequence()).getCounterFieldName() + " FROM " + ((TableSequence)databaseLogin.getDefaultSequence()).getTableName() + " WHERE " + ((TableSequence)databaseLogin.getDefaultSequence()).getNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            this.sequenceProcedures.put("SELECT", storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
        }
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery databaseQuery, List list, String string) {
        return this.generateStoredProcedure(databaseQuery, list, new DatabaseRecord(), string);
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery databaseQuery, List list, AbstractRecord abstractRecord, String string) {
        Cloneable cloneable;
        StoredProcedureDefinition storedProcedureDefinition = new StoredProcedureDefinition();
        Vector<String> vector = new Vector<String>();
        databaseQuery.checkPrepare(this.getSession(), abstractRecord, true);
        Vector vector2 = ((CallQueryMechanism)databaseQuery.getQueryMechanism()).getCalls();
        if (vector2.isEmpty() && ((CallQueryMechanism)databaseQuery.getQueryMechanism()).getCall() != null) {
            vector2.addElement(((CallQueryMechanism)databaseQuery.getQueryMechanism()).getCall());
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (SQLCall)enumeration.nextElement();
            vector.addElement(this.buildProcedureString((SQLCall)cloneable));
        }
        storedProcedureDefinition.setStatements(vector);
        Hashtable hashtable = new Hashtable();
        List list2 = list;
        for (int i = 0; i < list2.size(); ++i) {
            cloneable = (DatabaseField)list2.get(i);
            hashtable.put(((DatabaseField)cloneable).getName(), this.schemaManager.getColumnInfo(null, null, ((DatabaseField)cloneable).getTableName(), ((DatabaseField)cloneable).getName()).firstElement());
        }
        storedProcedureDefinition.setName(Helper.truncate(string, 30));
        Enumeration enumeration2 = hashtable.keys();
        String string2 = this.getSession().getPlatform().isOracle() ? this.getSession().getPlatform().getStoredProcedureParameterPrefix() : DEFAULT_PREFIX;
        while (enumeration2.hasMoreElements()) {
            AbstractRecord abstractRecord2 = (AbstractRecord)hashtable.get(enumeration2.nextElement());
            Number number = (Number)abstractRecord2.get("DATA_TYPE");
            Class clazz = this.getFieldType(number);
            String string3 = (String)abstractRecord2.get("TYPE_NAME");
            if (clazz != null || string3 == null || string3.length() == 0) {
                storedProcedureDefinition.addArgument(string2 + (String)abstractRecord2.get("COLUMN_NAME"), clazz, ((Number)abstractRecord2.get("COLUMN_SIZE")).intValue());
                continue;
            }
            storedProcedureDefinition.addArgument(string2 + (String)abstractRecord2.get("COLUMN_NAME"), string3);
        }
        return storedProcedureDefinition;
    }

    public void generateStoredProcedures() {
        boolean bl = this.getSession().getLogin().shouldBindAllParameters();
        this.getSession().getLogin().setShouldBindAllParameters(false);
        Map map = this.getSession().getProject().getDescriptors();
        Iterator iterator = map.keySet().iterator();
        this.generateSequenceStoredProcedures(this.getSession().getProject());
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)map.get(iterator.next());
            if (classDescriptor.isDescriptorForInterface() || classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor()) continue;
            StoredProcedureDefinition storedProcedureDefinition = this.generateInsertStoredProcedure(classDescriptor);
            Vector<StoredProcedureDefinition> vector = new Vector<StoredProcedureDefinition>();
            vector.addElement(storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
            storedProcedureDefinition = this.generateUpdateStoredProcedure(classDescriptor);
            vector.addElement(storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
            storedProcedureDefinition = this.generateDeleteStoredProcedure(classDescriptor);
            vector.addElement(storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
            if (!this.getSession().getPlatform().isOracle()) {
                storedProcedureDefinition = this.generateReadStoredProcedure(classDescriptor);
                vector.addElement(storedProcedureDefinition);
                this.writeDefinition(storedProcedureDefinition);
                storedProcedureDefinition = this.generateReadAllStoredProcedure(classDescriptor);
                vector.addElement(storedProcedureDefinition);
                this.writeDefinition(storedProcedureDefinition);
            }
            Hashtable hashtable = this.generateMappingStoredProcedures(classDescriptor);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable2 = (Hashtable)enumeration.nextElement();
                storedProcedureDefinition = (StoredProcedureDefinition)hashtable2.get("1MREAD");
                if (storedProcedureDefinition != null) {
                    this.writeDefinition(storedProcedureDefinition);
                }
                if ((storedProcedureDefinition = (StoredProcedureDefinition)hashtable2.get("1MDALL")) == null) continue;
                this.writeDefinition(storedProcedureDefinition);
            }
            this.storedProcedures.put(classDescriptor, vector);
            if (hashtable.isEmpty()) continue;
            this.mappingStoredProcedures.put(classDescriptor, hashtable);
        }
        this.getSession().getLogin().setShouldBindAllParameters(bl);
    }

    public void generateStoredProcedures(Writer writer) {
        this.writer = writer;
        this.schemaManager.outputDDLToWriter(this.getWriter());
        this.generateStoredProcedures();
        try {
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
        }
    }

    protected StoredProcedureDefinition generateUpdateStoredProcedure(ClassDescriptor classDescriptor) {
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setDescriptor(classDescriptor);
        updateObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildTemplateUpdateRow(this.getSession()));
        return this.generateObjectStoredProcedure(updateObjectQuery, classDescriptor.getFields(), "UPD_");
    }

    protected String getFieldName(String string) {
        if (this.getSession().getPlatform().isOracle()) {
            return string.substring(this.getSession().getPlatform().getStoredProcedureParameterPrefix().length());
        }
        return string;
    }

    protected Class getFieldType(Object object) {
        Integer n = new Integer(((Number)object).intValue());
        return (Class)this.intToTypeConverterHash.get(n);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public AbstractSession getSession() {
        return this.schemaManager.getSession();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    protected void verify() throws ValidationException {
        if (this.getSession().getProject().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingNotSupportedWithStoredProcedureGeneration();
        }
    }

    public void writeDefinition(StoredProcedureDefinition storedProcedureDefinition) {
        this.schemaManager.replaceObject(storedProcedureDefinition);
    }
}

