/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ClassInstanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.SerializedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingAccessor
extends MetadataAccessor {
    private static final String CONVERT_NONE = "none";
    private static final String CONVERT_SERIALIZED = "serialized";
    private static final String CONVERT_CLASS_INSTANCE = "class-instance";
    protected static final String KEY_DOT_NOTATION = "key.";
    protected static final String VALUE_DOT_NOTATION = "value.";
    private static final String DEFAULT_MAP_KEY_COLUMN_SUFFIX = "_KEY";
    private AccessMethodsMetadata m_accessMethods;
    private ClassAccessor m_classAccessor;
    private DatabaseMapping m_mapping;
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();

    protected MappingAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor.getDescriptor(), classAccessor.getProject());
        this.m_classAccessor = classAccessor;
    }

    protected MappingAccessor(String string) {
        super(string);
    }

    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String string, DatabaseField databaseField, DatabaseMapping databaseMapping) {
        DatabaseField databaseField2 = databaseMapping.getField();
        if (this.getOwningDescriptor().isPrimaryKeyField(databaseField2)) {
            this.getOwningDescriptor().removePrimaryKeyField(databaseField2);
            this.getOwningDescriptor().addPrimaryKeyField(databaseField);
        }
        if (string.indexOf(".") > -1) {
            embeddableMapping.addNestedFieldNameTranslation(string, databaseField.getQualifiedName(), databaseField2.getName());
        } else {
            embeddableMapping.addFieldNameTranslation(databaseField.getQualifiedName(), databaseField2.getName());
        }
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    protected Map<String, AssociationOverrideMetadata> getAssociationOverrides(List<AssociationOverrideMetadata> list) {
        String string;
        HashMap<String, AssociationOverrideMetadata> hashMap = new HashMap<String, AssociationOverrideMetadata>();
        for (AssociationOverrideMetadata associationOverrideMetadata : list) {
            string = associationOverrideMetadata.getName();
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName() + "." + string)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logWarningMessage("metadata_warning_ignore_association_override", string, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                hashMap.put(string, this.getDescriptor().getAssociationOverrideFor(string));
                continue;
            }
            hashMap.put(string, associationOverrideMetadata);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AssociationOverrideMetadata associationOverrideMetadata : this.getDescriptor().getAssociationOverrides()) {
                String string2 = string = associationOverrideMetadata.getName();
                String string3 = string;
                int n = string.indexOf(".");
                if (n > -1) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                if (!string2.equals(this.getAttributeName()) || hashMap.containsKey(string2)) continue;
                hashMap.put(string3, associationOverrideMetadata);
            }
        }
        return hashMap;
    }

    protected AttributeOverrideMetadata getAttributeOverride(String string) {
        if (string.equals("metadata_default_key_column")) {
            return this.getDescriptor().getAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (string.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return this.getDescriptor().getAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName());
        }
        return this.getDescriptor().getAttributeOverrideFor(this.getAttributeName());
    }

    protected Map<String, AttributeOverrideMetadata> getAttributeOverrides(List<AttributeOverrideMetadata> list) {
        String string;
        HashMap<String, AttributeOverrideMetadata> hashMap = new HashMap<String, AttributeOverrideMetadata>();
        for (AttributeOverrideMetadata attributeOverrideMetadata : list) {
            string = attributeOverrideMetadata.getName();
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName() + "." + string)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logWarningMessage("metadata_warning_ignore_attribute_override", string, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                hashMap.put(string, this.getDescriptor().getAttributeOverrideFor(string));
                continue;
            }
            hashMap.put(string, attributeOverrideMetadata);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AttributeOverrideMetadata attributeOverrideMetadata : this.getDescriptor().getAttributeOverrides()) {
                String string2 = string = attributeOverrideMetadata.getName();
                String string3 = string;
                int n = string.indexOf(".");
                if (n > -1) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                if (!string2.equals(this.getAttributeName()) || hashMap.containsKey(string2)) continue;
                hashMap.put(string3, attributeOverrideMetadata);
            }
        }
        return hashMap;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    protected ColumnMetadata getColumn(String string) {
        return new ColumnMetadata(this.getAccessibleObject(), this.getAttributeName());
    }

    protected DatabaseField getDatabaseField(DatabaseTable databaseTable, String string) {
        ColumnMetadata columnMetadata = this.hasAttributeOverride(string) ? this.getAttributeOverride(string).getColumn() : this.getColumn(string);
        DatabaseField databaseField = columnMetadata.getDatabaseField();
        if (databaseField.getTableName().equals("")) {
            databaseField.setTable(databaseTable);
        }
        String string2 = columnMetadata.getUpperCaseAttributeName();
        if (string.equals("metadata_default_key_column")) {
            string2 = string2 + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        }
        databaseField.setName(this.getName(databaseField.getName(), string2, string));
        return databaseField;
    }

    protected Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    public EnumeratedMetadata getEnumerated(boolean bl) {
        return null;
    }

    protected String getGetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getGetMethodName() != null) {
            return this.m_accessMethods.getGetMethodName();
        }
        return this.getAccessibleObjectName();
    }

    protected List<JoinColumnMetadata> getJoinColumns(List<JoinColumnMetadata> list, MetadataDescriptor metadataDescriptor) {
        List<JoinColumnMetadata> list2 = this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName()) ? this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns() : list;
        if (list2.isEmpty()) {
            if (metadataDescriptor.hasCompositePrimaryKey()) {
                for (String object : metadataDescriptor.getPrimaryKeyFieldNames()) {
                    JoinColumnMetadata joinColumnMetadata = new JoinColumnMetadata();
                    joinColumnMetadata.setReferencedColumnName(object);
                    joinColumnMetadata.setName(object);
                    list2.add(joinColumnMetadata);
                }
            } else {
                list2.add(new JoinColumnMetadata());
            }
        } else {
            for (JoinColumnMetadata joinColumnMetadata : list2) {
                joinColumnMetadata.setReferencedColumnName(metadataDescriptor.getPrimaryKeyJoinColumnAssociation(joinColumnMetadata.getReferencedColumnName()));
            }
        }
        if (metadataDescriptor.hasCompositePrimaryKey()) {
            if (list2.size() != metadataDescriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified((Object)this.getAnnotatedElement(), (Class)this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumnMetadata : list2) {
                if (!joinColumnMetadata.isPrimaryKeyFieldNotSpecified() && !joinColumnMetadata.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified((Object)this.getAnnotatedElement(), (Class)this.getJavaClass());
            }
        }
        return list2;
    }

    public LobMetadata getLob(boolean bl) {
        return null;
    }

    public DatabaseMapping getMapping() {
        return this.m_mapping;
    }

    protected int getMappingJoinFetchType(Enum enum_) {
        if (enum_ == null) {
            return 0;
        }
        if (enum_.name().equals(JoinFetchType.INNER.name())) {
            return 1;
        }
        return 2;
    }

    public Class getMapKeyReferenceClass() {
        if (this.isMapAccessor()) {
            Class clazz = this.getAccessibleObject().getMapKeyClass(this.getDescriptor());
            if (clazz == null) {
                throw ValidationException.unableToDetermineMapKeyClass((String)this.getAttributeName(), (Class)this.getJavaClass());
            }
            return clazz;
        }
        return Void.TYPE;
    }

    public Class getRawClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClassFromGeneric() {
        return this.getAccessibleObject().getReferenceClassFromGeneric(this.getDescriptor());
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        ClassAccessor classAccessor = this.getProject().getAccessor(this.getReferenceClassName());
        if (classAccessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit((String)this.getReferenceClassName());
        }
        return classAccessor.getDescriptor();
    }

    protected DatabaseTable getReferenceDatabaseTable() {
        return this.getReferenceDescriptor().getPrimaryKeyTable();
    }

    protected String getSetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getSetMethodName() != null) {
            return this.m_accessMethods.getSetMethodName();
        }
        return ((MetadataMethod)this.getAccessibleObject()).getSetMethodName();
    }

    public TemporalMetadata getTemporal(boolean bl) {
        return null;
    }

    protected boolean hasAttributeOverride(String string) {
        if (string.equals("metadata_default_key_column")) {
            return this.getDescriptor().hasAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (string.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return true;
        }
        return this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName());
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasConvert(boolean bl) {
        return this.isAnnotationPresent(Convert.class);
    }

    protected boolean hasEnumerated(boolean bl) {
        return false;
    }

    protected boolean hasLob(boolean bl) {
        return false;
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public boolean hasTemporal(boolean bl) {
        return false;
    }

    public void initXMLMappingAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
        this.initXMLAccessor(classAccessor.getDescriptor(), classAccessor.getProject());
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_accessMethods, metadataAccessibleObject);
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isBasicMap() {
        return false;
    }

    public boolean isDerivedId() {
        return false;
    }

    public boolean isDirectCollection() {
        return false;
    }

    public boolean isDirectEmbeddableCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    protected boolean isEnumerated(Class clazz, boolean bl) {
        if (this.hasConvert(bl)) {
            if (this.hasEnumerated(bl)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_enumerated", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasEnumerated(bl) || EnumeratedMetadata.isValidEnumeratedType(clazz);
    }

    public boolean isId() {
        return false;
    }

    protected boolean isLob(Class clazz, boolean bl) {
        if (this.hasConvert(bl)) {
            if (this.hasLob(bl)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_lob", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasLob(bl);
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isMapAccessor() {
        return this.getAccessibleObject().isSupportedMapClass(this.getDescriptor());
    }

    public boolean isMappedKeyMapAccessor() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    protected boolean isPrimitiveWrapperClass(Class clazz) {
        return Long.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isProcessed() {
        return this.m_mapping != null;
    }

    public boolean isRelationship() {
        return this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne();
    }

    public boolean isSerialized(Class clazz, boolean bl) {
        if (this.hasConvert(bl)) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_serialized", this.getJavaClass(), this.getAnnotatedElement());
            return false;
        }
        return this.isValidSerializedType(clazz);
    }

    protected boolean isTemporal(Class clazz, boolean bl) {
        if (this.hasConvert(bl)) {
            if (this.hasTemporal(bl)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_temporal", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasTemporal(bl) || TemporalMetadata.isValidTemporalType(clazz);
    }

    public boolean isTransient() {
        return false;
    }

    protected boolean isValidSerializedType(Class clazz) {
        if (clazz.isPrimitive()) {
            return false;
        }
        if (this.isPrimitiveWrapperClass(clazz)) {
            return false;
        }
        if (LobMetadata.isValidLobType(clazz)) {
            return false;
        }
        return !TemporalMetadata.isValidTemporalType(clazz);
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverrideMetadata, EmbeddableMapping embeddableMapping, DatabaseMapping databaseMapping, DatabaseTable databaseTable, MetadataDescriptor metadataDescriptor) {
        String string = associationOverrideMetadata.getName();
        if (databaseMapping != null && databaseMapping.isOneToOneMapping()) {
            MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(databaseMapping.getAttributeName());
            MetadataDescriptor metadataDescriptor2 = mappingAccessor.getReferenceDescriptor();
            if (associationOverrideMetadata.hasJoinColumns()) {
                for (JoinColumnMetadata joinColumnMetadata : this.getJoinColumns(associationOverrideMetadata.getJoinColumns(), metadataDescriptor2)) {
                    DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
                    databaseField.setTable(metadataDescriptor2.getPrimaryKeyTable());
                    DatabaseField databaseField2 = (DatabaseField)((OneToOneMapping)databaseMapping).getTargetToSourceKeyFields().get(databaseField);
                    if (databaseField2 == null) continue;
                    DatabaseField databaseField3 = joinColumnMetadata.getForeignKeyField();
                    if (!databaseField3.hasTableName()) {
                        databaseField3.setTable(databaseTable);
                    }
                    embeddableMapping.addFieldNameTranslation(databaseField3.getQualifiedName(), databaseField2.getName());
                }
            }
        } else {
            throw ValidationException.embeddableAssociationOverrideNotFound((Class)this.getReferenceDescriptor().getJavaClass(), (String)string, (Class)this.getJavaClass(), (String)this.getAttributeName());
        }
    }

    protected void processAssociationOverrides(List<AssociationOverrideMetadata> list, EmbeddableMapping embeddableMapping, MetadataDescriptor metadataDescriptor) {
        for (AssociationOverrideMetadata associationOverrideMetadata : this.getAssociationOverrides(list).values()) {
            this.processAssociationOverride(associationOverrideMetadata, embeddableMapping, metadataDescriptor.getMappingForAttributeName(associationOverrideMetadata.getName()), this.getOwningDescriptor().getPrimaryTable(), metadataDescriptor);
        }
    }

    protected void processAttributeOverrides(List<AttributeOverrideMetadata> list, AggregateObjectMapping aggregateObjectMapping, MetadataDescriptor metadataDescriptor) {
        for (AttributeOverrideMetadata attributeOverrideMetadata : this.getAttributeOverrides(list).values()) {
            String string = attributeOverrideMetadata.getName();
            DatabaseMapping databaseMapping = metadataDescriptor.getMappingForAttributeName(string);
            if (databaseMapping == null) {
                throw ValidationException.embeddableAttributeOverrideNotFound((Class)metadataDescriptor.getJavaClass(), (String)string, (Class)this.getJavaClass(), (String)this.getAttributeName());
            }
            if (!databaseMapping.isDirectToFieldMapping()) {
                throw ValidationException.invalidEmbeddableAttributeForAttributeOverride((Class)metadataDescriptor.getJavaClass(), (String)string, (Class)this.getJavaClass(), (String)this.getAttributeName());
            }
            this.addFieldNameTranslation((EmbeddableMapping)aggregateObjectMapping, string, attributeOverrideMetadata.getColumn().getDatabaseField(), databaseMapping);
        }
    }

    protected void processContainerPolicyAndIndirection(CollectionMapping collectionMapping) {
        String string = null;
        if (this.isMappedKeyMapAccessor()) {
            MappedKeyMapAccessor mappedKeyMapAccessor = (MappedKeyMapAccessor)((Object)this);
            Class clazz = mappedKeyMapAccessor.getMapKeyClass();
            if (clazz != null && (this.getProject().hasEntity(clazz) || this.getProject().hasEmbeddable(clazz) || mappedKeyMapAccessor.getMapKeyColumn() != null)) {
                this.processMapKeyClass(clazz, collectionMapping, mappedKeyMapAccessor);
            } else {
                this.setIndirectionPolicy(collectionMapping, this.processMapKey(string, collectionMapping), this.usesIndirection());
            }
        } else if (this.isMapAccessor()) {
            this.setIndirectionPolicy(collectionMapping, this.processMapKey(string, collectionMapping), this.usesIndirection());
        } else {
            this.setIndirectionPolicy(collectionMapping, null, this.usesIndirection());
        }
    }

    protected void processConvert(DatabaseMapping databaseMapping, String string, Class clazz, boolean bl) {
        if (!string.equals(CONVERT_NONE)) {
            if (string.equals(CONVERT_SERIALIZED)) {
                this.processSerialized(databaseMapping, clazz, bl);
            } else if (string.equals(CONVERT_CLASS_INSTANCE)) {
                new ClassInstanceMetadata().process(databaseMapping, this, clazz, bl);
            } else {
                AbstractConverterMetadata abstractConverterMetadata = this.getProject().getConverter(string);
                if (abstractConverterMetadata == null) {
                    throw ValidationException.converterNotFound((Class)this.getJavaClass(), (String)string, (Object)this.getAnnotatedElement());
                }
                abstractConverterMetadata.process(databaseMapping, this, clazz, bl);
            }
        }
    }

    protected DirectToFieldMapping processDirectMapKeyClass(Class clazz, MappedKeyMapAccessor mappedKeyMapAccessor) {
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        DatabaseField databaseField = this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column");
        directToFieldMapping.setField(databaseField);
        this.processMappingKeyConverter((DatabaseMapping)directToFieldMapping, mappedKeyMapAccessor.getMapKeyConvert(), mappedKeyMapAccessor.getMapKeyClass());
        directToFieldMapping.setAttributeClassification(this.getMapKeyReferenceClass());
        directToFieldMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        return directToFieldMapping;
    }

    protected AggregateObjectMapping processEmbeddableMapKeyClass(Class clazz, MappedKeyMapAccessor mappedKeyMapAccessor) {
        AggregateObjectMapping aggregateObjectMapping = new AggregateObjectMapping();
        aggregateObjectMapping.setReferenceClass(clazz);
        EmbeddableAccessor embeddableAccessor = this.getProject().getEmbeddableAccessor(clazz);
        if (!embeddableAccessor.isProcessed()) {
            embeddableAccessor.process(this.getReferenceDescriptor());
        }
        embeddableAccessor.getDescriptor().setIsEmbeddableCollection();
        this.processAttributeOverrides(mappedKeyMapAccessor.getMapKeyAttributeOverrides(), aggregateObjectMapping, embeddableAccessor.getDescriptor());
        this.processAssociationOverrides(mappedKeyMapAccessor.getMapKeyAssociationOverrides(), (EmbeddableMapping)aggregateObjectMapping, embeddableAccessor.getDescriptor());
        aggregateObjectMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        return aggregateObjectMapping;
    }

    protected OneToOneMapping processEntityMapKeyClass(Class clazz, MappedKeyMapAccessor mappedKeyMapAccessor) {
        OneToOneMapping oneToOneMapping = new OneToOneMapping();
        oneToOneMapping.setReferenceClass(clazz);
        oneToOneMapping.dontUseIndirection();
        oneToOneMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        EntityAccessor entityAccessor = this.getProject().getEntityAccessor(clazz.getName());
        MetadataDescriptor metadataDescriptor = entityAccessor.getDescriptor();
        String string = metadataDescriptor.getPrimaryKeyFieldName();
        String string2 = this.getAttributeName() + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        this.processOneToOneForeignKeyRelationship(oneToOneMapping, this.getJoinColumns(mappedKeyMapAccessor.getMapKeyJoinColumns(), metadataDescriptor), string, metadataDescriptor.getPrimaryTable(), string2, this.getReferenceDescriptor().getPrimaryTable());
        return oneToOneMapping;
    }

    protected void processEnumerated(EnumeratedMetadata enumeratedMetadata, DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        if (enumeratedMetadata == null) {
            enumeratedMetadata = new EnumeratedMetadata();
        }
        enumeratedMetadata.process(databaseMapping, this, clazz, bl);
    }

    protected void processJPAConverters(DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        if (this.isEnumerated(clazz, bl)) {
            this.processEnumerated(this.getEnumerated(bl), databaseMapping, clazz, bl);
        } else if (this.isLob(clazz, bl)) {
            this.processLob(this.getLob(bl), databaseMapping, clazz, bl);
        } else if (this.isTemporal(clazz, bl)) {
            this.processTemporal(this.getTemporal(bl), databaseMapping, clazz, bl);
        } else if (this.isSerialized(clazz, bl)) {
            this.processSerialized(databaseMapping, clazz, bl);
        }
    }

    protected void processLob(LobMetadata lobMetadata, DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        lobMetadata.process(databaseMapping, this, clazz, bl);
    }

    protected String processMapKey(String string, CollectionMapping collectionMapping) {
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        if ((string == null || string.equals("")) && metadataDescriptor.hasCompositePrimaryKey()) {
            return null;
        }
        String string2 = metadataDescriptor.getIdAttributeName();
        this.getLogger();
        String string3 = this.getName(string, string2, "metadata_default_map_key_attribute_name");
        MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(string3);
        if (mappingAccessor == null) {
            throw ValidationException.couldNotFindMapKey((String)string3, (Class)metadataDescriptor.getJavaClass(), (DatabaseMapping)collectionMapping);
        }
        return mappingAccessor.getAccessibleObjectName();
    }

    protected void processMapKeyClass(Class clazz, CollectionMapping collectionMapping, MappedKeyMapAccessor mappedKeyMapAccessor) {
        Class<Hashtable> clazz2;
        Object object = this.getProject().hasEntity(clazz) ? this.processEntityMapKeyClass(clazz, mappedKeyMapAccessor) : (this.getProject().hasEmbeddable(clazz) ? this.processEmbeddableMapKeyClass(clazz, mappedKeyMapAccessor) : this.processDirectMapKeyClass(clazz, mappedKeyMapAccessor));
        if (this.usesIndirection()) {
            clazz2 = ClassConstants.IndirectMap_Class;
            collectionMapping.setIndirectionPolicy((IndirectionPolicy)new TransparentIndirectionPolicy());
        } else {
            clazz2 = Hashtable.class;
            collectionMapping.dontUseIndirection();
        }
        MappedKeyMapContainerPolicy mappedKeyMapContainerPolicy = new MappedKeyMapContainerPolicy(clazz2);
        mappedKeyMapContainerPolicy.setKeyMapping((MapKeyMapping)object);
        mappedKeyMapContainerPolicy.setValueMapping((MapComponentMapping)collectionMapping);
        collectionMapping.setContainerPolicy((ContainerPolicy)mappedKeyMapContainerPolicy);
    }

    protected void processMappingConverter(DatabaseMapping databaseMapping, String string, Class clazz, boolean bl) {
        if (string != null && !string.equals(CONVERT_NONE)) {
            this.processConvert(databaseMapping, string, clazz, bl);
        }
        this.processJPAConverters(databaseMapping, clazz, bl);
    }

    protected void processMappingKeyConverter(DatabaseMapping databaseMapping, String string, Class clazz) {
        this.processMappingConverter(databaseMapping, string, clazz, true);
    }

    protected void processMappingValueConverter(DatabaseMapping databaseMapping, String string, Class clazz) {
        this.processMappingConverter(databaseMapping, string, clazz, false);
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping oneToOneMapping, List<JoinColumnMetadata> list, String string, DatabaseTable databaseTable, String string2, DatabaseTable databaseTable2) {
        for (JoinColumnMetadata joinColumnMetadata : list) {
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, string, "metadata_default_pk_column"));
            databaseField.setTable(databaseTable);
            DatabaseField databaseField2 = joinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, string2, "metadata_default_fk_column"));
            if (databaseField2.getTableName().equals("")) {
                databaseField2.setTable(databaseTable2);
            }
            oneToOneMapping.addForeignKeyField(databaseField2, databaseField);
            if (!databaseField2.isReadOnly()) continue;
            oneToOneMapping.setIsReadOnly(true);
        }
    }

    protected void processProperties(DatabaseMapping databaseMapping) {
        if (this.loadedFromXML()) {
            for (PropertyMetadata propertyMetadata : this.getProperties()) {
                this.processProperty(databaseMapping, propertyMetadata);
            }
        } else {
            Object object;
            Object t = this.getAnnotation(Properties.class);
            if (t != null) {
                object = (Annotation[])MetadataHelper.invokeMethod("value", t);
                int n = ((T)object).length;
                for (int i = 0; i < n; ++i) {
                    Object t2 = object[i];
                    this.processProperty(databaseMapping, new PropertyMetadata((Annotation)t2, this.getAccessibleObject()));
                }
            }
            if ((object = this.getAnnotation(Property.class)) != null) {
                this.processProperty(databaseMapping, new PropertyMetadata((Annotation)object, this.getAccessibleObject()));
            }
        }
    }

    protected void processProperty(DatabaseMapping databaseMapping, PropertyMetadata propertyMetadata) {
        if (propertyMetadata.shouldOverride(this.m_properties.get(propertyMetadata.getName()))) {
            this.m_properties.put(propertyMetadata.getName(), propertyMetadata);
            databaseMapping.getProperties().put(propertyMetadata.getName(), propertyMetadata.getConvertedValue());
        }
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    protected void processSerialized(DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        new SerializedMetadata().process(databaseMapping, this, clazz, bl);
    }

    protected void processSerialized(DatabaseMapping databaseMapping, Class clazz, Class clazz2, boolean bl) {
        new SerializedMetadata().process(databaseMapping, this, clazz, clazz2, bl);
    }

    protected void processTemporal(TemporalMetadata temporalMetadata, DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        if (temporalMetadata == null) {
            throw ValidationException.noTemporalTypeSpecified((String)this.getAttributeName(), (Class)this.getJavaClass());
        }
        temporalMetadata.process(databaseMapping, this, clazz, bl);
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethodsMetadata) {
        this.m_accessMethods = accessMethodsMetadata;
    }

    protected void setAccessorMethods(DatabaseMapping databaseMapping) {
        if (this.usesPropertyAccess(this.getDescriptor())) {
            databaseMapping.setGetMethodName(this.getGetMethodName());
            databaseMapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setClassAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
    }

    protected void setIndirectionPolicy(CollectionMapping collectionMapping, String string, boolean bl) {
        Class clazz = this.getRawClass();
        if (bl) {
            if (clazz == Map.class) {
                if (collectionMapping.isDirectMapMapping()) {
                    ((DirectMapMapping)collectionMapping).useTransparentMap();
                } else {
                    collectionMapping.useTransparentMap(string);
                }
            } else if (clazz == List.class) {
                collectionMapping.useTransparentList();
            } else if (clazz == Collection.class) {
                collectionMapping.useTransparentCollection();
                collectionMapping.setContainerPolicy((ContainerPolicy)new CollectionContainerPolicy(ClassConstants.IndirectList_Class));
            } else if (clazz == Set.class) {
                collectionMapping.useTransparentSet();
            } else {
                this.getLogger().logWarningMessage("non_jpa_allowed_type_used_for_collection_using_lazy_access", this.getJavaClass(), this.getAnnotatedElement(), clazz);
            }
        } else {
            collectionMapping.dontUseIndirection();
            if (clazz == Map.class) {
                if (collectionMapping.isDirectMapMapping()) {
                    ((DirectMapMapping)collectionMapping).useMapClass(Hashtable.class);
                } else {
                    collectionMapping.useMapClass(Hashtable.class, string);
                }
            } else if (clazz == Set.class) {
                collectionMapping.useCollectionClass(HashSet.class);
            } else if (clazz == List.class) {
                collectionMapping.useCollectionClass(Vector.class);
            } else if (clazz == Collection.class) {
                collectionMapping.setContainerPolicy((ContainerPolicy)new CollectionContainerPolicy(Vector.class));
            } else if (string == null || string.equals("")) {
                collectionMapping.useCollectionClass(clazz);
            } else {
                collectionMapping.useMapClass(clazz, string);
            }
        }
    }

    protected void setMapping(DatabaseMapping databaseMapping) {
        this.processProperties(databaseMapping);
        this.getDescriptor().getClassDescriptor().addMapping(databaseMapping);
        this.m_mapping = databaseMapping;
    }

    protected boolean usesIndirection() {
        return false;
    }

    public boolean usesPropertyAccess(MetadataDescriptor metadataDescriptor) {
        if (this.hasAccess()) {
            return this.hasPropertyAccess();
        }
        return this.m_accessMethods == null ? this.m_classAccessor.usesPropertyAccess() : true;
    }
}

