/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.developer.Stateful;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.glassfish.server.ServerEnvironmentImpl;
import org.glassfish.webservices.InstanceResolverImpl;
import org.glassfish.webservices.JAXWSAdapterRegistry;
import org.glassfish.webservices.JAXWSContainer;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.glassfish.webservices.monitoring.WebServiceTesterServlet;

public class JAXWSServlet
extends HttpServlet {
    private static Logger logger = LogDomains.getLogger(JAXWSServlet.class, (String)"javax.enterprise.webservices");
    private WebServiceEndpoint endpoint;
    private String urlPattern;
    private String contextRoot;
    private WebServiceEngineImpl wsEngine_;
    private ClassLoader classLoader;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.wsEngine_ = WebServiceEngineImpl.getInstance();
            this.doInit(servletConfig);
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        JAXWSServlet jAXWSServlet = this;
        synchronized (jAXWSServlet) {
            ServletAdapterList list = (ServletAdapterList)this.getServletContext().getAttribute("ADAPTER_LIST");
            if (list != null) {
                for (ServletAdapter x : list) {
                    x.getEndpoint().dispose();
                }
                this.getServletContext().removeAttribute("ADAPTER_LIST");
            }
            JAXWSAdapterRegistry.getInstance().removeAdapter(this.contextRoot);
            this.wsEngine_.removeHandler(this.endpoint);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Endpoint endpt;
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding()) && (endpt = this.wsEngine_.getEndpoint(request.getServletPath())) != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
            WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
            return;
        }
        try {
            ServletAdapter targetEndpoint = (ServletAdapter)this.getEndpointFor(request);
            if (targetEndpoint == null) {
                throw new ServletException("Service not found");
            }
            targetEndpoint.handle(this.getServletContext(), request, response);
        }
        catch (Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("Tester".equalsIgnoreCase(request.getQueryString()) && !"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
            Endpoint endpt = this.wsEngine_.getEndpoint(request.getServletPath());
            if (endpt != null && (endpt.getDescriptor().isSecure() || endpt.getDescriptor().getMessageSecurityBinding() != null || this.endpoint.hasSecurePipeline())) {
                String message = endpt.getDescriptor().getWebService().getName() + "is a secured web service; Tester feature is not supported for secured services";
                return;
            }
            if (endpt != null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
                WebServiceTesterServlet.invoke(request, response, endpt.getDescriptor());
                return;
            }
        }
        try {
            ServletAdapter targetEndpoint = (ServletAdapter)this.getEndpointFor(request);
            if (targetEndpoint != null) {
                targetEndpoint.publishWSDL(this.getServletContext(), request, response);
            } else {
                String message = "Invalid wsdl request " + request.getRequestURL();
            }
        }
        catch (Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    private void doInit(ServletConfig servletConfig) throws ServletException {
        String servletName = "unknown";
        try {
            WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
            ComponentEnvManager compEnvManager = wscImpl.getComponentEnvManager();
            JndiNameEnvironment jndiNameEnv = compEnvManager.getCurrentJndiNameEnvironment();
            WebBundleDescriptor webBundle = null;
            if (jndiNameEnv == null || !(jndiNameEnv instanceof WebBundleDescriptor)) {
                throw new WebServiceException("Cannot intialize the JAXWSServlet for " + jndiNameEnv);
            }
            webBundle = (WebBundleDescriptor)jndiNameEnv;
            this.classLoader = Thread.currentThread().getContextClassLoader();
            servletName = servletConfig.getServletName();
            this.contextRoot = webBundle.getContextRoot();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(servletName);
            if (webComponent != null) {
                WebServicesDescriptor webServices = webBundle.getWebServices();
                Collection endpoints = webServices.getEndpointsImplementedBy(webComponent);
                this.endpoint = (WebServiceEndpoint)endpoints.iterator().next();
                if (!"http://www.w3.org/2004/08/wsdl/http".equals(this.endpoint.getProtocolBinding())) {
                    this.wsEngine_.createHandler(this.endpoint);
                }
            } else {
                throw new ServletException(servletName + " not found");
            }
            this.registerEndpoint();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + servletName + "' failure", t);
            t.printStackTrace();
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEndpoint() throws Exception {
        ServletAdapter adapter;
        WsUtil wsu = new WsUtil();
        Class<?> serviceEndpointClass = Class.forName(this.endpoint.getServletImplClass(), true, this.classLoader);
        String givenBinding = this.endpoint.getProtocolBinding();
        SDDocumentSource primaryWsdl = null;
        Collection docs = null;
        if (this.endpoint.getWebService().hasWsdlFile()) {
            WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
            ServerEnvironmentImpl servEnv = wscImpl.getServerEnvironmentImpl();
            String deployedDir = servEnv.getApplicationRepositoryPath().getAbsolutePath();
            File pkgedWsdl = null;
            pkgedWsdl = deployedDir != null ? (this.endpoint.getBundleDescriptor().getApplication().isVirtual() ? new File(deployedDir + File.separator + this.endpoint.getWebService().getWsdlFileUri()) : new File(deployedDir + File.separator + this.endpoint.getBundleDescriptor().getModuleDescriptor().getArchiveUri().replaceAll("\\.", "_") + File.separator + this.endpoint.getWebService().getWsdlFileUri())) : new File(this.endpoint.getWebService().getWsdlFileUrl().getFile());
            if (pkgedWsdl.exists()) {
                pkgedWsdl = pkgedWsdl.getCanonicalFile();
                primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl.toURL());
                docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.INFO, "Creating endpoint with packaged WSDL " + primaryWsdl.getSystemId().toString());
                    logger.log(Level.FINE, "Metadata documents:");
                    for (Object source : docs) {
                        logger.log(Level.FINE, ((SDDocumentSource)source).getSystemId().toString());
                    }
                }
            }
        }
        JAXWSContainer container = new JAXWSContainer(this.getServletContext(), this.endpoint);
        URL catalogURL = null;
        File catalogFile = new File(this.endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        if (catalogFile.exists()) {
            catalogURL = catalogFile.toURL();
        }
        boolean mtomEnabled = wsu.getMtom(this.endpoint);
        WSBinding binding = null;
        if (mtomEnabled) {
            MTOMFeature mtom = new MTOMFeature(true);
            binding = BindingID.parse((String)givenBinding).createBinding(new WebServiceFeature[]{mtom});
        } else {
            binding = BindingID.parse((String)givenBinding).createBinding();
        }
        wsu.configureJAXWSServiceHandlers(this.endpoint, givenBinding, binding);
        Invoker inv = serviceEndpointClass.getAnnotation(Stateful.class) == null ? new InstanceResolverImpl(serviceEndpointClass).createInvoker() : null;
        WSEndpoint wsep = WSEndpoint.create(serviceEndpointClass, (boolean)false, (Invoker)inv, (QName)this.endpoint.getServiceName(), (QName)this.endpoint.getWsdlPort(), (Container)container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, (Collection)docs, (URL)catalogURL);
        String uri = this.endpoint.getEndpointAddressUri();
        this.urlPattern = uri.startsWith("/") ? uri : "/" + uri;
        JAXWSServlet jAXWSServlet = this;
        synchronized (jAXWSServlet) {
            ServletAdapterList list = (ServletAdapterList)this.getServletContext().getAttribute("ADAPTER_LIST");
            if (list == null) {
                list = new ServletAdapterList();
                this.getServletContext().setAttribute("ADAPTER_LIST", (Object)list);
            }
            adapter = (ServletAdapter)list.createAdapter(this.endpoint.getName(), this.urlPattern, wsep);
            container.addEndpoint(adapter);
        }
        this.registerEndpointUrlPattern((Adapter)adapter);
    }

    private void registerEndpointUrlPattern(Adapter info) {
        JAXWSAdapterRegistry.getInstance().addAdapter(this.contextRoot, this.urlPattern, info);
    }

    private Adapter getEndpointFor(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return JAXWSAdapterRegistry.getInstance().getAdapter(this.contextRoot, this.urlPattern, path);
    }
}

