/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.util;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.util.FiberExecutor;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public final class Communicator {
    private static final Logger LOGGER = Logger.getLogger(Communicator.class);
    public final QName soapMustUnderstandAttributeName;
    private final SecureConversationInitiator scInitiator;
    private final AddressingVersion addressingVersion;
    private final SOAPVersion soapVersion;
    private final FiberExecutor fiberExecutor;
    private final JAXBRIContext jaxbContext;
    private final EndpointAddress destinationAddress;

    public Communicator(String name, EndpointAddress destinationAddress, Tube tubeline, SecureConversationInitiator scInitiator, AddressingVersion addressingVersion, SOAPVersion soapVersion, JAXBRIContext jaxbContext) {
        this.destinationAddress = destinationAddress;
        this.fiberExecutor = new FiberExecutor(name, tubeline);
        this.scInitiator = scInitiator;
        this.addressingVersion = addressingVersion;
        this.soapVersion = soapVersion;
        this.soapMustUnderstandAttributeName = new QName(soapVersion.nsUri, "mustUnderstand");
        this.jaxbContext = jaxbContext;
    }

    public final Packet createRequestPacket(Object jaxbElement, String wsaAction, boolean expectReply) {
        Message message = Messages.create(this.jaxbContext, jaxbElement, this.soapVersion);
        Packet packet = new Packet(message);
        packet.endpointAddress = this.destinationAddress;
        packet.expectReply = expectReply;
        message.getHeaders().fillRequestAddressingHeaders(packet, this.addressingVersion, this.soapVersion, false, wsaAction);
        return packet;
    }

    public SecurityTokenReferenceType tryStartSecureConversation() {
        SecurityTokenReferenceType strType = null;
        if (this.scInitiator != null) {
            try {
                JAXBElement strElement = this.scInitiator.startSecureConversation(this.createEmptyRequestPacket(false));
                strType = strElement != null ? (SecurityTokenReferenceType)strElement.getValue() : null;
            }
            catch (WSSecureConversationException ex) {
                LOGGER.severe(LocalizationMessages.WSRM_1121_SECURE_CONVERSATION_INIT_FAILED(), ex);
            }
        }
        return strType;
    }

    public Packet send(Packet request) {
        request.expectReply = Boolean.TRUE;
        return this.fiberExecutor.runSync(request);
    }

    public void sendAsync(Packet request, Fiber.CompletionCallback completionCallbackHandler) {
        this.fiberExecutor.start(request, completionCallbackHandler);
    }

    public EndpointAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public Packet createEmptyRequestPacket(boolean expectReply) {
        Packet packet = new Packet();
        packet.endpointAddress = this.destinationAddress;
        packet.expectReply = expectReply;
        return packet;
    }
}

