/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.annotation.handlers;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.util.XModuleType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.ejb.Stateless;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceProvider;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServiceProviderHandler
extends AbstractHandler
implements AnnotationHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return WebServiceProvider.class;
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        WebService newWS;
        WebServicesDescriptor wsDesc;
        WebServiceEndpoint endpoint;
        String portName;
        String targetNameSpace;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        if (!(annElem instanceof Class)) {
            AnnotationProcessorException ape = new AnnotationProcessorException("@WebServiceProvider can only be specified on TYPE", annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        if (!Provider.class.isAssignableFrom((Class)annElem)) {
            AnnotationProcessorException ape = new AnnotationProcessorException(annElem.toString() + "does not implement the javax.xml.ws.Provider interface", annInfo);
            annInfo.getProcessingContext().getErrorHandler().error(ape);
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
        }
        WebServiceProvider ann = (WebServiceProvider)annInfo.getAnnotation();
        EjbBundleDescriptor bundleDesc = null;
        if (annElem.getAnnotation(Stateless.class) != null) {
            EjbContext ctx = (EjbContext)annCtx;
            bundleDesc = ctx.getDescriptor().getEjbBundleDescriptor();
            bundleDesc.setSpecVersion("3.0");
        } else {
            if (annCtx instanceof WebComponentContext) {
                bundleDesc = ((WebComponentContext)annCtx).getDescriptor().getWebBundleDescriptor();
            } else if (!(annCtx instanceof WebBundleContext)) {
                return this.getInvalidAnnotatedElementHandlerResult(annInfo.getProcessingContext().getHandler(), annInfo);
            }
            bundleDesc = ((WebBundleContext)annCtx).getDescriptor();
            bundleDesc.setSpecVersion("2.5");
        }
        String portComponentName = ((Class)annElem).getName();
        String svcName = ann.serviceName();
        if (svcName == null) {
            svcName = "";
        }
        String userSpecifiedBinding = null;
        BindingType bindingAnn = ((Class)annElem).getAnnotation(BindingType.class);
        if (bindingAnn != null) {
            userSpecifiedBinding = bindingAnn.value();
        }
        if ((targetNameSpace = ann.targetNamespace()) == null) {
            targetNameSpace = "";
        }
        if ((portName = ann.portName()) == null) {
            portName = "";
        }
        if ((endpoint = (wsDesc = bundleDesc.getWebServices()).getEndpointByName(portComponentName)) == null) {
            newWS = svcName.length() != 0 ? wsDesc.getWebServiceByName(svcName) : wsDesc.getWebServiceByName(((Class)annElem).getSimpleName() + "Service");
            if (newWS == null) {
                newWS = new WebService();
                if (svcName.length() != 0) {
                    newWS.setName(svcName);
                } else {
                    newWS.setName(((Class)annElem).getSimpleName() + "Service");
                }
                wsDesc.addWebService(newWS);
            }
            endpoint = new WebServiceEndpoint();
            endpoint.setEndpointName(portComponentName);
            newWS.addEndpoint(endpoint);
            wsDesc.setSpecVersion("1.2");
        } else {
            newWS = endpoint.getWebService();
        }
        if (endpoint.getWsdlService() != null) {
            if (targetNameSpace != null && targetNameSpace.length() != 0 && !endpoint.getWsdlService().getNamespaceURI().equals(targetNameSpace)) {
                throw new AnnotationProcessorException("Target Namespace inwsdl-service element does not match @WebService.targetNamespace", annInfo);
            }
            targetNameSpace = endpoint.getWsdlService().getNamespaceURI();
        }
        if (!endpoint.hasUserSpecifiedProtocolBinding() && userSpecifiedBinding != null && userSpecifiedBinding.length() != 0) {
            endpoint.setProtocolBinding(userSpecifiedBinding);
        }
        if (newWS.getWsdlFileUri() == null && ann.wsdlLocation() != null && ann.wsdlLocation().length() != 0) {
            newWS.setWsdlFileUri(ann.wsdlLocation());
        }
        annElem = annInfo.getAnnotatedElement();
        Class clz = (Class)annElem;
        Class<?> serviceEndpointIntf = null;
        for (Class<?> intf : clz.getInterfaces()) {
            if (!Provider.class.isAssignableFrom(intf)) continue;
            serviceEndpointIntf = intf;
            break;
        }
        if (serviceEndpointIntf == null) {
            endpoint.setServiceEndpointInterface("javax.xml.ws.Provider");
        } else {
            endpoint.setServiceEndpointInterface(serviceEndpointIntf.getName());
        }
        if (XModuleType.WAR.equals((Object)bundleDesc.getModuleType())) {
            if (endpoint.getServletImplClass() == null) {
                endpoint.setServletImplClass(((Class)annElem).getName());
            }
            WebBundleDescriptor webBundle = (WebBundleDescriptor)bundleDesc;
            if (endpoint.getWebComponentLink() == null) {
                endpoint.setWebComponentLink(portComponentName);
            }
            if (endpoint.getWebComponentImpl() == null) {
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(endpoint.getWebComponentLink());
                if (webComponent == null) {
                    webComponent = new WebComponentDescriptor();
                    webComponent.setServlet(true);
                    webComponent.setWebComponentImplementation(((Class)annElem).getCanonicalName());
                    webComponent.setName(endpoint.getEndpointName());
                    webComponent.addUrlPattern("/" + newWS.getName());
                    webBundle.addWebComponentDescriptor(webComponent);
                }
                endpoint.setWebComponentImpl(webComponent);
            }
        } else if (endpoint.getEjbLink() == null) {
            EjbDescriptor[] ejbDescs = bundleDesc.getEjbByClassName(((Class)annElem).getName());
            if (ejbDescs.length != 1) {
                throw new AnnotationProcessorException("Unable to find matching descriptor for EJB endpoint", annInfo);
            }
            endpoint.setEjbComponentImpl(ejbDescs[0]);
            ejbDescs[0].setWebServiceEndpointInterfaceName(endpoint.getServiceEndpointInterface());
            endpoint.setEjbLink(ejbDescs[0].getName());
        }
        if (endpoint.getWsdlPort() == null) {
            endpoint.setWsdlPort(new QName(targetNameSpace, portName, "ns1"));
        }
        if (endpoint.getWsdlService() == null) {
            endpoint.setWsdlService(new QName(targetNameSpace, svcName, "ns1"));
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }
}

