/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import javax.net.ssl.SSLEngine;

public class GrizzlyUtils {
    public static int readToWorkerThreadBuffers(SelectionKey key, int timeout) throws IOException {
        Object attachment = key.attachment();
        SSLEngine sslEngine = null;
        if (attachment instanceof ThreadAttachment) {
            sslEngine = ((ThreadAttachment)attachment).getSSLEngine();
        }
        WorkerThread thread = (WorkerThread)Thread.currentThread();
        if (sslEngine == null) {
            return Utils.readWithTemporarySelector((SelectableChannel)key.channel(), (ByteBuffer)thread.getByteBuffer(), (long)timeout);
        }
        ByteBuffer byteBuffer = thread.getByteBuffer();
        ByteBuffer securedBuffer = thread.getInputBB();
        if (securedBuffer.position() > 0) {
            int initialPosition = byteBuffer.position();
            int producedBytes = (byteBuffer = SSLUtils.unwrapAll((ByteBuffer)byteBuffer, (ByteBuffer)securedBuffer, (SSLEngine)sslEngine)).position() - initialPosition;
            if (producedBytes > 0) {
                return producedBytes;
            }
        }
        return SSLUtils.doSecureRead((SelectableChannel)key.channel(), (SSLEngine)sslEngine, (ByteBuffer)byteBuffer, (ByteBuffer)securedBuffer);
    }
}

