/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.fsm;

import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.State;
import com.sun.corba.ee.spi.orbutil.fsm.StateEngine;

public class FSMImpl
implements FSM {
    private boolean debug;
    private FSM parent = null;
    private State state;
    private StateEngine stateEngine;

    public FSMImpl(StateEngine se, State initialState) {
        this(se, initialState, false);
    }

    public FSMImpl(StateEngine se, State initialState, boolean debug) {
        this.state = initialState;
        this.stateEngine = se;
        if (!se.getStates(State.Kind.INITIAL).contains(initialState)) {
            throw new IllegalStateException("Error: State " + initialState + " is not an initial state");
        }
        this.debug = debug;
    }

    public FSM getParent() {
        return this.parent;
    }

    public void setParent(FSM fsm) {
        this.parent = fsm;
    }

    public StateEngine getStateEngine() {
        return this.stateEngine;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State nextState) {
        if (this.debug) {
            System.out.println("Calling internalSetState with nextState = " + nextState);
        }
        this.state = nextState;
        if (this.debug) {
            System.out.println("Exiting internalSetState with state = " + this.state);
        }
    }
}

