/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.fsm;

import com.sun.corba.ee.spi.orbutil.fsm.FSM;
import com.sun.corba.ee.spi.orbutil.fsm.Input;
import com.sun.corba.ee.spi.orbutil.fsm.NameBase;
import com.sun.corba.ee.spi.orbutil.generic.BinaryBooleanFunction;
import com.sun.corba.ee.spi.orbutil.generic.BinaryIntFunction;

public interface Guard {
    public Result evaluate(FSM var1, Input var2);

    public static abstract class Base
    extends NameBase
    implements Guard {
        public static Guard makeGuard(final Predicate pred) {
            return new Base(pred.toString()){

                public Result evaluate(FSM fsm, Input in) {
                    return pred.evaluate(fsm, in) ? Result.ENABLED : Result.DISABLED;
                }
            };
        }

        public static Predicate not(final Predicate pred) {
            return new Predicate("!" + pred.toString()){

                public boolean evaluate(FSM fsm, Input in) {
                    return !pred.evaluate(fsm, in);
                }
            };
        }

        public static Predicate and(final Predicate arg1, final Predicate arg2) {
            return new Predicate("(" + arg1.toString() + "&&" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    if (!arg1.evaluate(fsm, in)) {
                        return false;
                    }
                    return arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate or(final Predicate arg1, final Predicate arg2) {
            return new Predicate("(" + arg1.toString() + "||" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    if (arg1.evaluate(fsm, in)) {
                        return true;
                    }
                    return arg2.evaluate(fsm, in);
                }
            };
        }

        public static IntFunc constant(final int val) {
            return new IntFunc("constant(" + val + ")"){

                public int evaluate(FSM fsm, Input input) {
                    return val;
                }
            };
        }

        public static Predicate lt(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "<" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) < arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate le(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "<=" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) <= arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate gt(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + ">" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) > arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate ge(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + ">=" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) >= arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate eq(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "==" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) == arg2.evaluate(fsm, in);
                }
            };
        }

        public static Predicate ne(final IntFunc arg1, final IntFunc arg2) {
            return new Predicate("(" + arg1.toString() + "!=" + arg2.toString() + ")"){

                public boolean evaluate(FSM fsm, Input in) {
                    return arg1.evaluate(fsm, in) != arg2.evaluate(fsm, in);
                }
            };
        }

        public Base(String name) {
            super(name);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class IntFunc
        extends SimpleName
        implements BinaryIntFunction<FSM, Input> {
            public IntFunc(String name) {
                super(name);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Predicate
        extends SimpleName
        implements BinaryBooleanFunction<FSM, Input> {
            public Predicate(String name) {
                super(name);
            }
        }

        public static abstract class SimpleName {
            private String name;

            public SimpleName(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        ENABLED,
        DISABLED,
        DEFERRED;

    }
}

