/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class ExceptionFactory {
    protected String stackTraceString(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        exception.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public SystemException newSystemException(String string) {
        return new SystemException(string);
    }

    public SystemException newSystemException(Exception exception) {
        return new SystemException("Real nested exception: " + this.stackTraceString(exception));
    }

    public RollbackException rollbackException(SQLException sQLException) {
        return new RollbackException(sQLException.toString());
    }

    public SystemException txMarkedForRollbackException() {
        return this.newSystemException("Transaction marked for rollback");
    }

    public SystemException txActiveException() {
        return this.newSystemException("Transaction is already active");
    }

    public SystemException txNotActiveException() {
        return this.newSystemException("No transaction is active");
    }

    public SystemException invalidStateException(int n) {
        return this.newSystemException("Cannot complete operation, invalid state: " + n);
    }
}

