/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedAccessor
extends MappingAccessor {
    private List<AssociationOverrideMetadata> m_associationOverrides;
    private List<AttributeOverrideMetadata> m_attributeOverrides;

    public EmbeddedAccessor() {
        super("<embedded>");
    }

    protected EmbeddedAccessor(String string) {
        super(string);
    }

    public EmbeddedAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        if (this.isAnnotationPresent(AttributeOverrides.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(AttributeOverrides.class))) {
                this.m_attributeOverrides.add(new AttributeOverrideMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(AttributeOverride.class)) {
            this.m_attributeOverrides.add(new AttributeOverrideMetadata((Annotation)this.getAnnotation(AttributeOverride.class), metadataAccessibleObject));
        }
        this.m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
        if (this.isAnnotationPresent(AssociationOverrides.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(AssociationOverrides.class))) {
                this.m_associationOverrides.add(new AssociationOverrideMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(AssociationOverride.class)) {
            this.m_associationOverrides.add(new AssociationOverrideMetadata((Annotation)this.getAnnotation(AssociationOverride.class), metadataAccessibleObject));
        }
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_associationOverrides, metadataAccessibleObject);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public void process() {
        AggregateObjectMapping aggregateObjectMapping = new AggregateObjectMapping();
        this.setMapping((DatabaseMapping)aggregateObjectMapping);
        aggregateObjectMapping.setIsReadOnly(false);
        aggregateObjectMapping.setIsNullAllowed(true);
        aggregateObjectMapping.setReferenceClassName(this.getReferenceClassName());
        aggregateObjectMapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods((DatabaseMapping)aggregateObjectMapping);
        this.processAttributeOverrides(this.m_attributeOverrides, aggregateObjectMapping, this.getReferenceDescriptor());
        this.processAssociationOverrides(this.m_associationOverrides, (EmbeddableMapping)aggregateObjectMapping, this.getReferenceDescriptor());
        this.processReturnInsertAndUpdate();
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> list) {
        this.m_associationOverrides = list;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> list) {
        this.m_attributeOverrides = list;
    }
}

