/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;

public class JoinColumnMetadata
extends PrimaryKeyJoinColumnMetadata {
    private Boolean m_unique;
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;
    private String m_table;

    public JoinColumnMetadata() {
        super("<join-column>");
    }

    public JoinColumnMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        if (annotation != null) {
            this.m_table = (String)MetadataHelper.invokeMethod("table", annotation);
            this.m_unique = (Boolean)MetadataHelper.invokeMethod("unique", annotation);
            this.m_nullable = (Boolean)MetadataHelper.invokeMethod("nullable", annotation);
            this.m_updatable = (Boolean)MetadataHelper.invokeMethod("updatable", annotation);
            this.m_insertable = (Boolean)MetadataHelper.invokeMethod("insertable", annotation);
        }
    }

    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof JoinColumnMetadata) {
            JoinColumnMetadata joinColumnMetadata = (JoinColumnMetadata)object;
            if (!this.valuesMatch(this.m_unique, joinColumnMetadata.getUnique())) {
                return false;
            }
            if (!this.valuesMatch(this.m_nullable, joinColumnMetadata.getNullable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_updatable, joinColumnMetadata.getUpdatable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_insertable, joinColumnMetadata.getInsertable())) {
                return false;
            }
            return this.valuesMatch(this.m_table, joinColumnMetadata.getTable());
        }
        return false;
    }

    public DatabaseField getForeignKeyField() {
        DatabaseField databaseField = super.getForeignKeyField();
        databaseField.setTableName(this.m_table == null ? "" : this.m_table);
        databaseField.setUnique(this.m_unique == null ? false : this.m_unique);
        databaseField.setNullable(this.m_nullable == null ? true : this.m_nullable);
        databaseField.setUpdatable(this.m_updatable == null ? true : this.m_updatable);
        databaseField.setInsertable(this.m_insertable == null ? true : this.m_insertable);
        return databaseField;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public void setInsertable(Boolean bl) {
        this.m_insertable = bl;
    }

    public void setNullable(Boolean bl) {
        this.m_nullable = bl;
    }

    public void setTable(String string) {
        this.m_table = string;
    }

    public void setUnique(Boolean bl) {
        this.m_unique = bl;
    }

    public void setUpdatable(Boolean bl) {
        this.m_updatable = bl;
    }
}

