/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConversionValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConverterMetadata
extends TypeConverterMetadata {
    private List<ConversionValueMetadata> m_conversionValues = new ArrayList<ConversionValueMetadata>();
    private String m_defaultObjectValue;

    public ObjectTypeConverterMetadata() {
        super("<object-type-converter>");
    }

    public ObjectTypeConverterMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("conversionValues", annotation)) {
            this.m_conversionValues.add(new ConversionValueMetadata(annotation2, metadataAccessibleObject));
        }
        this.m_defaultObjectValue = (String)MetadataHelper.invokeMethod("defaultObjectValue", annotation);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ObjectTypeConverterMetadata) {
            ObjectTypeConverterMetadata objectTypeConverterMetadata = (ObjectTypeConverterMetadata)object;
            if (!this.valuesMatch(this.getName(), objectTypeConverterMetadata.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.getDataType(), objectTypeConverterMetadata.getDataType())) {
                return false;
            }
            if (!this.valuesMatch(this.getObjectType(), objectTypeConverterMetadata.getObjectType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_conversionValues, objectTypeConverterMetadata.getConversionValues())) {
                return false;
            }
            return this.valuesMatch(this.m_defaultObjectValue, objectTypeConverterMetadata.getDefaultObjectValue());
        }
        return false;
    }

    public List<ConversionValueMetadata> getConversionValues() {
        return this.m_conversionValues;
    }

    public String getDefaultObjectValue() {
        return this.m_defaultObjectValue;
    }

    public boolean hasConversionValues() {
        return !this.m_conversionValues.isEmpty();
    }

    private Object initObject(Class clazz, String string, boolean bl) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(clazz, new Class[]{String.class}, false));
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{string}));
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwInitObjectException(privilegedActionException, clazz, string, bl);
            }
        } else {
            try {
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor((Class)clazz, (Class[])new Class[]{String.class}, (boolean)false);
                return PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{string});
            }
            catch (Exception exception) {
                this.throwInitObjectException(exception, clazz, string, bl);
            }
        }
        return null;
    }

    @Override
    public void process(DatabaseMapping databaseMapping, MappingAccessor mappingAccessor, Class clazz, boolean bl) {
        Object object;
        String string;
        ObjectTypeConverter objectTypeConverter;
        Class clazz2 = this.getDataType(mappingAccessor, clazz);
        Class<String> clazz3 = this.getObjectType(mappingAccessor, clazz);
        if (clazz3.isEnum()) {
            objectTypeConverter = new EnumTypeConverter(databaseMapping, clazz3.getName());
            clazz3 = String.class;
        } else {
            objectTypeConverter = new ObjectTypeConverter(databaseMapping);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
        if (this.hasConversionValues()) {
            for (ConversionValueMetadata object2 : this.getConversionValues()) {
                string = object2.getDataValue();
                object = object2.getObjectValue();
                if (hashMap.containsKey(string)) {
                    throw ValidationException.multipleObjectValuesForDataValue((Class)mappingAccessor.getJavaClass(), (String)this.getName(), (String)string);
                }
                hashMap.put(string, object);
                if (hashMap2.containsKey(object)) continue;
                hashMap2.put(object, string);
            }
        }
        for (String string2 : hashMap.keySet()) {
            string = (String)hashMap.get(string2);
            object = this.initObject(clazz2, string2, true);
            Object object2 = this.initObject(clazz3, string, false);
            if (hashMap2.containsKey(string)) {
                objectTypeConverter.addConversionValue(object, object2);
                continue;
            }
            objectTypeConverter.addToAttributeOnlyConversionValue(object, object2);
        }
        if (this.m_defaultObjectValue != null && !this.m_defaultObjectValue.equals("")) {
            objectTypeConverter.setDefaultAttributeValue(this.initObject(clazz3, this.m_defaultObjectValue, false));
        }
        this.setConverter(databaseMapping, (Converter)objectTypeConverter, bl);
    }

    public void setConversionValues(List<ConversionValueMetadata> list) {
        this.m_conversionValues = list;
    }

    public void setDefaultObjectValue(String string) {
        this.m_defaultObjectValue = string;
    }

    protected void throwInitObjectException(Exception exception, Class clazz, String string, boolean bl) {
        if (bl) {
            throw ValidationException.errorInstantiatingConversionValueData((String)this.getName(), (String)string, (Class)clazz, (Exception)exception);
        }
        throw ValidationException.errorInstantiatingConversionValueObject((String)this.getName(), (String)string, (Class)clazz, (Exception)exception);
    }
}

