/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.inheritance;

import java.lang.annotation.Annotation;
import javax.persistence.InheritanceType;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.TablePerClassPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.MetadataHelper;

public class InheritanceMetadata
extends ORMetadata {
    private Enum m_strategy;

    public InheritanceMetadata() {
        super("<inheritance>");
    }

    public InheritanceMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        if (annotation != null) {
            this.m_strategy = (Enum)MetadataHelper.invokeMethod("strategy", annotation);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof InheritanceMetadata) {
            return this.valuesMatch(this.m_strategy, ((InheritanceMetadata)object).getStrategy());
        }
        return false;
    }

    public Enum getStrategy() {
        return this.m_strategy;
    }

    public void process(MetadataDescriptor metadataDescriptor) {
        EntityAccessor entityAccessor = (EntityAccessor)metadataDescriptor.getClassAccessor();
        if (this.m_strategy != null && this.m_strategy.name().equals(InheritanceType.TABLE_PER_CLASS.name())) {
            this.setTablePerClassInheritancePolicy(metadataDescriptor);
        } else {
            this.setInheritancePolicy(metadataDescriptor);
        }
        if (metadataDescriptor.isInheritanceSubclass()) {
            MetadataDescriptor metadataDescriptor2 = metadataDescriptor.getInheritanceRootDescriptor();
            EntityAccessor entityAccessor2 = (EntityAccessor)metadataDescriptor2.getClassAccessor();
            if (metadataDescriptor2.usesTablePerClassInheritanceStrategy()) {
                MetadataDescriptor metadataDescriptor3 = metadataDescriptor.getInheritanceParentDescriptor();
                metadataDescriptor.getClassDescriptor().getTablePerClassPolicy().addParentDescriptor(metadataDescriptor3.getClassDescriptor());
                metadataDescriptor3.getClassDescriptor().getTablePerClassPolicy().addChildDescriptor(metadataDescriptor.getClassDescriptor());
            } else {
                metadataDescriptor.getClassDescriptor().getInheritancePolicy().setParentClassName(metadataDescriptor.getInheritanceParentDescriptor().getJavaClassName());
            }
            if (entityAccessor.hasInheritance() && !this.equals(entityAccessor2.getInheritance())) {
                if (metadataDescriptor2.usesTablePerClassInheritanceStrategy()) {
                    this.addTablePerClassParentMappings(metadataDescriptor, metadataDescriptor);
                } else {
                    if (!this.usesTablePerClassStrategy()) {
                        this.addClassIndicatorField(metadataDescriptor, entityAccessor);
                        this.addClassIndicator(metadataDescriptor2, entityAccessor);
                    }
                    entityAccessor.processInheritancePrimaryKeyJoinColumns();
                }
            } else if (this.usesTablePerClassStrategy()) {
                this.addTablePerClassParentMappings(metadataDescriptor, metadataDescriptor);
            } else {
                this.addClassIndicator(metadataDescriptor2, entityAccessor);
                if (entityAccessor2.getInheritance().usesJoinedStrategy()) {
                    entityAccessor.processInheritancePrimaryKeyJoinColumns();
                }
            }
            if (metadataDescriptor.getInheritanceRootDescriptor().hasCompositePrimaryKey()) {
                metadataDescriptor.setPKClass(metadataDescriptor.getInheritanceRootDescriptor().getPKClass());
            }
        } else if (!this.usesTablePerClassStrategy()) {
            this.addClassIndicatorField(metadataDescriptor, entityAccessor);
            this.addClassIndicator(metadataDescriptor, entityAccessor);
        }
    }

    private void addClassIndicator(MetadataDescriptor metadataDescriptor, EntityAccessor entityAccessor) {
        if (metadataDescriptor.isInheritanceSubclass()) {
            this.addClassIndicator(metadataDescriptor.getInheritanceRootDescriptor(), entityAccessor);
        } else {
            String string = entityAccessor.getDiscriminatorValueOrNull();
            if (string != null) {
                metadataDescriptor.getClassDescriptor().getInheritancePolicy().addClassNameIndicator(entityAccessor.getJavaClassName(), (Object)string);
            }
        }
    }

    private void addClassIndicatorField(MetadataDescriptor metadataDescriptor, EntityAccessor entityAccessor) {
        metadataDescriptor.getClassDescriptor().getInheritancePolicy().setClassIndicatorField(entityAccessor.processDiscriminatorColumn());
    }

    public void addTablePerClassParentMappings(MetadataDescriptor metadataDescriptor, MetadataDescriptor metadataDescriptor2) {
        EntityAccessor entityAccessor = null;
        MetadataDescriptor metadataDescriptor3 = null;
        if (metadataDescriptor2.isInheritanceSubclass() && metadataDescriptor2.getInheritanceRootDescriptor().usesTablePerClassInheritanceStrategy()) {
            metadataDescriptor3 = metadataDescriptor2.getInheritanceParentDescriptor();
            entityAccessor = this.reloadEntity((EntityAccessor)metadataDescriptor3.getClassAccessor(), metadataDescriptor);
            this.addTablePerClassParentMappings(metadataDescriptor, metadataDescriptor3);
        }
        if (entityAccessor != null) {
            EntityAccessor entityAccessor2 = (EntityAccessor)metadataDescriptor3.getClassAccessor();
            for (MappedSuperclassAccessor mappedSuperclassAccessor : entityAccessor2.getMappedSuperclasses()) {
                this.reloadMappedSuperclass(mappedSuperclassAccessor, metadataDescriptor).addAccessors();
            }
            entityAccessor.addAccessors();
        }
    }

    private void setInheritancePolicy(MetadataDescriptor metadataDescriptor) {
        if (this.m_strategy != null || !metadataDescriptor.isInheritanceSubclass()) {
            // empty if block
        }
        metadataDescriptor.getClassDescriptor().setInheritancePolicy(new InheritancePolicy(metadataDescriptor.getClassDescriptor()));
    }

    public void setStrategy(Enum enum_) {
        this.m_strategy = enum_;
    }

    private void setTablePerClassInheritancePolicy(MetadataDescriptor metadataDescriptor) {
        metadataDescriptor.getClassDescriptor().setTablePerClassPolicy(new TablePerClassPolicy(metadataDescriptor.getClassDescriptor()));
    }

    public boolean usesJoinedStrategy() {
        return this.m_strategy != null && this.m_strategy.name().equals(InheritanceType.JOINED.name());
    }

    public boolean usesSingleTableStrategy() {
        return this.m_strategy == null || this.m_strategy.name().equals(InheritanceType.SINGLE_TABLE.name());
    }

    public boolean usesTablePerClassStrategy() {
        return this.m_strategy != null && this.m_strategy.name().equals(InheritanceType.TABLE_PER_CLASS.name());
    }
}

