/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.FieldResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResultMetadata
extends ORMetadata {
    private Class m_entityClass;
    private List<FieldResultMetadata> m_fieldResults = new ArrayList<FieldResultMetadata>();
    private String m_discriminatorColumn;
    private String m_entityClassName;

    public EntityResultMetadata() {
        super("<entity-result>");
    }

    public EntityResultMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_entityClass = (Class)MetadataHelper.invokeMethod("entityClass", annotation);
        this.m_discriminatorColumn = (String)MetadataHelper.invokeMethod("discriminatorColumn", annotation);
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("fields", annotation)) {
            this.m_fieldResults.add(new FieldResultMetadata(annotation2, metadataAccessibleObject));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof EntityResultMetadata) {
            EntityResultMetadata entityResultMetadata = (EntityResultMetadata)object;
            if (!this.valuesMatch(this.m_entityClass, entityResultMetadata.getEntityClass())) {
                return false;
            }
            if (!this.valuesMatch(this.m_fieldResults, entityResultMetadata.getFieldResults())) {
                return false;
            }
            return this.valuesMatch(this.m_discriminatorColumn, entityResultMetadata.getDiscriminatorColumn());
        }
        return false;
    }

    public String getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    public String getEntityClassName() {
        return this.m_entityClassName;
    }

    public List<FieldResultMetadata> getFieldResults() {
        return this.m_fieldResults;
    }

    public boolean hasFieldResults() {
        return this.m_fieldResults != null && !this.m_fieldResults.isEmpty();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_fieldResults, metadataAccessibleObject);
        this.m_entityClass = this.initXMLClassName(this.m_entityClassName);
    }

    public void setDiscriminatorColumn(String string) {
        this.m_discriminatorColumn = string;
    }

    public void setEntityClass(Class clazz) {
        this.m_entityClass = clazz;
    }

    public void setEntityClassName(String string) {
        this.m_entityClassName = string;
    }

    public void setFieldResults(List<FieldResultMetadata> list) {
        this.m_fieldResults = list;
    }
}

