/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.codegen;

import com.sun.corba.ee.spi.orbutil.codegen.ClassInfo;
import com.sun.corba.ee.spi.orbutil.codegen.Expression;
import com.sun.corba.ee.spi.orbutil.codegen.MethodInfo;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.copyobject.Immutable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class Signature {
    private Type rtype;
    private List<Type> types;
    private String signature;

    private Signature(Type rtype, List<Type> types) {
        this.rtype = rtype;
        this.types = types;
        this.signature = "(";
        if (types != null) {
            for (Type t : types) {
                this.signature = this.signature + t.signature();
            }
        }
        this.signature = this.signature + ")" + rtype.signature();
    }

    public static Signature make(Type rtype, List<Type> types) {
        return new Signature(rtype, types);
    }

    public Type returnType() {
        return this.rtype;
    }

    public List<Type> argTypes() {
        return this.types;
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public String toString() {
        return "Signature[" + this.signature + "]";
    }

    public String signature() {
        return this.signature;
    }

    public String displayAsMethod() {
        return this.displayAsMethod("");
    }

    public String displayAsMethod(String methodName) {
        StringBuilder result = new StringBuilder();
        if (methodName.length() > 0) {
            result.append(this.rtype.name());
            result.append(" ");
            result.append(methodName);
        }
        result.append("(");
        boolean first = true;
        for (Type t : this.types) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(t.name());
        }
        result.append(")");
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Signature)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Signature other = (Signature)Signature.class.cast(obj);
        return this.signature.equals(other.signature);
    }

    private void checkArgTypeCompatibility(List<Type> atypes) {
        this.checkArgTypeCompatibility(atypes, true);
    }

    private boolean checkArgTypeCompatibility(List<Type> atypes, boolean throwsException) {
        Iterator<Type> titer = this.types.iterator();
        Iterator<Type> aiter = atypes.iterator();
        while (titer.hasNext() && aiter.hasNext()) {
            Type at;
            Type tt = titer.next();
            if (tt.isMethodInvocationConvertibleFrom(at = aiter.next())) continue;
            if (throwsException) {
                throw new IllegalArgumentException("Type " + at.name() + " cannot be converted to type " + tt.name() + " by a method invocation conversion");
            }
            return false;
        }
        if (titer.hasNext() != aiter.hasNext()) {
            if (throwsException) {
                throw new IllegalArgumentException("Signature requires " + this.types.size() + " but " + atypes.size() + " arguments were passed to call");
            }
            return false;
        }
        return true;
    }

    static List<Type> getExprTypes(List<Expression> exprs) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Expression ex : exprs) {
            result.add(ex.type());
        }
        return result;
    }

    private static ClassInfo getClassInfo(Type type) {
        ClassInfo cinfo = null;
        if (type != null) {
            cinfo = type.classInfo();
        }
        return cinfo;
    }

    private void checkCompatibility(Type targetType, String ident, List<Expression> args, boolean isStaticMethod) {
        List<Type> atypes = Signature.getExprTypes(args);
        this.checkArgTypeCompatibility(atypes);
        ClassInfo cinfo = Signature.getClassInfo(targetType);
        MethodInfo minfo = cinfo.findMethodInfo(ident, this);
        if (minfo == null) {
            throw new IllegalArgumentException("Could not find method " + this.displayAsMethod(ident) + " in class " + cinfo.name());
        }
        if (isStaticMethod != Modifier.isStatic(minfo.modifiers())) {
            if (isStaticMethod) {
                throw new IllegalArgumentException("Method " + this.displayAsMethod(ident) + " is not static");
            }
            throw new IllegalArgumentException("Method " + this.displayAsMethod(ident) + " is static");
        }
    }

    public void checkCompatibility(Type targetType, String ident, List<Expression> args) {
        this.checkCompatibility(targetType, ident, args, false);
    }

    public void checkStaticCompatibility(Type targetType, String ident, List<Expression> args) {
        this.checkCompatibility(targetType, ident, args, true);
    }

    public void checkConstructorCompatibility(Type targetType, List<Expression> args) {
        List<Type> atypes = Signature.getExprTypes(args);
        this.checkArgTypeCompatibility(atypes);
        ClassInfo cinfo = Signature.getClassInfo(targetType);
        MethodInfo minfo = null;
        for (MethodInfo info : cinfo.constructorInfo()) {
            if (!this.equals(info.signature())) continue;
            minfo = info;
            break;
        }
        if (minfo == null) {
            throw new IllegalArgumentException("Could not find constructor with signature " + this.displayAsMethod() + " in class " + cinfo.name());
        }
    }

    private static Set<MethodInfo> getMethods(Type type, String ident, boolean staticOnly) {
        ClassInfo cinfo = Signature.getClassInfo(type);
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        while (cinfo != null) {
            Set<MethodInfo> methods = cinfo.methodInfoByName().get(ident);
            if (methods != null) {
                for (MethodInfo mi : methods) {
                    if (Modifier.isStatic(mi.modifiers()) != staticOnly) continue;
                    result.add(mi);
                }
            }
            cinfo = Signature.getClassInfo(cinfo.superType());
        }
        if (result.size() == 0) {
            if (staticOnly) {
                throw new IllegalArgumentException("Type " + type.name() + " does not have any static methods named " + ident);
            }
            throw new IllegalArgumentException("Type " + type.name() + " does not have any non-static methods named " + ident);
        }
        return result;
    }

    private static Set<MethodInfo> getCompatibleMethods(Set<MethodInfo> methods, List<Type> argTypes) {
        HashSet<MethodInfo> compatibleMethods = new HashSet<MethodInfo>();
        for (MethodInfo minfo : methods) {
            Signature sig = minfo.signature();
            if (!sig.checkArgTypeCompatibility(argTypes, false)) continue;
            compatibleMethods.add(minfo);
        }
        return compatibleMethods;
    }

    private static String sprintf(String format, Object ... args) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.printf(format, args);
        return sw.toString();
    }

    private static String getCallTypeString(CallType ct, String ident) {
        switch (ct) {
            case STATIC: {
                return "static method named " + ident;
            }
            case NON_STATIC: {
                return "non-static method named " + ident;
            }
            case CONSTRUCTOR: {
                return "constructor";
            }
        }
        throw new IllegalArgumentException("getCallTypeString is missing a CallType");
    }

    private static String getTypeListString(List<Type> types) {
        String start = "(";
        StringBuilder asb = new StringBuilder();
        asb.append("(");
        for (Type type : types) {
            if (asb.length() != "(".length()) {
                asb.append(", ");
            }
            asb.append(type.name());
        }
        asb.append(")");
        return asb.toString();
    }

    private static String getMethodListString(Set<MethodInfo> mlist) {
        StringBuilder sb = new StringBuilder();
        for (MethodInfo m : mlist) {
            sb.append(Signature.sprintf("\t%s\n", m.signature().displayAsMethod(m.name())));
        }
        return sb.toString();
    }

    private static MethodInfo returnCompatibleMethod(Type type, String ident, List<Type> argTypes, CallType ctype, Set<MethodInfo> compatibleMethods) {
        if (compatibleMethods.size() == 0) {
            String cts = Signature.getCallTypeString(ctype, ident);
            String tls = Signature.getTypeListString(argTypes);
            throw new IllegalArgumentException(Signature.sprintf("Could not find %s in class %s compatible with arguments %s", cts, type.name(), tls));
        }
        if (compatibleMethods.size() == 1) {
            Iterator<MethodInfo> i$ = compatibleMethods.iterator();
            if (i$.hasNext()) {
                MethodInfo m = i$.next();
                return m;
            }
        } else {
            String cts = Signature.getCallTypeString(ctype, ident);
            String tls = Signature.getTypeListString(argTypes);
            String infoList = Signature.getMethodListString(compatibleMethods);
            throw new IllegalArgumentException(Signature.sprintf("Found more than one %s in class %s compatible with arguments %s:\n%s", cts, ident, type.name(), tls, infoList));
        }
        return null;
    }

    private static Signature fromMethodCallUsingTypes(Type type, String ident, List<Type> types, boolean isStaticCall) {
        Set<MethodInfo> methods = Signature.getMethods(type, ident, false);
        Set<MethodInfo> compatibleMethods = Signature.getCompatibleMethods(methods, types);
        MethodInfo minfo = Signature.returnCompatibleMethod(type, ident, types, isStaticCall ? CallType.STATIC : CallType.NON_STATIC, compatibleMethods);
        return minfo.signature();
    }

    private static Signature fromMethodCall(Type type, String ident, List<Expression> exprs, boolean isStaticCall) {
        List<Type> types = Signature.getExprTypes(exprs);
        return Signature.fromMethodCallUsingTypes(type, ident, types, isStaticCall);
    }

    public static Signature fromCall(Type type, String ident, List<Expression> exprs) {
        return Signature.fromMethodCall(type, ident, exprs, false);
    }

    public static Signature fromCallUsingTypes(Type type, String ident, List<Type> types) {
        return Signature.fromMethodCallUsingTypes(type, ident, types, false);
    }

    public static Signature fromStaticCall(Type type, String ident, List<Expression> exprs) {
        return Signature.fromMethodCall(type, ident, exprs, true);
    }

    public static Signature fromStaticCallUsingTypes(Type type, String ident, List<Type> types) {
        return Signature.fromMethodCallUsingTypes(type, ident, types, true);
    }

    public static Signature fromConstructorUsingTypes(Type type, List<Type> types) {
        ClassInfo cinfo = Signature.getClassInfo(type);
        Set<MethodInfo> methods = cinfo.constructorInfo();
        if (methods == null) {
            throw new IllegalArgumentException("Type " + type.name() + " does not have any constructors!");
        }
        Set<MethodInfo> compatibleMethods = Signature.getCompatibleMethods(methods, types);
        MethodInfo minfo = Signature.returnCompatibleMethod(type, "", types, CallType.CONSTRUCTOR, compatibleMethods);
        return minfo.signature();
    }

    public static Signature fromConstructor(Type type, List<Expression> exprs) {
        List<Type> types = Signature.getExprTypes(exprs);
        return Signature.fromConstructorUsingTypes(type, types);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CallType {
        STATIC,
        NON_STATIC,
        CONSTRUCTOR;

    }
}

