/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor.telemetry;

import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.monitor.telemetry.JDBCPoolTelemetryBootstrap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Average;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.AverageFactory;
import org.glassfish.flashlight.statistics.factory.CounterFactory;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPoolTelemetry
implements PostConstruct {
    private boolean isEnabled = true;
    private String monitoringLevel;
    private String jdbcPoolName;
    private Collection<ProbeClientMethodHandle> handles;
    private Logger logger;
    private TreeNode jdbcPoolNode = null;
    private JDBCPoolTelemetryBootstrap jdbcPoolTMBootstrap = new JDBCPoolTelemetryBootstrap();
    private ProbeClientMediator pcm;
    private PoolLifeCycleListenerRegistry poolRegistry;
    private Counter numConnFailedValidation = CounterFactory.createCount((long[])new long[0]);
    private Counter numConnTimedOut = CounterFactory.createCount((long[])new long[0]);
    private Counter numConnFree = CounterFactory.createCount((long[])new long[0]);
    private Counter numConnUsed = CounterFactory.createCount((long[])new long[0]);
    private Average connRequestWaitTime = AverageFactory.createAverage();
    private Counter numConnDestroyed = CounterFactory.createCount((long[])new long[0]);
    private Counter numConnAcquired = CounterFactory.createCount((long[])new long[0]);
    private Counter numConnReleased = CounterFactory.createCount((long[])new long[0]);
    private Counter numConnCreated = CounterFactory.createCount((long[])new long[0]);
    private Counter numPotentialConnLeak = CounterFactory.createCount((long[])new long[0]);

    public void postConstruct() {
    }

    public JDBCPoolTelemetry(TreeNode parent, String jdbcPoolName, Logger logger, ProbeClientMediator pcm) {
        this.jdbcPoolNode = parent;
        this.jdbcPoolName = jdbcPoolName;
        this.logger = logger;
        this.pcm = pcm;
        this.addSubNodes(parent);
    }

    public JDBCPoolTelemetry(TreeNode parent, String jdbcPoolName, Logger logger) {
        this.jdbcPoolNode = parent;
        this.jdbcPoolName = jdbcPoolName;
        this.logger = logger;
        this.addSubNodes(parent);
    }

    public TreeNode getJdbcPoolNode() {
        return this.jdbcPoolNode;
    }

    private void addSubNodes(TreeNode parent) {
        try {
            TreeNode poolNode = TreeNodeFactory.createTreeNode((String)this.jdbcPoolName, null, (String)"jdbc-connection-pool");
            parent.addChild(poolNode);
            Method m1 = this.getClass().getMethod("getNumPotentialConnLeakCount", new Class[0]);
            TreeNode connLeakNode = TreeNodeFactory.createMethodInvoker((String)"numpotentialconnleak-count", (Object)this, (String)"jdbc-connection-pool", (Method)m1);
            poolNode.addChild(connLeakNode);
            Method m2 = this.getClass().getMethod("getNumConnFailedValidation", new Class[0]);
            TreeNode connFailValNode = TreeNodeFactory.createMethodInvoker((String)"numconnfailedvalidation-count", (Object)this, (String)"jdbc-connection-pool", (Method)m2);
            poolNode.addChild(connFailValNode);
            Method m3 = this.getClass().getMethod("getNumConnTimedOut", new Class[0]);
            TreeNode numConnTimedOutNode = TreeNodeFactory.createMethodInvoker((String)"numconntimedout-count", (Object)this, (String)"jdbc-connection-pool", (Method)m3);
            poolNode.addChild(numConnTimedOutNode);
            Method m4 = this.getClass().getMethod("getNumConnFree", new Class[0]);
            TreeNode numConnFreeNode = TreeNodeFactory.createMethodInvoker((String)"numconnfree-count", (Object)this, (String)"jdbc-connection-pool", (Method)m4);
            poolNode.addChild(numConnFreeNode);
            Method m5 = this.getClass().getMethod("getNumConnUsed", new Class[0]);
            TreeNode numConnUsedNode = TreeNodeFactory.createMethodInvoker((String)"numconnused-count", (Object)this, (String)"jdbc-connection-pool", (Method)m5);
            poolNode.addChild(numConnUsedNode);
            Method m6 = this.getClass().getMethod("getConnRequestWaitTime", new Class[0]);
            TreeNode connReqWaitTimeNode = TreeNodeFactory.createMethodInvoker((String)"connectionrequestwaittime-count", (Object)this, (String)"jdbc-connection-pool", (Method)m6);
            poolNode.addChild(connReqWaitTimeNode);
            Method m7 = this.getClass().getMethod("getNumConnDestroyed", new Class[0]);
            TreeNode numConnDestroyedNode = TreeNodeFactory.createMethodInvoker((String)"numconndestroyed-count", (Object)this, (String)"jdbc-connection-pool", (Method)m7);
            poolNode.addChild(numConnDestroyedNode);
            Method m8 = this.getClass().getMethod("getNumConnAcquired", new Class[0]);
            TreeNode numConnAcquiredNode = TreeNodeFactory.createMethodInvoker((String)"numconnacquired-count", (Object)this, (String)"jdbc-connection-pool", (Method)m8);
            poolNode.addChild(numConnAcquiredNode);
            Method m9 = this.getClass().getMethod("getNumConnCreated", new Class[0]);
            TreeNode numConnCreatedNode = TreeNodeFactory.createMethodInvoker((String)"numconncreated-count", (Object)this, (String)"jdbc-connection-pool", (Method)m9);
            poolNode.addChild(numConnCreatedNode);
            Method m10 = this.getClass().getMethod("getNumConnReleased", new Class[0]);
            TreeNode numConnReleasedNode = TreeNodeFactory.createMethodInvoker((String)"numconnreleased-count", (Object)this, (String)"jdbc-connection-pool", (Method)m10);
            poolNode.addChild(numConnReleasedNode);
            parent.addChild(poolNode);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(JDBCPoolTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(JDBCPoolTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(JDBCPoolTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getJdbcPoolName() {
        return this.jdbcPoolName;
    }

    public PoolLifeCycleListenerRegistry getPoolRegistry() {
        return this.poolRegistry;
    }

    public void setPoolRegistry(PoolLifeCycleListenerRegistry poolRegistry) {
        this.poolRegistry = poolRegistry;
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled != flag) {
            for (ProbeClientMethodHandle handle : this.handles) {
                if (flag) {
                    handle.enable();
                    continue;
                }
                handle.disable();
            }
            this.isEnabled = flag;
        }
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
    }

    public void removeProbeListenerHandles() {
        this.handles = null;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::potentialConnLeakEvent")
    public void potentialConnLeakEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Leak event received - poolName = " + poolName);
            this.numPotentialConnLeak.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionTimedOutEvent")
    public void connectionTimedOutEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Timed-out event received - poolName = " + poolName);
            this.numConnTimedOut.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::decrementFreeConnectionsSizeEvent")
    public void decrementFreeConnectionsSizeEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="steadyPoolSize") int steadyPoolSize) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Decrement Num Connections Free event received - poolName = " + poolName);
            if (this.numConnFree.getCount() + this.numConnUsed.getCount() > (long)steadyPoolSize) {
                this.logger.finest("Free + Used greater than steady pool size. Decrementing numConnFree");
                this.numConnFree.decrement();
            }
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::decrementConnectionUsedEvent")
    public void decrementConnectionUsedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="beingDestroyed") boolean beingDestroyed, @ProbeParam(value="steadyPoolSize") int steadyPoolSize) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Decrement Num Connections Used event received - poolName = " + poolName);
            this.numConnUsed.decrement();
            if (beingDestroyed) {
                if (this.numConnFree.getCount() + this.numConnUsed.getCount() < (long)steadyPoolSize) {
                    this.numConnFree.increment();
                }
            } else {
                this.numConnFree.increment();
            }
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionsFreedEvent")
    public void connectionsFreedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="count") int count) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connections Freed event received - poolName = " + poolName);
            this.logger.finest("numConnUsed =" + this.numConnUsed.getCount() + " numConnFree=" + this.numConnFree.getCount() + " Number of connections freed =" + count);
            this.numConnFree.setCount((long)count);
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionUsedEvent")
    public void connectionUsedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Used event received - poolName = " + poolName);
            this.numConnUsed.increment();
            this.numConnFree.decrement();
            this.numConnFree.setCount(this.numConnFree.getCount() < 0L ? 0L : this.numConnFree.getCount());
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionValidationFailedEvent")
    public void connectionValidationFailedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="increment") int increment) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection Validation Failed event received - poolName = " + poolName);
            this.numConnFailedValidation.increment((long)increment);
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionRequestServedEvent")
    public void connectionRequestServedEvent(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="timeTakenInMillis") long timeTakenInMillis) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection request served event received - poolName = " + poolName);
            this.connRequestWaitTime.addDataPoint(timeTakenInMillis);
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionDestroyedEvent")
    public void connectionDestroyedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection destroyed event received - poolName = " + poolName);
            this.numConnDestroyed.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionAcquiredEvent")
    public void connectionAcquiredEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection acquired event received - poolName = " + poolName);
            this.numConnAcquired.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionReleasedEvent")
    public void connectionReleasedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection released event received - poolName = " + poolName);
            this.numConnReleased.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::connectionCreatedEvent")
    public void connectionCreatedEvent(@ProbeParam(value="poolName") String poolName) {
        if (poolName != null && poolName.equals(this.jdbcPoolName)) {
            this.logger.finest("Connection created event received - poolName = " + poolName);
            this.numConnCreated.increment();
        }
    }

    @ProbeListener(value="jdbc-connection-pool:jdbc-connection-pool::toString")
    public void toString(@ProbeParam(value="poolName") String poolName, @ProbeParam(value="stackTrace") StringBuffer stackTrace) {
        this.logger.finest("toString(poolName) event received. Monitoring level observed : " + this.monitoringLevel);
        if (poolName != null && poolName.equals(this.jdbcPoolName) && this.jdbcPoolTMBootstrap.getEnabledValue(this.monitoringLevel)) {
            if ("LOW".equals(this.monitoringLevel)) {
                this.lowLevelLog(stackTrace);
            } else if ("HIGH".equals(this.monitoringLevel)) {
                this.highLevelLog(stackTrace);
            }
        }
    }

    private void lowLevelLog(StringBuffer stackTrace) {
        stackTrace.append("\n curNumConnUsed = " + this.numConnUsed.getCount());
        stackTrace.append("\n curNumConnFree = " + this.numConnFree.getCount());
        stackTrace.append("\n numConnCreated = " + this.numConnCreated.getCount());
        stackTrace.append("\n numConnDestroyed = " + this.numConnDestroyed.getCount());
    }

    private void highLevelLog(StringBuffer stackTrace) {
        this.lowLevelLog(stackTrace);
        stackTrace.append("\n numConnFailedValidation = " + this.numConnFailedValidation.getCount());
        stackTrace.append("\n numConnTimedOut = " + this.numConnTimedOut.getCount());
        stackTrace.append("\n numConnAcquired = " + this.numConnAcquired.getCount());
        stackTrace.append("\n numConnReleased = " + this.numConnReleased.getCount());
        stackTrace.append("\n numPotentialConnLeak = " + this.numPotentialConnLeak.getCount());
    }

    public void setMonitoringLevel(String newLevel) {
        this.monitoringLevel = newLevel;
    }

    public long getNumPotentialConnLeakCount() {
        return this.numPotentialConnLeak.getCount();
    }

    public long getNumConnFailedValidation() {
        return this.numConnFailedValidation.getCount();
    }

    public long getNumConnTimedOut() {
        return this.numConnTimedOut.getCount();
    }

    public long getNumConnUsed() {
        return this.numConnUsed.getCount();
    }

    public long getNumConnFree() {
        return this.numConnFree.getCount();
    }

    public long getConnRequestWaitTime() {
        return this.connRequestWaitTime.getCurrent();
    }

    public long getNumConnDestroyed() {
        return this.numConnDestroyed.getCount();
    }

    public long getNumConnAcquired() {
        return this.numConnAcquired.getCount();
    }

    public long getNumConnCreated() {
        return this.numConnCreated.getCount();
    }

    public long getNumConnReleased() {
        return this.numConnReleased.getCount();
    }
}

