/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import java.util.Stack;

public class DprintUtil {
    private Object client;
    private ThreadLocal<Stack<String>> currentMethod = new ThreadLocal<Stack<String>>(){

        @Override
        public Stack<String> initialValue() {
            return new Stack<String>();
        }
    };

    public DprintUtil(Object self) {
        this.client = self;
    }

    public void dprint(String msg) {
        ORBUtility.dprint(this.client, msg);
    }

    private String makeString(Object ... args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        boolean first = true;
        for (Object obj : args) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(obj.toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public void enter(String mname, Object ... args) {
        this.currentMethod.get().push(mname);
        String str = this.makeString(args);
        this.dprint("." + mname + "->" + str);
    }

    public void info(Object ... args) {
        String mname = this.currentMethod.get().peek();
        String str = this.makeString(args);
        this.dprint("." + mname + "::" + str);
    }

    public void exit() {
        String mname = this.currentMethod.get().pop();
        this.dprint("." + mname + "<-");
    }

    public void exit(Object retVal) {
        String mname = this.currentMethod.get().pop();
        this.dprint("." + mname + "<-(" + retVal + ")");
    }
}

