/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.servicecontext;

import com.sun.corba.ee.impl.encoding.CDRInputStream;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.TimingPoints;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContextFactoryRegistry;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.servicecontext.UnknownServiceContext;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContextsImpl
implements ServiceContexts {
    private final com.sun.corba.ee.spi.orb.ORB orb;
    private static final AtomicInteger creationCount = new AtomicInteger(0);
    private final int instance;
    private final Map<Integer, Object> scMap;
    private CodeBase codeBase;
    private GIOPVersion giopVersion;
    private TimingPoints tp;
    private final ORBUtilSystemException wrapper;

    private String getValidSCIds() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (int id : this.scMap.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(id);
        }
        sb.append(")");
        return sb.toString();
    }

    private void dprint(String msg) {
        ORBUtility.dprint(this, "SC" + this.instance + this.getValidSCIds() + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMapFromInputStream(InputStream is) {
        this.tp.enter_serviceContextsCreateMap();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->createMapFromInputStream");
        }
        try {
            int numValid = is.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint(".createMapFromInputStream: numValid = " + numValid);
            }
            for (int ctr = 0; ctr < numValid; ++ctr) {
                int scId = is.read_long();
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".createMapFromInputStream: Reading service context id " + scId);
                }
                byte[] data = OctetSeqHelper.read((org.omg.CORBA.portable.InputStream)is);
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".createMapFromInputStream: Service context" + scId + " length: " + data.length);
                }
                this.scMap.put(scId, data);
            }
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-createMapFromInputStream");
            }
            this.tp.exit_serviceContextsCreateMap();
        }
    }

    public ServiceContextsImpl(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
        this.instance = orb.serviceContextDebugFlag ? creationCount.getAndIncrement() : 0;
        this.tp = (TimingPoints)orb.getTimerManager().points();
        this.wrapper = orb.getLogWrapperTable().get_RPC_PROTOCOL_ORBUtil();
        this.scMap = new HashMap<Integer, Object>();
        this.giopVersion = orb.getORBData().getGIOPVersion();
        this.codeBase = null;
        if (orb.serviceContextDebugFlag) {
            this.dprint("<init>(ORB)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContextsImpl(InputStream s) {
        this((com.sun.corba.ee.spi.orb.ORB)s.orb());
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("-> <init>(InputStream)");
        }
        try {
            this.codeBase = ((CDRInputStream)s).getCodeBase();
            this.createMapFromInputStream(s);
            this.giopVersion = ((CDRInputStream)s).getGIOPVersion();
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<- <init>(InputStream)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceContext unmarshal(int scId, byte[] data) {
        this.tp.enter_serviceContextsUnmarshal();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->unmarshal");
        }
        try {
            ServiceContextFactoryRegistry scr = this.orb.getServiceContextFactoryRegistry();
            ServiceContext.Factory factory = scr.find(scId);
            ServiceContext sc = null;
            if (factory == null) {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".unmarshal: Could not find ServiceContext.Factory for " + scId + " using UnknownServiceContext");
                }
                sc = ServiceContextDefaults.makeUnknownServiceContext(scId, data);
            } else {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".unmarshal: Found " + factory + " id " + scId);
                }
                EncapsInputStream eis = new EncapsInputStream((ORB)this.orb, data, data.length, this.giopVersion, this.codeBase);
                try {
                    eis.consumeEndian();
                    sc = factory.create(eis, this.giopVersion);
                }
                finally {
                    try {
                        eis.close();
                    }
                    catch (IOException e) {
                        this.wrapper.ioexceptionDuringStreamClose(e);
                    }
                }
                if (sc == null) {
                    throw this.wrapper.svcctxUnmarshalError(CompletionStatus.COMPLETED_MAYBE);
                }
            }
            UnknownServiceContext unknownServiceContext = sc;
            return unknownServiceContext;
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-unmarshal");
            }
            this.tp.exit_serviceContextsUnmarshal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream os, GIOPVersion gv) {
        this.tp.enter_serviceContextsWrite();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->write");
        }
        try {
            int numsc = this.scMap.size();
            os.write_long(numsc);
            this.writeServiceContextsInOrder(os, gv);
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-write");
            }
            this.tp.exit_serviceContextsWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServiceContextsInOrder(OutputStream os, GIOPVersion gv) {
        this.tp.enter_serviceContextsWriteInOrder();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->writeServiceContextsInOrder");
        }
        try {
            int ueid = 9;
            for (int i : this.scMap.keySet()) {
                if (i == ueid) continue;
                this.writeMapEntry(os, i, this.scMap.get(i), gv);
            }
            Object uesc = this.scMap.get(ueid);
            if (uesc != null) {
                this.writeMapEntry(os, ueid, uesc, gv);
            }
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("->writeServiceContextsInOrder");
            }
            this.tp.exit_serviceContextsWriteInOrder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapEntry(OutputStream os, int id, Object scObj, GIOPVersion gv) {
        this.tp.enter_serviceContextsWriteMapEntry();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->writeMapEntry: id = " + id);
        }
        try {
            if (scObj instanceof byte[]) {
                byte[] sc = (byte[])scObj;
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".writeMapEntry: writing service context bytes for id " + id);
                }
                OctetSeqHelper.write((org.omg.CORBA.portable.OutputStream)os, (byte[])sc);
            } else if (scObj instanceof ServiceContext) {
                ServiceContext sc = (ServiceContext)scObj;
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".writeMapEntry: Writing service context " + sc);
                }
                sc.write(os, gv);
            } else {
                this.wrapper.errorInServiceContextMap();
            }
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-writeMapEntry");
            }
            this.tp.exit_serviceContextsWriteMapEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ServiceContext sc) {
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->put: sc.id = " + sc.getId());
        }
        try {
            this.scMap.put(sc.getId(), sc);
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-put");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int scId) {
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->delete: scId = " + scId);
        }
        try {
            this.scMap.remove(scId);
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-delete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContext get(int id) {
        this.tp.enter_serviceContextsGet();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->get: id = " + id);
        }
        try {
            Object result = this.scMap.get(id);
            if (result == null) {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".get: id " + id + " not found ");
                }
                ServiceContext serviceContext = null;
                return serviceContext;
            }
            if (this.orb.serviceContextDebugFlag) {
                this.dprint(".get: id " + id + " found ");
            }
            if (result instanceof byte[]) {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint(".get: unmarshalling id = " + id);
                }
                ServiceContext sc = this.unmarshal(id, (byte[])result);
                this.scMap.put(id, sc);
                ServiceContext serviceContext = sc;
                return serviceContext;
            }
            ServiceContext serviceContext = (ServiceContext)result;
            return serviceContext;
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-get");
            }
            this.tp.exit_serviceContextsGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceContextsImpl(ServiceContextsImpl scimpl) {
        this(scimpl.orb);
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("-> <init>(ServiceContextsImpl)");
        }
        try {
            this.codeBase = scimpl.codeBase;
            this.giopVersion = scimpl.giopVersion;
            for (Map.Entry<Integer, Object> entry : scimpl.scMap.entrySet()) {
                this.scMap.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<- <init>(ServiceContextsImpl)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceContexts copy() {
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("->copy");
        }
        try {
            ServiceContextsImpl result;
            ServiceContextsImpl serviceContextsImpl = result = new ServiceContextsImpl(this);
            return serviceContextsImpl;
        }
        finally {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("<-copy");
            }
        }
    }
}

