/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.AbstractSingletonContainer;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.security.PolicyLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.ejb.security.application.EJBSecurityManager;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.ejb.startup.SingletonLifeCycleManager;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ejb")
@Scoped(value=PerLookup.class)
public class EjbApplication
implements ApplicationContainer<Collection<EjbDescriptor>> {
    private Collection<EjbDescriptor> ejbs;
    private Collection<Container> containers = new ArrayList<Container>();
    private ClassLoader ejbAppClassLoader;
    private DeploymentContext dc;
    private Habitat habitat;
    private EJBSecurityManagerFactory ejbSMF;
    private ContainerFactory ejbContainerFactory;
    private SingletonLifeCycleManager singletonLCM;
    boolean usesEJBTimerService = false;
    private PolicyLoader policyLoader;
    private static boolean restored = false;
    private static Object lock = new Object();

    public EjbApplication(Collection<EjbDescriptor> bundleDesc, DeploymentContext dc, ClassLoader cl, Habitat habitat, EJBSecurityManagerFactory ejbSecMgrFactory) {
        this.ejbs = bundleDesc;
        this.ejbAppClassLoader = cl;
        this.dc = dc;
        this.habitat = habitat;
        this.ejbContainerFactory = (ContainerFactory)habitat.getByContract(ContainerFactory.class);
        this.ejbSMF = ejbSecMgrFactory;
        this.policyLoader = (PolicyLoader)habitat.getComponent(PolicyLoader.class);
    }

    public Collection<EjbDescriptor> getDescriptor() {
        return this.ejbs;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        try {
            DeployCommandParameters params = (DeployCommandParameters)((DeploymentContext)startupContext).getCommandParameters(DeployCommandParameters.class);
            if (this.usesEJBTimerService) {
                this.initEJBTimerService(params);
            }
            for (Container container : this.containers) {
                container.startApplication(params.origin == OpsParams.Origin.deploy);
            }
            this.singletonLCM.doStartup();
        }
        catch (Exception e) {
            this.abortInitializationAfterException();
            throw e;
        }
        return true;
    }

    boolean loadContainers(ApplicationContext startupContext) {
        DeployCommandParameters params = (DeployCommandParameters)((DeploymentContext)startupContext).getCommandParameters(DeployCommandParameters.class);
        boolean deploy = params.origin == OpsParams.Origin.deploy;
        boolean counter = false;
        this.singletonLCM = new SingletonLifeCycleManager();
        try {
            this.policyLoader.loadPolicy();
            Object moduleName = null;
            for (EjbDescriptor desc : this.ejbs) {
                EJBSecurityManager ejbSM = null;
                ejbSM = this.ejbSMF.createManager(desc, true);
                Container container = this.ejbContainerFactory.createContainer(desc, this.ejbAppClassLoader, ejbSM, this.dc);
                this.containers.add(container);
                boolean bl = this.usesEJBTimerService = this.usesEJBTimerService || container.isTimedObject();
                if (!(container instanceof AbstractSingletonContainer)) continue;
                this.singletonLCM.addSingletonContainer((AbstractSingletonContainer)container);
            }
        }
        catch (Throwable t) {
            this.abortInitializationAfterException();
            throw new RuntimeException("EJB Container initialization error", t);
        }
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        OpsParams params = ((DeploymentContext)stopContext).getCommandParameters(OpsParams.class);
        boolean undeploy = params.origin == OpsParams.Origin.undeploy || params.origin == OpsParams.Origin.deploy;
        this.singletonLCM.doShutdown();
        for (Container container : this.containers) {
            if (undeploy) {
                container.undeploy();
                if (container.getSecurityManager() == null) continue;
                container.getSecurityManager().destroy();
                continue;
            }
            container.onShutdown();
        }
        this.containers.clear();
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.ejbAppClassLoader;
    }

    private void abortInitializationAfterException() {
        for (Container container : this.containers) {
            container.undeploy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEJBTimerService(DeployCommandParameters callerParams) {
        Object object = lock;
        synchronized (object) {
            EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
            EJBTimerService ejbTimerService = ejbContainerUtil.getEJBTimerService();
            if (ejbTimerService == null) {
                Logger logger = ejbContainerUtil.getLogger();
                Deployment deployment = (Deployment)this.habitat.getByContract(Deployment.class);
                boolean isRegistered = deployment.isRegistered("ejb-timer-service-app");
                if (isRegistered) {
                    logger.log(Level.WARNING, "EJBTimerService had been explicitly deployed.");
                    return;
                }
                logger.log(Level.INFO, "Loading EJBTimerService. Please wait.");
                ServerContext sc = (ServerContext)this.habitat.getByContract(ServerContext.class);
                File root = sc.getInstallRoot();
                File app = new File(root, "lib/install/applications/ejb-timer-service-app.war");
                ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
                DeployCommandParameters params = new DeployCommandParameters(app);
                params.name = "ejb-timer-service-app";
                params.origin = callerParams.origin;
                if (!app.exists()) {
                    throw new RuntimeException("Failed to deploy EJBTimerService: required WAR file (ejb-timer-service-app.war) is not installed");
                }
                try {
                    ExtendedDeploymentContext dc = deployment.getContext(logger, app, (OpsParams)params, report);
                    deployment.deploy(dc);
                    if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                        throw new RuntimeException("Failed to deploy EJBTimerService: " + report.getFailureCause());
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Failed to deploy EJBTimerService: " + ioe);
                }
            }
        }
    }
}

