/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.BeanDescriptor;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.BeanMetaData;
import org.hibernate.validation.engine.BeanMetaDataCache;
import org.hibernate.validation.engine.BeanMetaDataImpl;
import org.hibernate.validation.engine.ConstraintHelper;
import org.hibernate.validation.engine.ExecutionContext;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.engine.groups.Group;
import org.hibernate.validation.engine.groups.GroupChain;
import org.hibernate.validation.engine.groups.GroupChainGenerator;
import org.hibernate.validation.jtype.TypeUtils;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.PropertyIterator;
import org.hibernate.validation.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorImpl
implements Validator {
    private static final Logger log = LoggerFactory.make();
    private static final Set<Class<?>> VALID_MAP_INDEX_CLASSES = new HashSet();
    private static final Class<?>[] DEFAULT_GROUP_ARRAY;
    private GroupChainGenerator groupChainGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintHelper constraintHelper, BeanMetaDataCache beanMetaDataCache) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.constraintHelper = constraintHelper;
        this.beanMetaDataCache = beanMetaDataCache;
        this.groupChainGenerator = new GroupChainGenerator();
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validation of a null object");
        }
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ExecutionContext<T> context = ExecutionContext.getContextForValidate(object, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver);
        List<ConstraintViolation<T>> list = this.validateInContext(context, groupChain);
        return new HashSet<ConstraintViolation<T>>(list);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validated object cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ArrayList<ConstraintViolation<T>> failingConstraintViolations = new ArrayList<ConstraintViolation<T>>();
        this.validateProperty(object, new PropertyIterator(propertyName), failingConstraintViolations, groupChain);
        return new HashSet<ConstraintViolation<T>>(failingConstraintViolations);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        if (beanType == null) {
            throw new IllegalArgumentException("The bean type cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ArrayList<ConstraintViolation<T>> failingConstraintViolations = new ArrayList<ConstraintViolation<T>>();
        this.validateValue(beanType, value, new PropertyIterator(propertyName), failingConstraintViolations, groupChain);
        return new HashSet<ConstraintViolation<T>>(failingConstraintViolations);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.getBeanMetaData(clazz).getBeanDescriptor();
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Invalid property path.");
        }
    }

    private GroupChain determineGroupExecutionOrder(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("null passed as group name");
        }
        if (groups.length == 0) {
            groups = DEFAULT_GROUP_ARRAY;
        }
        return this.groupChainGenerator.getGroupChainFor(Arrays.asList(groups));
    }

    private <T> List<ConstraintViolation<T>> validateInContext(ExecutionContext<T> context, GroupChain groupChain) {
        Group group;
        if (context.peekCurrentBean() == null) {
            return Collections.emptyList();
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            context.setCurrentGroup(group.getGroup());
            this.validateConstraints(context);
        }
        groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            context.setCurrentGroup(group.getGroup());
            this.validateCascadedConstraints(context);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group2 : sequence) {
                int numberOfViolations = context.getFailingConstraints().size();
                context.setCurrentGroup(group2.getGroup());
                this.validateConstraints(context);
                this.validateCascadedConstraints(context);
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private <T> void validateConstraints(ExecutionContext<T> executionContext) {
        BeanMetaData<?> beanMetaData = this.getBeanMetaData(executionContext.peekCurrentBeanType());
        if (executionContext.getCurrentGroup().getName().equals(Default.class.getName())) {
            List<Class<?>> defaultGroupSequence = beanMetaData.getDefaultGroupSequence();
            if (log.isTraceEnabled() && defaultGroupSequence.size() > 0 && defaultGroupSequence.get(0) != Default.class) {
                log.trace("Executing re-defined Default group for bean {} as sequence {}", (Object)beanMetaData.getBeanClass().getName(), defaultGroupSequence);
            }
            for (Class<?> defaultSequenceMember : defaultGroupSequence) {
                executionContext.setCurrentGroup(defaultSequenceMember);
                boolean validationSuccessful = this.validateConstraintsForCurrentGroup(executionContext, beanMetaData);
                if (validationSuccessful) continue;
                break;
            }
        } else {
            this.validateConstraintsForCurrentGroup(executionContext, beanMetaData);
        }
    }

    private <T> boolean validateConstraintsForCurrentGroup(ExecutionContext<T> executionContext, BeanMetaData<T> beanMetaData) {
        boolean validationSuccessful = true;
        for (MetaConstraint<T, Annotation> metaConstraint : beanMetaData.geMetaConstraintList()) {
            executionContext.pushProperty(metaConstraint.getPropertyName());
            if (executionContext.isValidationRequired(metaConstraint)) {
                boolean tmp = metaConstraint.validateConstraint(executionContext);
                validationSuccessful = validationSuccessful && tmp;
            }
            executionContext.popProperty();
        }
        return validationSuccessful;
    }

    private <T> void validateCascadedConstraints(ExecutionContext<T> context) {
        List<Member> cascadedMembers = this.getBeanMetaData(context.peekCurrentBeanType()).getCascadedMembers();
        for (Member member : cascadedMembers) {
            Type type = ReflectionHelper.typeOf(member);
            context.pushProperty(ReflectionHelper.getPropertyName(member));
            Object value = ReflectionHelper.getValue(member, context.peekCurrentBean());
            if (value != null) {
                Iterator<?> iter = this.createIteratorForCascadedValue(context, type, value);
                this.validateCascadedConstraint(context, iter);
            }
            context.popProperty();
        }
    }

    private <T> Iterator<?> createIteratorForCascadedValue(ExecutionContext<T> context, Type type, Object value) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
            context.markCurrentPropertyAsIndexed();
        } else if (ReflectionHelper.isMap(type)) {
            Map map = (Map)value;
            iter = map.values().iterator();
            context.markCurrentPropertyAsIndexed();
        } else if (TypeUtils.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
            context.markCurrentPropertyAsIndexed();
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    private <T> void validateCascadedConstraint(ExecutionContext<T> context, Iterator<?> iter) {
        int i = 0;
        while (iter.hasNext()) {
            Object actualValue = iter.next();
            String propertyIndex = String.valueOf(i);
            if (actualValue instanceof Map.Entry) {
                Object key = ((Map.Entry)actualValue).getKey();
                if (VALID_MAP_INDEX_CLASSES.contains(key.getClass())) {
                    propertyIndex = key.toString();
                }
                actualValue = ((Map.Entry)actualValue).getValue();
            }
            if (!context.isAlreadyValidated(actualValue)) {
                context.setPropertyIndex(propertyIndex);
                context.pushCurrentBean(actualValue);
                GroupChain groupChain = this.groupChainGenerator.getGroupChainFor(Arrays.asList(context.getCurrentGroup()));
                this.validateInContext(context, groupChain);
                context.popCurrentBean();
            }
            ++i;
        }
    }

    private <T> void validateProperty(T object, PropertyIterator propertyIter, List<ConstraintViolation<T>> failingConstraintViolations, GroupChain groupChain) {
        HashSet metaConstraints;
        Class<?> beanType = object.getClass();
        Object hostingBeanInstance = this.collectMetaConstraintsForPath(beanType, object, propertyIter, metaConstraints = new HashSet());
        if (hostingBeanInstance == null) {
            throw new IllegalArgumentException("Invalid property path.");
        }
        if (metaConstraints.size() == 0) {
            return;
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            this.validatePropertyForGroup(object, propertyIter, failingConstraintViolations, metaConstraints, hostingBeanInstance, group);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            int numberOfConstraintViolationsBefore = failingConstraintViolations.size();
            for (Group group : sequence) {
                this.validatePropertyForGroup(object, propertyIter, failingConstraintViolations, metaConstraints, hostingBeanInstance, group);
                if (failingConstraintViolations.size() <= numberOfConstraintViolationsBefore) continue;
                continue block1;
            }
        }
    }

    private <T> void validatePropertyForGroup(T object, PropertyIterator propertyIter, List<ConstraintViolation<T>> failingConstraintViolations, Set<MetaConstraint<T, ?>> metaConstraints, Object hostingBeanInstance, Group group) {
        List<Class<?>> groupList;
        int numberOfConstraintViolationsBefore = failingConstraintViolations.size();
        BeanMetaData<T> beanMetaData = this.getBeanMetaData(metaConstraints.iterator().next().getBeanClass());
        if (group.isDefaultGroup()) {
            groupList = beanMetaData.getDefaultGroupSequence();
        } else {
            groupList = new ArrayList();
            groupList.add(group.getGroup());
        }
        for (Class<?> groupClass : groupList) {
            for (MetaConstraint<T, ?> metaConstraint : metaConstraints) {
                ExecutionContext<T> context = ExecutionContext.getContextForValidateProperty(object, hostingBeanInstance, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver);
                context.pushProperty(propertyIter.getOriginalProperty());
                context.setCurrentGroup(groupClass);
                if (context.isValidationRequired(metaConstraint)) {
                    metaConstraint.validateConstraint(context);
                    failingConstraintViolations.addAll(context.getFailingConstraints());
                }
                context.popProperty();
            }
            if (failingConstraintViolations.size() <= numberOfConstraintViolationsBefore) continue;
            break;
        }
    }

    private <T> void validateValue(Class<T> beanType, Object value, PropertyIterator propertyIter, List<ConstraintViolation<T>> failingConstraintViolations, GroupChain groupChain) {
        HashSet metaConstraints = new HashSet();
        this.collectMetaConstraintsForPath(beanType, null, propertyIter, metaConstraints);
        if (metaConstraints.size() == 0) {
            return;
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            this.validateValueForGroup(beanType, value, propertyIter, failingConstraintViolations, metaConstraints, group);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            int numberOfConstraintViolations = failingConstraintViolations.size();
            for (Group group : sequence) {
                this.validateValueForGroup(beanType, value, propertyIter, failingConstraintViolations, metaConstraints, group);
                if (failingConstraintViolations.size() <= numberOfConstraintViolations) continue;
                continue block1;
            }
        }
    }

    private <T> void validateValueForGroup(Class<T> beanType, Object value, PropertyIterator propertyIter, List<ConstraintViolation<T>> failingConstraintViolations, Set<MetaConstraint<T, ?>> metaConstraints, Group group) {
        List<Class<?>> groupList;
        int numberOfConstraintViolations = failingConstraintViolations.size();
        BeanMetaData<T> beanMetaData = this.getBeanMetaData(metaConstraints.iterator().next().getBeanClass());
        if (group.isDefaultGroup()) {
            groupList = beanMetaData.getDefaultGroupSequence();
        } else {
            groupList = new ArrayList();
            groupList.add(group.getGroup());
        }
        for (Class<?> groupClass : groupList) {
            for (MetaConstraint<T, ?> metaConstraint : metaConstraints) {
                ExecutionContext<T> context = ExecutionContext.getContextForValidateValue(beanType, value, this.messageInterpolator, this.constraintValidatorFactory, this.traversableResolver);
                context.pushProperty(propertyIter.getOriginalProperty());
                context.setCurrentGroup(groupClass);
                if (context.isValidationRequired(metaConstraint)) {
                    metaConstraint.validateConstraint(value, context);
                    failingConstraintViolations.addAll(context.getFailingConstraints());
                }
                context.popProperty();
            }
            if (failingConstraintViolations.size() <= numberOfConstraintViolations) continue;
            break;
        }
    }

    private <T> Object collectMetaConstraintsForPath(Class<T> clazz, Object value, PropertyIterator propertyIter, Set<MetaConstraint<T, ?>> metaConstraints) {
        propertyIter.split();
        if (!propertyIter.hasNext()) {
            if (!ReflectionHelper.containsMember(clazz, propertyIter.getHead())) {
                throw new IllegalArgumentException("Invalid property path.");
            }
            List<MetaConstraint<T, Annotation>> metaConstraintList = this.getBeanMetaData(clazz).geMetaConstraintList();
            for (MetaConstraint<T, Annotation> metaConstraint : metaConstraintList) {
                if (!metaConstraint.getPropertyName().equals(propertyIter.getHead())) continue;
                metaConstraints.add(metaConstraint);
            }
        } else {
            List<Member> cascadedMembers = this.getBeanMetaData(clazz).getCascadedMembers();
            for (Member m : cascadedMembers) {
                if (!ReflectionHelper.getPropertyName(m).equals(propertyIter.getHead())) continue;
                Type type = ReflectionHelper.typeOf(m);
                Object object = value = value == null ? null : ReflectionHelper.getValue(m, value);
                if (propertyIter.isIndexed()) {
                    type = ReflectionHelper.getIndexedType(type);
                    Object object2 = value = value == null ? null : ReflectionHelper.getIndexedValue(value, propertyIter.getIndex());
                    if (type == null) continue;
                }
                this.collectMetaConstraintsForPath((Class)type, value, propertyIter, metaConstraints);
            }
        }
        return value;
    }

    private <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        BeanMetaDataImpl<T> metadata = this.beanMetaDataCache.getBeanMetaData(beanClass);
        if (metadata == null) {
            metadata = new BeanMetaDataImpl<T>(beanClass, this.constraintHelper);
            this.beanMetaDataCache.addBeanMetaData(beanClass, metadata);
        }
        return metadata;
    }

    static {
        VALID_MAP_INDEX_CLASSES.add(Integer.class);
        VALID_MAP_INDEX_CLASSES.add(Long.class);
        VALID_MAP_INDEX_CLASSES.add(String.class);
        DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    }
}

