/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.Record;

public class QueryException
extends ValidationException {
    protected transient DatabaseQuery query;
    protected transient AbstractRecord queryArguments;
    public static final int ADDITIONAL_SIZE_QUERY_NOT_SPECIFIED = 6001;
    public static final int AGGREGATE_OBJECT_CANNOT_BE_DELETED = 6002;
    public static final int ARGUMENT_SIZE_MISMATCH_IN_QUERY_AND_QUERY_DEFINITION = 6003;
    public static final int BACKUP_CLONE_IS_ORIGINAL_FROM_PARENT = 6004;
    public static final int BACKUP_CLONE_IS_ORIGINAL_FROM_SELF = 6005;
    public static final int BATCH_READING_NOT_SUPPORTED = 6006;
    public static final int DESCRIPTOR_IS_MISSING = 6007;
    public static final int DESCRIPTOR_IS_MISSING_FOR_NAMED_QUERY = 6008;
    public static final int INCORRECT_SIZE_QUERY_FOR_CURSOR_STREAM = 6013;
    public static final int INVALID_QUERY = 6014;
    public static final int INVALID_QUERY_KEY_IN_EXPRESSION = 6015;
    public static final int INVALID_QUERY_ON_SERVER_SESSION = 6016;
    public static final int NO_CONCRETE_CLASS_INDICATED = 6020;
    public static final int NO_CURSOR_SUPPORT = 6021;
    public static final int OBJECT_TO_INSERT_IS_EMPTY = 6023;
    public static final int OBJECT_TO_MODIFY_NOT_SPECIFIED = 6024;
    public static final int QUERY_NOT_DEFINED = 6026;
    public static final int QUERY_SENT_TO_INACTIVE_UNIT_OF_WORK = 6027;
    public static final int READ_BEYOND_QUERY = 6028;
    public static final int REFERENCE_CLASS_MISSING = 6029;
    public static final int REFRESH_NOT_POSSIBLE_WITHOUT_CACHE = 6030;
    public static final int SIZE_ONLY_SUPPORTED_ON_EXPRESSION_QUERIES = 6031;
    public static final int SQL_STATEMENT_NOT_SET_PROPERLY = 6032;
    public static final int INVALID_QUERY_ITEM = 6034;
    public static final int SELECTION_OBJECT_CANNOT_BE_NULL = 6041;
    public static final int UNNAMED_QUERY_ON_SESSION_BROKER = 6042;
    public static final int REPORT_RESULT_WITHOUT_PKS = 6043;
    public static final int NULL_PRIMARY_KEY_IN_BUILDING_OBJECT = 6044;
    public static final int NO_DESCRIPTOR_FOR_SUBCLASS = 6045;
    public static final int CANNOT_DELETE_READ_ONLY_OBJECT = 6046;
    public static final int INVALID_OPERATOR = 6047;
    public static final int ILLEGAL_USE_OF_GETFIELD = 6048;
    public static final int ILLEGAL_USE_OF_GETTABLE = 6049;
    public static final int REPORT_QUERY_RESULT_SIZE_MISMATCH = 6050;
    public static final int CANNOT_CACHE_PARTIAL_OBJECT = 6051;
    public static final int OUTER_JOIN_ONLY_VALID_FOR_ONE_TO_ONE = 6052;
    public static final int CANNOT_ADD_TO_CONTAINER = 6054;
    public static final int METHOD_INVOCATION_FAILED = 6055;
    public static final int CANNOT_CREATE_CLONE = 6056;
    public static final int METHOD_NOT_VALID = 6057;
    public static final int METHOD_DOES_NOT_EXIST_IN_CONTAINER_CLASS = 6058;
    public static final int COULD_NOT_INSTANTIATE_CONTAINER_CLASS = 6059;
    public static final int MAP_KEY_NOT_COMPARABLE = 6060;
    public static final int CANNOT_ACCESS_METHOD_ON_OBJECT = 6061;
    public static final int CALLED_METHOD_THREW_EXCEPTION = 6062;
    public static final int INVALID_OPERATION = 6063;
    public static final int CANNOT_REMOVE_FROM_CONTAINER = 6064;
    public static final int CANNOT_ADD_ELEMENT = 6065;
    public static final int BACKUP_CLONE_DELETED = 6066;
    public static final int CANNOT_ACCESS_FIELD_ON_OBJECT = 6067;
    public static final int CANNOT_COMPARE_TABLES_IN_EXPRESSION = 6068;
    public static final int INVALID_TABLE_FOR_FIELD_IN_EXPRESSION = 6069;
    public static final int INVALID_USE_OF_TO_MANY_QUERY_KEY_IN_EXPRESSION = 6070;
    public static final int INVALID_USE_OF_ANY_OF_IN_EXPRESSION = 6071;
    public static final int CANNOT_QUERY_ACROSS_VARIABLE_ONE_TO_ONE_MAPPING = 6072;
    public static final int ILL_FORMED_EXPRESSION = 6073;
    public static final int CANNOT_CONFORM_EXPRESSION = 6074;
    public static final int INVALID_OPERATOR_FOR_OBJECT_EXPRESSION = 6075;
    public static final int UNSUPPORTED_MAPPING_FOR_OBJECT_COMPARISON = 6076;
    public static final int OBJECT_COMPARISON_CANNOT_BE_PARAMETERIZED = 6077;
    public static final int INCORRECT_CLASS_FOR_OBJECT_COMPARISON = 6078;
    public static final int CANNOT_COMPARE_TARGET_FOREIGN_KEYS_TO_NULL = 6079;
    public static final int INVALID_DATABASE_CALL = 6080;
    public static final int INVALID_DATABASE_ACCESSOR = 6081;
    public static final int METHOD_DOES_NOT_EXIST_ON_EXPRESSION = 6082;
    public static final int IN_CANNOT_BE_PARAMETERIZED = 6083;
    public static final int REDIRECTION_CLASS_OR_METHOD_NOT_SET = 6084;
    public static final int REDIRECTION_METHOD_NOT_DEFINED_CORRECTLY = 6085;
    public static final int REDIRECTION_METHOD_ERROR = 6086;
    public static final int EXAMPLE_AND_REFERENCE_OBJECT_CLASS_MISMATCH = 6087;
    public static final int NO_ATTRIBUTES_FOR_REPORT_QUERY = 6088;
    public static final int NO_EXPRESSION_BUILDER_CLASS_FOUND = 6089;
    public static final int CANNOT_SET_REPORT_QUERY_TO_CHECK_CACHE_ONLY = 6090;
    public static final int TYPE_MISMATCH_BETWEEN_ATTRIBUTE_AND_CONSTANT_ON_EXPRESSION = 6091;
    public static final int MUST_INSTANTIATE_VALUEHOLDERS = 6092;
    public static final int PARAMETER_NAME_MISMATCH = 6094;
    public static final int CLONE_METHOD_REQUIRED = 6095;
    public static final int CLONE_METHOD_INACCESSIBLE = 6096;
    public static final int CLONE_METHOD_THORW_EXCEPTION = 6097;
    public static final int UNEXPECTED_INVOCATION = 6098;
    public static final int JOINING_ACROSS_INHERITANCE_WITH_MULTIPLE_TABLES = 6099;
    public static final int MULTIPLE_ROWS_DETECTED_FROM_SINGLE_OBJECT_READ = 6100;
    public static final int HISTORICAL_QUERIES_MUST_PRESERVE_GLOBAL_CACHE = 6101;
    public static final int HISTORICAL_QUERIES_ONLY_SUPPORTED_ON_ORACLE = 6102;
    public static final int INVALID_QUERY_ON_HISTORICAL_SESSION = 6103;
    public static final int OBJECT_DOES_NOT_EXIST_IN_CACHE = 6104;
    public static final int MUST_USE_CURSOR_STREAM_POLICY = 6105;
    public static final int CLASS_PK_DOES_NOT_EXIST_IN_CACHE = 6106;
    public static final int UPDATE_STATEMENTS_NOT_SPECIFIED = 6107;
    public static final int INHERITANCE_WITH_MULTIPLE_TABLES_NOT_SUPPORTED = 6108;
    public static final int QUERY_FETCHGROUP_NOT_DEFINED_IN_DESCRIPTOR = 6109;
    public static final int CANNOT_CONFORM_UNFETCHED_ATTRIBUTE = 6110;
    public static final int FETCH_GROUP_ATTRIBUTE_NOT_MAPPED = 6111;
    public static final int FETCH_GROUP_NOT_SUPPORT_ON_REPORT_QUERY = 6112;
    public static final int FETCH_GROUP_NOT_SUPPORT_ON_PARTIAL_ATTRIBUTE_READING = 6113;
    public static final int FETCHGROUP_VALID_ONLY_IF_FETCHGROUP_MANAGER_IN_DESCRIPTOR = 6114;
    public static final int ISOLATED_QUERY_EXECUTED_ON_SERVER_SESSION = 6115;
    public static final int NO_CALL_OR_INTERACTION_SPECIFIED = 6116;
    public static final int CANNOT_CACHE_CURSOR_RESULTS_ON_QUERY = 6117;
    public static final int CANNOT_CACHE_ISOLATED_DATA_ON_QUERY = 6118;
    public static final int MAPPING_FOR_EXPRESSION_DOES_NOT_SUPPORT_JOINING = 6119;
    public static final int SPECIFIED_PARTIAL_ATTRIBUTE_DOES_NOT_EXIST = 6120;
    public static final int INVALID_BUILDER_IN_QUERY = 6121;
    public static final int INVALID_EXPRESSION = 6122;
    public static final int INVALID_CONTAINER_CLASS = 6123;
    public static final int INCORRECT_QUERY_FOUND = 6124;
    public static final int CLEAR_QUERY_RESULTS_NOT_SUPPORTED = 6125;
    public static final int CANNOT_CONFORM_AND_CACHE_QUERY_RESULTS = 6126;
    public static final int REFLECTIVE_CALL_ON_TOPLINK_CLASS_FAILED = 6127;
    public static final int BATCH_READING_NOT_SUPPORTED_WITH_CALL = 6128;
    public static final int REFRESH_NOT_POSSIBLE_WITH_CHECK_CACHE_ONLY = 6129;
    public static final int DISCRIMINATOR_COLUMN_NOT_SELECTED = 6130;
    public static final int DELETE_ALL_QUERY_SPECIFIES_OBJECTS_BUT_NOT_SELECTION_CRITERIA = 6131;
    public static final int NAMED_ARGUMENT_NOT_FOUND_IN_QUERY_PARAMETERS = 6132;
    public static final int UPDATE_ALL_QUERY_ADD_UPDATE_FIELD_IS_NULL = 6133;
    public static final int UPDATE_ALL_QUERY_ADD_UPDATE_DOES_NOT_DEFINE_FIELD = 6134;
    public static final int UPDATE_ALL_QUERY_ADD_UPDATE_DEFINES_WRONG_FIELD = 6135;
    public static final int POLYMORPHIC_REPORT_ITEM_NOT_SUPPORTED = 6136;
    public static final int EXCEPTION_WHILE_USING_CONSTRUCTOR_EXPRESSION = 6137;
    public static final int TEMP_TABLES_NOT_SUPPORTED = 6138;
    public static final int MAPPING_FOR_FIELDRESULT_NOT_FOUND = 6139;
    public static final int JOIN_EXPRESSIONS_NOT_APPLICABLE_ON_NON_OBJECT_REPORT_ITEM = 6140;
    public static final int CLASS_NOT_FOUND_WHILE_USING_QUERY_HINT = 6141;
    public static final int QUERY_HINT_NAVIGATED_ILLEGAL_RELATIONSHIP = 6142;
    public static final int QUERY_HINT_NAVIGATED_NON_EXISTANT_RELATIONSHIP = 6143;
    public static final int QUERY_HINT_DID_NOT_CONTAIN_ENOUGH_TOKENS = 6144;
    public static final int DISTINCT_COUNT_ON_OUTER_JOINED_COMPOSITE_PK = 6145;
    public static final int QUERY_HINT_CONTAINED_INVALID_INTEGER_VALUE = 6146;
    public static final int EXPRESSION_DOES_NOT_SUPPORT_PARTIAL_ATTRIBUTE_READING = 6147;
    public static final int ADD_ARGS_NOT_SUPPORTED = 6148;
    public static final int UNNAMED_ARG_NOT_SUPPORTED = 6149;
    public static final int MAP_KEY_IS_NULL = 6150;
    public static final int UNABLE_TO_SET_REDIRECTOR_FROM_HINT = 6151;
    public static final int ERROR_INSTANTIATING_CLASS_FOR_QUERY_HINT = 6152;
    public static final int COMPATIBLE_TYPE_NOT_SET = 6153;
    public static final int TYPE_NAME_NOT_SET = 6154;
    public static final int EXCEPTION_WHILE_READING_MAP_KEY = 6155;
    public static final int CANNOT_ADD_ELEMENT_WITHOUT_KEY_TO_MAP = 6156;
    public static final int CANNOT_UNWRAP_NON_MAP_MEMBERS = 6157;

    protected QueryException(String string) {
        super(string);
    }

    protected QueryException(String string, DatabaseQuery databaseQuery) {
        super(string);
        this.query = databaseQuery;
    }

    protected QueryException(String string, DatabaseQuery databaseQuery, Exception exception) {
        super(string, exception);
        this.query = databaseQuery;
    }

    public static QueryException additionalSizeQueryNotSpecified(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6001, objectArray), databaseQuery);
        queryException.setErrorCode(6001);
        return queryException;
    }

    public static QueryException aggregateObjectCannotBeDeletedOrWritten(ClassDescriptor classDescriptor, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{classDescriptor.toString(), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6002, objectArray), databaseQuery);
        queryException.setErrorCode(6002);
        return queryException;
    }

    public static QueryException argumentSizeMismatchInQueryAndQueryDefinition(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6003, objectArray), databaseQuery);
        queryException.setErrorCode(6003);
        return queryException;
    }

    public static QueryException namedArgumentNotFoundInQueryParameters(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6132, objectArray));
        queryException.setErrorCode(6132);
        return queryException;
    }

    public static QueryException backupCloneIsDeleted(Object object) {
        Object[] objectArray = new Object[]{object, object.getClass(), new Integer(System.identityHashCode(object)), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6066, objectArray));
        queryException.setErrorCode(6066);
        return queryException;
    }

    public static QueryException backupCloneIsOriginalFromParent(Object object) {
        Object[] objectArray = new Object[]{object, object.getClass(), new Integer(System.identityHashCode(object)), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6004, objectArray));
        queryException.setErrorCode(6004);
        return queryException;
    }

    public static QueryException backupCloneIsOriginalFromSelf(Object object) {
        Object[] objectArray = new Object[]{object, object.getClass(), new Integer(System.identityHashCode(object)), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6005, objectArray));
        queryException.setErrorCode(6005);
        return queryException;
    }

    public static QueryException batchReadingNotSupported(DatabaseMapping databaseMapping, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{databaseMapping};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6006, objectArray), databaseQuery);
        queryException.setErrorCode(6006);
        return queryException;
    }

    public static QueryException batchReadingNotSupported(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6128, objectArray), databaseQuery);
        queryException.setErrorCode(6128);
        return queryException;
    }

    public static QueryException calledMethodThrewException(Method method, Object object, Exception exception) {
        Object[] objectArray = new Object[]{method, object, object.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6062, objectArray));
        queryException.setErrorCode(6062);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static ValidationException cannotAccessFieldOnObject(Field field, Object object) {
        Object[] objectArray = new Object[]{field, object, object.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6067, objectArray));
        validationException.setErrorCode(6067);
        return validationException;
    }

    public static ValidationException cannotAccessMethodOnObject(Method method, Object object) {
        Object[] objectArray = new Object[]{method, object, object.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6061, objectArray));
        validationException.setErrorCode(6061);
        return validationException;
    }

    public static QueryException cannotAddElement(Object object, Object object2, Exception exception) {
        Object[] objectArray = new Object[]{object, object.getClass(), object2.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6065, objectArray));
        queryException.setErrorCode(6065);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException cannotAddToContainer(Object object, Object object2, ContainerPolicy containerPolicy) {
        Object[] objectArray = new Object[]{object, object.getClass(), object2.getClass(), containerPolicy};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6054, objectArray));
        queryException.setErrorCode(6054);
        return queryException;
    }

    public static QueryException cannotCacheCursorResultsOnQuery(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6117, objectArray));
        queryException.setQuery(databaseQuery);
        queryException.setErrorCode(6117);
        return queryException;
    }

    public static QueryException cannotCacheIsolatedDataOnQuery(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6118, objectArray));
        queryException.setQuery(databaseQuery);
        queryException.setErrorCode(6118);
        return queryException;
    }

    public static QueryException cannotCachePartialObjects(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6051, objectArray));
        queryException.setQuery(databaseQuery);
        queryException.setErrorCode(6051);
        return queryException;
    }

    public static QueryException cannotCompareTablesInExpression(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6068, objectArray));
        queryException.setErrorCode(6068);
        return queryException;
    }

    public static QueryException cannotCompareTargetForeignKeysToNull(Expression expression, Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{expression, databaseMapping, object, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6079, objectArray));
        queryException.setErrorCode(6079);
        return queryException;
    }

    public static QueryException cannotConformAndCacheQueryResults(ReadQuery readQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6126, objectArray), readQuery);
        queryException.setErrorCode(6126);
        return queryException;
    }

    public static QueryException cannotConformExpression() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6074, objectArray));
        queryException.setErrorCode(6074);
        return queryException;
    }

    public static QueryException cannotCreateClone(ContainerPolicy containerPolicy, Object object) {
        Object[] objectArray = new Object[]{object, object.getClass(), containerPolicy};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6056, objectArray));
        queryException.setErrorCode(6056);
        return queryException;
    }

    public static QueryException cannotDeleteReadOnlyObject(Object object) {
        Object[] objectArray = new Object[]{object.getClass().toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6046, objectArray));
        queryException.setErrorCode(6046);
        return queryException;
    }

    public static QueryException cannotQueryAcrossAVariableOneToOneMapping(DatabaseMapping databaseMapping, ClassDescriptor classDescriptor) {
        Object[] objectArray = new Object[]{classDescriptor.toString(), databaseMapping.toString(), CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6072, objectArray));
        queryException.setErrorCode(6072);
        return queryException;
    }

    public static QueryException cannotRemoveFromContainer(Object object, Object object2, ContainerPolicy containerPolicy) {
        Object[] objectArray = new Object[]{object, object.getClass(), object2.getClass(), containerPolicy};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6064, objectArray));
        queryException.setErrorCode(6064);
        return queryException;
    }

    public static QueryException cannotSetShouldCheckCacheOnlyOnReportQuery() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6090, objectArray));
        queryException.setErrorCode(6090);
        return queryException;
    }

    public static QueryException couldNotInstantiateContainerClass(Class clazz, Exception exception) {
        Object[] objectArray = new Object[]{clazz.toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6059, objectArray));
        queryException.setErrorCode(6059);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException descriptorIsMissing(Class clazz, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{clazz};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6007, objectArray), databaseQuery);
        queryException.setErrorCode(6007);
        return queryException;
    }

    public static QueryException descriptorIsMissingForNamedQuery(Class clazz, String string) {
        Object[] objectArray = new Object[]{clazz.getName(), string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6008, objectArray));
        queryException.setErrorCode(6008);
        return queryException;
    }

    public static QueryException discriminatorColumnNotSelected(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6130, objectArray));
        queryException.setErrorCode(6130);
        return queryException;
    }

    public static QueryException exampleAndReferenceObjectClassMismatch(Class clazz, Class clazz2, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{clazz, clazz2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6087, objectArray));
        queryException.setErrorCode(6087);
        queryException.setQuery(databaseQuery);
        return queryException;
    }

    public static QueryException exceptionWhileUsingConstructorExpression(Exception exception, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{exception};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6137, objectArray));
        queryException.setErrorCode(6137);
        queryException.setQuery(databaseQuery);
        return queryException;
    }

    public String getMessage() {
        if (this.getQuery() == null) {
            return super.getMessage();
        }
        return super.getMessage() + QueryException.cr() + this.getIndentationString() + ExceptionMessageGenerator.getHeader("QueryHeader") + this.getQuery().toString();
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public Record getQueryArgumentsRecord() {
        return this.queryArguments;
    }

    public static QueryException illegalUseOfGetField(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6048, objectArray));
        queryException.setErrorCode(6048);
        return queryException;
    }

    public static QueryException illegalUseOfGetTable(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6049, objectArray));
        queryException.setErrorCode(6049);
        return queryException;
    }

    public static QueryException illFormedExpression(Expression expression) {
        Object[] objectArray = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6073, objectArray));
        queryException.setErrorCode(6073);
        return queryException;
    }

    public static QueryException inCannotBeParameterized(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6083, objectArray), databaseQuery);
        queryException.setErrorCode(6083);
        return queryException;
    }

    public static QueryException incorrectClassForObjectComparison(Expression expression, Object object, DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{expression, databaseMapping, object, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6078, objectArray));
        queryException.setErrorCode(6078);
        return queryException;
    }

    public static QueryException incorrectSizeQueryForCursorStream(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6013, objectArray), databaseQuery);
        queryException.setErrorCode(6013);
        return queryException;
    }

    public static QueryException incorrectQueryObjectFound(DatabaseQuery databaseQuery, Class clazz) {
        Object[] objectArray = new Object[]{clazz, databaseQuery.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6124, objectArray), databaseQuery);
        queryException.setErrorCode(6124);
        return queryException;
    }

    public static QueryException invalidContainerClass(Class clazz, Class clazz2) {
        Object[] objectArray = new Object[]{clazz, clazz2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6123, objectArray));
        queryException.setErrorCode(6123);
        return queryException;
    }

    public static QueryException invalidDatabaseAccessor(Accessor accessor) {
        Object[] objectArray = new Object[]{accessor};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6081, objectArray));
        queryException.setErrorCode(6081);
        return queryException;
    }

    public static QueryException invalidDatabaseCall(Call call) {
        Object[] objectArray = new Object[]{call};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6080, objectArray));
        queryException.setErrorCode(6080);
        return queryException;
    }

    public static QueryException invalidExpressionForQueryItem(Expression expression, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6034, objectArray), databaseQuery);
        queryException.setErrorCode(6034);
        return queryException;
    }

    public static QueryException invalidOperation(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6063, objectArray));
        queryException.setErrorCode(6063);
        return queryException;
    }

    public static QueryException invalidOperator(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6047, objectArray));
        queryException.setErrorCode(6047);
        return queryException;
    }

    public static QueryException invalidOperatorForObjectComparison(Expression expression) {
        Object[] objectArray = new Object[]{expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6075, objectArray));
        queryException.setErrorCode(6075);
        return queryException;
    }

    public static QueryException invalidQuery(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6014, objectArray), databaseQuery);
        queryException.setErrorCode(6014);
        return queryException;
    }

    public static QueryException invalidBuilderInQuery(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6121, objectArray), databaseQuery);
        queryException.setErrorCode(6121);
        return queryException;
    }

    public static QueryException invalidQueryKeyInExpression(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6015, objectArray));
        queryException.setErrorCode(6015);
        return queryException;
    }

    public static QueryException invalidExpression(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6122, objectArray));
        queryException.setErrorCode(6122);
        return queryException;
    }

    public static QueryException mappingForExpressionDoesNotSupportJoining(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6119, objectArray));
        queryException.setErrorCode(6119);
        return queryException;
    }

    public static QueryException mappingForFieldResultNotFound(String[] stringArray, int n) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
        }
        Object[] objectArray = new Object[]{string, stringArray[n]};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6139, objectArray));
        queryException.setErrorCode(6139);
        return queryException;
    }

    public static QueryException invalidQueryOnHistoricalSession(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6103, objectArray), databaseQuery);
        queryException.setErrorCode(6103);
        return queryException;
    }

    public static QueryException invalidQueryOnServerSession(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6016, objectArray), databaseQuery);
        queryException.setErrorCode(6016);
        return queryException;
    }

    public static QueryException invalidTableForFieldInExpression(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6069, objectArray));
        queryException.setErrorCode(6069);
        return queryException;
    }

    public static QueryException invalidUseOfAnyOfInExpression(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6071, objectArray));
        queryException.setErrorCode(6071);
        return queryException;
    }

    public static QueryException joinExpressionsNotApplicableOnNonObjectReportItem(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6140, objectArray));
        queryException.setErrorCode(6140);
        return queryException;
    }

    public static QueryException joiningAcrossInheritanceClassWithMultipleTablesNotSupported(DatabaseQuery databaseQuery, Class clazz) {
        Object[] objectArray = new Object[]{databaseQuery, clazz};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6099, objectArray));
        queryException.setErrorCode(6099);
        return queryException;
    }

    public static QueryException invalidUseOfToManyQueryKeyInExpression(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6070, objectArray));
        queryException.setErrorCode(6070);
        return queryException;
    }

    public static QueryException isolatedQueryExecutedOnServerSession() {
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6115, new Object[0]));
        queryException.setErrorCode(6115);
        return queryException;
    }

    public static ValidationException mapKeyIsNull(Object object, Object object2) {
        Object[] objectArray = new Object[]{object.getClass(), object2.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6150, objectArray));
        validationException.setErrorCode(6150);
        return validationException;
    }

    public static ValidationException mapKeyNotComparable(Object object, Object object2) {
        String string;
        String string2;
        if (object == null) {
            string2 = "null";
            string = "NULL";
        } else {
            string2 = object.toString();
            string = object.getClass().toString();
        }
        Object[] objectArray = new Object[]{string2, string, object2, object2.getClass()};
        ValidationException validationException = new ValidationException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6060, objectArray));
        validationException.setErrorCode(6060);
        return validationException;
    }

    public static QueryException methodDoesNotExistInContainerClass(String string, Class clazz) {
        Object[] objectArray = new Object[]{string, clazz};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6058, objectArray));
        queryException.setErrorCode(6058);
        return queryException;
    }

    public static QueryException methodDoesNotExistOnExpression(String string, Class[] classArray) {
        Object[] objectArray = new Object[]{string, classArray};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6082, objectArray));
        queryException.setErrorCode(6082);
        return queryException;
    }

    public static QueryException methodInvocationFailed(Method method, Object object, Exception exception) {
        Object[] objectArray = new Object[]{method, object, object.getClass()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6055, objectArray));
        queryException.setErrorCode(6055);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException methodNotValid(Object object, String string) {
        Object[] objectArray = new Object[]{string, object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6057, objectArray));
        queryException.setErrorCode(6057);
        return queryException;
    }

    public static QueryException mustInstantiateValueholders() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6092, objectArray));
        queryException.setErrorCode(6092);
        return queryException;
    }

    public static QueryException noAttributesForReportQuery(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6088, objectArray));
        queryException.setErrorCode(6088);
        queryException.setQuery(databaseQuery);
        return queryException;
    }

    public static QueryException noConcreteClassIndicated(AbstractRecord abstractRecord, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{abstractRecord};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6020, objectArray), databaseQuery);
        queryException.setErrorCode(6020);
        return queryException;
    }

    public static QueryException noCallOrInteractionSpecified() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6116, objectArray));
        queryException.setErrorCode(6116);
        return queryException;
    }

    public static QueryException noCursorSupport(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6021, objectArray), databaseQuery);
        queryException.setErrorCode(6021);
        return queryException;
    }

    public static QueryException noDescriptorForClassFromInheritancePolicy(DatabaseQuery databaseQuery, Class clazz) {
        Object[] objectArray = new Object[]{String.valueOf(clazz)};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6045, objectArray), databaseQuery);
        queryException.setErrorCode(6045);
        return queryException;
    }

    public static QueryException noExpressionBuilderFound(Expression expression) {
        Object[] objectArray = new Object[]{expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6089, objectArray));
        queryException.setErrorCode(6089);
        return queryException;
    }

    public static QueryException nullPrimaryKeyInBuildingObject(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) {
        Object[] objectArray = new Object[]{abstractRecord};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6044, objectArray), databaseQuery);
        queryException.setErrorCode(6044);
        return queryException;
    }

    public static QueryException objectComparisonsCannotBeParameterized(Expression expression) {
        Object[] objectArray = new Object[]{expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6077, objectArray));
        queryException.setErrorCode(6077);
        return queryException;
    }

    public static QueryException objectDoesNotExistInCache(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6104, objectArray));
        queryException.setErrorCode(6104);
        return queryException;
    }

    public static QueryException classPkDoesNotExistInCache(Class clazz, Vector vector) {
        Object[] objectArray = new Object[]{clazz, vector};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6106, objectArray));
        queryException.setErrorCode(6106);
        return queryException;
    }

    public static QueryException clearQueryResultsNotSupported(ReadQuery readQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6125, objectArray), readQuery);
        queryException.setErrorCode(6125);
        return queryException;
    }

    public static QueryException objectToInsertIsEmpty(DatabaseTable databaseTable) {
        Object[] objectArray = new Object[]{databaseTable};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6023, objectArray));
        queryException.setErrorCode(6023);
        return queryException;
    }

    public static QueryException objectToModifyNotSpecified(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6024, objectArray), databaseQuery);
        queryException.setErrorCode(6024);
        return queryException;
    }

    public static QueryException outerJoinIsOnlyValidForOneToOneMappings(DatabaseMapping databaseMapping) {
        Object[] objectArray = new Object[]{databaseMapping.toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6052, objectArray));
        queryException.setErrorCode(6052);
        return queryException;
    }

    public static QueryException queryNotDefined() {
        Object[] objectArray = new Object[]{"", ""};
        return QueryException.queryNotDefined(objectArray);
    }

    public static QueryException queryNotDefined(String string) {
        Object[] objectArray = new Object[]{string, ""};
        return QueryException.queryNotDefined(objectArray);
    }

    public static QueryException queryNotDefined(String string, Class clazz) {
        Object[] objectArray = new Object[]{string, clazz};
        return QueryException.queryNotDefined(objectArray);
    }

    private static QueryException queryNotDefined(Object[] objectArray) {
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6026, objectArray));
        queryException.setErrorCode(6026);
        return queryException;
    }

    public static QueryException querySentToInactiveUnitOfWork(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6027, objectArray), databaseQuery);
        queryException.setErrorCode(6027);
        return queryException;
    }

    public static QueryException readBeyondStream(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6028, objectArray), databaseQuery);
        queryException.setErrorCode(6028);
        return queryException;
    }

    public static QueryException redirectionClassOrMethodNotSet(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6084, objectArray), databaseQuery);
        queryException.setErrorCode(6084);
        return queryException;
    }

    public static QueryException unableToSetRedirectorOnQueryFromHint(DatabaseQuery databaseQuery, String string, String string2, Exception exception) {
        Object[] objectArray = new Object[]{string, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6151, objectArray), databaseQuery);
        queryException.setInternalException(exception);
        queryException.setErrorCode(6151);
        return queryException;
    }

    public static QueryException redirectionMethodError(Exception exception, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6086, objectArray), databaseQuery);
        queryException.setInternalException(exception);
        queryException.setErrorCode(6086);
        return queryException;
    }

    public static QueryException redirectionMethodNotDefinedCorrectly(Class clazz, String string, Exception exception, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{clazz, string, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6085, objectArray), databaseQuery);
        queryException.setInternalException(exception);
        queryException.setErrorCode(6085);
        return queryException;
    }

    public static QueryException referenceClassMissing(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6029, objectArray), databaseQuery);
        queryException.setErrorCode(6029);
        return queryException;
    }

    public static QueryException refreshNotPossibleWithoutCache(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6030, objectArray), databaseQuery);
        queryException.setErrorCode(6030);
        return queryException;
    }

    public static QueryException reportQueryResultSizeMismatch(int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6050, objectArray));
        queryException.setErrorCode(6050);
        return queryException;
    }

    public static QueryException reportQueryResultWithoutPKs(ReportQueryResult reportQueryResult) {
        Object[] objectArray = new Object[]{reportQueryResult, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6043, objectArray), null);
        queryException.setErrorCode(6043);
        return queryException;
    }

    public static QueryException parameterNameMismatch(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6094, objectArray), null);
        queryException.setErrorCode(6094);
        return queryException;
    }

    public static QueryException polymorphicReportItemWithMultipletableNotSupported(String string, Expression expression, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{string, expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6136, objectArray), databaseQuery);
        queryException.setErrorCode(6136);
        return queryException;
    }

    public static QueryException selectionObjectCannotBeNull(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6041, objectArray), databaseQuery);
        queryException.setErrorCode(6041);
        return queryException;
    }

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    public void setQueryArguments(AbstractRecord abstractRecord) {
        this.queryArguments = abstractRecord;
    }

    public static QueryException sizeOnlySupportedOnExpressionQueries(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6031, objectArray), databaseQuery);
        queryException.setErrorCode(6031);
        return queryException;
    }

    public static QueryException specifiedPartialAttributeDoesNotExist(DatabaseQuery databaseQuery, String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6120, objectArray), databaseQuery);
        queryException.setErrorCode(6120);
        return queryException;
    }

    public static QueryException sqlStatementNotSetProperly(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6032, objectArray), databaseQuery);
        queryException.setErrorCode(6032);
        return queryException;
    }

    public static QueryException typeMismatchBetweenAttributeAndConstantOnExpression(Class clazz, Class clazz2) {
        Object[] objectArray = new Object[]{clazz, clazz2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6091, objectArray));
        queryException.setErrorCode(6091);
        return queryException;
    }

    public static QueryException unnamedQueryOnSessionBroker(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6042, objectArray), databaseQuery);
        queryException.setErrorCode(6042);
        return queryException;
    }

    public static QueryException unsupportedMappingForObjectComparison(DatabaseMapping databaseMapping, Expression expression) {
        Object[] objectArray = new Object[]{databaseMapping, expression, CR};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6076, objectArray));
        queryException.setErrorCode(6076);
        return queryException;
    }

    public static QueryException updateStatementsNotSpecified() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6107, objectArray));
        queryException.setErrorCode(6107);
        return queryException;
    }

    public static QueryException inheritanceWithMultipleTablesNotSupported() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6108, objectArray));
        queryException.setErrorCode(6108);
        return queryException;
    }

    public static QueryException cloneMethodRequired() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6095, objectArray));
        queryException.setErrorCode(6095);
        return queryException;
    }

    public static QueryException cloneMethodInaccessible() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6096, objectArray));
        queryException.setErrorCode(6096);
        return queryException;
    }

    public static QueryException cloneMethodThrowException(Throwable throwable) {
        Object[] objectArray = new Object[]{throwable};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6097, objectArray));
        queryException.setErrorCode(6097);
        return queryException;
    }

    public static QueryException unexpectedInvocation(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6098, objectArray));
        queryException.setErrorCode(6098);
        return queryException;
    }

    public static QueryException multipleRowsDetectedFromReadObjectQuery() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6100, objectArray));
        queryException.setErrorCode(6100);
        return queryException;
    }

    public static QueryException historicalQueriesMustPreserveGlobalCache() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6101, objectArray));
        queryException.setErrorCode(6101);
        return queryException;
    }

    public static QueryException historicalQueriesOnlySupportedOnOracle() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6102, objectArray));
        queryException.setErrorCode(6102);
        return queryException;
    }

    public static QueryException mustUseCursorStreamPolicy() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6105, objectArray));
        queryException.setErrorCode(6105);
        return queryException;
    }

    public static QueryException fetchGroupNotDefinedInDescriptor(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6109, objectArray));
        queryException.setErrorCode(6109);
        return queryException;
    }

    public static QueryException cannotConformUnfetchedAttribute(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6110, objectArray));
        queryException.setErrorCode(6110);
        return queryException;
    }

    public static QueryException fetchGroupAttributeNotMapped(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6111, objectArray));
        queryException.setErrorCode(6111);
        return queryException;
    }

    public static QueryException fetchGroupNotSupportOnReportQuery() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6112, objectArray));
        queryException.setErrorCode(6112);
        return queryException;
    }

    public static QueryException fetchGroupNotSupportOnPartialAttributeReading() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6113, objectArray));
        queryException.setErrorCode(6113);
        return queryException;
    }

    public static QueryException fetchGroupValidOnlyIfFetchGroupManagerInDescriptor(String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6114, objectArray));
        queryException.setErrorCode(6114);
        return queryException;
    }

    public static QueryException reflectiveCallOnTopLinkClassFailed(String string, Exception exception) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6127, objectArray));
        queryException.setErrorCode(6127);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException refreshNotPossibleWithCheckCacheOnly(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6129, objectArray), databaseQuery);
        queryException.setErrorCode(6129);
        return queryException;
    }

    public static QueryException deleteAllQuerySpecifiesObjectsButNotSelectionCriteria(ClassDescriptor classDescriptor, DatabaseQuery databaseQuery, String string) {
        Object[] objectArray = new Object[]{classDescriptor.toString(), CR, string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6131, objectArray), databaseQuery);
        queryException.setErrorCode(6131);
        return queryException;
    }

    public static QueryException updateAllQueryAddUpdateFieldIsNull(DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6133, objectArray), databaseQuery);
        queryException.setErrorCode(6133);
        return queryException;
    }

    public static QueryException updateAllQueryAddUpdateDoesNotDefineField(ClassDescriptor classDescriptor, DatabaseQuery databaseQuery, String string) {
        Object[] objectArray = new Object[]{classDescriptor.toString(), CR, string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6134, objectArray), databaseQuery);
        queryException.setErrorCode(6134);
        return queryException;
    }

    public static QueryException updateAllQueryAddUpdateDefinesWrongField(ClassDescriptor classDescriptor, DatabaseQuery databaseQuery, String string, String string2) {
        Object[] objectArray = new Object[]{classDescriptor.toString(), CR, string, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6135, objectArray), databaseQuery);
        queryException.setErrorCode(6135);
        return queryException;
    }

    public static QueryException tempTablesNotSupported(DatabaseQuery databaseQuery, String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6138, objectArray), databaseQuery);
        queryException.setErrorCode(6138);
        return queryException;
    }

    public static QueryException classNotFoundWhileUsingQueryHint(DatabaseQuery databaseQuery, Object object, Exception exception) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6141, objectArray), databaseQuery);
        queryException.setErrorCode(6141);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException queryHintNavigatedIllegalRelationship(DatabaseQuery databaseQuery, String string, Object object, String string2) {
        Object[] objectArray = new Object[]{string, object, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6142, objectArray), databaseQuery);
        queryException.setErrorCode(6142);
        return queryException;
    }

    public static QueryException queryHintNavigatedNonExistantRelationship(DatabaseQuery databaseQuery, String string, Object object, String string2) {
        Object[] objectArray = new Object[]{string, object, string2};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6143, objectArray), databaseQuery);
        queryException.setErrorCode(6143);
        return queryException;
    }

    public static QueryException queryHintDidNotContainEnoughTokens(DatabaseQuery databaseQuery, String string, Object object) {
        Object[] objectArray = new Object[]{string, object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6144, objectArray), databaseQuery);
        queryException.setErrorCode(6144);
        return queryException;
    }

    public static QueryException distinctCountOnOuterJoinedCompositePK(ClassDescriptor classDescriptor, DatabaseQuery databaseQuery) {
        Object[] objectArray = new Object[]{classDescriptor.getJavaClass().getName(), classDescriptor.toString()};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6145, objectArray), databaseQuery);
        queryException.setErrorCode(6145);
        return queryException;
    }

    public static QueryException queryHintContainedInvalidIntegerValue(String string, Object object, Exception exception) {
        Object[] objectArray = new Object[]{string, object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6146, objectArray), null, exception);
        queryException.setErrorCode(6146);
        return queryException;
    }

    public static QueryException expressionDoesNotSupportPartialAttributeReading(Expression expression) {
        Object[] objectArray = new Object[]{expression};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6147, objectArray));
        queryException.setErrorCode(6147);
        return queryException;
    }

    public static QueryException addArgumentsNotSupported(String string) {
        Object[] objectArray = new Object[]{string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6148, objectArray));
        queryException.setErrorCode(6148);
        return queryException;
    }

    public static QueryException unnamedArgumentsNotSupported() {
        Object[] objectArray = new Object[]{};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6149, objectArray));
        queryException.setErrorCode(6149);
        return queryException;
    }

    public static QueryException compatibleTypeNotSet(DatabaseType databaseType) {
        Object[] objectArray = new Object[]{databaseType};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6153, objectArray));
        queryException.setErrorCode(6153);
        return queryException;
    }

    public static QueryException typeNameNotSet(DatabaseType databaseType) {
        Object[] objectArray = new Object[]{databaseType};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6154, objectArray));
        queryException.setErrorCode(6154);
        return queryException;
    }

    public static QueryException errorInstantiatedClassForQueryHint(Exception exception, DatabaseQuery databaseQuery, Class clazz, String string) {
        Object[] objectArray = new Object[]{clazz, string};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6152, objectArray), databaseQuery);
        queryException.setErrorCode(6152);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException exceptionWhileReadingMapKey(Object object, Exception exception) {
        Object[] objectArray = new Object[]{object, exception};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6155, objectArray));
        queryException.setErrorCode(6155);
        queryException.setInternalException(exception);
        return queryException;
    }

    public static QueryException cannotAddElementWithoutKeyToMap(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6156, objectArray));
        queryException.setErrorCode(6156);
        return queryException;
    }

    public static QueryException cannotUnwrapNonMapMembers(Object object) {
        Object[] objectArray = new Object[]{object};
        QueryException queryException = new QueryException(ExceptionMessageGenerator.buildMessage(QueryException.class, 6157, objectArray));
        queryException.setErrorCode(6157);
        return queryException;
    }
}

