/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ManualQueryKeyExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;

public abstract class ObjectExpression
extends DataExpression {
    public transient ClassDescriptor descriptor;
    public Vector derivedExpressions;
    protected boolean shouldUseOuterJoinForMultitableInheritance;
    protected boolean shouldUseOuterJoin = false;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.shouldUseOuterJoin() == ((ObjectExpression)object).shouldUseOuterJoin();
    }

    public void addDerivedExpression(Expression expression) {
        if (this.derivedExpressions == null) {
            this.derivedExpressions = NonSynchronizedVector.newInstance();
        }
        this.derivedExpressions.addElement(expression);
    }

    public Expression additionalExpressionCriteria() {
        if (this.getDescriptor() == null) {
            return null;
        }
        Expression expression = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
        if (this.getSession().getPlatform().shouldPrintOuterJoinInWhereClause() && this.isUsingOuterJoinForMultitableInheritance()) {
            Expression expression2 = this.getDescriptor().getInheritancePolicy().getChildrenJoinExpression();
            expression2 = this.getBaseExpression().twist(expression2, this);
            expression2.convertToUseOuterJoin();
            expression = expression == null ? expression2 : expression.and(expression2);
        }
        return expression;
    }

    public Map additionalExpressionCriteriaMap() {
        if (this.getDescriptor() == null) {
            return null;
        }
        HashMap<DatabaseTable, Expression> hashMap = null;
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            hashMap = new HashMap<DatabaseTable, Expression>();
            List list = this.getDescriptor().getInheritancePolicy().getChildrenTables();
            for (int i = 0; i < list.size(); ++i) {
                DatabaseTable databaseTable = (DatabaseTable)list.get(i);
                Expression expression = (Expression)this.getDescriptor().getInheritancePolicy().getChildrenTablesJoinExpressions().get(databaseTable);
                expression = this.getBaseExpression() != null ? this.getBaseExpression().twist(expression, this) : this.twist(expression, this);
                hashMap.put(databaseTable, expression);
            }
        }
        return hashMap;
    }

    public Expression anyOf(String string) {
        QueryKeyExpression queryKeyExpression = this.newDerivedExpressionNamed(string);
        queryKeyExpression.doQueryToManyRelationship();
        return queryKeyExpression;
    }

    public Expression anyOfAllowingNone(String string) {
        QueryKeyExpression queryKeyExpression = this.newDerivedExpressionNamed(string);
        queryKeyExpression.doUseOuterJoin();
        queryKeyExpression.doQueryToManyRelationship();
        return queryKeyExpression;
    }

    public QueryKeyExpression derivedExpressionNamed(String string) {
        QueryKeyExpression queryKeyExpression = this.existingDerivedExpressionNamed(string);
        if (queryKeyExpression != null) {
            return queryKeyExpression;
        }
        return this.newDerivedExpressionNamed(string);
    }

    public Expression derivedManualExpressionNamed(String string, ClassDescriptor classDescriptor) {
        QueryKeyExpression queryKeyExpression = this.existingDerivedExpressionNamed(string);
        if (queryKeyExpression != null) {
            return queryKeyExpression;
        }
        return this.newManualDerivedExpressionNamed(string, classDescriptor);
    }

    protected void doNotUseOuterJoin() {
        this.shouldUseOuterJoin = false;
    }

    protected void doUseOuterJoin() {
        this.shouldUseOuterJoin = true;
    }

    public QueryKeyExpression existingDerivedExpressionNamed(String string) {
        if (this.derivedExpressions == null) {
            return null;
        }
        Enumeration enumeration = this.derivedExpressions.elements();
        while (enumeration.hasMoreElements()) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)enumeration.nextElement();
            if (!queryKeyExpression.getName().equals(string)) continue;
            return queryKeyExpression;
        }
        return null;
    }

    public Expression get(String string, Vector vector) {
        Expression expression = super.get(string, vector);
        if (expression != null) {
            return expression;
        }
        QueryKeyExpression queryKeyExpression = this.derivedExpressionNamed(string);
        queryKeyExpression.doNotUseOuterJoin();
        return queryKeyExpression;
    }

    public Expression getAllowingNull(String string, Vector vector) {
        QueryKeyExpression queryKeyExpression = this.existingDerivedExpressionNamed(string);
        if (queryKeyExpression != null) {
            return queryKeyExpression;
        }
        queryKeyExpression = this.derivedExpressionNamed(string);
        queryKeyExpression.doUseOuterJoin();
        return queryKeyExpression;
    }

    public ClassDescriptor getDescriptor() {
        if (this.isAttribute()) {
            return null;
        }
        if (this.descriptor == null) {
            ForeignReferenceQueryKey foreignReferenceQueryKey = (ForeignReferenceQueryKey)this.getQueryKeyOrNull();
            if (foreignReferenceQueryKey != null) {
                this.descriptor = this.getSession().getDescriptor(foreignReferenceQueryKey.getReferenceClass());
                return this.descriptor;
            }
            if (this.getMapping() == null) {
                throw QueryException.invalidQueryKeyInExpression(this);
            }
            this.descriptor = this.getMapping().getReferenceDescriptor();
            if (this.getMapping().isVariableOneToOneMapping()) {
                throw QueryException.cannotQueryAcrossAVariableOneToOneMapping(this.getMapping(), this.descriptor);
            }
        }
        return this.descriptor;
    }

    public Vector getFields() {
        if (this.getDescriptor() == null) {
            DatabaseMapping databaseMapping = this.getMapping();
            if (databaseMapping != null) {
                return databaseMapping.getSelectFields();
            }
            return new NonSynchronizedVector(0);
        }
        if (this.descriptor.hasInheritance() && this.descriptor.getInheritancePolicy().shouldReadSubclasses() && !this.descriptor.getInheritancePolicy().hasMultipleTableChild() || this.shouldUseOuterJoinForMultitableInheritance()) {
            return this.descriptor.getAllFields();
        }
        return this.descriptor.getFields();
    }

    protected Vector getForUpdateOfFields() {
        Vector vector = this.getFields();
        int n = this.getTableAliases().size();
        Vector<DatabaseField> vector2 = new Vector<DatabaseField>(n);
        DatabaseTable databaseTable = null;
        DatabaseField databaseField = null;
        int n2 = 0;
        while (n2 < vector.size() && vector2.size() < n) {
            int n3;
            databaseField = (DatabaseField)vector.elementAt(n2++);
            if (databaseTable != null && databaseField.getTable().equals(databaseTable)) continue;
            databaseTable = databaseField.getTable();
            for (n3 = 0; n3 < vector2.size() && !databaseTable.equals(((DatabaseField)vector2.elementAt(n3)).getTable()); ++n3) {
            }
            if (n3 != vector2.size()) continue;
            vector2.addElement(databaseField);
        }
        return vector2;
    }

    public Expression getManualQueryKey(String string, ClassDescriptor classDescriptor) {
        return this.derivedManualExpressionNamed(string, classDescriptor);
    }

    public Vector getOwnedTables() {
        if (this.isUsingOuterJoinForMultitableInheritance()) {
            return this.getDescriptor().getInheritancePolicy().getAllTables();
        }
        return super.getOwnedTables();
    }

    protected boolean hasDerivedExpressions() {
        return this.derivedExpressions != null;
    }

    public boolean isObjectExpression() {
        return true;
    }

    public boolean isUsingOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance() && this.getDescriptor() != null && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses();
    }

    public QueryKeyExpression newDerivedExpressionNamed(String string) {
        QueryKeyExpression queryKeyExpression = new QueryKeyExpression(string, this);
        this.addDerivedExpression(queryKeyExpression);
        return queryKeyExpression;
    }

    public Expression newManualDerivedExpressionNamed(String string, ClassDescriptor classDescriptor) {
        ManualQueryKeyExpression manualQueryKeyExpression = new ManualQueryKeyExpression(string, this, classDescriptor);
        this.addDerivedExpression(manualQueryKeyExpression);
        return manualQueryKeyExpression;
    }

    protected void postCopyIn(Map map) {
        super.postCopyIn(map);
        this.derivedExpressions = this.copyCollection(this.derivedExpressions, map);
    }

    public void postCopyIn(Map map, Vector vector, Vector vector2) {
        if (vector != null) {
            if (this.derivedFields == null) {
                this.derivedFields = this.copyCollection(vector, map);
            } else {
                this.derivedFields.addAll(this.copyCollection(vector, map));
            }
        }
        if (vector2 != null) {
            if (this.derivedTables == null) {
                this.derivedTables = this.copyCollection(vector2, map);
            } else {
                this.derivedTables.addAll(this.copyCollection(vector2, map));
            }
        }
    }

    public void setShouldUseOuterJoinForMultitableInheritance(boolean bl) {
        this.shouldUseOuterJoinForMultitableInheritance = bl;
    }

    public boolean shouldUseOuterJoin() {
        return this.shouldUseOuterJoin;
    }

    public boolean shouldUseOuterJoinForMultitableInheritance() {
        return this.shouldUseOuterJoinForMultitableInheritance;
    }

    protected void writeForUpdateOfFields(ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        for (DatabaseField databaseField : this.getForUpdateOfFields()) {
            if (expressionSQLPrinter.getPlatform().shouldPrintAliasForUpdate()) {
                this.writeAlias(expressionSQLPrinter, databaseField, sQLSelectStatement);
                continue;
            }
            this.writeField(expressionSQLPrinter, databaseField, sQLSelectStatement);
        }
    }
}

