/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.Serializable;
import java.io.StringWriter;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseLogin;

public abstract class SQLStatement
implements Serializable,
Cloneable {
    protected Expression whereClause;
    protected ExpressionBuilder builder;
    protected AbstractRecord translationRow;
    protected String hintString;

    public abstract DatabaseCall buildCall(AbstractSession var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ExpressionBuilder getBuilder() {
        return this.builder;
    }

    public ExpressionBuilder getExpressionBuilder() {
        return this.builder;
    }

    public String getHintString() {
        return this.hintString;
    }

    public AbstractRecord getTranslationRow() {
        return this.translationRow;
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setHintString(String string) {
        this.hintString = string;
    }

    protected void setBuilder(ExpressionBuilder expressionBuilder) {
        this.builder = expressionBuilder;
    }

    public void setTranslationRow(AbstractRecord abstractRecord) {
        this.translationRow = abstractRecord;
    }

    public void setWhereClause(Expression expression) {
        this.whereClause = expression;
        if (expression != null) {
            this.builder = expression.getBuilder();
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        try {
            DatabaseCall databaseCall = this.buildCall(new DatabaseSessionImpl(new DatabaseLogin()));
            stringWriter.write(databaseCall.getSQLString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }
}

