/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.util.Map;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class NoIndirectionPolicy
extends IndirectionPolicy {
    public Object buildIndirectObject(ValueHolderInterface valueHolderInterface) {
        return valueHolderInterface.getValue();
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        if (bl) {
            return object;
        }
        boolean bl2 = unitOfWorkImpl.isObjectRegistered(object3) && !unitOfWorkImpl.isOriginalNewObject(object2);
        return this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWorkImpl, bl2);
    }

    protected boolean collectionTypeIsValid(Class clazz) {
        return this.getCollectionMapping().getContainerPolicy().isValidContainerType(clazz);
    }

    public AbstractRecord extractReferenceRow(Object object) {
        return null;
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        this.getMapping().fixRealObjectReferences(object, map, map2, objectLevelReadQuery, remoteSession);
    }

    public Object getOriginalIndirectionObject(Object object, AbstractSession abstractSession) {
        return object;
    }

    public Object getOriginalValueHolder(Object object, AbstractSession abstractSession) {
        return object;
    }

    public Object getRealAttributeValueFromObject(Object object, Object object2) {
        return object2;
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        throw DescriptorException.invalidIndirectionPolicyOperation(this, "getValueFromRemoteValueHolder");
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        throw DescriptorException.invalidIndirectionPolicyOperation(this, "mergeRemoteValueHolder");
    }

    public Object nullValueFromRow() {
        return null;
    }

    public boolean objectIsInstantiated(Object object) {
        return true;
    }

    protected boolean typeIsValid(Class clazz) {
        return clazz != ClassConstants.ValueHolderInterface_Class;
    }

    public boolean usesIndirection() {
        return false;
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.attributeAndMappingWithoutIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateDeclaredAttributeTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeTypeForCollection(clazz, integrityChecker);
        if (!this.collectionTypeIsValid(clazz)) {
            InterfaceContainerPolicy interfaceContainerPolicy = (InterfaceContainerPolicy)this.getCollectionMapping().getContainerPolicy();
            integrityChecker.handleError(DescriptorException.attributeTypeNotValid(this.getCollectionMapping(), interfaceContainerPolicy.getInterfaceType()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.returnAndMappingWithoutIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateGetMethodReturnTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnTypeForCollection(clazz, integrityChecker);
        if (!this.collectionTypeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.getMethodReturnTypeNotValid(this.getCollectionMapping()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.parameterAndMappingWithoutIndirectionMismatch(this.getMapping()));
        }
    }

    public void validateSetMethodParameterTypeForCollection(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterTypeForCollection(clazz, integrityChecker);
        if (!this.collectionTypeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.setMethodParameterTypeNotValid(this.getCollectionMapping()));
        }
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, AbstractRecord abstractRecord, ObjectLevelReadQuery objectLevelReadQuery) {
        return this.getForeignReferenceMapping().extractResultFromBatchQuery(readQuery, abstractRecord, objectLevelReadQuery.getSession(), objectLevelReadQuery.getTranslationRow());
    }

    public Object valueFromMethod(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        return this.getTransformationMapping().invokeAttributeTransformer(abstractRecord, object, abstractSession);
    }

    public Object valueFromQuery(ReadQuery readQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        return abstractSession.executeQuery((DatabaseQuery)readQuery, abstractRecord);
    }

    public Object valueFromRow(Object object) {
        return object;
    }
}

