/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BackupValueHolder;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class TransparentIndirectionPolicy
extends IndirectionPolicy {
    protected static Integer defaultContainerSize;
    protected ContainerPolicy containerPolicy;

    public Object backupCloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl) {
        if (!(object instanceof IndirectContainer) || this.objectIsInstantiated(object)) {
            return super.backupCloneAttribute(object, object2, object3, unitOfWorkImpl);
        }
        return this.buildBackupClone((IndirectContainer)object);
    }

    protected Object buildBackupClone(IndirectContainer indirectContainer) {
        UnitOfWorkValueHolder unitOfWorkValueHolder = (UnitOfWorkValueHolder)indirectContainer.getValueHolder();
        BackupValueHolder backupValueHolder = new BackupValueHolder(unitOfWorkValueHolder);
        unitOfWorkValueHolder.setBackupValueHolder(backupValueHolder);
        return this.buildIndirectContainer(backupValueHolder);
    }

    protected IndirectContainer buildIndirectContainer() {
        if (defaultContainerSize != null) {
            return (IndirectContainer)this.getContainerPolicy().containerInstance(TransparentIndirectionPolicy.getDefaultContainerSize());
        }
        return (IndirectContainer)this.getContainerPolicy().containerInstance();
    }

    protected Object buildIndirectContainer(ValueHolderInterface valueHolderInterface) {
        IndirectContainer indirectContainer = this.buildIndirectContainer();
        indirectContainer.setValueHolder(valueHolderInterface);
        return indirectContainer;
    }

    public Object buildIndirectObject(ValueHolderInterface valueHolderInterface) {
        return this.buildIndirectContainer(valueHolderInterface);
    }

    public Object cloneAttribute(Object object, Object object2, Object object3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        ValueHolderInterface valueHolderInterface = null;
        Object object4 = null;
        if (object instanceof IndirectContainer) {
            valueHolderInterface = ((IndirectContainer)object).getValueHolder();
        }
        if (!bl && unitOfWorkImpl.isOriginalNewObject(object2)) {
            if (valueHolderInterface instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolderInterface).isInstantiated() && ((DatabaseValueHolder)valueHolderInterface).getSession() == null && !((DatabaseValueHolder)valueHolderInterface).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(object2, this.getMapping());
            }
            if (this.getMapping().getRelationshipPartner() == null) {
                object4 = this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWorkImpl, false);
            } else {
                if (!(object instanceof IndirectContainer)) {
                    valueHolderInterface = new ValueHolder(object);
                }
                AbstractRecord abstractRecord = null;
                if (valueHolderInterface instanceof DatabaseValueHolder) {
                    abstractRecord = ((DatabaseValueHolder)valueHolderInterface).getRow();
                }
                UnitOfWorkValueHolder unitOfWorkValueHolder = this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, abstractRecord, unitOfWorkImpl, bl);
                object4 = this.buildIndirectContainer(unitOfWorkValueHolder);
                Object object5 = this.getMapping().buildCloneForPartObject(object, object2, object3, unitOfWorkImpl, false);
                unitOfWorkValueHolder.privilegedSetValue(object5);
                unitOfWorkValueHolder.setInstantiated();
            }
        } else {
            if (!(object instanceof IndirectContainer)) {
                valueHolderInterface = new ValueHolder(object);
            }
            AbstractRecord abstractRecord = null;
            if (valueHolderInterface instanceof DatabaseValueHolder) {
                abstractRecord = ((DatabaseValueHolder)valueHolderInterface).getRow();
            }
            object4 = this.buildIndirectContainer(this.getMapping().createUnitOfWorkValueHolder(valueHolderInterface, object2, object3, abstractRecord, unitOfWorkImpl, bl));
        }
        if (this.getMapping().getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && ((ChangeTracker)object3)._persistence_getPropertyChangeListener() != null && object4 instanceof CollectionChangeTracker) {
            ((CollectionChangeTracker)object4).setTrackedAttributeName(this.getMapping().getAttributeName());
            ((CollectionChangeTracker)object4)._persistence_setPropertyChangeListener(((ChangeTracker)object3)._persistence_getPropertyChangeListener());
        }
        return object4;
    }

    protected boolean containerPolicyIsValid() {
        return Helper.classImplementsInterface(this.getContainerClass(), ClassConstants.IndirectContainer_Class);
    }

    public Vector extractPrimaryKeyForReferenceObject(Object object, AbstractSession abstractSession) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public AbstractRecord extractReferenceRow(Object object) {
        if (this.objectIsInstantiated(object)) {
            return null;
        }
        return ((DatabaseValueHolder)((IndirectContainer)object).getValueHolder()).getRow();
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getMapping().getAttributeValueFromObject(object);
        if (object2 instanceof IndirectContainer || !(((IndirectContainer)object2).getValueHolder() instanceof RemoteValueHolder)) {
            RemoteValueHolder remoteValueHolder = (RemoteValueHolder)((IndirectContainer)object2).getValueHolder();
            remoteValueHolder.setSession(remoteSession);
            remoteValueHolder.setMapping(this.getMapping());
            if (!objectLevelReadQuery.shouldMaintainCache() && (!objectLevelReadQuery.shouldCascadeParts() || objectLevelReadQuery.shouldCascadePrivateParts() && !this.getMapping().isPrivateOwned())) {
                remoteValueHolder.setQuery(null);
            } else {
                remoteValueHolder.setQuery(objectLevelReadQuery);
            }
            remoteValueHolder.setUninstantiated();
        } else {
            this.getMapping().fixRealObjectReferences(object, map, map2, objectLevelReadQuery, remoteSession);
        }
    }

    protected Class getContainerClass() {
        return this.getContainerPolicy().getContainerClass();
    }

    protected ContainerPolicy getContainerPolicy() {
        if (this.containerPolicy == null) {
            this.containerPolicy = this.getCollectionMapping().getContainerPolicy();
        }
        return this.containerPolicy;
    }

    protected static int getDefaultContainerSize() {
        return defaultContainerSize;
    }

    public Object getOriginalIndirectionObject(Object object, AbstractSession abstractSession) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        if (indirectContainer.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolder();
            if (valueHolderInterface == null && abstractSession.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)abstractSession).getParentSessionController();
                valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return this.buildIndirectContainer(valueHolderInterface);
        }
        return indirectContainer;
    }

    public Object getOriginalValueHolder(Object object, AbstractSession abstractSession) {
        IndirectContainer indirectContainer = (IndirectContainer)object;
        if (indirectContainer.getValueHolder() instanceof UnitOfWorkValueHolder) {
            ValueHolderInterface valueHolderInterface = ((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolder();
            if (valueHolderInterface == null && abstractSession.isRemoteUnitOfWork()) {
                RemoteSessionController remoteSessionController = ((RemoteUnitOfWork)abstractSession).getParentSessionController();
                valueHolderInterface = (ValueHolderInterface)remoteSessionController.getRemoteValueHolders().get(((UnitOfWorkValueHolder)indirectContainer.getValueHolder()).getWrappedValueHolderRemoteID());
            }
            return valueHolderInterface;
        }
        return indirectContainer.getValueHolder();
    }

    public Object getRealAttributeValueFromObject(Object object, Object object2) {
        return object2;
    }

    public void instantiateObject(Object object, Object object2) {
        this.getContainerPolicy().sizeFor(object2);
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        Object object = remoteValueHolder.getServerIndirectionObject();
        this.getContainerPolicy().sizeFor(object);
        return object;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) {
        super.setRealAttributeValueInObject(object, object2);
    }

    public void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object instanceof IndirectContainer) {
            descriptorIterator.iterateIndirectContainerForMapping((IndirectContainer)object, this.getMapping());
        } else {
            super.iterateOnAttributeValue(descriptorIterator, object);
        }
    }

    public void mergeRemoteValueHolder(Object object, Object object2, MergeManager mergeManager) {
        IndirectContainer indirectContainer = (IndirectContainer)this.getMapping().getAttributeValueFromObject(object2);
        RemoteValueHolder remoteValueHolder = (RemoteValueHolder)indirectContainer.getValueHolder();
        this.mergeClientIntoServerValueHolder(remoteValueHolder, mergeManager);
        this.getMapping().setAttributeValueInObject(object, indirectContainer);
    }

    public Object nullValueFromRow() {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public boolean objectIsInstantiated(Object object) {
        if (object instanceof IndirectContainer) {
            return ((IndirectContainer)object).isInstantiated();
        }
        return true;
    }

    public boolean objectIsInstantiatedOrChanged(Object object) {
        return this.objectIsInstantiated(object) || object instanceof IndirectCollection && ((IndirectCollection)object).hasDeferredChanges();
    }

    public static void setDefaultContainerSize(int n) {
        defaultContainerSize = new Integer(n);
    }

    protected boolean typeIsValid(Class clazz) {
        if (Helper.classIsSubclass(this.getContainerClass(), clazz)) {
            return true;
        }
        return Helper.classImplementsInterface(this.getContainerClass(), clazz);
    }

    public boolean usesTransparentIndirection() {
        return true;
    }

    public Object validateAttributeOfInstantiatedObject(Object object) {
        if (object == null) {
            return this.buildIndirectContainer();
        }
        return object;
    }

    public void validateContainerPolicy(IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateContainerPolicy(integrityChecker);
        if (!this.containerPolicyIsValid()) {
            integrityChecker.handleError(DescriptorException.invalidContainerPolicyWithTransparentIndirection(this.getMapping(), this.getContainerPolicy()));
        }
        if (this.getContainerPolicy().isMapPolicy() && (((ForeignReferenceMapping)this.getMapping()).getRelationshipPartnerAttributeName() != null || this.getMapping().getRelationshipPartner() != null)) {
            integrityChecker.handleError(DescriptorException.unsupportedTypeForBidirectionalRelationshipMaintenance(this.getMapping(), this.getContainerPolicy()));
        }
    }

    public void validateDeclaredAttributeType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateDeclaredAttributeType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.attributeAndMappingWithTransparentIndirectionMismatch(this.getMapping(), clazz, this.validTypeName()));
        }
    }

    public void validateGetMethodReturnType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateGetMethodReturnType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.returnAndMappingWithTransparentIndirectionMismatch(this.getMapping(), clazz, this.validTypeName()));
        }
    }

    public void validateSetMethodParameterType(Class clazz, IntegrityChecker integrityChecker) throws DescriptorException {
        super.validateSetMethodParameterType(clazz, integrityChecker);
        if (!this.typeIsValid(clazz)) {
            integrityChecker.handleError(DescriptorException.parameterAndMappingWithTransparentIndirectionMismatch(this.getMapping(), clazz, this.validTypeName()));
        }
    }

    protected String validTypeName() {
        return Helper.getShortClassName(this.getContainerClass());
    }

    public Object valueFromBatchQuery(ReadQuery readQuery, AbstractRecord abstractRecord, ObjectLevelReadQuery objectLevelReadQuery) {
        return this.buildIndirectContainer(new BatchValueHolder(readQuery, abstractRecord, this.getForeignReferenceMapping(), objectLevelReadQuery));
    }

    public Object valueFromMethod(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        throw DescriptorException.invalidUseOfTransparentIndirection(this.getMapping());
    }

    public Object valueFromQuery(ReadQuery readQuery, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        return this.buildIndirectContainer(new QueryBasedValueHolder(readQuery, abstractRecord, abstractSession));
    }

    public Object valueFromQuery(ReadQuery readQuery, AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        return this.valueFromQuery(readQuery, abstractRecord, abstractSession);
    }

    public Object valueFromRow(Object object) {
        return object;
    }
}

