/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.LogicalOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class OrNode
extends LogicalOperatorNode {
    private Set leftOuterScopeVariables = null;
    private Set rightOuterScopeVariables = null;

    public void validate(ParseTreeContext parseTreeContext) {
        Set set = parseTreeContext.getOuterScopeVariables();
        if (this.left != null) {
            parseTreeContext.resetOuterScopeVariables();
            this.left.validate(parseTreeContext);
            this.leftOuterScopeVariables = parseTreeContext.getOuterScopeVariables();
        }
        if (this.right != null) {
            parseTreeContext.resetOuterScopeVariables();
            this.right.validate(parseTreeContext);
            this.rightOuterScopeVariables = parseTreeContext.getOuterScopeVariables();
        }
        parseTreeContext.resetOuterScopeVariables(set);
        if (this.left != null && this.right != null) {
            this.left.validateParameter(parseTreeContext, this.right.getType());
            this.right.validateParameter(parseTreeContext, this.left.getType());
        }
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        expression = this.appendOuterScopeVariableJoins(expression, this.leftOuterScopeVariables, generationContext);
        Expression expression2 = this.getRight().generateExpression(generationContext);
        expression2 = this.appendOuterScopeVariableJoins(expression2, this.rightOuterScopeVariables, generationContext);
        return expression.or(expression2);
    }

    private Expression appendOuterScopeVariableJoins(Expression expression, Set set, GenerationContext generationContext) {
        if (set == null || set.isEmpty()) {
            return expression;
        }
        Expression expression2 = generationContext.joinVariables(set);
        return this.appendExpression(expression, expression2);
    }
}

