/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.MemberOfNode;
import org.eclipse.persistence.internal.jpa.parsing.ParseTree;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class SelectGenerationContext
extends GenerationContext {
    private boolean useParallelExpressions = false;
    private boolean shouldCheckSelectNodeBeforeResolving = false;
    private boolean isNotIndicatedInMemberOf = false;
    private MemberOfNode memberOfNode = null;
    private boolean shouldUseOuterJoins = false;
    private GenerationContext outer = null;

    public SelectGenerationContext() {
    }

    public SelectGenerationContext(GenerationContext generationContext, ParseTree parseTree) {
        this(generationContext.getParseTreeContext(), generationContext.getSession(), parseTree);
        this.outer = generationContext;
    }

    public SelectGenerationContext(ParseTreeContext parseTreeContext, AbstractSession abstractSession, ParseTree parseTree) {
        super(parseTreeContext, abstractSession, parseTree);
        this.useParallelExpressions = this.computeUseParallelExpressions();
    }

    public void setMemberOfNode(MemberOfNode memberOfNode) {
        this.memberOfNode = memberOfNode;
    }

    public MemberOfNode getMemberOfNode() {
        return this.memberOfNode;
    }

    private boolean computeUseParallelExpressions() {
        boolean bl = ((SelectNode)this.parseTree.getQueryNode()).hasOneToOneSelected(this);
        bl = bl || ((SelectNode)this.parseTree.getQueryNode()).isVariableInINClauseSelected(this) || this.parseTree.getContext().hasMoreThanOneVariablePerType() || this.parseTree.getContext().hasMoreThanOneAliasInFrom();
        return bl;
    }

    public boolean useParallelExpressions() {
        return this.useParallelExpressions;
    }

    public void checkSelectNodeBeforeResolving(boolean bl) {
        this.shouldCheckSelectNodeBeforeResolving = bl;
    }

    public boolean shouldCheckSelectNodeBeforeResolving() {
        return this.shouldCheckSelectNodeBeforeResolving;
    }

    public boolean shouldUseOuterJoins() {
        return this.shouldUseOuterJoins;
    }

    public void useOuterJoins() {
        this.shouldUseOuterJoins = true;
    }

    public void dontUseOuterJoins() {
        this.shouldUseOuterJoins = false;
    }

    public boolean hasMemberOfNode() {
        return this.memberOfNode != null;
    }

    public GenerationContext getOuterContext() {
        return this.outer;
    }

    public Expression joinVariables(Set set) {
        if (this.outer == null || set == null || set.isEmpty()) {
            return null;
        }
        Expression expression = null;
        for (String string : set) {
            VariableNode variableNode = new VariableNode(string);
            Expression expression2 = variableNode.generateExpression(this);
            Expression expression3 = variableNode.generateExpression(this.outer);
            Expression expression4 = expression2.equal(expression3);
            expression = variableNode.appendExpression(expression, expression4);
        }
        return expression;
    }
}

