/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ArrayListContainerPolicy;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.IndirectListContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.VectorContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerPolicy
implements Cloneable,
Serializable {
    protected static Class defaultContainerClass = ClassConstants.Vector_class;
    protected transient ClassDescriptor elementDescriptor;
    protected transient Constructor constructor;

    public static Class getDefaultContainerClass() {
        return defaultContainerClass;
    }

    public static void setDefaultContainerClass(Class clazz) {
        defaultContainerClass = clazz;
    }

    public void addAdditionalFieldsToQuery(ReadQuery readQuery, Expression expression) {
    }

    public void addFieldsForMapKey(AbstractRecord abstractRecord) {
    }

    protected boolean addInto(Object object, Object object2, Object object3) {
        throw QueryException.cannotAddToContainer(object2, object3, this);
    }

    public boolean addInto(Object object, Object object2, AbstractSession abstractSession) {
        return this.addInto(null, object, object2, abstractSession);
    }

    public boolean addInto(Object object, Object object2, AbstractSession abstractSession, AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery) {
        return this.addInto(null, object, object2, abstractSession);
    }

    public boolean addInto(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        Object object4 = object2;
        if (this.elementDescriptor != null) {
            object4 = this.elementDescriptor.getObjectBuilder().wrapObject(object2, abstractSession);
        }
        return this.addInto(object, object4, object3);
    }

    public void addIntoWithOrder(Integer n, Object object, Object object2) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public void addIntoWithOrder(Integer n, Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = object;
        if (this.elementDescriptor != null) {
            object3 = this.elementDescriptor.getObjectBuilder().wrapObject(object, abstractSession);
        }
        this.addIntoWithOrder(n, object3, object2);
    }

    public void addIntoWithOrder(Vector vector, Hashtable hashtable, Object object, AbstractSession abstractSession) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public void addNestedJoinsQueriesForMapKey(JoinedAttributeManager joinedAttributeManager, ObjectLevelReadQuery objectLevelReadQuery, AbstractSession abstractSession) {
    }

    public void addNextValueFromIteratorInto(Object object, Object object2, Object object3, CollectionMapping collectionMapping, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        Object object4 = collectionMapping.buildElementClone(this.next(object, unitOfWorkImpl), object2, unitOfWorkImpl, bl);
        if (!bl && collectionMapping.isCandidateForPrivateOwnedRemoval() && unitOfWorkImpl.shouldDiscoverNewObjects() && object4 != null && unitOfWorkImpl.isObjectNew(object4)) {
            unitOfWorkImpl.addPrivateOwnedObject(collectionMapping, object4);
        }
        this.addInto(object4, object3, unitOfWorkImpl);
    }

    public void addToDeletedObjectsList(Object object, Map map) {
        map.put(object, object);
    }

    public Object buildCloneForKey(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        return object;
    }

    public Object buildCollectionEntry(Object object, ObjectChangeSet objectChangeSet) {
        return object;
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession abstractSession) {
        Object object = this.containerInstance(vector.size());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.addInto(vector.get(i), object, abstractSession);
        }
        return object;
    }

    public Object buildKey(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return null;
    }

    public Object buildKeyFromJoinedRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return null;
    }

    public static ContainerPolicy buildDefaultPolicy() {
        return ContainerPolicy.buildPolicyFor(ContainerPolicy.getDefaultContainerClass());
    }

    public static ContainerPolicy buildPolicyFor(Class clazz) {
        return ContainerPolicy.buildPolicyFor(clazz, false);
    }

    public static ContainerPolicy buildPolicyFor(Class clazz, boolean bl) {
        if (Helper.classImplementsInterface(clazz, ClassConstants.List_Class)) {
            if (bl) {
                return new OrderedListContainerPolicy(clazz);
            }
            if (clazz == ClassConstants.Vector_class) {
                return new VectorContainerPolicy(clazz);
            }
            if (clazz == ClassConstants.IndirectList_Class) {
                return new IndirectListContainerPolicy(clazz);
            }
            if (clazz == ClassConstants.ArrayList_class) {
                return new ArrayListContainerPolicy(clazz);
            }
            return new ListContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.SortedSet_Class)) {
            return new SortedCollectionContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.Collection_Class)) {
            return new CollectionContainerPolicy(clazz);
        }
        if (Helper.classImplementsInterface(clazz, ClassConstants.Map_Class)) {
            return new MapContainerPolicy(clazz);
        }
        if (clazz.equals(ClassConstants.CursoredStream_Class)) {
            return new CursoredStreamPolicy();
        }
        if (clazz.equals(ClassConstants.ScrollableCursor_Class)) {
            return new ScrollableCursorPolicy();
        }
        throw ValidationException.illegalContainerClass(clazz);
    }

    public ReadQuery buildSelectionQueryForDirectCollectionMapping() {
        DirectReadQuery directReadQuery = new DirectReadQuery();
        directReadQuery.setSQLStatement(new SQLSelectStatement());
        directReadQuery.setContainerPolicy(this);
        return directReadQuery;
    }

    public void clear(Object object) {
        throw QueryException.methodNotValid(this, "clear(Object container)");
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ContainerPolicy clone(ReadQuery readQuery) {
        return (ContainerPolicy)this.clone();
    }

    public Object cloneFor(Object object) {
        throw QueryException.cannotCreateClone(this, object);
    }

    protected void createChangeSetForKeys(Map map, CollectionChangeRecord collectionChangeRecord, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
    }

    protected void collectObjectForNewCollection(Map map, Map map2, Object object, CollectionChangeRecord collectionChangeRecord, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        Object object2 = this.iteratorFor(object);
        while (this.hasNext(object2)) {
            Object object3 = this.nextEntry(object2, abstractSession);
            Object object4 = this.unwrapIteratorResult(object3);
            if (object4 == null) continue;
            Object object5 = object4;
            if (collectionChangeRecord.getMapping().isAggregateCollectionMapping()) {
                object5 = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object4, abstractSession);
            }
            if (map.containsKey(object5)) {
                if (this.compareKeys(object4, abstractSession)) {
                    map.remove(object5);
                    continue;
                }
                Object object6 = null;
                object6 = ((UnitOfWorkImpl)abstractSession).isClassReadOnly(object4.getClass()) ? object4 : ((UnitOfWorkImpl)abstractSession).getBackupClone(object4, classDescriptor);
                ObjectChangeSet objectChangeSet = classDescriptor.getObjectBuilder().createObjectChangeSet(object4, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
                objectChangeSet.setOldKey(this.keyFrom(object6, abstractSession));
                objectChangeSet.setNewKey(this.keyFrom(object4, abstractSession));
                map2.put(object5, object4);
                continue;
            }
            this.buildChangeSetForNewObjectInCollection(object3, classDescriptor, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
            map2.put(object5, object4);
        }
    }

    public void compareCollectionsForChange(Object object, Object object2, CollectionChangeRecord collectionChangeRecord, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        AbstractMap abstractMap = null;
        AbstractMap abstractMap2 = null;
        if (collectionChangeRecord.getMapping().isAggregateCollectionMapping()) {
            abstractMap = new HashMap();
            abstractMap2 = new HashMap();
        } else {
            abstractMap = new IdentityHashMap();
            abstractMap2 = new IdentityHashMap();
        }
        if (object != null) {
            Object object3 = this.iteratorFor(object);
            while (this.hasNext(object3)) {
                Object object4 = this.nextEntry(object3, abstractSession);
                Object object5 = this.unwrapIteratorResult(object4);
                if (object5 == null) continue;
                Object object6 = object5;
                if (collectionChangeRecord.getMapping().isAggregateCollectionMapping()) {
                    object6 = classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object5, abstractSession);
                }
                abstractMap.put(object6, object4);
            }
        }
        if (object2 != null) {
            this.collectObjectForNewCollection(abstractMap, abstractMap2, object2, collectionChangeRecord, abstractSession, classDescriptor);
        }
        this.createChangeSetForKeys(abstractMap, collectionChangeRecord, abstractSession, classDescriptor);
        collectionChangeRecord.addAdditionChange(abstractMap2, this, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
        collectionChangeRecord.addRemoveChange(abstractMap, this, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
    }

    public void buildChangeSetForNewObjectInCollection(Object object, ClassDescriptor classDescriptor, UnitOfWorkChangeSet unitOfWorkChangeSet, AbstractSession abstractSession) {
    }

    public boolean compareKeys(Object object, AbstractSession abstractSession) {
        return true;
    }

    public Object concatenateContainers(Object object, Object object2) {
        Object object3 = this.containerInstance(this.sizeFor(object) + this.sizeFor(object2));
        Object object4 = this.iteratorFor(object);
        while (this.hasNext(object4)) {
            this.addInto(null, this.next(object4), object3);
        }
        object4 = this.iteratorFor(object2);
        while (this.hasNext(object4)) {
            this.addInto(null, this.next(object4), object3);
        }
        return object3;
    }

    public Object containerInstance() {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getContainerClass()));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception exception) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception);
        }
    }

    public Object containerInstance(int n) {
        if (this.getConstructor() == null) {
            return this.containerInstance();
        }
        try {
            Object[] objectArray = new Object[]{new Integer(n)};
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getConstructor(), objectArray));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.invokeConstructor(this.getConstructor(), objectArray);
        }
        catch (Exception exception) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception);
        }
    }

    protected boolean contains(Object object, Object object2) {
        throw QueryException.methodNotValid(this, "contains(Object element, Object container)");
    }

    public boolean contains(Object object, Object object2, AbstractSession abstractSession) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object object3 = this.iteratorFor(object2);
            while (this.hasNext(object3)) {
                Object object4 = this.next(object3);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(object4, abstractSession).equals(object)) continue;
                return true;
            }
            return false;
        }
        return this.contains(object, object2);
    }

    protected boolean containsKey(Object object, Object object2) {
        throw QueryException.methodNotValid(this, "containsKey(Object element, Object container)");
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createWrappedObjectFromExistingWrappedObject(Object object, Object object2, ClassDescriptor classDescriptor, MergeManager mergeManager) {
        return classDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(this.unwrapIteratorResult(object)), mergeManager.getSession());
    }

    public void deleteWrappedObject(Object object, AbstractSession abstractSession) {
        abstractSession.deleteObject(object);
    }

    public Object execute() {
        throw QueryException.methodNotValid(this, "execute()");
    }

    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return null;
    }

    public List<DatabaseField> getAllFieldsForMapKey() {
        return null;
    }

    public Iterator getChangeValuesFrom(Map map) {
        return map.values().iterator();
    }

    public Object getCloneDataFromChangeSet(ObjectChangeSet objectChangeSet) {
        return objectChangeSet.getUnitOfWorkClone();
    }

    protected Constructor getConstructor() {
        return this.constructor;
    }

    public Class getContainerClass() {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public String getContainerClassName() {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public ClassDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return null;
    }

    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession abstractSession) {
        return null;
    }

    public Expression getKeySelectionCriteria() {
        return null;
    }

    public boolean hasElementDescriptor() {
        return this.elementDescriptor != null;
    }

    public abstract boolean hasNext(Object var1);

    public boolean hasOrder() {
        return false;
    }

    public void initialize(AbstractSession abstractSession, DatabaseTable databaseTable) {
    }

    public void initializeConstructor() {
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return;
                }
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false);
            }
            this.setConstructor(constructor);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isCollectionPolicy() {
        return false;
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return false;
    }

    public boolean isDirectMapPolicy() {
        return false;
    }

    public boolean isEmpty(Object object) {
        return this.sizeFor(object) == 0;
    }

    public boolean isListPolicy() {
        return false;
    }

    public boolean isMapPolicy() {
        return false;
    }

    public boolean isMappedKeyMapPolicy() {
        return false;
    }

    public boolean isValidContainer(Object object) {
        throw QueryException.methodNotValid(this, "isValidContainer(Object container)");
    }

    public boolean isValidContainerType(Class clazz) {
        throw QueryException.methodNotValid(this, "isValidContainerType(Class containerType)");
    }

    public void iterateOnMapKey(DescriptorIterator descriptorIterator, Object object) {
    }

    public abstract Object iteratorFor(Object var1);

    public Object keyFrom(Object object, AbstractSession abstractSession) {
        return null;
    }

    public Object keyFromEntry(Object object) {
        return null;
    }

    public Object keyFromIterator(Object object) {
        return null;
    }

    public Object mergeCascadeParts(ObjectChangeSet objectChangeSet, MergeManager mergeManager, AbstractSession abstractSession) {
        Object object = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            object = objectChangeSet.getTargetVersionOfSourceObject(abstractSession);
            if (object == null && (objectChangeSet.isNew() || objectChangeSet.isAggregate()) && objectChangeSet.containsChangesFromSynchronization()) {
                if (!mergeManager.getObjectsAlreadyMerged().containsKey(objectChangeSet)) {
                    Class clazz = objectChangeSet.getClassType(mergeManager.getSession());
                    object = mergeManager.getSession().getDescriptor(clazz).getObjectBuilder().buildNewInstance();
                    mergeManager.getObjectsAlreadyMerged().put(objectChangeSet, object);
                } else {
                    object = mergeManager.getObjectsAlreadyMerged().get(objectChangeSet);
                }
            } else {
                object = objectChangeSet.getTargetVersionOfSourceObject(abstractSession, true);
            }
            if (objectChangeSet.containsChangesFromSynchronization()) {
                mergeManager.mergeChanges(object, objectChangeSet);
            }
        } else {
            mergeManager.mergeChanges(objectChangeSet.getUnitOfWorkClone(), objectChangeSet);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord collectionChangeRecord, Object object, boolean bl, MergeManager mergeManager, AbstractSession abstractSession) {
        Iterator iterator = collectionChangeRecord.getRemoveObjectList().keySet().iterator();
        Object object2 = object;
        if (object instanceof IndirectCollection) {
            object2 = ((IndirectCollection)object).getDelegateObject();
        }
        Object object3 = object2;
        synchronized (object3) {
            while (iterator.hasNext()) {
                ObjectChangeSet objectChangeSet = (ObjectChangeSet)iterator.next();
                this.removeFrom(objectChangeSet.getOldKey(), objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession()), object, abstractSession);
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) continue;
                mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
            }
            for (ObjectChangeSet objectChangeSet : collectionChangeRecord.getAddObjectList().keySet()) {
                Object object4 = null;
                if (bl) {
                    object4 = this.mergeCascadeParts(objectChangeSet, mergeManager, abstractSession);
                }
                if (object4 == null) {
                    object4 = objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), false);
                }
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object4, object, mergeManager.getSession())) continue;
                    this.addInto(objectChangeSet.getNewKey(), object4, object, mergeManager.getSession());
                    continue;
                }
                this.addInto(objectChangeSet.getNewKey(), object4, object, mergeManager.getSession());
            }
        }
    }

    protected abstract Object next(Object var1);

    public Object next(Object object, AbstractSession abstractSession) {
        Object object2 = this.next(object);
        if (this.hasElementDescriptor()) {
            object2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(object2, abstractSession);
        }
        return object2;
    }

    public Object nextEntry(Object object) {
        return this.next(object);
    }

    public Object nextEntry(Object object, AbstractSession abstractSession) {
        return this.next(object, abstractSession);
    }

    public boolean overridesRead() {
        return false;
    }

    public void postInitialize(AbstractSession abstractSession) {
    }

    public void postCalculateChanges(ObjectChangeSet objectChangeSet, ClassDescriptor classDescriptor, DatabaseMapping databaseMapping, UnitOfWorkImpl unitOfWorkImpl) {
        if (databaseMapping.isForeignReferenceMapping()) {
            Object object = objectChangeSet.getUnitOfWorkClone();
            unitOfWorkImpl.addDeletedPrivateOwnedObjects(databaseMapping, object);
        }
    }

    public void postCalculateChanges(Object object, Object object2, ClassDescriptor classDescriptor, DatabaseMapping databaseMapping, UnitOfWorkImpl unitOfWorkImpl) {
        if (!databaseMapping.isDirectCollectionMapping() && !databaseMapping.isAggregateCollectionMapping()) {
            unitOfWorkImpl.addDeletedPrivateOwnedObjects(databaseMapping, object2);
        }
    }

    public void recordPrivateOwnedRemovals(Object object, ClassDescriptor classDescriptor, UnitOfWorkImpl unitOfWorkImpl) {
        if (classDescriptor != null) {
            classDescriptor.getObjectBuilder().recordPrivateOwnedRemovals(this.unwrapIteratorResult(object), unitOfWorkImpl, false);
        }
    }

    public void prepare(DatabaseQuery databaseQuery, AbstractSession abstractSession) throws QueryException {
        if (databaseQuery.isReadAllQuery() && !databaseQuery.isReportQuery() && databaseQuery.shouldUseWrapperPolicy()) {
            this.setElementDescriptor(databaseQuery.getDescriptor());
        } else if (databaseQuery.isDataReadQuery()) {
            ((DataReadQuery)databaseQuery).setContainerPolicy(this);
        }
    }

    public void prepareForExecution() throws QueryException {
    }

    public void propogatePostDelete(DeleteObjectQuery deleteObjectQuery, Object object) {
    }

    public void propogatePostInsert(WriteObjectQuery writeObjectQuery, Object object) {
    }

    public void propogatePostUpdate(WriteObjectQuery writeObjectQuery, Object object) {
    }

    public void propogatePreDelete(DeleteObjectQuery deleteObjectQuery, Object object) {
    }

    public void propogatePreInsert(WriteObjectQuery writeObjectQuery, Object object) {
    }

    public void propogatePreUpdate(WriteObjectQuery writeObjectQuery, Object object) {
    }

    public boolean propagatesEventsToCollection() {
        return false;
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getRemoveObjectList().remove(objectChangeSet);
        } else {
            collectionChangeRecord.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getAddObjectList().remove(objectChangeSet);
        } else {
            collectionChangeRecord.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent collectionChangeEvent, ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.ADD) {
            this.recordAddToCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
        } else if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.REMOVE) {
            this.recordRemoveFromCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(collectionChangeEvent.getChangeType());
        }
    }

    public Object remoteExecute() {
        return null;
    }

    public void removeAllElements(Object object) {
        this.clear(object);
    }

    protected boolean removeFrom(Object object, Object object2, Object object3) {
        throw QueryException.cannotRemoveFromContainer(object2, object3, this);
    }

    public boolean removeFrom(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        Object object4 = object2;
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object object5 = this.iteratorFor(object3);
            while (this.hasNext(object5)) {
                Object object6 = this.next(object5);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(object6, abstractSession).equals(object2)) continue;
                object4 = object6;
                break;
            }
        }
        return this.removeFrom(object, object4, object3);
    }

    public boolean removeFrom(Object object, Object object2, AbstractSession abstractSession) {
        return this.removeFrom(null, object, object2, abstractSession);
    }

    public void removeFromWithOrder(int n, Object object) {
        throw QueryException.methodDoesNotExistInContainerClass("remove(index)", this.getContainerClass());
    }

    public boolean requiresDataModificationEvents() {
        return false;
    }

    protected void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public void setContainerClass(Class clazz) {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public void setContainerClassName(String string) {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public void setElementDescriptor(ClassDescriptor classDescriptor) {
        this.elementDescriptor = classDescriptor;
    }

    public void setKeyName(String string, String string2) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, string);
    }

    public void setKeyName(String string, Class clazz) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, string);
    }

    public boolean shouldIncludeKeyInDeleteEvent() {
        return false;
    }

    public boolean shouldUpdateForeignKeysPostInsert() {
        return false;
    }

    public int sizeFor(Object object) {
        throw QueryException.methodNotValid(this, "sizeFor(Object container)");
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.toStringInfo() + ")";
    }

    protected Object toStringInfo() {
        return "";
    }

    public int updateJoinedMappingIndexesForMapKey(Map<DatabaseMapping, Object> map, int n) {
        return 0;
    }

    public Object unwrapElement(Object object) {
        return object;
    }

    public Object unwrapIteratorResult(Object object) {
        return object;
    }

    public void validateElementAndRehashIfRequired(Object object, Object object2, AbstractSession abstractSession, Object object3) {
    }

    public Vector vectorFor(Object object, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.sizeFor(object));
        Object object2 = this.iteratorFor(object);
        while (this.hasNext(object2)) {
            vector.addElement(this.next(object2, abstractSession));
        }
        return vector;
    }

    public static void copyMapDataToRow(Map map, AbstractRecord abstractRecord) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                abstractRecord.put(k, v);
            }
        }
    }
}

