/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.AttributeDetails;
import org.eclipse.persistence.internal.weaving.ClassDetails;
import org.eclipse.persistence.internal.weaving.ClassWeaver;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeaver;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;

public class TransformerFactory {
    public static final String WEAVER_DISABLE_CT_NOT_SUPPORTED = "weaver_change_tracking_disabled_not_supported";
    public static final String WEAVER_FOUND_USER_IMPL_CT = "weaver_user_impl_change_tracking";
    public static final String WEAVER_NULL_PROJECT = "weaver_null_project";
    public static final String WEAVER_DISABLE_BY_SYSPROP = "weaver_disable_by_system_property";
    public static final String WEAVER_CLASS_NOT_IN_PROJECT = "weaver_class_not_in_project";
    public static final String WEAVER_PROCESSING_CLASS = "weaver_processing_class";
    public static final String CANNOT_WEAVE_CHANGETRACKING = "cannot_weave_changetracking";
    protected Session session;
    protected Collection entityClasses;
    protected Map classDetailsMap;
    protected ClassLoader classLoader;
    protected boolean weaveChangeTracking;
    protected boolean weaveLazy;
    protected boolean weaveFetchGroups;
    protected boolean weaveInternal;

    public static ClassTransformer createTransformerAndModifyProject(Session session, Collection collection, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (session == null) {
            throw new IllegalArgumentException("Weaver session cannot be null");
        }
        if (session.getProject() == null) {
            ((AbstractSession)session).log(7, "weaver", WEAVER_NULL_PROJECT, null);
            throw new IllegalArgumentException("Weaver session's project cannot be null");
        }
        TransformerFactory transformerFactory = new TransformerFactory(session, collection, classLoader, bl, bl2, bl3, bl4);
        transformerFactory.buildClassDetailsAndModifyProject();
        return transformerFactory.buildTopLinkWeaver();
    }

    public TransformerFactory(Session session, Collection collection, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.session = session;
        this.entityClasses = collection;
        this.classLoader = classLoader;
        this.classDetailsMap = new HashMap();
        this.weaveLazy = bl;
        this.weaveChangeTracking = bl2;
        this.weaveFetchGroups = bl3;
        this.weaveInternal = bl4;
    }

    public void addClassDetailsForMappedSuperClasses(Class clazz, ClassDescriptor classDescriptor, ClassDetails classDetails, Map map, List list, boolean bl) {
        if (classDescriptor.getInheritancePolicyOrNull() != null && classDescriptor.getInheritancePolicyOrNull().getParentClass() != null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == null || clazz2 == Object.class) {
            return;
        }
        boolean bl2 = this.canWeaveValueHolders(clazz2, list);
        List list2 = null;
        ClassDetails classDetails2 = this.createClassDetails(clazz2, bl2, bl, this.weaveFetchGroups, this.weaveInternal);
        classDetails2.setIsMappedSuperClass(true);
        if (!map.containsKey(classDetails2.getClassName())) {
            list2 = this.storeAttributeMappings(clazz2, classDetails2, list, bl2);
            map.put(classDetails2.getClassName(), classDetails2);
        }
        if (list2 != null && list2.size() > 0) {
            this.addClassDetailsForMappedSuperClasses(clazz2, classDescriptor, classDetails, map, list2, bl);
        }
    }

    public ClassTransformer buildTopLinkWeaver() {
        return new PersistenceWeaver(this.session, this.classDetailsMap);
    }

    public void buildClassDetailsAndModifyProject() {
        if (this.entityClasses != null && this.entityClasses.size() > 0) {
            Object object;
            for (Object object2 : this.entityClasses) {
                object = this.findDescriptor(this.session.getProject(), ((Class)object2).getName());
                if (object == null) {
                    this.log(2, WEAVER_CLASS_NOT_IN_PROJECT, new Object[]{((Class)object2).getName()});
                    continue;
                }
                this.log(2, WEAVER_PROCESSING_CLASS, new Object[]{((Class)object2).getName()});
                boolean bl = this.weaveLazy && this.canWeaveValueHolders((Class)object2, ((ClassDescriptor)object).getMappings());
                boolean bl2 = this.canChangeTrackingBeEnabled((ClassDescriptor)object, (Class)object2, this.weaveChangeTracking);
                ClassDetails classDetails = this.createClassDetails((Class)object2, bl, bl2, this.weaveFetchGroups, this.weaveInternal);
                if (((ClassDescriptor)object).isAggregateDescriptor()) {
                    classDetails.setIsEmbedable(true);
                    classDetails.setShouldWeaveFetchGroups(false);
                }
                List list = this.storeAttributeMappings((Class)object2, classDetails, ((ClassDescriptor)object).getMappings(), bl);
                this.classDetailsMap.put(classDetails.getClassName(), classDetails);
                if (!list.isEmpty()) {
                    this.addClassDetailsForMappedSuperClasses((Class)object2, (ClassDescriptor)object, classDetails, this.classDetailsMap, list, this.weaveChangeTracking);
                }
                if (classDetails.getLazyMappings() == null) continue;
                for (ForeignReferenceMapping foreignReferenceMapping : classDetails.getLazyMappings()) {
                    foreignReferenceMapping.setGetMethodName(ClassWeaver.getWeavedValueHolderGetMethodName(foreignReferenceMapping.getAttributeName()));
                    foreignReferenceMapping.setSetMethodName(ClassWeaver.getWeavedValueHolderSetMethodName(foreignReferenceMapping.getAttributeName()));
                }
            }
            for (Object object2 : this.classDetailsMap.values()) {
                ClassDescriptor classDescriptor;
                object = (ClassDetails)this.classDetailsMap.get(((ClassDetails)object2).getSuperClassName());
                if (object == null && (classDescriptor = this.findDescriptor(this.session.getProject(), ((ClassDetails)object2).getClassName())) != null && classDescriptor.hasInheritance()) {
                    object = (ClassDetails)this.classDetailsMap.get(classDescriptor.getInheritancePolicy().getParentClassName());
                }
                if (object == null) continue;
                ((ClassDetails)object2).setSuperClassDetails((ClassDetails)object);
            }
            for (Object object2 : this.classDetailsMap.values()) {
                ((ClassDetails)object2).setShouldWeaveChangeTracking(((ClassDetails)object2).canWeaveChangeTracking());
            }
        }
    }

    protected boolean canChangeTrackingBeEnabled(ClassDescriptor classDescriptor, Class clazz, boolean bl) {
        boolean bl2;
        if (!bl) {
            return false;
        }
        if (classDescriptor.getObjectChangePolicyInternal() != null) {
            if (classDescriptor.getObjectChangePolicyInternal().isDeferredChangeDetectionPolicy()) {
                return false;
            }
            if (classDescriptor.getObjectChangePolicyInternal().isObjectChangeTrackingPolicy()) {
                return true;
            }
        }
        if (!(bl2 = classDescriptor.supportsChangeTracking(this.session.getProject()))) {
            this.log(4, CANNOT_WEAVE_CHANGETRACKING, new Object[]{classDescriptor.getJavaClassName()});
        }
        return bl2;
    }

    protected boolean wasChangeTrackingAlreadyWeaved(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            if (!clazz2.getName().equals(PersistenceWeavedChangeTracking.class.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean canWeaveValueHolders(Class clazz, List list) {
        boolean bl = false;
        for (DatabaseMapping databaseMapping : list) {
            String string = databaseMapping.getAttributeName();
            if (!databaseMapping.isForeignReferenceMapping()) continue;
            ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)databaseMapping;
            Class clazz2 = this.getAttributeTypeFromClass(clazz, string, foreignReferenceMapping, true);
            if (!(foreignReferenceMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy) || clazz2 == null || ValueHolderInterface.class.isAssignableFrom(clazz2)) continue;
            bl = true;
        }
        return bl;
    }

    private ClassDetails createClassDetails(Class clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = Helper.toSlashedClassName(clazz.getName());
        String string2 = Helper.toSlashedClassName(clazz.getSuperclass().getName());
        ClassDetails classDetails = new ClassDetails();
        classDetails.setDescribedClass(clazz);
        classDetails.setClassName(string);
        classDetails.setSuperClassName(string2);
        classDetails.setShouldWeaveValueHolders(bl);
        classDetails.setShouldWeaveChangeTracking(bl2);
        classDetails.setShouldWeaveFetchGroups(bl3);
        classDetails.setShouldWeaveInternal(bl4);
        Method method = null;
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(clazz, "clone", null));
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else {
                method = PrivilegedAccessHelper.getDeclaredMethod(clazz, "clone", null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        classDetails.setImplementsCloneMethod(method != null);
        return classDetails;
    }

    protected ClassDescriptor findDescriptor(Project project, String string) {
        for (ClassDescriptor classDescriptor : project.getOrderedDescriptors()) {
            if (!classDescriptor.getJavaClassName().equals(string)) continue;
            return classDescriptor;
        }
        return null;
    }

    protected boolean hasFieldInClass(Class clazz, String string) {
        try {
            Field field = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, string, false));
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else {
                field = PrivilegedAccessHelper.getField(clazz, string, false);
            }
            return field != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Class getAttributeDeclaringClass(Class clazz, String string) {
        try {
            Field field = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, string, false));
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else {
                field = PrivilegedAccessHelper.getField(clazz, string, false);
            }
            return field.getDeclaringClass();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Class getAttributeTypeFromClass(Class clazz, String string, DatabaseMapping databaseMapping, boolean bl) {
        String string2 = databaseMapping.getGetMethodName();
        if (databaseMapping != null && string2 != null) {
            try {
                Method method = null;
                if (bl) {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, string2, null, false));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        method = PrivilegedAccessHelper.getMethod(clazz, string2, null, false);
                    }
                } else {
                    method = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(clazz, string2, null));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        method = PrivilegedAccessHelper.getDeclaredMethod(clazz, string2, null);
                    }
                }
                if (method != null) {
                    return method.getReturnType();
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                Class<?> clazz2 = null;
                if (bl) {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, string, false));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        field = PrivilegedAccessHelper.getField(clazz, string, false);
                    }
                    clazz2 = field.getType();
                } else {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clazz, string, false));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        field = PrivilegedAccessHelper.getDeclaredField(clazz, string, false);
                    }
                    clazz2 = field.getType();
                }
                if (clazz2 != null) {
                    return clazz2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected List storeAttributeMappings(Class clazz, ClassDetails classDetails, List list, boolean bl) {
        ArrayList<DatabaseMapping> arrayList = new ArrayList<DatabaseMapping>();
        HashMap<String, AttributeDetails> hashMap = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> hashMap2 = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> hashMap3 = new HashMap<String, AttributeDetails>();
        ArrayList<DatabaseMapping> arrayList2 = new ArrayList<DatabaseMapping>();
        for (DatabaseMapping databaseMapping : list) {
            String string = databaseMapping.getAttributeName();
            AttributeDetails attributeDetails = new AttributeDetails(string, databaseMapping);
            Class clazz2 = this.getAttributeTypeFromClass(clazz, string, databaseMapping, false);
            if (clazz2 == null) {
                attributeDetails.setAttributeOnSuperClass(true);
                arrayList.add(databaseMapping);
            }
            if (databaseMapping.getGetMethodName() != null) {
                hashMap3.put(databaseMapping.getGetMethodName(), attributeDetails);
                attributeDetails.setGetterMethodName(databaseMapping.getGetMethodName());
                if (databaseMapping.getSetMethodName() != null) {
                    hashMap2.put(databaseMapping.getSetMethodName(), attributeDetails);
                    attributeDetails.setSetterMethodName(databaseMapping.getSetMethodName());
                }
                if (databaseMapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)databaseMapping).requiresTransientWeavedFields()) {
                    attributeDetails.setWeaveTransientFieldValueHolders();
                }
                if (this.weaveInternal) {
                    attributeDetails.setHasField(this.hasFieldInClass(clazz, string));
                }
            } else {
                attributeDetails.setHasField(true);
            }
            if (attributeDetails.hasField()) {
                attributeDetails.setDeclaringType(Type.getType((Class)this.getAttributeDeclaringClass(clazz, string)));
            }
            if (databaseMapping.isForeignReferenceMapping()) {
                ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)databaseMapping;
                attributeDetails.setReferenceClassName(foreignReferenceMapping.getReferenceClassName());
                Class clazz3 = null;
                if (attributeDetails.getReferenceClassName() != null) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                clazz3 = (Class)AccessController.doPrivileged(new PrivilegedClassForName(attributeDetails.getReferenceClassName(), true, this.classLoader));
                            }
                            catch (PrivilegedActionException privilegedActionException) {}
                        } else {
                            clazz3 = PrivilegedAccessHelper.getClassForName(attributeDetails.getReferenceClassName(), true, this.classLoader);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    attributeDetails.setReferenceClassType(Type.getType(clazz3));
                }
                if (clazz2 == null) {
                    clazz2 = this.getAttributeTypeFromClass(clazz, string, foreignReferenceMapping, true);
                }
                if (bl && foreignReferenceMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy && clazz2 != null && !ValueHolderInterface.class.isAssignableFrom(clazz2)) {
                    arrayList2.add(foreignReferenceMapping);
                    attributeDetails.weaveVH(bl, foreignReferenceMapping);
                }
            }
            if (attributeDetails.getReferenceClassType() == null && clazz2 == null) {
                clazz2 = this.getAttributeTypeFromClass(clazz, string, databaseMapping, true);
            }
            if (clazz2 != null) {
                attributeDetails.setReferenceClassName(clazz2.getName());
                attributeDetails.setReferenceClassType(Type.getType((Class)clazz2));
            }
            hashMap.put(string, attributeDetails);
        }
        classDetails.setAttributesMap(hashMap);
        classDetails.setGetterMethodToAttributeDetails(hashMap3);
        classDetails.setSetterMethodToAttributeDetails(hashMap2);
        classDetails.setLazyMappings(arrayList2);
        return arrayList;
    }

    protected void log(int n, String string, Object[] objectArray) {
        ((AbstractSession)this.session).log(n, "weaver", string, objectArray);
    }
}

