/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectCollectionMapping
extends CollectionMapping
implements RelationalMapping {
    protected static final String Delete = "delete";
    protected static final String Insert = "insert";
    protected static final String DeleteAll = "deleteAll";
    protected Converter valueConverter;
    protected String valueConverterClassName;
    protected transient DatabaseTable referenceTable;
    protected transient DatabaseField directField;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Vector<DatabaseField> referenceKeyFields;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient ModifyQuery changeSetDeleteQuery;
    protected transient boolean hasCustomDeleteQuery;
    protected transient boolean hasCustomInsertQuery;
    protected HistoryPolicy historyPolicy;

    public DirectCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.referenceKeyFields = NonSynchronizedVector.newInstance(1);
        this.selectionQuery = new DirectReadQuery();
        this.hasCustomInsertQuery = false;
        this.isPrivateOwned = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter converter) {
        this.valueConverter = converter;
    }

    public void setValueConverterClassName(String string) {
        this.valueConverterClassName = string;
    }

    public void addReferenceKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceKeyFields().addElement(databaseField2);
        this.getReferenceKeyFields().addElement(databaseField);
    }

    public void addReferenceKeyFieldName(String string, String string2) {
        this.addReferenceKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    @Override
    public ReadQuery prepareNestedBatchQuery(ReadAllQuery readAllQuery) {
        ExpressionBuilder expressionBuilder;
        DataReadQuery dataReadQuery = new DataReadQuery();
        Expression expression = null;
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (readAllQuery.getSelectionCriteria() == null) {
            expressionBuilder = new ExpressionBuilder();
            if (readAllQuery.hasAsOfClause()) {
                expressionBuilder.asOf(readAllQuery.getAsOfClause());
            }
        } else {
            expression = readAllQuery.getSelectionCriteria().copiedVersionFrom(identityHashMap);
            expressionBuilder = expression.getBuilder();
        }
        Expression expression2 = null;
        expression2 = this.getSelectionQuery().isReadAllQuery() ? expressionBuilder.twist(this.getSelectionQuery().getSelectionCriteria(), expressionBuilder) : expressionBuilder.twist(this.getSelectionQuery().getSQLStatement().getWhereClause(), expressionBuilder);
        if (expression != null) {
            expression2 = expression2.and(expression);
        }
        if (readAllQuery.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
            expression2 = expression2.and(readAllQuery.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expressionBuilder));
        }
        if (this.getHistoryPolicy() != null) {
            if (readAllQuery.getSession().getAsOfClause() != null) {
                expressionBuilder.asOf(readAllQuery.getSession().getAsOfClause());
            } else if (expressionBuilder.getAsOfClause() == null) {
                expressionBuilder.asOf(AsOfClause.NO_CLAUSE);
            }
            expression2 = expression2.and(this.getHistoryPolicy().additionalHistoryExpression(expressionBuilder));
        }
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        Enumeration<DatabaseField> enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            sQLSelectStatement.addField(expressionBuilder.getTable(this.getReferenceTable()).getField(enumeration.nextElement()));
        }
        sQLSelectStatement.addField(expressionBuilder.getTable(this.getReferenceTable()).getField(this.getDirectField()));
        sQLSelectStatement.setWhereClause(expression2);
        dataReadQuery.setSQLStatement(sQLSelectStatement);
        this.getContainerPolicy().addAdditionalFieldsToQuery(dataReadQuery, expressionBuilder);
        sQLSelectStatement.normalize(readAllQuery.getSession(), this.getDescriptor(), identityHashMap);
        return dataReadQuery;
    }

    @Override
    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return null;
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = containerPolicy.containerInstance();
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        Vector vector = objectBuilder.extractPrimaryKeyFromRow(abstractRecord, abstractSession);
        CacheKey cacheKey = new CacheKey(vector);
        List list = joinedAttributeManager.getDataResultsByPrimaryKey().get(cacheKey);
        HashSet<Object> hashSet = new HashSet<Object>();
        Converter converter = this.getValueConverter();
        for (int i = 0; i < list.size(); ++i) {
            AbstractRecord abstractRecord2;
            AbstractRecord abstractRecord3 = abstractRecord2 = (AbstractRecord)list.get(i);
            Object object2 = (abstractRecord3 = this.trimRowForJoin(abstractRecord3, joinedAttributeManager, abstractSession)).get(this.getDirectField());
            if (object2 == null) {
                return this.getIndirectionPolicy().valueFromRow(object);
            }
            if (hashSet.contains(object2)) continue;
            hashSet.add(object2);
            if (converter != null) {
                object2 = converter.convertDataValueToObjectValue(object2, abstractSession);
            }
            containerPolicy.addInto(object2, object, abstractSession);
        }
        return this.getIndirectionPolicy().valueFromRow(object);
    }

    @Override
    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object2, objectCopyingPolicy.getSession());
        object3 = this.getContainerPolicy().cloneFor(object3);
        this.setRealAttributeValueInObject(object, object3);
    }

    @Override
    public Object buildElementClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        Object object3 = object;
        if (this.getValueConverter() != null && this.getValueConverter().isMutable()) {
            object3 = this.getValueConverter().convertDataValueToObjectValue(this.getValueConverter().convertObjectValueToDataValue(object3, unitOfWorkImpl), unitOfWorkImpl);
        }
        return object3;
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
    }

    @Override
    public Object clone() {
        DirectCollectionMapping directCollectionMapping = (DirectCollectionMapping)super.clone();
        directCollectionMapping.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        directCollectionMapping.setReferenceKeyFields(this.cloneFields(this.getReferenceKeyFields()));
        return directCollectionMapping;
    }

    @Override
    public void compareCollectionsForChange(Object object, Object object2, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession abstractSession) {
        Object object3;
        Object object4;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        int n = 0;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(10);
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>(10);
        if (object != null) {
            object4 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object4)) {
                Object object5 = containerPolicy.next(object4, abstractSession);
                if (object5 == null) {
                    --n;
                    continue;
                }
                object3 = (Integer)hashMap.get(object5);
                if (object3 == null) {
                    hashMap.put(object5, new Integer(1));
                    continue;
                }
                hashMap.put(object5, new Integer((Integer)object3 + 1));
            }
        }
        object4 = (HashMap)hashMap.clone();
        int n2 = Math.abs(n);
        if (object2 != null) {
            object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                Object object6 = containerPolicy.next(object3, abstractSession);
                if (object6 == null) {
                    ++n;
                    continue;
                }
                Integer n3 = (Integer)hashMap.get(object6);
                if (n3 == null) {
                    Integer n4 = (Integer)hashMap2.get(object6);
                    if (n4 == null) {
                        hashMap2.put(object6, new Integer(1));
                        continue;
                    }
                    hashMap2.put(object6, new Integer(n4 + 1));
                    continue;
                }
                if (n3 == 1) {
                    hashMap.remove(object6);
                    continue;
                }
                hashMap.put(object6, new Integer(n3 - 1));
            }
        }
        if (hashMap2.isEmpty() && hashMap.isEmpty() && n == 0 && !changeRecord.getOwner().isNew()) {
            return;
        }
        ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(hashMap2, (HashMap)object4);
        ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(hashMap, (HashMap)object4);
        if (n != 0) {
            ((DirectCollectionChangeRecord)changeRecord).getCommitAddMap().put(DirectCollectionChangeRecord.Null, new Integer(n2));
            if (n > 0) {
                ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(DirectCollectionChangeRecord.Null, new Integer(n));
            } else {
                ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(DirectCollectionChangeRecord.Null, new Integer(n *= -1));
            }
        }
    }

    @Override
    public org.eclipse.persistence.internal.sessions.ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = null;
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        Object object5 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        Object object6 = null;
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object4 == null && object3 == null) {
                return null;
            }
            object6 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
        }
        DirectCollectionChangeRecord directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
        directCollectionChangeRecord.setAttribute(this.getAttributeName());
        directCollectionChangeRecord.setMapping(this);
        this.compareCollectionsForChange(object6, object5, directCollectionChangeRecord, abstractSession);
        if (directCollectionChangeRecord.hasChanges()) {
            return directCollectionChangeRecord;
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        int n;
        Object object3;
        Object object4 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        Object object5 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object4) != containerPolicy.sizeFor(object5)) {
            return false;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        Iterator iterator = containerPolicy.iteratorFor(object4);
        while (containerPolicy.hasNext(iterator)) {
            object3 = containerPolicy.next(iterator, abstractSession);
            if (hashMap.containsKey(object3)) {
                n = (Integer)hashMap.get(object3);
                hashMap.put(object3, new Integer(++n));
                continue;
            }
            hashMap.put(object3, new Integer(1));
        }
        iterator = containerPolicy.iteratorFor(object5);
        while (containerPolicy.hasNext(iterator)) {
            object3 = containerPolicy.next(iterator, abstractSession);
            if (hashMap2.containsKey(object3)) {
                n = (Integer)hashMap2.get(object3);
                hashMap2.put(object3, new Integer(++n));
                continue;
            }
            hashMap2.put(object3, new Integer(1));
        }
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!hashMap2.containsKey(object3) || ((Integer)hashMap2.get(object3)).intValue() != ((Integer)hashMap.get(object3)).intValue()) {
                n = 0;
                for (Object k : hashMap2.keySet()) {
                    n = Helper.comparePotentialArrays(object3, k) ? 1 : 0;
                    if (n == 0) continue;
                    iterator.remove();
                    hashMap2.remove(k);
                    break;
                }
                if (n != 0) continue;
                return false;
            }
            iterator.remove();
            hashMap2.remove(object3);
        }
        return hashMap.isEmpty() && hashMap2.isEmpty();
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.valueConverter != null) {
            if (this.valueConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            } else if (this.valueConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.valueConverterClassName != null) {
            Converter converter;
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class clazz;
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.valueConverterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, privilegedActionException.getException());
                        }
                        try {
                            converter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                            break block13;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, privilegedActionException.getException());
                        }
                    }
                    Class clazz = PrivilegedAccessHelper.getClassForName(this.valueConverterClassName, true, classLoader);
                    converter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, classNotFoundException);
                }
                catch (Exception exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, exception);
                }
            }
            this.setValueConverter(converter);
        }
    }

    protected Vector extractKeyFromReferenceRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getReferenceKeyFields().size());
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getReferenceKeyFields().elementAt(i);
            DatabaseField databaseField2 = this.getSourceKeyFields().elementAt(i);
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        Vector<Object> vector = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            Object object = abstractRecord.get(databaseField);
            try {
                object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord, AbstractSession abstractSession, AbstractRecord abstractRecord2) {
        Hashtable hashtable = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, abstractSession);
            containerPolicy = this.getContainerPolicy();
            if (hashtable == null) {
                Vector vector = (Vector)abstractSession.executeQuery(databaseQuery, abstractRecord2);
                hashtable = new Hashtable();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    AbstractRecord abstractRecord3 = (AbstractRecord)enumeration.nextElement();
                    Object object = abstractRecord3.get(this.getDirectField());
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromReferenceRow(abstractRecord3, abstractSession));
                    Object object2 = hashtable.get(cacheKey);
                    if (object2 == null) {
                        object2 = containerPolicy.containerInstance();
                        hashtable.put(cacheKey, object2);
                    }
                    if (this.getValueConverter() != null) {
                        object = this.getValueConverter().convertDataValueToObjectValue(object, databaseQuery.getSession());
                    }
                    containerPolicy.addInto(object, object2, databaseQuery.getSession());
                }
                this.setBatchReadObjects(hashtable, databaseQuery, abstractSession);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(abstractRecord, abstractSession)));
        if (databaseQuery2 == null) {
            return containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    @Override
    public void fixRealObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
    }

    protected ModifyQuery getDeleteQuery() {
        if (this.changeSetDeleteQuery == null) {
            this.changeSetDeleteQuery = new DataModifyQuery();
        }
        return this.changeSetDeleteQuery;
    }

    @Override
    public Vector getSelectFields() {
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector(2);
        ((Vector)nonSynchronizedVector).add(this.getDirectField());
        return nonSynchronizedVector;
    }

    @Override
    public Vector getSelectTables() {
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector(0);
        ((Vector)nonSynchronizedVector).add(this.getReferenceTable());
        return nonSynchronizedVector;
    }

    public DatabaseField getDirectField() {
        return this.directField;
    }

    public String getDirectFieldName() {
        if (this.getDirectField() == null) {
            return null;
        }
        return this.getDirectField().getQualifiedName();
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    @Override
    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        if (this.getHistoryPolicy() != null) {
            Expression expression = super.getJoinCriteria(queryKeyExpression);
            Expression expression2 = this.getHistoryPolicy().additionalHistoryExpression(queryKeyExpression);
            if (expression != null) {
                return expression.and(expression2);
            }
            if (expression2 != null) {
                return expression2;
            }
            return null;
        }
        return super.getJoinCriteria(queryKeyExpression);
    }

    @Override
    public Object getObjectCorrespondingTo(Object object, RemoteSession remoteSession, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery) {
        return object;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    @Override
    public Class getReferenceClass() {
        return null;
    }

    @Override
    public String getReferenceClassName() {
        return null;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public Vector getReferenceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getReferenceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getReferenceKeyFields() {
        return this.referenceKeyFields;
    }

    public DatabaseTable getReferenceTable() {
        return this.referenceTable;
    }

    public String getReferenceTableName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getName();
    }

    public String getReferenceTableQualifiedName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getQualifiedName();
    }

    @Override
    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().getQualifiedName());
        }
        return vector;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        if (this.isKeyForSourceSpecified()) {
            this.initializeSourceKeys(abstractSession);
        } else {
            this.initializeSourceKeysWithDefaults(abstractSession);
        }
        this.initializeReferenceTable(abstractSession);
        this.initializeReferenceKeys(abstractSession);
        this.initializeDirectField(abstractSession);
        if (this.getReferenceTable().getName().indexOf(32) != -1) {
            String string = ((DatasourcePlatform)abstractSession.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (this.getReferenceTable().getName().indexOf(string) == -1) {
                this.getReferenceTable().setName(string + this.getReferenceTable().getName() + string);
            }
        }
        this.getContainerPolicy().initialize(abstractSession, this.referenceTable);
        if (!this.hasCustomSelectionQuery()) {
            this.selectionQuery = this.containerPolicy.buildSelectionQueryForDirectCollectionMapping();
            this.selectionQuery.setName(this.getAttributeName());
            if (this.shouldInitializeSelectionCriteria()) {
                this.initializeSelectionCriteria(abstractSession);
                this.initializeSelectionStatement(abstractSession);
            }
            if (!this.getSelectionQuery().hasSessionName()) {
                this.getSelectionQuery().setSessionName(abstractSession.getName());
            }
        }
        if (this.getValueConverter() != null && this.getSelectionQuery() instanceof DirectReadQuery) {
            ((DirectReadQuery)this.getSelectionQuery()).setValueConverter(this.getValueConverter());
        }
        this.initializeDeleteAllQuery(abstractSession);
        this.initializeDeleteQuery(abstractSession);
        this.initializeInsertQuery(abstractSession);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(abstractSession);
        }
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, abstractSession);
        }
        super.initialize(abstractSession);
    }

    protected void initializeDeleteAllQuery(AbstractSession abstractSession) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(abstractSession.getName());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getReferenceKeyFields().elementAt(i);
            DatabaseField databaseField2 = this.getSourceKeyFields().elementAt(i);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField);
            Expression expression3 = expressionBuilder.getParameter(databaseField2);
            Expression expression4 = expression2.equal(expression3);
            expression = expression == null ? expression4 : expression.and(expression4);
        }
        sQLDeleteStatement.setWhereClause(expression);
        sQLDeleteStatement.setTable(this.getReferenceTable());
        this.getDeleteAllQuery().setSQLStatement(sQLDeleteStatement);
    }

    protected void initializeDeleteQuery(AbstractSession abstractSession) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(abstractSession.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = ((Expression)expressionBuilder).getField(this.getDirectField()).equal(expressionBuilder.getParameter(this.getDirectField()));
        Expression expression2 = null;
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getReferenceKeyFields().get(i);
            DatabaseField databaseField2 = this.getSourceKeyFields().get(i);
            Expression expression3 = ((Expression)expressionBuilder).getField(databaseField);
            Expression expression4 = expressionBuilder.getParameter(databaseField2);
            Expression expression5 = expression3.equal(expression4);
            expression2 = expression5.and(expression2);
        }
        expression2 = expression2.and(expression);
        sQLDeleteStatement.setWhereClause(expression2);
        sQLDeleteStatement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(sQLDeleteStatement);
    }

    protected void initializeDirectField(AbstractSession abstractSession) throws DescriptorException {
        if (this.getDirectField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectField().setTable(this.getReferenceTable());
        this.getDirectField().setIndex(0);
    }

    protected void initializeInsertQuery(AbstractSession abstractSession) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(abstractSession.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
        sQLInsertStatement.setTable(this.getReferenceTable());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Enumeration<DatabaseField> enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseRecord.put(enumeration.nextElement(), (Object)null);
        }
        databaseRecord.put(this.getDirectField(), (Object)null);
        sQLInsertStatement.setModifyRow(databaseRecord);
        this.getInsertQuery().setSQLStatement(sQLInsertStatement);
        this.getInsertQuery().setModifyRow(databaseRecord);
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession abstractSession) {
    }

    protected void initializeReferenceKeys(AbstractSession abstractSession) throws DescriptorException {
        if (this.getReferenceKeyFields().size() == 0) {
            throw DescriptorException.noReferenceKeyIsSpecified(this);
        }
        Enumeration<DatabaseField> enumeration = this.getReferenceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            if (databaseField.hasTableName() && !databaseField.getTableName().equals(this.getReferenceTable().getName())) {
                throw DescriptorException.referenceKeyFieldNotProperlySpecified(databaseField, this);
            }
            databaseField.setTable(this.getReferenceTable());
        }
    }

    protected void initializeReferenceTable(AbstractSession abstractSession) throws DescriptorException {
        Platform platform = abstractSession.getDatasourcePlatform();
        if (this.getReferenceTable() == null) {
            throw DescriptorException.referenceTableNotSpecified(this);
        }
        if (platform.getTableQualifier().length() > 0 && this.getReferenceTable().getTableQualifier().length() == 0) {
            this.getReferenceTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(AbstractSession abstractSession) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        TableExpression tableExpression = (TableExpression)expressionBuilder.getTable(this.getReferenceTable());
        Enumeration<DatabaseField> enumeration = this.getReferenceKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            DatabaseField databaseField2 = enumeration2.nextElement();
            Expression expression2 = tableExpression.getField(databaseField);
            Expression expression3 = expressionBuilder.getParameter(databaseField2);
            Expression expression4 = expression2.equal(expression3);
            if (expression == null) {
                expression = expression4;
                continue;
            }
            expression = expression4.and(expression);
        }
        this.setSelectionCriteria(expression);
    }

    @Override
    protected void initializeSelectionQuery(AbstractSession abstractSession) {
    }

    protected void initializeSelectionStatement(AbstractSession abstractSession) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.addTable(this.getReferenceTable());
        sQLSelectStatement.addField((DatabaseField)this.getDirectField().clone());
        sQLSelectStatement.setWhereClause(this.getSelectionCriteria());
        sQLSelectStatement.normalize(abstractSession, null);
        this.getSelectionQuery().setSQLStatement(sQLSelectStatement);
    }

    protected void initializeSourceKeys(AbstractSession abstractSession) {
        for (int i = 0; i < this.getSourceKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getDescriptor().buildField(this.getSourceKeyFields().get(i));
            this.getSourceKeyFields().set(i, databaseField);
        }
    }

    protected void initializeSourceKeysWithDefaults(AbstractSession abstractSession) {
        List<DatabaseField> list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            this.getSourceKeyFields().addElement(list.get(i));
        }
    }

    @Override
    public boolean isDirectCollectionMapping() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    protected boolean isKeyForSourceSpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public boolean isLockableMapping() {
        return false;
    }

    @Override
    public boolean isPrivateOwned() {
        return true;
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (descriptorIterator.shouldIterateOnPrimitives()) {
            super.iterateOnRealAttributeValue(descriptorIterator, object);
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iteratePrimitiveForMapping(object, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChangesIntoObject(Object object, org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        AbstractSession abstractSession = mergeManager.getSession();
        HashMap hashMap = ((DirectCollectionChangeRecord)changeRecord).getAddObjectMap();
        HashMap hashMap2 = ((DirectCollectionChangeRecord)changeRecord).getRemoveObjectMap();
        object3 = this.isAttributeValueInstantiated(object) && !changeRecord.getOwner().isNew() ? this.getRealCollectionAttributeValueFromObject(object, abstractSession) : containerPolicy.containerInstance(hashMap.size());
        if (!this.isAttributeValueInstantiated(object)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object object4 = containerPolicy.iteratorFor(this.getRealCollectionAttributeValueFromObject(object2, abstractSession));
            while (containerPolicy.hasNext(object4)) {
                containerPolicy.addInto(containerPolicy.next(object4, abstractSession), object3, abstractSession);
            }
        } else {
            Object object5 = object3;
            if (object3 instanceof IndirectCollection) {
                object5 = ((IndirectCollection)object3).getDelegateObject();
            }
            Object object6 = object5;
            synchronized (object6) {
                int n;
                int n2;
                for (Object k : hashMap.keySet()) {
                    n2 = (Integer)hashMap.get(k);
                    for (n = 0; n < n2; ++n) {
                        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                            if (containerPolicy.contains(k, object3, abstractSession)) continue;
                            containerPolicy.addInto(k, object3, abstractSession);
                            continue;
                        }
                        containerPolicy.addInto(k, object3, abstractSession);
                    }
                }
                for (Object k : hashMap2.keySet()) {
                    n2 = (Integer)hashMap2.get(k);
                    for (n = 0; n < n2; ++n) {
                        containerPolicy.removeFrom(k, object3, abstractSession);
                    }
                }
            }
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    @Override
    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3;
        Object object4;
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(object) : !this.isAttributeValueInstantiatedOrChanged(object2)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object5 = this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
        Object object6 = this.getRealCollectionAttributeValueFromObject(object, mergeManager.getSession());
        Object object7 = containerPolicy.containerInstance(containerPolicy.sizeFor(object5));
        boolean bl2 = false;
        if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy() && object instanceof ChangeTracker && ((ChangeTracker)object)._persistence_getPropertyChangeListener() != null) {
            bl2 = true;
            object4 = containerPolicy.iteratorFor(object6);
            while (containerPolicy.hasNext(object4)) {
                ((ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(object, this.getAttributeName(), object6, containerPolicy.next(object4, mergeManager.getSession()), CollectionChangeEvent.REMOVE));
            }
            if (object7 instanceof ChangeTracker) {
                ((ChangeTracker)object7)._persistence_setPropertyChangeListener(((ChangeTracker)object)._persistence_getPropertyChangeListener());
            }
            if (object6 instanceof ChangeTracker) {
                ((ChangeTracker)object6)._persistence_setPropertyChangeListener(null);
            }
        }
        object6 = object7;
        object4 = containerPolicy.iteratorFor(object5);
        while (containerPolicy.hasNext(object4)) {
            object3 = containerPolicy.next(object4, mergeManager.getSession());
            if (bl2) {
                ((ObjectChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(object, this.getAttributeName(), object6, object3, CollectionChangeEvent.ADD));
            }
            containerPolicy.addInto(object3, object6, mergeManager.getSession());
        }
        if (bl2 && this.descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (object4 = ((AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (object3 = (DirectCollectionChangeRecord)((ObjectChangeSet)object4).getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!((DeferrableChangeRecord)object3).isDeferred()) {
                if (!((DirectCollectionChangeRecord)object3).hasChanges()) {
                    ((ObjectChangeSet)object4).removeChange(this.getAttributeName());
                }
            } else {
                ((DeferrableChangeRecord)object3).setLatestCollection(object6);
            }
        }
        this.setRealAttributeValueInObject(object, object6);
    }

    @Override
    public void performDataModificationEvent(Object[] objectArray, AbstractSession abstractSession) throws DatabaseException, DescriptorException {
        if (objectArray[0] == Delete) {
            abstractSession.executeQuery((DatabaseQuery)((DataModifyQuery)objectArray[1]), (AbstractRecord)objectArray[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)objectArray[1], (AbstractRecord)objectArray[2], abstractSession);
            }
        } else if (objectArray[0] == Insert) {
            abstractSession.executeQuery((DatabaseQuery)((DataModifyQuery)objectArray[1]), (AbstractRecord)objectArray[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalInsert((DataModifyQuery)objectArray[1], (AbstractRecord)objectArray[2], abstractSession);
            }
        } else if (objectArray[0] == DeleteAll) {
            this.preDelete((DeleteObjectQuery)objectArray[1]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(objectArray[0], this);
        }
    }

    @Override
    public void postCalculateChanges(ChangeRecord changeRecord, UnitOfWorkImpl unitOfWorkImpl) {
    }

    @Override
    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object[] objectArray;
        Object object;
        Object object2;
        DatabaseRecord databaseRecord = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object object3 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object3)) {
            return;
        }
        this.prepareTranslationRow(writeObjectQuery.getTranslationRow(), writeObjectQuery.getObject(), writeObjectQuery.getSession());
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            object2 = this.getReferenceKeyFields().get(i);
            object = this.getSourceKeyFields().get(i);
            objectArray = writeObjectQuery.getTranslationRow().get((DatabaseField)object);
            databaseRecord.put((DatabaseField)object2, (Object)objectArray);
        }
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            object2 = containerPolicy.nextEntry(object4, writeObjectQuery.getSession());
            object = containerPolicy.unwrapIteratorResult(object2);
            if (this.getValueConverter() != null) {
                object = this.getValueConverter().convertObjectValueToDataValue(object, writeObjectQuery.getSession());
            }
            databaseRecord.put(this.getDirectField(), object);
            if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
                objectArray = new Object[]{Insert, this.getInsertQuery(), databaseRecord.clone()};
                writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
            } else {
                writeObjectQuery.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRecord);
                if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                    this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRecord, writeObjectQuery.getSession());
                }
            }
            containerPolicy.propogatePostInsert(writeObjectQuery, object2);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (writeObjectQuery.getObjectChangeSet() != null) {
            this.postUpdateWithChangeSet(writeObjectQuery);
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), writeObjectQuery.getSession())) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setObject(writeObjectQuery.getObject());
        deleteObjectQuery.setSession(writeObjectQuery.getSession());
        deleteObjectQuery.setTranslationRow(writeObjectQuery.getTranslationRow());
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = DeleteAll;
            objectArray[1] = deleteObjectQuery;
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.preDelete(deleteObjectQuery);
        }
        this.postInsert(writeObjectQuery);
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            return;
        }
        for (int i = 0; i < this.getReferenceKeyFields().size(); ++i) {
            DatabaseField databaseField = this.getReferenceKeyFields().get(i);
            serializable = this.getSourceKeyFields().get(i);
            object3 = writeObjectQuery.getTranslationRow().get((DatabaseField)serializable);
            writeObjectQuery.getTranslationRow().put(databaseField, object3);
        }
        for (DatabaseField databaseField : directCollectionChangeRecord.getRemoveObjectMap().keySet()) {
            serializable = (AbstractRecord)writeObjectQuery.getTranslationRow().clone();
            object3 = databaseField;
            if (this.getValueConverter() != null) {
                object3 = this.getValueConverter().convertObjectValueToDataValue(object3, writeObjectQuery.getSession());
            }
            if (object3 == DirectCollectionChangeRecord.Null) {
                ((AbstractRecord)serializable).add(this.getDirectField(), null);
            } else {
                ((AbstractRecord)serializable).add(this.getDirectField(), object3);
            }
            object2 = new Object[]{Delete, this.getDeleteQuery(), serializable};
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, (Object[])object2);
            object = (Integer)directCollectionChangeRecord.getCommitAddMap().get(databaseField);
            if (object == null) continue;
            for (int i = ((Integer)object).intValue(); i > 0; --i) {
                serializable = (AbstractRecord)writeObjectQuery.getTranslationRow().clone();
                ((AbstractRecord)serializable).add(this.getDirectField(), object3);
                object2 = new Object[]{Insert, this.getInsertQuery(), serializable};
                writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, (Object[])object2);
            }
        }
        for (DatabaseField databaseField : directCollectionChangeRecord.getAddObjectMap().keySet()) {
            serializable = (Integer)directCollectionChangeRecord.getAddObjectMap().get(databaseField);
            for (int i = ((Integer)serializable).intValue(); i > 0; --i) {
                object2 = (AbstractRecord)writeObjectQuery.getTranslationRow().clone();
                object = databaseField;
                if (this.getValueConverter() != null) {
                    object = this.getValueConverter().convertObjectValueToDataValue(object, writeObjectQuery.getSession());
                }
                if (object == DirectCollectionChangeRecord.Null) {
                    ((AbstractRecord)object2).add(this.getDirectField(), null);
                } else {
                    ((AbstractRecord)object2).add(this.getDirectField(), object);
                }
                Object[] objectArray = new Object[]{Insert, this.getInsertQuery(), object2};
                writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
            }
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        this.prepareTranslationRow(deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        deleteObjectQuery.getSession().executeQuery((DatabaseQuery)this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow());
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getSession());
        }
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession) {
        Enumeration<DatabaseField> enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            if (abstractRecord.containsKey(databaseField)) continue;
            Object object2 = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            abstractRecord.put(databaseField, object2);
        }
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, UnitOfWorkImpl unitOfWorkImpl) {
    }

    @Override
    public void remoteInitialization(DistributedSession distributedSession) {
        if (!this.isRemotelyInitialized()) {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
            this.remotelyInitialized();
        }
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return null;
    }

    protected void setDeleteQuery(ModifyQuery modifyQuery) {
        this.changeSetDeleteQuery = modifyQuery;
    }

    public void setDeleteSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomDeleteQuery(dataModifyQuery);
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        if (this.selectionQuery.isDataReadQuery()) {
            ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
        }
    }

    public void setCustomDeleteQuery(ModifyQuery modifyQuery) {
        this.setDeleteQuery(modifyQuery);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery dataModifyQuery) {
        this.setInsertQuery(dataModifyQuery);
        this.setHasCustomInsertQuery(true);
    }

    public void setDirectField(DatabaseField databaseField) {
        this.directField = databaseField;
    }

    public void setDirectFieldClassification(Class clazz) {
        this.getDirectField().setType(clazz);
    }

    public void setDirectFieldName(String string) {
        this.setDirectField(new DatabaseField(string));
    }

    protected void setHasCustomDeleteQuery(boolean bl) {
        this.hasCustomDeleteQuery = bl;
    }

    protected void setHasCustomInsertQuery(boolean bl) {
        this.hasCustomInsertQuery = bl;
    }

    protected void setInsertQuery(DataModifyQuery dataModifyQuery) {
        this.insertQuery = dataModifyQuery;
    }

    public void setInsertSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomInsertQuery(dataModifyQuery);
    }

    @Override
    public void setReferenceClass(Class clazz) {
    }

    @Override
    public void setReferenceClassName(String string) {
    }

    public void setReferenceKeyFieldName(String string) {
        this.getReferenceKeyFields().addElement(new DatabaseField(string));
    }

    public void setReferenceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setReferenceKeyFields(nonSynchronizedVector);
    }

    public void setReferenceKeyFields(Vector<DatabaseField> vector) {
        this.referenceKeyFields = vector;
    }

    public void setReferenceTable(DatabaseTable databaseTable) {
        this.referenceTable = databaseTable;
    }

    @Override
    public void setSelectionCriteria(Expression expression) {
        if (this.getSelectionQuery().isReadAllQuery()) {
            ((ReadAllQuery)this.getSelectionQuery()).setSelectionCriteria(expression);
        } else {
            this.getSelectionQuery().getSQLStatement().setWhereClause(expression);
        }
    }

    public void setReferenceTableName(String string) {
        if (string == null) {
            this.setReferenceTable(null);
        } else {
            this.setReferenceTable(new DatabaseTable(string));
        }
    }

    @Override
    protected void setSelectionQueryContainerPolicy(ContainerPolicy containerPolicy) {
        ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setHistoryPolicy(HistoryPolicy historyPolicy) {
        this.historyPolicy = historyPolicy;
        if (historyPolicy != null) {
            historyPolicy.setMapping(this);
        }
    }

    @Override
    public void setSessionName(String string) {
        super.setSessionName(string);
        this.getInsertQuery().setSessionName(string);
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector<DatabaseField> vector) {
        this.sourceKeyFields = vector;
    }

    @Override
    public void calculateDeferredChanges(org.eclipse.persistence.internal.sessions.ChangeRecord changeRecord, AbstractSession abstractSession) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(directCollectionChangeRecord.getOriginalCollection(), directCollectionChangeRecord.getLatestCollection(), directCollectionChangeRecord, abstractSession);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
            Object object3 = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), abstractSession);
            directCollectionChangeRecord.storeDatabaseCounts(object3, this.getContainerPolicy(), abstractSession);
        }
        directCollectionChangeRecord.addAdditionChange(object2, new Integer(1));
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
            Object object3 = this.getRealAttributeValueFromObject(objectChangeSet.getUnitOfWorkClone(), abstractSession);
            directCollectionChangeRecord.storeDatabaseCounts(object3, this.getContainerPolicy(), abstractSession);
        }
        directCollectionChangeRecord.addRemoveChange(object2, new Integer(1));
    }

    @Override
    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        DirectCollectionChangeRecord directCollectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (directCollectionChangeRecord == null) {
            directCollectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            directCollectionChangeRecord.setAttribute(this.getAttributeName());
            directCollectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(directCollectionChangeRecord);
        }
        if (directCollectionChangeRecord.getOriginalCollection() == null) {
            directCollectionChangeRecord.setOriginalCollection(object3);
        }
        directCollectionChangeRecord.setLatestCollection(object2);
        directCollectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    @Override
    public void updateCollectionChangeRecord(CollectionChangeEvent collectionChangeEvent, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        if (collectionChangeEvent != null) {
            Object object = null;
            if (collectionChangeEvent.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
                object = ((MapChangeEvent)collectionChangeEvent).getKey();
            }
            if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.ADD) {
                this.addToCollectionChangeRecord(object, collectionChangeEvent.getNewValue(), objectChangeSet, unitOfWorkImpl);
            } else if (collectionChangeEvent.getChangeType() == CollectionChangeEvent.REMOVE) {
                this.removeFromCollectionChangeRecord(object, collectionChangeEvent.getNewValue(), objectChangeSet, unitOfWorkImpl);
            } else {
                throw ValidationException.wrongCollectionChangeEventType(collectionChangeEvent.getChangeType());
            }
        }
    }

    @Override
    public void useCollectionClass(Class clazz) {
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        this.setContainerPolicy(containerPolicy);
    }

    @Override
    public void useMapClass(Class clazz, String string) {
        throw ValidationException.illegalUseOfMapInDirectCollection(this, clazz, string);
    }

    @Override
    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        if (objectBuildingQuery.isReadAllQuery() && (((ReadAllQuery)objectBuildingQuery).isAttributeBatchRead(this.getDescriptor(), this.getAttributeName()) || this.shouldUseBatchReading())) {
            return this.batchedValueFromRow(abstractRecord, (ReadAllQuery)objectBuildingQuery);
        }
        if (this.shouldUseValueFromRowWithJoin(joinedAttributeManager, objectBuildingQuery)) {
            return this.valueFromRowInternalWithJoin(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
        }
        ReadQuery readQuery = this.getSelectionQuery();
        if (this.getHistoryPolicy() != null || objectBuildingQuery.getSession().getAsOfClause() != null || objectBuildingQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)objectBuildingQuery).hasAsOfClause() && (objectBuildingQuery.shouldCascadeAllParts() || objectBuildingQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectBuildingQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
            readQuery = (ReadQuery)readQuery.clone();
            SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
            sQLSelectStatement.addTable(this.getReferenceTable());
            sQLSelectStatement.addField((DatabaseField)this.getDirectField().clone());
            if (this.isDirectMapMapping()) {
                sQLSelectStatement.addField((DatabaseField)((DirectMapMapping)this).getDirectKeyField().clone());
            }
            sQLSelectStatement.setWhereClause((Expression)this.getSelectionCriteria().clone());
            sQLSelectStatement.getBuilder().asOf(((ObjectLevelReadQuery)objectBuildingQuery).getAsOfClause());
            if (this.getHistoryPolicy() != null) {
                ExpressionBuilder expressionBuilder = sQLSelectStatement.getBuilder();
                if (objectBuildingQuery.getSession().getAsOfClause() != null) {
                    expressionBuilder.asOf(objectBuildingQuery.getSession().getAsOfClause());
                } else if (expressionBuilder.getAsOfClause() == null) {
                    expressionBuilder.asOf(AsOfClause.NO_CLAUSE);
                }
                Expression expression = this.getHistoryPolicy().additionalHistoryExpression(expressionBuilder);
                sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(expression));
                if (expressionBuilder.hasAsOfClause()) {
                    sQLSelectStatement.getTables().set(0, this.getHistoryPolicy().getHistoricalTables().elementAt(0));
                }
            }
            sQLSelectStatement.normalize(objectBuildingQuery.getSession(), null);
            readQuery.setSQLStatement(sQLSelectStatement);
        }
        return this.getIndirectionPolicy().valueFromQuery(readQuery, abstractRecord, objectBuildingQuery.getSession());
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord abstractRecord = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, abstractSession);
        Object object2 = abstractSession.executeQuery((DatabaseQuery)this.getSelectionQuery(), abstractRecord);
        return this.getContainerPolicy().isEmpty(object2);
    }

    @Override
    public void addToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        if (object2 == null) {
            object2 = DirectCollectionChangeRecord.Null;
        }
        this.simpleAddToCollectionChangeRecord(object, object2, objectChangeSet, unitOfWorkImpl);
    }

    @Override
    public boolean isCandidateForPrivateOwnedRemoval() {
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public void removeFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) {
        if (object2 == null) {
            object2 = DirectCollectionChangeRecord.Null;
        }
        this.simpleRemoveFromCollectionChangeRecord(object, object2, objectChangeSet, unitOfWorkImpl);
    }
}

