/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.SimpleDatabaseType;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OraclePLSQLTypes implements SimpleDatabaseType,
OraclePLSQLType
{
    BinaryInteger("BINARY_INTEGER"),
    Dec("DEC"),
    Int("INT"),
    Natural("NATURAL"),
    NaturalN("NATURALN"){

        public void buildOutDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
            stringBuilder.append(" := 1;");
            stringBuilder.append(Helper.NL);
        }
    }
    ,
    PLSQLBoolean("BOOLEAN"){

        public int getConversionCode() {
            return JDBCTypes.INTEGER_TYPE.getConversionCode();
        }

        public void buildInDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
            stringBuilder.append(" := ");
            stringBuilder.append("SYS.SQLJUTL.INT2BOOL");
            stringBuilder.append("(:");
            stringBuilder.append(pLSQLargument.inIndex);
            stringBuilder.append(");");
            stringBuilder.append(Helper.NL);
        }

        public void buildOutAssignment(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
            stringBuilder.append("  :");
            stringBuilder.append(pLSQLargument.outIndex);
            stringBuilder.append(" := ");
            stringBuilder.append("SYS.SQLJUTL.BOOL2INT");
            stringBuilder.append("(");
            stringBuilder.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(pLSQLargument));
            stringBuilder.append(");");
            stringBuilder.append(Helper.NL);
        }
    }
    ,
    PLSQLInteger("PLS_INTEGER"),
    Positive("POSITIVE"),
    PositiveN("POSITIVEN"){

        public void buildOutDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
            stringBuilder.append(" := 1;");
            stringBuilder.append(Helper.NL);
        }
    }
    ,
    SignType("SIGNTYPE");

    private final String typeName;

    private OraclePLSQLTypes(String string2) {
        this.typeName = string2;
    }

    @Override
    public boolean isComplexDatabaseType() {
        return false;
    }

    @Override
    public int getSqlCode() {
        return 1111;
    }

    @Override
    public int getConversionCode() {
        return JDBCTypes.NUMERIC_TYPE.getConversionCode();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isJDBCType() {
        return false;
    }

    @Override
    public int computeInIndex(PLSQLargument pLSQLargument, int n, ListIterator<PLSQLargument> listIterator) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(pLSQLargument, n);
    }

    @Override
    public int computeOutIndex(PLSQLargument pLSQLargument, int n, ListIterator<PLSQLargument> listIterator) {
        return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(pLSQLargument, n);
    }

    @Override
    public void buildInDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
        stringBuilder.append(" := :");
        stringBuilder.append(pLSQLargument.inIndex);
        stringBuilder.append(";");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildOutDeclare(StringBuilder stringBuilder, PLSQLargument pLSQLargument) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.declareTarget(stringBuilder, pLSQLargument, this);
        stringBuilder.append(";");
        stringBuilder.append(Helper.NL);
    }

    @Override
    public void buildBeginBlock(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
    }

    @Override
    public void buildOutAssignment(StringBuilder stringBuilder, PLSQLargument pLSQLargument, PLSQLStoredProcedureCall pLSQLStoredProcedureCall) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutAssignment(stringBuilder, pLSQLargument, pLSQLStoredProcedureCall);
    }

    @Override
    public void translate(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, AbstractRecord abstractRecord2, Vector vector, Vector vector2, Vector vector3, StoredProcedureCall storedProcedureCall) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(pLSQLargument, abstractRecord, abstractRecord2, vector, vector2, vector3, storedProcedureCall);
    }

    @Override
    public void buildOutputRow(PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabaseRecord databaseRecord, Vector vector, Vector vector2) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(pLSQLargument, abstractRecord, databaseRecord, vector, vector2);
    }

    @Override
    public void logParameter(StringBuilder stringBuilder, Integer n, PLSQLargument pLSQLargument, AbstractRecord abstractRecord, DatabasePlatform databasePlatform) {
        DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(stringBuilder, n, pLSQLargument, abstractRecord, databasePlatform);
    }

    public static DatabaseType getDatabaseTypeForCode(String string) {
        OraclePLSQLTypes oraclePLSQLTypes = null;
        if (OraclePLSQLTypes.BinaryInteger.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = BinaryInteger;
        } else if (OraclePLSQLTypes.Dec.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = Dec;
        } else if (OraclePLSQLTypes.Int.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = Int;
        } else if (OraclePLSQLTypes.Natural.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = Natural;
        } else if (OraclePLSQLTypes.NaturalN.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = NaturalN;
        } else if (OraclePLSQLTypes.PLSQLBoolean.typeName.equalsIgnoreCase(string) || "BOOLEAN".equalsIgnoreCase(string)) {
            oraclePLSQLTypes = PLSQLBoolean;
        } else if (OraclePLSQLTypes.PLSQLInteger.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = PLSQLInteger;
        } else if (OraclePLSQLTypes.Positive.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = Positive;
        } else if (OraclePLSQLTypes.PositiveN.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = PositiveN;
        } else if (OraclePLSQLTypes.SignType.typeName.equalsIgnoreCase(string)) {
            oraclePLSQLTypes = SignType;
        }
        return oraclePLSQLTypes;
    }
}

