/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.InterfacePolicy;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.eis.interactions.XMLInteraction;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.descriptors.MethodBasedFieldTransformation;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.TransformerBasedFieldTransformation;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.DescriptorCompare;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.history.HistoricalDatabaseTable;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.factories.DirectToXMLTypeMappingHelper;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.MethodBaseQueryRedirector;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class ProjectClassGenerator {
    protected String className = "TopLinkProject";
    protected String packageName = "";
    protected String outputPath = "";
    protected String outputFileName = "TopLinkProject.java";
    protected Writer outputWriter;
    protected Project project;
    protected Hashtable descriptorMethodNames = new Hashtable();

    public ProjectClassGenerator() {
    }

    public ProjectClassGenerator(Project project) {
        this();
        this.project = project;
    }

    public ProjectClassGenerator(Project project, String string, Writer writer) {
        this(project);
        this.outputWriter = writer;
        this.setClassName(string);
    }

    public ProjectClassGenerator(Project project, String string, String string2) {
        this(project);
        this.setClassName(string);
        this.setOutputFileName(string2);
    }

    protected void addAggregateCollectionMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, AggregateCollectionMapping aggregateCollectionMapping) {
        Enumeration<DatabaseField> enumeration = aggregateCollectionMapping.getTargetForeignKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = aggregateCollectionMapping.getSourceKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            DatabaseField databaseField = enumeration2.nextElement();
            DatabaseField databaseField2 = enumeration.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addTargetForeignKeyFieldName(\"" + databaseField2.getQualifiedName() + "\", \"" + databaseField.getQualifiedName() + "\");");
        }
    }

    protected void addAggregateObjectMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, AggregateObjectMapping aggregateObjectMapping) {
        if (aggregateObjectMapping.getReferenceClassName() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setReferenceClass(" + aggregateObjectMapping.getReferenceClassName() + ".class);");
        }
        nonreflectiveMethodDefinition.addLine(string + ".setIsNullAllowed(" + aggregateObjectMapping.isNullAllowed() + ");");
        for (String string2 : aggregateObjectMapping.getAggregateToSourceFieldNames().keySet()) {
            String string3 = aggregateObjectMapping.getAggregateToSourceFieldNames().get(string2);
            nonreflectiveMethodDefinition.addLine(string + ".addFieldNameTranslation(\"" + string3 + "\", \"" + string2 + "\");");
        }
    }

    protected void addCacheInvalidationPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ClassDescriptor classDescriptor) {
        CacheInvalidationPolicy cacheInvalidationPolicy = classDescriptor.getCacheInvalidationPolicy();
        if (cacheInvalidationPolicy instanceof NoExpiryCacheInvalidationPolicy) {
            if (cacheInvalidationPolicy.shouldUpdateReadTimeOnUpdate()) {
                nonreflectiveMethodDefinition.addLine("// Cache Invalidation Policy");
                nonreflectiveMethodDefinition.addLine("NoExpiryCacheInvalidationPolicy policy = new NoExpiryCacheInvalidationPolicy();");
                nonreflectiveMethodDefinition.addLine("policy.setShouldUpdateReadTimeOnUpdate(" + cacheInvalidationPolicy.shouldUpdateReadTimeOnUpdate() + ");");
                nonreflectiveMethodDefinition.addLine("descriptor.setCacheInvalidationPolicy(policy);");
            }
        } else if (cacheInvalidationPolicy instanceof TimeToLiveCacheInvalidationPolicy) {
            nonreflectiveMethodDefinition.addLine("// Cache Invalidation Policy");
            nonreflectiveMethodDefinition.addLine("TimeToLiveCacheInvalidationPolicy policy = new TimeToLiveCacheInvalidationPolicy(" + ((TimeToLiveCacheInvalidationPolicy)cacheInvalidationPolicy).getTimeToLive() + ");");
            nonreflectiveMethodDefinition.addLine("policy.setShouldUpdateReadTimeOnUpdate(" + cacheInvalidationPolicy.shouldUpdateReadTimeOnUpdate() + ");");
            nonreflectiveMethodDefinition.addLine("descriptor.setCacheInvalidationPolicy(policy);");
        } else if (cacheInvalidationPolicy instanceof DailyCacheInvalidationPolicy) {
            Calendar calendar = ((DailyCacheInvalidationPolicy)cacheInvalidationPolicy).getExpiryTime();
            int n = calendar.get(11);
            int n2 = calendar.get(12);
            int n3 = calendar.get(13);
            int n4 = calendar.get(14);
            nonreflectiveMethodDefinition.addLine("// Cache Invalidation Policy");
            nonreflectiveMethodDefinition.addLine("DailyCacheInvalidationPolicy policy = new DailyCacheInvalidationPolicy(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ");");
            nonreflectiveMethodDefinition.addLine("policy.setShouldUpdateReadTimeOnUpdate(" + cacheInvalidationPolicy.shouldUpdateReadTimeOnUpdate() + ");");
            nonreflectiveMethodDefinition.addLine("descriptor.setCacheInvalidationPolicy(policy);");
        }
    }

    protected void addCMPPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, CMPPolicy cMPPolicy) {
        if (cMPPolicy == null) {
            return;
        }
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("// CMP Policy");
        nonreflectiveMethodDefinition.addLine("CMPPolicy cmpPolicy = new CMPPolicy();");
        nonreflectiveMethodDefinition.addLine("cmpPolicy.setDeferModificationsUntilCommit(" + cMPPolicy.getDeferModificationsUntilCommit() + ");");
        nonreflectiveMethodDefinition.addLine("cmpPolicy.setForceUpdate(" + cMPPolicy.getForceUpdate() + ");");
        nonreflectiveMethodDefinition.addLine("cmpPolicy.setNonDeferredCreateTime( " + cMPPolicy.getNonDeferredCreateTime() + ");");
        nonreflectiveMethodDefinition.addLine("cmpPolicy.setUpdateAllFields(" + cMPPolicy.getUpdateAllFields() + ");");
        if (cMPPolicy.hasPessimisticLockingPolicy()) {
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine("// Pessimistic Locking Policy");
            nonreflectiveMethodDefinition.addLine("cmpPolicy.setPessimisticLockingPolicy(new PessimisticLockingPolicy());");
            if (1 == cMPPolicy.getPessimisticLockingPolicy().getLockingMode()) {
                nonreflectiveMethodDefinition.addLine("cmpPolicy.getPessimisticLockingPolicy().setLockingMode(ObjectLevelReadQuery.LOCK);");
            } else {
                nonreflectiveMethodDefinition.addLine("cmpPolicy.getPessimisticLockingPolicy().setLockingMode(ObjectLevelReadQuery.LOCK_NOWAIT);");
            }
        }
        nonreflectiveMethodDefinition.addLine("descriptor.setCMPPolicy(cmpPolicy);");
    }

    protected void addDescriptorPropertyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ClassDescriptor classDescriptor) {
        nonreflectiveMethodDefinition.addLine("// ClassDescriptor Properties.");
        if (!(classDescriptor.isChildDescriptor() || classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor() || classDescriptor.isDescriptorForInterface())) {
            if (classDescriptor.shouldUseFullIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useFullIdentityMap();");
            } else if (classDescriptor.shouldUseCacheIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useCacheIdentityMap();");
            } else if (classDescriptor.shouldUseSoftCacheWeakIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useSoftCacheWeakIdentityMap();");
            } else if (classDescriptor.shouldUseHardCacheWeakIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useHardCacheWeakIdentityMap();");
            } else if (classDescriptor.shouldUseWeakIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useWeakIdentityMap();");
            } else if (classDescriptor.shouldUseSoftIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useSoftIdentityMap();");
            } else if (classDescriptor.shouldUseNoIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useNoIdentityMap();");
            }
            nonreflectiveMethodDefinition.addLine("descriptor.setIdentityMapSize(" + classDescriptor.getIdentityMapSize() + ");");
            if (classDescriptor.shouldUseRemoteFullIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useRemoteFullIdentityMap();");
            } else if (classDescriptor.shouldUseRemoteCacheIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useRemoteCacheIdentityMap();");
            } else if (classDescriptor.shouldUseRemoteSoftCacheWeakIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useRemoteSoftCacheWeakIdentityMap();");
            } else if (classDescriptor.shouldUseRemoteHardCacheWeakIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useRemoteHardCacheWeakIdentityMap();");
            } else if (classDescriptor.shouldUseRemoteWeakIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useRemoteWeakIdentityMap();");
            } else if (classDescriptor.shouldUseRemoteNoIdentityMap()) {
                nonreflectiveMethodDefinition.addLine("descriptor.useRemoteNoIdentityMap();");
            }
            nonreflectiveMethodDefinition.addLine("descriptor.setRemoteIdentityMapSize(" + classDescriptor.getRemoteIdentityMapSize() + ");");
        }
        if (classDescriptor.usesSequenceNumbers()) {
            nonreflectiveMethodDefinition.addLine("descriptor.setSequenceNumberFieldName(\"" + classDescriptor.getSequenceNumberField().getQualifiedName() + "\");");
            if (classDescriptor.getSequenceNumberName() != null) {
                nonreflectiveMethodDefinition.addLine("descriptor.setSequenceNumberName(\"" + classDescriptor.getSequenceNumberName() + "\");");
            }
        }
        if (classDescriptor.hasReturningPolicy()) {
            this.addReturningPolicyLines(nonreflectiveMethodDefinition, classDescriptor.getReturningPolicy());
        }
        if (classDescriptor.usesOptimisticLocking()) {
            this.addOptimisticLockingLines(nonreflectiveMethodDefinition, classDescriptor.getOptimisticLockingPolicy());
        }
        if (classDescriptor.shouldAlwaysConformResultsInUnitOfWork()) {
            nonreflectiveMethodDefinition.addLine("descriptor.alwaysConformResultsInUnitOfWork();");
        }
        if (classDescriptor.shouldBeReadOnly()) {
            nonreflectiveMethodDefinition.addLine("descriptor.setReadOnly();");
        }
        if (classDescriptor.isIsolated()) {
            nonreflectiveMethodDefinition.addLine("descriptor.setIsIsolated(true);");
        }
        if (classDescriptor.shouldAlwaysRefreshCache()) {
            nonreflectiveMethodDefinition.addLine("descriptor.alwaysRefreshCache();");
        }
        if (classDescriptor.shouldAlwaysRefreshCacheOnRemote()) {
            nonreflectiveMethodDefinition.addLine("descriptor.alwaysRefreshCacheOnRemote();");
        }
        if (classDescriptor.shouldDisableCacheHits()) {
            nonreflectiveMethodDefinition.addLine("descriptor.disableCacheHits();");
        }
        if (classDescriptor.shouldDisableCacheHitsOnRemote()) {
            nonreflectiveMethodDefinition.addLine("descriptor.disableCacheHitsOnRemote();");
        }
        if (classDescriptor.shouldOnlyRefreshCacheIfNewerVersion()) {
            nonreflectiveMethodDefinition.addLine("descriptor.onlyRefreshCacheIfNewerVersion();");
        }
        if (classDescriptor.getAlias() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.setAlias(\"" + classDescriptor.getAlias() + "\");");
        }
        if (classDescriptor.getCopyPolicy() instanceof CloneCopyPolicy && ((CloneCopyPolicy)classDescriptor.getCopyPolicy()).getMethodName() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.useCloneCopyPolicy(\"" + ((CloneCopyPolicy)classDescriptor.getCopyPolicy()).getMethodName() + "\");");
        }
        if (!classDescriptor.getInstantiationPolicy().isUsingDefaultConstructor()) {
            if (classDescriptor.getInstantiationPolicy().getFactoryClassName() != null) {
                if (classDescriptor.getInstantiationPolicy().getFactoryMethodName() != null) {
                    nonreflectiveMethodDefinition.addLine("descriptor.useFactoryInstantiationPolicy(" + classDescriptor.getInstantiationPolicy().getFactoryClassName() + ".class, \"" + classDescriptor.getInstantiationPolicy().getMethodName() + "\", \"" + classDescriptor.getInstantiationPolicy().getFactoryMethodName() + "\");");
                } else {
                    nonreflectiveMethodDefinition.addLine("descriptor.useFactoryInstantiationPolicy(" + classDescriptor.getInstantiationPolicy().getFactoryClassName() + ".class, \"" + classDescriptor.getInstantiationPolicy().getMethodName() + "\");");
                }
            } else {
                nonreflectiveMethodDefinition.addLine("descriptor.useMethodInstantiationPolicy(\"" + classDescriptor.getInstantiationPolicy().getMethodName() + "\");");
            }
        }
        if (classDescriptor.getAmendmentClassName() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.setAmendmentClass(" + classDescriptor.getAmendmentClassName() + ".class);");
        }
        if (classDescriptor.getAmendmentMethodName() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.setAmendmentMethodName(\"" + classDescriptor.getAmendmentMethodName() + "\");");
        }
        if (classDescriptor.getCacheSynchronizationType() != 1) {
            StringBuffer stringBuffer = new StringBuffer("descriptor.setCacheSynchronizationType(");
            if (classDescriptor.getCacheSynchronizationType() == 2) {
                stringBuffer.append("ClassDescriptor.INVALIDATE_CHANGED_OBJECTS");
            } else if (classDescriptor.getCacheSynchronizationType() == 4) {
                stringBuffer.append("ClassDescriptor.DO_NOT_SEND_CHANGES");
            } else if (classDescriptor.getCacheSynchronizationType() == 3) {
                stringBuffer.append("ClassDescriptor.SEND_NEW_OBJECTS_WITH_CHANGES");
            }
            stringBuffer.append(");");
            nonreflectiveMethodDefinition.addLine(stringBuffer.toString());
        }
        this.addCMPPolicyLines(nonreflectiveMethodDefinition, classDescriptor.getCMPPolicy());
    }

    protected void addDirectCollectionMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, DirectCollectionMapping directCollectionMapping) {
        Serializable serializable;
        if (directCollectionMapping.getReferenceTable() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setReferenceTableName(\"" + directCollectionMapping.getReferenceTable().getQualifiedName() + "\");");
        }
        nonreflectiveMethodDefinition.addLine(string + ".setDirectFieldName(\"" + directCollectionMapping.getDirectFieldName() + "\");");
        Enumeration<DatabaseField> enumeration = directCollectionMapping.getSourceKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = directCollectionMapping.getReferenceKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            serializable = enumeration.nextElement();
            DatabaseField databaseField = enumeration2.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addReferenceKeyFieldName(\"" + databaseField.getQualifiedName() + "\", \"" + ((DatabaseField)serializable).getQualifiedName() + "\");");
        }
        serializable = directCollectionMapping.getValueConverter();
        if (serializable != null) {
            this.addConverterLines(nonreflectiveMethodDefinition, string + "Converter", (Converter)serializable);
            nonreflectiveMethodDefinition.addLine(string + ".setValueConverter(" + string + "Converter" + ");");
        }
        this.addHistoryPolicyLines(nonreflectiveMethodDefinition, directCollectionMapping, string);
    }

    protected void addDirectMapMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, DirectMapMapping directMapMapping) {
        nonreflectiveMethodDefinition.addLine(string + ".setDirectKeyFieldName(\"" + directMapMapping.getDirectKeyField().getQualifiedName() + "\");");
        Converter converter = directMapMapping.getKeyConverter();
        if (converter != null) {
            this.addConverterLines(nonreflectiveMethodDefinition, string + "KeyConverter", converter);
            nonreflectiveMethodDefinition.addLine(string + ".setKeyConverter(" + string + "KeyConverter" + ");");
        }
    }

    protected void addFetchGroupManagerLine(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ClassDescriptor classDescriptor) {
        if (classDescriptor.getFetchGroupManager() == null) {
            return;
        }
        nonreflectiveMethodDefinition.addLine("//Fetch groups");
        nonreflectiveMethodDefinition.addLine("descriptor.setFetchGroupManager(new FetchGroupManager());");
        Map map = classDescriptor.getFetchGroupManager().getFetchGroups();
        if (classDescriptor.getFetchGroupManager().getDefaultFetchGroup() != null) {
            String string = classDescriptor.getFetchGroupManager().getDefaultFetchGroup().getName() + "FetchGroup";
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine("//Default fetch group -- " + (String)string);
            nonreflectiveMethodDefinition.addLine("descriptor.getFetchGroupManager().setDefaultFetchGroup(" + (String)string + ");");
        }
        if (map.isEmpty()) {
            return;
        }
        for (FetchGroup fetchGroup : map.values()) {
            String string = fetchGroup.getName() + "FetchGroup";
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine("//Named fetch group -- " + string);
            this.addFetchGroupLines(nonreflectiveMethodDefinition, fetchGroup, string);
            nonreflectiveMethodDefinition.addLine("descriptor.getFetchGroupManager().addFetchGroup(" + string + ");");
        }
    }

    protected void addFetchGroupLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, FetchGroup fetchGroup, String string) {
        Iterator iterator = fetchGroup.getAttributes().iterator();
        nonreflectiveMethodDefinition.addLine("FetchGroup " + string + " = new FetchGroup();");
        if (!fetchGroup.getName().equals("")) {
            nonreflectiveMethodDefinition.addLine(string + ".setName(\"" + fetchGroup.getName() + "\");");
        }
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            nonreflectiveMethodDefinition.addLine(string + ".addAttribute(\"" + string2 + "\");");
        }
    }

    protected void addEventManagerPropertyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ClassDescriptor classDescriptor) {
        nonreflectiveMethodDefinition.addLine("// Event Manager.");
        if (classDescriptor.getEventManager().getAboutToInsertSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setAboutToInsertSelector(\"" + classDescriptor.getEventManager().getAboutToInsertSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getAboutToUpdateSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setAboutToUpdateSelector(\"" + classDescriptor.getEventManager().getAboutToUpdateSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostBuildSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostBuildSelector(\"" + classDescriptor.getEventManager().getPostBuildSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostCloneSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostCloneSelector(\"" + classDescriptor.getEventManager().getPostCloneSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostDeleteSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostDeleteSelector(\"" + classDescriptor.getEventManager().getPostDeleteSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostInsertSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostInsertSelector(\"" + classDescriptor.getEventManager().getPostInsertSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostMergeSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostMergeSelector(\"" + classDescriptor.getEventManager().getPostMergeSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostRefreshSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostRefreshSelector(\"" + classDescriptor.getEventManager().getPostRefreshSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostUpdateSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostUpdateSelector(\"" + classDescriptor.getEventManager().getPostUpdateSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPostWriteSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPostWriteSelector(\"" + classDescriptor.getEventManager().getPostWriteSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPreDeleteSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPreDeleteSelector(\"" + classDescriptor.getEventManager().getPreDeleteSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPreInsertSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPreInsertSelector(\"" + classDescriptor.getEventManager().getPreInsertSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPreUpdateSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPreUpdateSelector(\"" + classDescriptor.getEventManager().getPreUpdateSelector() + "\");");
        }
        if (classDescriptor.getEventManager().getPreWriteSelector() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getEventManager().setPreWriteSelector(\"" + classDescriptor.getEventManager().getPreWriteSelector() + "\");");
        }
    }

    protected void addForeignReferenceMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, ForeignReferenceMapping foreignReferenceMapping) {
        Object object;
        IndirectionPolicy indirectionPolicy;
        if (foreignReferenceMapping.getReferenceClassName() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setReferenceClass(" + foreignReferenceMapping.getReferenceClassName() + ".class);");
        }
        if (foreignReferenceMapping.getRelationshipPartnerAttributeName() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setRelationshipPartnerAttributeName(\"" + foreignReferenceMapping.getRelationshipPartnerAttributeName() + "\");");
        }
        if ((indirectionPolicy = foreignReferenceMapping.getIndirectionPolicy()) instanceof ContainerIndirectionPolicy) {
            object = ((ContainerIndirectionPolicy)indirectionPolicy).getContainerClassName();
            nonreflectiveMethodDefinition.addLine(string + ".useContainerIndirection(" + (String)object + ".class);");
        } else if (indirectionPolicy instanceof ProxyIndirectionPolicy) {
            nonreflectiveMethodDefinition.addLine(string + ".useProxyIndirection();");
        } else if (indirectionPolicy instanceof BasicIndirectionPolicy) {
            nonreflectiveMethodDefinition.addLine(string + ".useBasicIndirection();");
        } else if (indirectionPolicy instanceof NoIndirectionPolicy) {
            nonreflectiveMethodDefinition.addLine(string + ".dontUseIndirection();");
        }
        if (foreignReferenceMapping.shouldUseBatchReading()) {
            nonreflectiveMethodDefinition.addLine(string + ".useBatchReading();");
        }
        if (foreignReferenceMapping.isJoinFetched()) {
            if (foreignReferenceMapping.isInnerJoinFetched()) {
                nonreflectiveMethodDefinition.addLine(string + ".useInnerJoinFetch();");
            } else if (foreignReferenceMapping.isOuterJoinFetched()) {
                nonreflectiveMethodDefinition.addLine(string + ".useOuterJoinFetch();");
            }
        }
        if (!foreignReferenceMapping.isDirectCollectionMapping() && foreignReferenceMapping.isPrivateOwned()) {
            nonreflectiveMethodDefinition.addLine(string + ".privateOwnedRelationship();");
        }
        if (foreignReferenceMapping.isCollectionMapping()) {
            Object object2;
            object = (CollectionMapping)foreignReferenceMapping;
            String string2 = ((CollectionMapping)object).getContainerPolicy().getContainerClassName();
            if (foreignReferenceMapping.getContainerPolicy().isCollectionPolicy()) {
                if (indirectionPolicy instanceof TransparentIndirectionPolicy) {
                    nonreflectiveMethodDefinition.addLine(string + ".useTransparentCollection();");
                }
                if (!string2.equals(Vector.class.getName())) {
                    nonreflectiveMethodDefinition.addLine(string + ".useCollectionClass(" + string2 + ".class);");
                }
            } else if (((CollectionMapping)object).getContainerPolicy().isMapPolicy()) {
                object2 = ((MapContainerPolicy)((CollectionMapping)object).getContainerPolicy()).getKeyName();
                if (indirectionPolicy instanceof TransparentIndirectionPolicy) {
                    nonreflectiveMethodDefinition.addLine(string + ".useTransparentMap(\"" + (String)object2 + "\");");
                    if (!string2.equals(IndirectMap.class.getName())) {
                        nonreflectiveMethodDefinition.addLine(string + ".useMapClass(" + string2 + ".class, \"" + (String)object2 + "\");");
                    }
                } else {
                    nonreflectiveMethodDefinition.addLine(string + ".useMapClass(" + string2 + ".class, \"" + (String)object2 + "\");");
                }
            } else if (((CollectionMapping)object).getContainerPolicy().isDirectMapPolicy()) {
                if (indirectionPolicy instanceof TransparentIndirectionPolicy) {
                    nonreflectiveMethodDefinition.addLine(string + ".useTransparentMap();");
                    if (!string2.equals(IndirectMap.class.getName())) {
                        nonreflectiveMethodDefinition.addLine(string + ".useMapClass(" + string2 + ".class);");
                    }
                } else {
                    nonreflectiveMethodDefinition.addLine(string + ".useMapClass(" + string2 + ".class);");
                }
            }
            object2 = ((CollectionMapping)object).getOrderByQueryKeyExpressions().elements();
            while (object2.hasMoreElements()) {
                FunctionExpression functionExpression = (FunctionExpression)object2.nextElement();
                String string3 = functionExpression.getBaseExpression().getName();
                if (functionExpression.getOperator().getSelector() == 27) {
                    nonreflectiveMethodDefinition.addLine(string + ".addDescendingOrdering(\"" + string3 + "\");");
                    continue;
                }
                nonreflectiveMethodDefinition.addLine(string + ".addAscendingOrdering(\"" + string3 + "\");");
            }
        }
    }

    protected void addHistoryPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ClassDescriptor classDescriptor) {
        if (classDescriptor.getHistoryPolicy() == null) {
            return;
        }
        this.addHistoryPolicyLines(nonreflectiveMethodDefinition, classDescriptor.getHistoryPolicy(), "historyPolicy");
        nonreflectiveMethodDefinition.addLine("descriptor.setHistoryPolicy(historyPolicy);");
    }

    protected void addHistoryPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, DirectCollectionMapping directCollectionMapping, String string) {
        if (directCollectionMapping.getHistoryPolicy() == null) {
            return;
        }
        String string2 = directCollectionMapping.getAttributeName() + "HistoryPolicy";
        this.addHistoryPolicyLines(nonreflectiveMethodDefinition, directCollectionMapping.getHistoryPolicy(), string2);
        nonreflectiveMethodDefinition.addLine(string + ".setHistoryPolicy(" + string2 + ");");
    }

    protected void addHistoryPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ManyToManyMapping manyToManyMapping, String string) {
        if (manyToManyMapping.getHistoryPolicy() == null) {
            return;
        }
        String string2 = manyToManyMapping.getAttributeName() + "HistoryPolicy";
        this.addHistoryPolicyLines(nonreflectiveMethodDefinition, manyToManyMapping.getHistoryPolicy(), string2);
        nonreflectiveMethodDefinition.addLine(string + ".setHistoryPolicy(" + string2 + ");");
    }

    protected void addHistoryPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, HistoryPolicy historyPolicy, String string) {
        Cloneable cloneable;
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("// History Policy");
        nonreflectiveMethodDefinition.addLine("HistoryPolicy " + string + " = new HistoryPolicy();");
        Enumeration enumeration = historyPolicy.getHistoricalTables().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (HistoricalDatabaseTable)enumeration.nextElement();
            String string2 = null;
            string2 = ((DatabaseTable)cloneable).getTableQualifier().equals("") ? ((DatabaseTable)cloneable).getName() : ((DatabaseTable)cloneable).getTableQualifier() + "." + ((DatabaseTable)cloneable).getName();
            String string3 = ((HistoricalDatabaseTable)cloneable).getQualifiedName();
            nonreflectiveMethodDefinition.addLine(string + ".addHistoryTableName(\"" + string2 + "\", \"" + string3 + "\");");
        }
        enumeration = historyPolicy.getStartFields().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (DatabaseField)enumeration.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addStartFieldName(\"" + ((DatabaseField)cloneable).getQualifiedName() + "\");");
        }
        enumeration = historyPolicy.getEndFields().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (DatabaseField)enumeration.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addEndFieldName(\"" + ((DatabaseField)cloneable).getQualifiedName() + "\");");
        }
        nonreflectiveMethodDefinition.addLine(string + ".setShouldHandleWrites(" + (historyPolicy.shouldHandleWrites() ? "true" : "false") + ");");
        if (historyPolicy.shouldUseLocalTime()) {
            nonreflectiveMethodDefinition.addLine(string + ".useLocalTime();");
        } else {
            nonreflectiveMethodDefinition.addLine(string + ".useDatabaseTime();");
        }
    }

    protected void addInheritanceLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, InheritancePolicy inheritancePolicy) {
        nonreflectiveMethodDefinition.addLine("// Inheritance Properties.");
        if (inheritancePolicy.isChildDescriptor()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().setParentClass(" + inheritancePolicy.getParentClassName() + ".class);");
        } else if (inheritancePolicy.getClassExtractionMethodName() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().setClassExtractionMethodName(\"" + inheritancePolicy.getClassExtractionMethodName() + "\");");
        } else if (inheritancePolicy.getClassIndicatorField() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().setClassIndicatorFieldName(\"" + inheritancePolicy.getClassIndicatorField().getQualifiedName() + "\");");
            if (inheritancePolicy.shouldUseClassNameAsIndicator()) {
                nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().useClassNameAsIndicator();");
            } else {
                for (String string : inheritancePolicy.getClassNameIndicatorMapping().keySet()) {
                    Object v = inheritancePolicy.getClassNameIndicatorMapping().get(string);
                    nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().addClassIndicator(" + string + ".class, " + this.printString(v) + ");");
                }
            }
        }
        if (inheritancePolicy.getReadAllSubclassesView() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().setReadAllSubclassesViewName(\"" + inheritancePolicy.getReadAllSubclassesViewName() + "\");");
        }
        if (inheritancePolicy.shouldOuterJoinSubclasses()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().setShouldOuterJoinSubclasses(true);");
        }
        if (!inheritancePolicy.shouldReadSubclasses()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();");
        }
    }

    protected void addInterfaceLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, InterfacePolicy interfacePolicy) {
        nonreflectiveMethodDefinition.addLine("// Interface Properties.");
        if (interfacePolicy.isInterfaceChildDescriptor()) {
            Enumeration enumeration = interfacePolicy.getParentInterfaceNames().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                nonreflectiveMethodDefinition.addLine("descriptor.getInterfacePolicy().addParentInterface(" + string + ".class);");
            }
        }
    }

    protected void addManyToManyMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, ManyToManyMapping manyToManyMapping) {
        Object object;
        Object object2;
        if (manyToManyMapping.getRelationTable() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setRelationTableName(\"" + manyToManyMapping.getRelationTable().getQualifiedName() + "\");");
        }
        Enumeration<DatabaseField> enumeration = manyToManyMapping.getSourceRelationKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = manyToManyMapping.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration2.nextElement();
            object = enumeration.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addSourceRelationKeyFieldName(\"" + ((DatabaseField)object).getQualifiedName() + "\", \"" + ((DatabaseField)object2).getQualifiedName() + "\");");
        }
        object2 = manyToManyMapping.getTargetRelationKeyFields().elements();
        object = manyToManyMapping.getTargetKeyFields().elements();
        while (object2.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)object.nextElement();
            DatabaseField databaseField2 = (DatabaseField)object2.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addTargetRelationKeyFieldName(\"" + databaseField2.getQualifiedName() + "\", \"" + databaseField.getQualifiedName() + "\");");
        }
        this.addHistoryPolicyLines(nonreflectiveMethodDefinition, manyToManyMapping, string);
    }

    protected void addMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, DatabaseMapping databaseMapping) {
        String string = databaseMapping.getAttributeName() + "Mapping";
        String string2 = databaseMapping.getClass().getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        if (string3.equals("org.eclipse.persistence.mappings")) {
            string2 = Helper.getShortClassName(databaseMapping);
        }
        nonreflectiveMethodDefinition.addLine(string2 + " " + string + " = new " + string2 + "();");
        if (!databaseMapping.isWriteOnly()) {
            nonreflectiveMethodDefinition.addLine(string + ".setAttributeName(\"" + databaseMapping.getAttributeName() + "\");");
            if (databaseMapping.getGetMethodName() != null) {
                nonreflectiveMethodDefinition.addLine(string + ".setGetMethodName(\"" + databaseMapping.getGetMethodName() + "\");");
            }
            if (databaseMapping.getSetMethodName() != null) {
                nonreflectiveMethodDefinition.addLine(string + ".setSetMethodName(\"" + databaseMapping.getSetMethodName() + "\");");
            }
        }
        if (databaseMapping.isDirectToFieldMapping()) {
            Converter converter;
            AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)databaseMapping;
            if (databaseMapping.getDescriptor().isAggregateDescriptor()) {
                nonreflectiveMethodDefinition.addLine(string + ".setFieldName(\"" + abstractDirectMapping.getField().getName() + "\");");
            } else {
                nonreflectiveMethodDefinition.addLine(string + ".setFieldName(\"" + abstractDirectMapping.getField().getQualifiedName() + "\");");
            }
            if (abstractDirectMapping.getNullValue() != null) {
                nonreflectiveMethodDefinition.addLine(string + ".setNullValue(" + this.printString(abstractDirectMapping.getNullValue()) + ");");
            }
            if ((converter = abstractDirectMapping.getConverter()) != null) {
                this.addConverterLines(nonreflectiveMethodDefinition, string + "Converter", converter);
                nonreflectiveMethodDefinition.addLine(string + ".setConverter(" + string + "Converter" + ");");
            }
        } else if (databaseMapping.isForeignReferenceMapping()) {
            this.addForeignReferenceMappingLines(nonreflectiveMethodDefinition, string, (ForeignReferenceMapping)databaseMapping);
        }
        if (databaseMapping.isReadOnly()) {
            nonreflectiveMethodDefinition.addLine(string + ".readOnly();");
        }
        if (databaseMapping.isAggregateObjectMapping()) {
            this.addAggregateObjectMappingLines(nonreflectiveMethodDefinition, string, (AggregateObjectMapping)databaseMapping);
        } else if (databaseMapping.isOneToOneMapping()) {
            this.addOneToOneMappingLines(nonreflectiveMethodDefinition, string, (OneToOneMapping)databaseMapping);
        } else if (databaseMapping.isOneToManyMapping()) {
            this.addOneToManyMappingLines(nonreflectiveMethodDefinition, string, (OneToManyMapping)databaseMapping);
        } else if (databaseMapping.isManyToManyMapping()) {
            this.addManyToManyMappingLines(nonreflectiveMethodDefinition, string, (ManyToManyMapping)databaseMapping);
        } else if (databaseMapping.isTransformationMapping()) {
            this.addTransformationMappingLines(nonreflectiveMethodDefinition, string, (TransformationMapping)databaseMapping);
        } else if (databaseMapping.isDirectCollectionMapping()) {
            this.addDirectCollectionMappingLines(nonreflectiveMethodDefinition, string, (DirectCollectionMapping)databaseMapping);
        } else if (databaseMapping.isAggregateCollectionMapping()) {
            this.addAggregateCollectionMappingLines(nonreflectiveMethodDefinition, string, (AggregateCollectionMapping)databaseMapping);
        } else if (databaseMapping.isVariableOneToOneMapping()) {
            this.addVariableOneToOneMappingLines(nonreflectiveMethodDefinition, string, (VariableOneToOneMapping)databaseMapping);
        }
        if (databaseMapping.isDirectMapMapping()) {
            this.addDirectMapMappingLines(nonreflectiveMethodDefinition, string, (DirectMapMapping)databaseMapping);
        }
        if (databaseMapping.isDirectToXMLTypeMapping()) {
            DirectToXMLTypeMappingHelper.getInstance().writeShouldreadWholeDocument(nonreflectiveMethodDefinition, string, databaseMapping);
        }
        nonreflectiveMethodDefinition.addLine("descriptor.addMapping(" + databaseMapping.getAttributeName() + "Mapping);");
    }

    protected void addObjectTypeConverterLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, ObjectTypeConverter objectTypeConverter) {
        Object v;
        if (objectTypeConverter.getDefaultAttributeValue() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setDefaultAttributeValue(" + this.printString(objectTypeConverter.getDefaultAttributeValue()) + ");");
        }
        for (Object k : objectTypeConverter.getAttributeToFieldValues().keySet()) {
            v = objectTypeConverter.getAttributeToFieldValues().get(k);
            nonreflectiveMethodDefinition.addLine(string + ".addConversionValue(" + this.printString(v) + ", " + this.printString(k) + ");");
        }
        for (Object k : objectTypeConverter.getFieldToAttributeValues().keySet()) {
            v = objectTypeConverter.getFieldToAttributeValues().get(k);
            if (objectTypeConverter.getAttributeToFieldValues().containsKey(v)) continue;
            nonreflectiveMethodDefinition.addLine(string + ".addToAttributeOnlyConversionValue(" + this.printString(k) + ", " + this.printString(v) + ");");
        }
    }

    protected void addOneToManyMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, OneToManyMapping oneToManyMapping) {
        Enumeration<DatabaseField> enumeration = oneToManyMapping.getTargetForeignKeyFields().elements();
        Enumeration<DatabaseField> enumeration2 = oneToManyMapping.getSourceKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            DatabaseField databaseField = enumeration2.nextElement();
            DatabaseField databaseField2 = enumeration.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addTargetForeignKeyFieldName(\"" + databaseField2.getQualifiedName() + "\", \"" + databaseField.getQualifiedName() + "\");");
        }
    }

    protected void addOneToOneMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, OneToOneMapping oneToOneMapping) {
        for (DatabaseField databaseField : oneToOneMapping.getSourceToTargetKeyFields().keySet()) {
            DatabaseField databaseField2 = oneToOneMapping.getSourceToTargetKeyFields().get(databaseField);
            if (oneToOneMapping.getForeignKeyFields().contains(databaseField)) {
                nonreflectiveMethodDefinition.addLine(string + ".addForeignKeyFieldName(\"" + databaseField.getQualifiedName() + "\", \"" + databaseField2.getQualifiedName() + "\");");
                continue;
            }
            nonreflectiveMethodDefinition.addLine(string + ".addTargetForeignKeyFieldName(\"" + databaseField2.getQualifiedName() + "\", \"" + databaseField.getQualifiedName() + "\");");
        }
        if (!oneToOneMapping.shouldVerifyDelete()) {
            nonreflectiveMethodDefinition.addLine(string + ".setShouldVerifyDelete(false);");
        }
    }

    protected void addOptimisticLockingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, OptimisticLockingPolicy optimisticLockingPolicy) {
        String string = optimisticLockingPolicy.getClass().getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        if (string2.equals("org.eclipse.persistence.descriptors")) {
            string = Helper.getShortClassName(optimisticLockingPolicy);
        }
        nonreflectiveMethodDefinition.addLine(string + " lockingPolicy = new " + string + "();");
        if (optimisticLockingPolicy instanceof SelectedFieldsLockingPolicy) {
            SelectedFieldsLockingPolicy selectedFieldsLockingPolicy = (SelectedFieldsLockingPolicy)optimisticLockingPolicy;
            Enumeration enumeration = selectedFieldsLockingPolicy.getLockFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                nonreflectiveMethodDefinition.addLine("lockingPolicy.addLockFieldName(\"" + databaseField.getQualifiedName() + "\");");
            }
        } else if (optimisticLockingPolicy instanceof VersionLockingPolicy) {
            TimestampLockingPolicy timestampLockingPolicy;
            VersionLockingPolicy versionLockingPolicy = (VersionLockingPolicy)optimisticLockingPolicy;
            nonreflectiveMethodDefinition.addLine("lockingPolicy.setWriteLockFieldName(\"" + versionLockingPolicy.getWriteLockField().getQualifiedName() + "\");");
            if (versionLockingPolicy.isStoredInObject()) {
                nonreflectiveMethodDefinition.addLine("lockingPolicy.storeInObject();");
            }
            if (optimisticLockingPolicy instanceof TimestampLockingPolicy && (timestampLockingPolicy = (TimestampLockingPolicy)optimisticLockingPolicy).usesLocalTime()) {
                nonreflectiveMethodDefinition.addLine("lockingPolicy.useLocalTime();");
            }
        }
        nonreflectiveMethodDefinition.addLine("descriptor.setOptimisticLockingPolicy(lockingPolicy);");
    }

    protected void addQueryKeyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, QueryKey queryKey) {
        if (queryKey.isDirectQueryKey()) {
            nonreflectiveMethodDefinition.addLine("descriptor.addDirectQueryKey(\"" + queryKey.getName() + "\", \"" + ((DirectQueryKey)queryKey).getField().getQualifiedName() + "\");");
        } else if (queryKey.isAbstractQueryKey()) {
            nonreflectiveMethodDefinition.addLine("descriptor.addAbstractQueryKey(\"" + queryKey.getName() + "\");");
        }
    }

    protected void addQueryManagerPropertyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ClassDescriptor classDescriptor) {
        nonreflectiveMethodDefinition.addLine("// Query Manager.");
        if (!(classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor() || classDescriptor.isDescriptorForInterface())) {
            if (classDescriptor.getQueryManager().getDoesExistQuery().shouldAssumeExistenceForDoesExist()) {
                nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().assumeExistenceForDoesExist();");
            } else if (classDescriptor.getQueryManager().getDoesExistQuery().shouldAssumeNonExistenceForDoesExist()) {
                nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().assumeNonExistenceForDoesExist();");
            } else if (classDescriptor.getQueryManager().getDoesExistQuery().shouldCheckCacheForDoesExist()) {
                nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().checkCacheForDoesExist();");
            } else if (classDescriptor.getQueryManager().getDoesExistQuery().shouldCheckDatabaseForDoesExist()) {
                nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().checkDatabaseForDoesExist();");
            }
        }
        if (classDescriptor.getQueryManager().getQueryTimeout() != -1) {
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setQueryTimeout(" + classDescriptor.getQueryManager().getQueryTimeout() + ");");
        }
        if (classDescriptor.getQueryManager().hasReadObjectQuery() && classDescriptor.getQueryManager().getReadObjectQuery().isSQLCallQuery()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setReadObjectSQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(classDescriptor.getQueryManager().getReadObjectQuery().getSQLString()) + "\");");
        } else if (classDescriptor.getQueryManager().hasReadObjectQuery() && classDescriptor.getQueryManager().getReadObjectQuery().getDatasourceCall() instanceof XMLInteraction) {
            this.addXMLInteractionLines(nonreflectiveMethodDefinition, (XMLInteraction)classDescriptor.getQueryManager().getReadObjectQuery().getDatasourceCall(), "readObjectCall");
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setReadObjectCall(readObjectCall);");
        }
        if (classDescriptor.getQueryManager().hasReadAllQuery() && classDescriptor.getQueryManager().getReadAllQuery().isSQLCallQuery()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setReadAllSQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(classDescriptor.getQueryManager().getReadAllQuery().getSQLString()) + "\");");
        } else if (classDescriptor.getQueryManager().hasReadAllQuery() && classDescriptor.getQueryManager().getReadAllQuery().getDatasourceCall() instanceof XMLInteraction) {
            this.addXMLInteractionLines(nonreflectiveMethodDefinition, (XMLInteraction)classDescriptor.getQueryManager().getReadAllQuery().getDatasourceCall(), "readAllCall");
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setReadAllCall(readAllCall);");
        }
        if (classDescriptor.getQueryManager().hasInsertQuery() && classDescriptor.getQueryManager().getInsertQuery().isSQLCallQuery()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setInsertSQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(classDescriptor.getQueryManager().getInsertQuery().getSQLString()) + "\");");
        } else if (classDescriptor.getQueryManager().hasInsertQuery() && classDescriptor.getQueryManager().getInsertQuery().getDatasourceCall() instanceof XMLInteraction) {
            this.addXMLInteractionLines(nonreflectiveMethodDefinition, (XMLInteraction)classDescriptor.getQueryManager().getInsertQuery().getDatasourceCall(), "insertCall");
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setInsertCall(insertCall);");
        }
        if (classDescriptor.getQueryManager().hasUpdateQuery() && classDescriptor.getQueryManager().getUpdateQuery().isSQLCallQuery()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setUpdateSQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(classDescriptor.getQueryManager().getUpdateQuery().getSQLString()) + "\");");
        } else if (classDescriptor.getQueryManager().hasUpdateQuery() && classDescriptor.getQueryManager().getUpdateQuery().getDatasourceCall() instanceof XMLInteraction) {
            this.addXMLInteractionLines(nonreflectiveMethodDefinition, (XMLInteraction)classDescriptor.getQueryManager().getUpdateQuery().getDatasourceCall(), "updateCall");
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setUpdateCall(updateCall);");
        }
        if (classDescriptor.getQueryManager().hasDeleteQuery() && classDescriptor.getQueryManager().getDeleteQuery().isSQLCallQuery()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setDeleteSQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(classDescriptor.getQueryManager().getDeleteQuery().getSQLString()) + "\");");
        } else if (classDescriptor.getQueryManager().hasDeleteQuery() && classDescriptor.getQueryManager().getUpdateQuery().getDatasourceCall() instanceof XMLInteraction) {
            this.addXMLInteractionLines(nonreflectiveMethodDefinition, (XMLInteraction)classDescriptor.getQueryManager().getDeleteQuery().getDatasourceCall(), "deleteCall");
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setDeleteCall(deleteCall);");
        }
        if (classDescriptor.getQueryManager().hasDoesExistQuery() && classDescriptor.getQueryManager().getDoesExistQuery().isSQLCallQuery()) {
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setDoesExistSQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(classDescriptor.getQueryManager().getDoesExistQuery().getSQLString()) + "\");");
        } else if (classDescriptor.getQueryManager().hasDoesExistQuery() && classDescriptor.getQueryManager().getDoesExistQuery().getDatasourceCall() instanceof XMLInteraction) {
            this.addXMLInteractionLines(nonreflectiveMethodDefinition, (XMLInteraction)classDescriptor.getQueryManager().getDoesExistQuery().getDatasourceCall(), "doesExistCall");
            nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().setDoesExistCall(doesExistCall);");
        }
        if (classDescriptor.getQueryManager().getAllQueries().size() > 0) {
            nonreflectiveMethodDefinition.addLine("// Named Queries.");
            Enumeration enumeration = classDescriptor.getQueryManager().getAllQueries().elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                this.addNamedQueryLines(nonreflectiveMethodDefinition, (DatabaseQuery)enumeration.nextElement(), classDescriptor.getQueryManager(), n);
                ++n;
            }
        }
    }

    private String constructValidSQLorEJBQLLinesForJavaSource(String string) {
        String string2 = "\" " + Helper.cr() + '\t' + '\t' + "+ " + "\"";
        if (string != null) {
            string.trim();
            while (string.endsWith("\n")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.replaceAll("\n", string2);
        }
        return string;
    }

    protected void addXMLInteractionLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, XMLInteraction xMLInteraction, String string) {
        nonreflectiveMethodDefinition.addLine("org.eclipse.persistence.eis.XMLInteraction " + string + " = new org.eclipse.persistence.eis.XMLInteraction();");
        if (xMLInteraction.getFunctionName() != null && xMLInteraction.getFunctionName().length() != 0) {
            nonreflectiveMethodDefinition.addLine(string + ".setFunctionName(\"" + xMLInteraction.getFunctionName() + "\");");
        }
        if (xMLInteraction.getInputRecordName() != null && xMLInteraction.getInputRecordName().length() != 0) {
            nonreflectiveMethodDefinition.addLine(string + ".setInputRecordName(\"" + xMLInteraction.getInputRecordName() + "\");");
        }
        if (xMLInteraction.getInputRootElementName() != null && xMLInteraction.getInputRootElementName().length() != 0) {
            nonreflectiveMethodDefinition.addLine(string + ".setInputRootElementName(\"" + xMLInteraction.getInputRootElementName() + "\");");
        }
        if (xMLInteraction.getInputResultPath() != null && xMLInteraction.getInputResultPath().length() != 0) {
            nonreflectiveMethodDefinition.addLine(string + ".setInputResultPath(\"" + xMLInteraction.getInputResultPath() + "\");");
        }
        if (xMLInteraction.getOutputResultPath() != null && xMLInteraction.getOutputResultPath().length() != 0) {
            nonreflectiveMethodDefinition.addLine(string + ".setOutputResultPath(\"" + xMLInteraction.getOutputResultPath() + "\");");
        }
        for (int i = xMLInteraction.getArgumentNames().size(); i < xMLInteraction.getArgumentNames().size(); ++i) {
            String string2 = (String)xMLInteraction.getArgumentNames().get(i);
            String string3 = (String)xMLInteraction.getArguments().get(i);
            nonreflectiveMethodDefinition.addLine(string + ".addArgument(\"" + string2 + "\", \"" + string3 + "\");");
        }
    }

    protected void addNamedQueryLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, DatabaseQuery databaseQuery, DescriptorQueryManager descriptorQueryManager, int n) {
        Object object;
        Iterator<Expression> iterator;
        Object object3;
        Object object4;
        String string = "namedQuery" + String.valueOf(n);
        nonreflectiveMethodDefinition.addLine("// Named Query -- " + databaseQuery.getName());
        String string2 = "";
        string2 = databaseQuery.getDescriptor() != null ? databaseQuery.getDescriptor().getJavaClassName() : databaseQuery.getReferenceClassName();
        if (databaseQuery.isReportQuery()) {
            nonreflectiveMethodDefinition.addLine("ReportQuery " + string + " = new ReportQuery(" + string2 + ".class, new ExpressionBuilder());");
        } else if (databaseQuery.isReadAllQuery()) {
            nonreflectiveMethodDefinition.addLine("ReadAllQuery " + string + " = new ReadAllQuery(" + string2 + ".class);");
        } else if (databaseQuery.isReadObjectQuery()) {
            nonreflectiveMethodDefinition.addLine("ReadObjectQuery " + string + " = new ReadObjectQuery(" + string2 + ".class);");
        } else if (databaseQuery.isValueReadQuery()) {
            nonreflectiveMethodDefinition.addLine("ValueReadQuery " + string + " = new ValueReadQuery();");
        } else if (databaseQuery.isDataReadQuery()) {
            nonreflectiveMethodDefinition.addLine("DataReadQuery " + string + " = new DataReadQuery();");
        } else if (databaseQuery.isDirectReadQuery()) {
            nonreflectiveMethodDefinition.addLine("DirectReadQuery " + string + " = new DirectReadQuery();");
        }
        if (databaseQuery.getSQLString() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setSQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(databaseQuery.getSQLString()) + "\");");
        } else if (databaseQuery.getEJBQLString() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setEJBQLString(\"" + this.constructValidSQLorEJBQLLinesForJavaSource(databaseQuery.getEJBQLString()) + "\");");
        } else if (databaseQuery.getDatasourceCall() instanceof XMLInteraction) {
            this.addXMLInteractionLines(nonreflectiveMethodDefinition, (XMLInteraction)databaseQuery.getDatasourceCall(), string + "Call");
            nonreflectiveMethodDefinition.addLine(string + ".setCall(" + string + "Call" + ");");
        }
        if (databaseQuery.getRedirector() != null && databaseQuery.getRedirector().getClass().equals(MethodBaseQueryRedirector.class)) {
            nonreflectiveMethodDefinition.addLine(string + ".setRedirector(new MethodBaseQueryRedirector(" + ((MethodBaseQueryRedirector)databaseQuery.getRedirector()).getMethodClassName() + ".class, \"" + ((MethodBaseQueryRedirector)databaseQuery.getRedirector()).getMethodName() + "\"));");
        }
        nonreflectiveMethodDefinition.addLine(string + ".setName(\"" + databaseQuery.getName() + "\");");
        if (!databaseQuery.isReadQuery() || databaseQuery.getCascadePolicy() != 1) {
            object4 = "DatabaseQuery.NoCascading";
            if (databaseQuery.getCascadePolicy() == 2) {
                object4 = "DatabaseQuery.CascadePrivateParts";
            } else if (databaseQuery.getCascadePolicy() == 4) {
                object4 = "DatabaseQuery.CascadeDependentParts";
            } else if (databaseQuery.getCascadePolicy() == 3) {
                object4 = "DatabaseQuery.CascadeAllParts";
            }
            nonreflectiveMethodDefinition.addLine(string + ".setCascadePolicy(" + (String)object4 + ");");
        }
        if (databaseQuery.getQueryTimeout() != -1) {
            nonreflectiveMethodDefinition.addLine(string + ".setQueryTimeout(" + String.valueOf(databaseQuery.getQueryTimeout()) + ");");
        }
        if (!databaseQuery.shouldUseWrapperPolicy()) {
            nonreflectiveMethodDefinition.addLine(string + ".setShouldUseWrapperPolicy(" + String.valueOf(databaseQuery.shouldUseWrapperPolicy()) + ");");
        }
        if (!databaseQuery.shouldIgnoreBindAllParameters()) {
            nonreflectiveMethodDefinition.addLine(string + ".setShouldBindAllParameters(" + String.valueOf(databaseQuery.shouldBindAllParameters()) + ");");
        }
        if (!databaseQuery.shouldIgnoreCacheStatement()) {
            nonreflectiveMethodDefinition.addLine(string + ".setShouldCacheStatement(" + String.valueOf(databaseQuery.shouldCacheStatement()) + ");");
        }
        if (databaseQuery.getSessionName() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setSessionName(\"" + databaseQuery.getSessionName() + "\");");
        }
        if (!databaseQuery.shouldMaintainCache()) {
            nonreflectiveMethodDefinition.addLine(string + ".setShouldMaintainCache(" + String.valueOf(databaseQuery.shouldMaintainCache()) + ");");
        }
        if (!databaseQuery.shouldPrepare()) {
            nonreflectiveMethodDefinition.addLine(string + ".setShouldPrepare(" + String.valueOf(databaseQuery.shouldPrepare()) + ");");
        }
        if (databaseQuery.isReadQuery()) {
            object4 = (ReadQuery)databaseQuery;
            if (((ReadQuery)object4).shouldCacheQueryResults()) {
                nonreflectiveMethodDefinition.addLine(string + ".setQueryResultsCachePolicy(new QueryResultsCachePolicy());");
            }
            if (((ReadQuery)object4).getMaxRows() != 0) {
                nonreflectiveMethodDefinition.addLine(string + ".setMaxRows(" + String.valueOf(((ReadQuery)object4).getMaxRows()) + ");");
            }
            if (((ReadQuery)object4).getFirstResult() != 0) {
                nonreflectiveMethodDefinition.addLine(string + ".setFirstResult(" + String.valueOf(((ReadQuery)object4).getFirstResult()) + ");");
            }
        }
        object4 = null;
        if (databaseQuery.isObjectLevelReadQuery()) {
            object3 = (ObjectLevelReadQuery)databaseQuery;
            if (((ObjectLevelReadQuery)object3).shouldRefreshIdentityMapResult()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldRefreshIdentityMapResult(" + String.valueOf(((ObjectLevelReadQuery)object3).shouldRefreshIdentityMapResult()) + ");");
            }
            if (((ObjectLevelReadQuery)object3).getCacheUsage() != -1) {
                iterator = "ObjectLevelReadQuery.UseDescriptorSetting";
                if (((ObjectLevelReadQuery)object3).getCacheUsage() == 0) {
                    iterator = "ObjectLevelReadQuery.DoNotCheckCache";
                } else if (((ObjectLevelReadQuery)object3).getCacheUsage() == 1) {
                    iterator = "ObjectLevelReadQuery.CheckCacheByExactPrimaryKey";
                } else if (((ObjectLevelReadQuery)object3).getCacheUsage() == 2) {
                    iterator = "ObjectLevelReadQuery.CheckCacheByPrimaryKey";
                } else if (((ObjectLevelReadQuery)object3).getCacheUsage() == 3) {
                    iterator = "ObjectLevelReadQuery.CheckCacheThenDatabase";
                } else if (((ObjectLevelReadQuery)object3).getCacheUsage() == 4) {
                    iterator = "ObjectLevelReadQuery.CheckCacheOnly";
                } else if (((ObjectLevelReadQuery)object3).getCacheUsage() == 5) {
                    iterator = "ObjectLevelReadQuery.ConformResultsInUnitOfWork";
                }
                nonreflectiveMethodDefinition.addLine(string + ".setCacheUsage(" + iterator + ");");
            }
            if (((ObjectLevelReadQuery)object3).getLockMode() != -1) {
                iterator = null;
                if (((ObjectLevelReadQuery)object3).getLockMode() == 0 && !((DatabaseQuery)object3).isReportQuery()) {
                    iterator = "ObjectLevelReadQuery.NO_LOCK";
                } else if (((ObjectLevelReadQuery)object3).getLockMode() == 1) {
                    iterator = "ObjectLevelReadQuery.LOCK";
                } else if (((ObjectLevelReadQuery)object3).getLockMode() == 2) {
                    iterator = "ObjectLevelReadQuery.LOCK_NOWAIT";
                }
                if (iterator != null) {
                    nonreflectiveMethodDefinition.addLine(string + ".setLockMode(" + (String)((Object)iterator) + ");");
                }
            }
            if (((ObjectLevelReadQuery)object3).shouldRefreshRemoteIdentityMapResult()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldRefreshRemoteIdentityMapResult(" + String.valueOf(((ObjectLevelReadQuery)object3).shouldRefreshRemoteIdentityMapResult()) + ");");
            }
            if (((ObjectLevelReadQuery)object3).getDistinctState() != 0) {
                iterator = "ObjectLevelReadQuery.UNCOMPUTED_DISTINCT";
                if (((ObjectLevelReadQuery)object3).getDistinctState() == 1) {
                    iterator = "ObjectLevelReadQuery.USE_DISTINCT";
                } else if (((ObjectLevelReadQuery)object3).getDistinctState() == 2) {
                    iterator = "ObjectLevelReadQuery.DONT_USE_DISTINCT";
                }
                nonreflectiveMethodDefinition.addLine(string + ".setDistinctState((short)" + (String)((Object)iterator) + ");");
            }
            if (((ObjectLevelReadQuery)object3).getInMemoryQueryIndirectionPolicy().getPolicy() != 0) {
                iterator = "InMemoryQueryIndirectionPolicy.SHOULD_THROW_INDIRECTION_EXCEPTION";
                if (((ObjectLevelReadQuery)object3).getInMemoryQueryIndirectionPolicy().getPolicy() == 1) {
                    iterator = "InMemoryQueryIndirectionPolicy.SHOULD_TRIGGER_INDIRECTION";
                } else if (((ObjectLevelReadQuery)object3).getInMemoryQueryIndirectionPolicy().getPolicy() == 2) {
                    iterator = "InMemoryQueryIndirectionPolicy.SHOULD_IGNORE_EXCEPTION_RETURN_CONFORMED";
                } else if (((ObjectLevelReadQuery)object3).getInMemoryQueryIndirectionPolicy().getPolicy() == 3) {
                    iterator = "InMemoryQueryIndirectionPolicy.SHOULD_IGNORE_EXCEPTION_RETURN_NOT_CONFORMED";
                }
                nonreflectiveMethodDefinition.addLine(string + ".setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(" + (String)((Object)iterator) + "));");
            }
            if (!((ObjectLevelReadQuery)object3).shouldUseDefaultFetchGroup()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldUseDefaultFetchGroup(false);");
            }
            if (((ObjectLevelReadQuery)object3).getFetchGroupName() != null) {
                nonreflectiveMethodDefinition.addLine(string + ".setFetchGroupName(\"" + ((ObjectLevelReadQuery)object3).getFetchGroupName() + "\");");
            } else if (((ObjectLevelReadQuery)object3).getFetchGroup() != null) {
                iterator = ((ObjectLevelReadQuery)object3).getFetchGroup().getName() + "FetchGroup";
                this.addFetchGroupLines(nonreflectiveMethodDefinition, ((ObjectLevelReadQuery)object3).getFetchGroup(), (String)((Object)iterator));
                nonreflectiveMethodDefinition.addLine(string + ".setFetchGroup(" + iterator + ");");
            }
            if (((ObjectBuildingQuery)object3).shouldUseExclusiveConnection()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldUseExclusiveConnection(true);");
            }
            if (((ObjectLevelReadQuery)object3).isReadOnly()) {
                nonreflectiveMethodDefinition.addLine(string + ".setIsReadOnly(true);");
            }
            if (((ObjectLevelReadQuery)object3).shouldOuterJoinSubclasses()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldOuterJoinSubclasses(true);");
            }
            if (((DatabaseQuery)object3).getSelectionCriteria() != null) {
                object4 = this.buildBuilderString((String)object4, nonreflectiveMethodDefinition, n, string);
                this.buildExpressionString((String)object4, nonreflectiveMethodDefinition, string, ((DatabaseQuery)object3).getSelectionCriteria(), ".setSelectionCriteria(");
            }
            for (Expression object22 : ((ObjectLevelReadQuery)object3).getJoinedAttributeManager().getJoinedAttributeExpressions()) {
                object4 = this.buildBuilderString((String)object4, nonreflectiveMethodDefinition, n, string);
                this.buildExpressionString((String)object4, nonreflectiveMethodDefinition, string, object22, ".addJoinedAttribute(");
            }
        }
        if (databaseQuery.isReadAllQuery()) {
            object3 = (ReadAllQuery)databaseQuery;
            iterator = ((ReadAllQuery)object3).getOrderByExpressions().elements();
            while (iterator.hasMoreElements()) {
                Expression expression = (Expression)iterator.nextElement();
                object4 = this.buildBuilderString((String)object4, nonreflectiveMethodDefinition, n, string);
                this.buildExpressionString((String)object4, nonreflectiveMethodDefinition, string, expression, ".addOrdering(");
            }
            iterator = ((ReadAllQuery)object3).getBatchReadAttributeExpressions().elements();
            while (iterator.hasMoreElements()) {
                Expression expression = (Expression)iterator.nextElement();
                object4 = this.buildBuilderString((String)object4, nonreflectiveMethodDefinition, n, string);
                this.buildExpressionString((String)object4, nonreflectiveMethodDefinition, string, expression, ".addBatchReadAttribute(");
            }
            if (((ReadAllQuery)object3).getContainerPolicy().isCursoredStreamPolicy()) {
                nonreflectiveMethodDefinition.addLine(string + ".useCursoredStream();");
            }
            if (((ReadAllQuery)object3).getContainerPolicy().isScrollableCursorPolicy()) {
                nonreflectiveMethodDefinition.addLine(string + ".useScrollableCursor();");
            }
            if (((ReadAllQuery)object3).getContainerPolicy().isCollectionPolicy() && !((String)((Object)(iterator = ((ReadAllQuery)object3).getContainerPolicy().getContainerClassName()))).equals("java.util.Vector")) {
                nonreflectiveMethodDefinition.addLine(string + ".useCollectionClass(" + iterator + ".class);");
            }
        }
        if (databaseQuery.isReportQuery()) {
            object3 = (ReportQuery)databaseQuery;
            object4 = this.buildBuilderString((String)object4, nonreflectiveMethodDefinition, n, string);
            iterator = ((ReportQuery)object3).getItems().elements();
            while (iterator.hasMoreElements()) {
                Object object2;
                String string3;
                ReportItem reportItem = (ReportItem)iterator.nextElement();
                object = reportItem.getAttributeExpression();
                String string4 = reportItem.getName();
                StringWriter stringWriter = new StringWriter();
                ExpressionJavaPrinter expressionJavaPrinter = new ExpressionJavaPrinter((String)object4, stringWriter, this.project.getDatasourceLogin().getPlatform());
                if (object == null) continue;
                String string5 = null;
                if (((Expression)object).isQueryKeyExpression()) {
                    string3 = ".addAttribute(\"";
                    object2 = object;
                } else if (((Expression)object).isFunctionExpression()) {
                    int n2 = ((Expression)object).getOperator().getSelector();
                    object2 = ((FunctionExpression)object).getBaseExpression();
                    if (n2 == 21) {
                        string3 = ".addAverage(\"";
                    } else if (n2 == 19) {
                        string3 = ".addCount(\"";
                    } else if (n2 == 22) {
                        string3 = ".addMaximum(\"";
                    } else if (n2 == 23) {
                        string3 = ".addMinimum(\"";
                    } else if (n2 == 24) {
                        string3 = ".addStandardDeviation(\"";
                    } else if (n2 == 20) {
                        string3 = ".addSum(\"";
                    } else if (n2 == 25) {
                        string3 = ".addVariance(\"";
                    } else {
                        string3 = ".addFunctionItem(\"";
                        string5 = ((Expression)object).getOperator().getDatabaseStrings()[0];
                        string5 = string5.substring(0, string5.length() - 1);
                    }
                } else {
                    string3 = ".addItem(\"";
                    object2 = object;
                }
                ((Expression)object2).printJava(expressionJavaPrinter);
                if (string5 == null) {
                    nonreflectiveMethodDefinition.addLine(string + string3 + string4 + "\", " + stringWriter.toString() + ");");
                    continue;
                }
                nonreflectiveMethodDefinition.addLine(string + string3 + string4 + "\", " + stringWriter.toString() + ", \"" + string5 + "\");");
            }
            iterator = ((ReportQuery)object3).getGroupByExpressions().elements();
            while (iterator.hasMoreElements()) {
                Expression expression = (Expression)iterator.nextElement();
                this.buildExpressionString((String)object4, nonreflectiveMethodDefinition, string, expression, ".addGrouping(");
            }
            if (((ReportQuery)object3).shouldRetrieveFirstPrimaryKey()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldRetrieveFirstPrimaryKey(true);");
            } else if (((ReportQuery)object3).shouldRetrievePrimaryKeys()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldRetrievePrimaryKeys(true);");
            }
            if (((ReportQuery)object3).shouldReturnSingleAttribute()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldReturnSingleAttribute(true);");
            } else if (((ReportQuery)object3).shouldReturnSingleValue()) {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldReturnSingleValue(true);");
            } else {
                nonreflectiveMethodDefinition.addLine(string + ".setShouldReturnSingleResult(true);");
            }
        }
        object3 = databaseQuery.getArgumentTypeNames().elements();
        iterator = databaseQuery.getArguments().elements();
        while (iterator.hasMoreElements()) {
            String string6 = (String)iterator.nextElement();
            object = (String)object3.nextElement();
            nonreflectiveMethodDefinition.addLine(string + ".addArgument(\"" + string6 + "\", " + (String)object + ".class);");
        }
        nonreflectiveMethodDefinition.addLine("descriptor.getQueryManager().addQuery(\"" + databaseQuery.getName() + "\", " + string + ");");
        nonreflectiveMethodDefinition.addLine("");
    }

    protected String buildBuilderString(String string, NonreflectiveMethodDefinition nonreflectiveMethodDefinition, int n, String string2) {
        if (string == null) {
            string = "expBuilder" + String.valueOf(n);
            nonreflectiveMethodDefinition.addLine("ExpressionBuilder " + string + " = " + string2 + ".getExpressionBuilder();");
        }
        return string;
    }

    protected void buildExpressionString(String string, NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string2, Expression expression, String string3) {
        StringWriter stringWriter = new StringWriter();
        ExpressionJavaPrinter expressionJavaPrinter = new ExpressionJavaPrinter(string, stringWriter, this.project.getDatasourceLogin().getPlatform());
        expression.printJava(expressionJavaPrinter);
        nonreflectiveMethodDefinition.addLine(string2 + string3 + stringWriter.toString() + ");");
    }

    protected void addReturningPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ReturningPolicy returningPolicy) {
        if (returningPolicy.getFieldInfos().isEmpty()) {
            return;
        }
        this.addReturningPolicyLines(nonreflectiveMethodDefinition, returningPolicy, "returningPolicy");
        nonreflectiveMethodDefinition.addLine("descriptor.setReturningPolicy(returningPolicy);");
    }

    protected void addReturningPolicyLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, ReturningPolicy returningPolicy, String string) {
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("// Returning Policy");
        nonreflectiveMethodDefinition.addLine("ReturningPolicy " + string + " = new ReturningPolicy();");
        String string2 = string + ".addFieldFor";
        String[] stringArray = new String[]{null, null};
        Enumeration enumeration = returningPolicy.getFieldInfos().elements();
        while (enumeration.hasMoreElements()) {
            String string3;
            ReturningPolicy.Info info = (ReturningPolicy.Info)enumeration.nextElement();
            String string4 = info.getField().getQualifiedName();
            String string5 = null;
            if (info.getField().getType() != null) {
                string5 = info.getField().getType().getName() + ".class";
            }
            if (info.isInsert()) {
                string3 = string2 + "Insert";
                if (info.isInsertModeReturnOnly()) {
                    string3 = string3 + "ReturnOnly";
                }
                stringArray[0] = string3;
            }
            if (info.isUpdate()) {
                stringArray[1] = string3 = string2 + "Update";
            }
            for (int i = 0; i < 2; ++i) {
                if (stringArray[i] == null) continue;
                stringArray[i] = stringArray[i] + "(\"" + string4 + "\"";
                if (string5 != null) {
                    stringArray[i] = stringArray[i] + ", " + string5;
                }
                stringArray[i] = stringArray[i] + ");";
                nonreflectiveMethodDefinition.addLine(stringArray[i]);
                stringArray[i] = null;
            }
        }
    }

    protected void addTransformationMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, TransformationMapping transformationMapping) {
        String string2;
        Serializable serializable2;
        if (!transformationMapping.isWriteOnly()) {
            if (transformationMapping.getAttributeMethodName() != null) {
                nonreflectiveMethodDefinition.addLine(string + ".setAttributeTransformation(\"" + transformationMapping.getAttributeMethodName() + "\");");
            } else {
                nonreflectiveMethodDefinition.addLine(string + ".setAttributeTransformer(new " + transformationMapping.getAttributeTransformerClassName() + "());");
            }
        }
        for (Serializable serializable2 : transformationMapping.getFieldTransformations()) {
            String string3;
            string2 = ((FieldTransformation)serializable2).getFieldName();
            if (serializable2 instanceof MethodBasedFieldTransformation) {
                string3 = ((MethodBasedFieldTransformation)serializable2).getMethodName();
                nonreflectiveMethodDefinition.addLine(string + ".addFieldTransformation(\"" + string2 + "\", \"" + string3 + "\");");
                continue;
            }
            string3 = ((TransformerBasedFieldTransformation)serializable2).getTransformerClassName();
            nonreflectiveMethodDefinition.addLine(string + ".addFieldTransformer(\"" + string2 + "\", new " + string3 + "());");
        }
        serializable2 = transformationMapping.getIndirectionPolicy();
        if (serializable2 instanceof ContainerIndirectionPolicy) {
            string2 = ((ContainerIndirectionPolicy)serializable2).getContainerClassName();
            nonreflectiveMethodDefinition.addLine(string + ".useContainerIndirection(" + string2 + ".class);");
        } else if (serializable2 instanceof BasicIndirectionPolicy) {
            nonreflectiveMethodDefinition.addLine(string + ".useBasicIndirection();");
        }
        nonreflectiveMethodDefinition.addLine(string + ".setIsMutable(" + transformationMapping.isMutable() + ");");
    }

    protected void addConverterLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, Converter converter) {
        if (converter instanceof ObjectTypeConverter) {
            nonreflectiveMethodDefinition.addLine("ObjectTypeConverter " + string + " = new ObjectTypeConverter();");
            this.addObjectTypeConverterLines(nonreflectiveMethodDefinition, string, (ObjectTypeConverter)converter);
        } else if (converter instanceof TypeConversionConverter) {
            nonreflectiveMethodDefinition.addLine("TypeConversionConverter " + string + " = new TypeConversionConverter();");
            this.addTypeConversionConverterLines(nonreflectiveMethodDefinition, string, (TypeConversionConverter)converter);
        } else if (converter instanceof SerializedObjectConverter) {
            nonreflectiveMethodDefinition.addLine("SerializedObjectConverter " + string + " = new SerializedObjectConverter();");
        } else {
            nonreflectiveMethodDefinition.addLine(converter.getClass().getName() + " " + string + " = new " + converter.getClass().getName() + "();");
        }
    }

    protected void addTypeConversionConverterLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, TypeConversionConverter typeConversionConverter) {
        String string2;
        if (typeConversionConverter.getObjectClassName() != null) {
            string2 = Helper.getComponentTypeNameFromArrayString(typeConversionConverter.getObjectClassName());
            if (string2 != null) {
                nonreflectiveMethodDefinition.addLine(string + ".setObjectClass(" + string2 + "[].class);");
            } else {
                nonreflectiveMethodDefinition.addLine(string + ".setObjectClass(" + typeConversionConverter.getObjectClassName() + ".class);");
            }
        }
        if (typeConversionConverter.getDataClassName() != null) {
            string2 = Helper.getComponentTypeNameFromArrayString(typeConversionConverter.getDataClassName());
            if (string2 != null) {
                nonreflectiveMethodDefinition.addLine(string + ".setDataClass(" + string2 + "[].class);");
            } else {
                nonreflectiveMethodDefinition.addLine(string + ".setDataClass(" + typeConversionConverter.getDataClassName() + ".class);");
            }
        }
    }

    protected void addVariableOneToOneMappingLines(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, String string, VariableOneToOneMapping variableOneToOneMapping) {
        String string2;
        for (Object object : variableOneToOneMapping.getSourceToTargetQueryKeyNames().keySet()) {
            string2 = (String)variableOneToOneMapping.getSourceToTargetQueryKeyNames().get(object);
            if (variableOneToOneMapping.getForeignKeyFields().contains(object)) {
                nonreflectiveMethodDefinition.addLine(string + ".addForeignQueryKeyName(\"" + ((DatabaseField)object).getQualifiedName() + "\", \"" + string2 + "\");");
                continue;
            }
            nonreflectiveMethodDefinition.addLine(string + ".addTargetForeignQueryKeyName(\"" + string2 + "\", \"" + ((DatabaseField)object).getQualifiedName() + "\");");
        }
        if (variableOneToOneMapping.getTypeField() != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setTypeFieldName(\"" + variableOneToOneMapping.getTypeFieldName() + "\");");
            for (Object object : variableOneToOneMapping.getTypeIndicatorNameTranslation().keySet()) {
                string2 = variableOneToOneMapping.getTypeIndicatorNameTranslation().get(object);
                nonreflectiveMethodDefinition.addLine(string + ".addClassIndicator(" + (String)object + ".class, " + this.printString(string2) + ");");
            }
        }
    }

    protected NonreflectiveMethodDefinition buildConstructor() {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName(this.getClassName());
        nonreflectiveMethodDefinition.setIsConstructor(true);
        nonreflectiveMethodDefinition.addLine("setName(\"" + this.getProject().getName() + "\");");
        nonreflectiveMethodDefinition.addLine("applyLogin();");
        if (!this.getProject().getDefaultReadOnlyClasses().isEmpty()) {
            nonreflectiveMethodDefinition.addLine("setDefaultReadOnlyClasses(buildDefaultReadOnlyClasses());");
        }
        nonreflectiveMethodDefinition.addLine("");
        Vector vector = this.buildSortedVectorOfDescriptors(this.getProject().getOrderedDescriptors());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            if (classDescriptor.isDescriptorForInterface() && classDescriptor.getInterfacePolicy().getImplementorDescriptor() != null) continue;
            nonreflectiveMethodDefinition.addLine("addDescriptor(build" + this.getDescriptorMethodNames().get(classDescriptor) + "ClassDescriptor());");
        }
        return nonreflectiveMethodDefinition;
    }

    protected NonreflectiveMethodDefinition buildDescriptorMethod(ClassDescriptor classDescriptor) {
        Object object;
        if (classDescriptor.isFullyInitialized()) {
            throw ValidationException.descriptorMustBeNotInitialized(classDescriptor);
        }
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName("build" + this.getDescriptorMethodNames().get(classDescriptor) + "ClassDescriptor");
        nonreflectiveMethodDefinition.setReturnType("ClassDescriptor");
        String string = "RelationalDescriptor";
        if (classDescriptor.getClass() != ClassDescriptor.class && classDescriptor.getClass() != RelationalDescriptor.class) {
            string = classDescriptor.getClass().getName();
        }
        nonreflectiveMethodDefinition.addLine(string + " descriptor = new " + string + "();");
        if (classDescriptor.isDescriptorForInterface()) {
            nonreflectiveMethodDefinition.addLine("descriptor.descriptorIsForInterface();");
        } else if (classDescriptor.isAggregateDescriptor()) {
            nonreflectiveMethodDefinition.addLine("descriptor.descriptorIsAggregate();");
        } else if (classDescriptor.isAggregateCollectionDescriptor()) {
            nonreflectiveMethodDefinition.addLine("descriptor.descriptorIsAggregateCollection();");
        }
        nonreflectiveMethodDefinition.addLine("descriptor.setJavaClass(" + classDescriptor.getJavaClassName() + ".class);");
        if (!classDescriptor.isAggregateDescriptor() && !classDescriptor.isDescriptorForInterface()) {
            object = classDescriptor.getTables().elements();
            while (object.hasMoreElements()) {
                String object2 = object.nextElement().getQualifiedName();
                nonreflectiveMethodDefinition.addLine("descriptor.addTableName(\"" + object2 + "\");");
            }
            if (!classDescriptor.isChildDescriptor()) {
                object = classDescriptor.getPrimaryKeyFieldNames().elements();
                while (object.hasMoreElements()) {
                    nonreflectiveMethodDefinition.addLine("descriptor.addPrimaryKeyFieldName(\"" + object.nextElement() + "\");");
                }
            }
            for (Map map : classDescriptor.getAdditionalTablePrimaryKeyFields().values()) {
                Iterator iterator = map.keySet().iterator();
                Iterator iterator2 = map.values().iterator();
                while (iterator.hasNext()) {
                    DatabaseField databaseField = (DatabaseField)iterator.next();
                    DatabaseField databaseField2 = (DatabaseField)iterator2.next();
                    if (!classDescriptor.getMultipleTableForeignKeys().containsKey(databaseField.getTable())) continue;
                    nonreflectiveMethodDefinition.addLine("descriptor.addForeignKeyFieldNameForMultipleTable(\"" + databaseField2.getQualifiedName() + "\", \"" + databaseField.getQualifiedName() + "\");");
                }
            }
        }
        if (classDescriptor.hasInheritance()) {
            nonreflectiveMethodDefinition.addLine("");
            this.addInheritanceLines(nonreflectiveMethodDefinition, classDescriptor.getInheritancePolicy());
        }
        if (classDescriptor.hasInterfacePolicy()) {
            nonreflectiveMethodDefinition.addLine("");
            this.addInterfaceLines(nonreflectiveMethodDefinition, classDescriptor.getInterfacePolicy());
        }
        nonreflectiveMethodDefinition.addLine("");
        this.addDescriptorPropertyLines(nonreflectiveMethodDefinition, classDescriptor);
        nonreflectiveMethodDefinition.addLine("");
        this.addCacheInvalidationPolicyLines(nonreflectiveMethodDefinition, classDescriptor);
        this.addHistoryPolicyLines(nonreflectiveMethodDefinition, classDescriptor);
        nonreflectiveMethodDefinition.addLine("");
        this.addQueryManagerPropertyLines(nonreflectiveMethodDefinition, classDescriptor);
        nonreflectiveMethodDefinition.addLine("");
        this.addFetchGroupManagerLine(nonreflectiveMethodDefinition, classDescriptor);
        nonreflectiveMethodDefinition.addLine("");
        this.addEventManagerPropertyLines(nonreflectiveMethodDefinition, classDescriptor);
        if (!classDescriptor.getQueryKeys().isEmpty()) {
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine("// Query keys.");
            object = classDescriptor.getQueryKeys().values().iterator();
            while (object.hasNext()) {
                this.addQueryKeyLines(nonreflectiveMethodDefinition, (QueryKey)object.next());
            }
        }
        if (!classDescriptor.getMappings().isEmpty()) {
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine("// Mappings.");
            object = this.sortMappings(classDescriptor.getMappings()).elements();
            while (object.hasMoreElements()) {
                this.addMappingLines(nonreflectiveMethodDefinition, (DatabaseMapping)object.nextElement());
                nonreflectiveMethodDefinition.addLine("");
            }
        } else {
            nonreflectiveMethodDefinition.addLine("");
        }
        if (classDescriptor.getAmendmentClassName() != null && classDescriptor.getAmendmentMethodName() != null) {
            nonreflectiveMethodDefinition.addLine("descriptor.applyAmendmentMethod();");
        }
        nonreflectiveMethodDefinition.addLine("return descriptor;");
        return nonreflectiveMethodDefinition;
    }

    private Vector buildSortedVectorOfDescriptors(Vector vector) {
        int n;
        Vector<Object> vector2 = Helper.addAllUniqueToVector(new Vector(vector.size()), vector);
        Object[] objectArray = new Object[vector2.size()];
        for (n = 0; n < vector2.size(); ++n) {
            objectArray[n] = vector2.elementAt(n);
        }
        Arrays.sort(objectArray, new DescriptorCompare());
        vector2 = new Vector<Object>(vector2.size());
        for (n = 0; n < objectArray.length; ++n) {
            vector2.addElement(objectArray[n]);
        }
        return vector2;
    }

    protected NonreflectiveMethodDefinition buildLoginMethod(Login login) {
        Map map;
        DatasourceLogin datasourceLogin;
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName("applyLogin");
        String string = login.getClass().getName();
        if (login.getClass().equals(DatabaseLogin.class)) {
            string = Helper.getShortClassName(login);
        }
        nonreflectiveMethodDefinition.addLine(string + " login = new " + string + "();");
        if (login instanceof DatabaseLogin) {
            datasourceLogin = (DatabaseLogin)login;
            nonreflectiveMethodDefinition.addLine("login.usePlatform(new " + datasourceLogin.getPlatformClassName() + "());");
            nonreflectiveMethodDefinition.addLine("login.setDriverClassName(\"" + ((DatabaseLogin)datasourceLogin).getDriverClassName() + "\");");
            nonreflectiveMethodDefinition.addLine("login.setConnectionString(\"" + ((DatabaseLogin)datasourceLogin).getConnectionString() + "\");");
            if (datasourceLogin.getUserName() != null) {
                nonreflectiveMethodDefinition.addLine("login.setUserName(\"" + datasourceLogin.getUserName() + "\");");
            }
            if (datasourceLogin.getPassword() != null) {
                nonreflectiveMethodDefinition.addLine("login.setEncryptedPassword(\"" + datasourceLogin.getPassword() + "\");");
            }
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine("// Configuration Properties.");
            if (!((DatabaseLogin)datasourceLogin).shouldBindAllParameters()) {
                nonreflectiveMethodDefinition.addLine("login.setShouldBindAllParameters(" + ((DatabaseLogin)datasourceLogin).shouldBindAllParameters() + ");");
            }
            if (((DatabaseLogin)datasourceLogin).shouldCacheAllStatements()) {
                nonreflectiveMethodDefinition.addLine("login.setShouldCacheAllStatements(" + ((DatabaseLogin)datasourceLogin).shouldCacheAllStatements() + ");");
            }
            if (!((DatabaseLogin)datasourceLogin).shouldUseByteArrayBinding()) {
                nonreflectiveMethodDefinition.addLine("login.setUsesByteArrayBinding(" + ((DatabaseLogin)datasourceLogin).shouldUseByteArrayBinding() + ");");
            }
            if (((DatabaseLogin)datasourceLogin).shouldUseStringBinding()) {
                nonreflectiveMethodDefinition.addLine("login.setUsesStringBinding(" + ((DatabaseLogin)datasourceLogin).shouldUseStringBinding() + ");");
            }
            if (((DatabaseLogin)datasourceLogin).shouldUseStreamsForBinding()) {
                nonreflectiveMethodDefinition.addLine("\tlogin.setUsesStreamsForBinding(" + ((DatabaseLogin)datasourceLogin).shouldUseStreamsForBinding() + ");");
            }
            if (((DatabaseLogin)datasourceLogin).shouldForceFieldNamesToUpperCase()) {
                nonreflectiveMethodDefinition.addLine("login.setShouldForceFieldNamesToUpperCase(" + ((DatabaseLogin)datasourceLogin).shouldForceFieldNamesToUpperCase() + ");");
            }
            if (!((DatabaseLogin)datasourceLogin).shouldOptimizeDataConversion()) {
                nonreflectiveMethodDefinition.addLine("login.setShouldOptimizeDataConversion(" + ((DatabaseLogin)datasourceLogin).shouldOptimizeDataConversion() + ");");
            }
            if (!((DatabaseLogin)datasourceLogin).shouldTrimStrings()) {
                nonreflectiveMethodDefinition.addLine("login.setShouldTrimStrings(" + ((DatabaseLogin)datasourceLogin).shouldTrimStrings() + ");");
            }
            if (((DatabaseLogin)datasourceLogin).shouldUseBatchWriting()) {
                nonreflectiveMethodDefinition.addLine("login.setUsesBatchWriting(" + ((DatabaseLogin)datasourceLogin).shouldUseBatchWriting() + ");");
            }
            if (!((DatabaseLogin)datasourceLogin).shouldUseJDBCBatchWriting()) {
                nonreflectiveMethodDefinition.addLine("\tlogin.setUsesJDBCBatchWriting(" + ((DatabaseLogin)datasourceLogin).shouldUseJDBCBatchWriting() + ");");
            }
            if (datasourceLogin.shouldUseExternalConnectionPooling()) {
                nonreflectiveMethodDefinition.addLine("login.setUsesExternalConnectionPooling(" + datasourceLogin.shouldUseExternalConnectionPooling() + ");");
            }
            if (datasourceLogin.shouldUseExternalTransactionController()) {
                nonreflectiveMethodDefinition.addLine("login.setUsesExternalTransactionController(" + datasourceLogin.shouldUseExternalTransactionController() + ");");
            }
        } else if (login instanceof EISLogin) {
            datasourceLogin = (EISLogin)login;
            nonreflectiveMethodDefinition.addLine("login.setConnectionSpec(new " + ((EISLogin)datasourceLogin).getConnectionSpec().getClass().getName() + "());");
            if (((EISLogin)datasourceLogin).getConnectionFactoryURL() != null) {
                nonreflectiveMethodDefinition.addLine("login.setConnectionFactoryURL(\"" + ((EISLogin)datasourceLogin).getConnectionFactoryURL() + "\");");
            }
        }
        boolean bl = false;
        Sequence sequence = ((DatasourceLogin)login).getDefaultSequenceToWrite();
        if (sequence != null) {
            nonreflectiveMethodDefinition.addLine("");
            nonreflectiveMethodDefinition.addLine("// Sequencing.");
            bl = true;
            nonreflectiveMethodDefinition.addLine(this.setDefaultOrAddSequenceString(sequence, true));
        }
        if ((map = ((DatasourceLogin)login).getSequencesToWrite()) != null && !map.isEmpty()) {
            if (!bl) {
                nonreflectiveMethodDefinition.addLine("");
                nonreflectiveMethodDefinition.addLine("// Sequencing.");
                bl = true;
            }
            for (Sequence sequence2 : map.values()) {
                nonreflectiveMethodDefinition.addLine(this.setDefaultOrAddSequenceString(sequence2, false));
            }
        }
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("setDatasourceLogin(login);");
        return nonreflectiveMethodDefinition;
    }

    protected String setDefaultOrAddSequenceString(Sequence sequence, boolean bl) {
        String string;
        String string2 = bl ? "login.setDefaultSequence(new " : "login.addSequence(new ";
        if (sequence instanceof TableSequence) {
            TableSequence tableSequence = (TableSequence)sequence;
            string = "TableSequence(\"" + tableSequence.getName() + "\", " + tableSequence.getPreallocationSize() + ", \"" + tableSequence.getTableName() + "\", \"" + tableSequence.getNameFieldName() + "\", \"" + tableSequence.getCounterFieldName() + "\"));";
        } else if (sequence instanceof UnaryTableSequence) {
            UnaryTableSequence unaryTableSequence = (UnaryTableSequence)sequence;
            string = "UnaryTableSequence(\"" + unaryTableSequence.getName() + "\", " + unaryTableSequence.getPreallocationSize() + ", \"" + unaryTableSequence.getCounterFieldName() + "\"));";
        } else {
            String string3 = Helper.getShortClassName(sequence);
            string = string3 + "(\"" + sequence.getName() + "\", " + sequence.getPreallocationSize() + "));";
        }
        return string2 + string;
    }

    protected void computeDescriptorMethodNames() {
        Hashtable<String, ClassDescriptor> hashtable = new Hashtable<String, ClassDescriptor>();
        for (ClassDescriptor classDescriptor : this.project.getOrderedDescriptors()) {
            if (classDescriptor.isDescriptorForInterface() && classDescriptor.getInterfacePolicy().getImplementorDescriptor() != null) continue;
            String string = Helper.getShortClassName(classDescriptor.getJavaClassName());
            if (hashtable.containsKey(string)) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)hashtable.get(string);
                this.getDescriptorMethodNames().put(classDescriptor2, this.removeDots(classDescriptor2.getJavaClassName()));
                this.getDescriptorMethodNames().put(classDescriptor, this.removeDots(classDescriptor.getJavaClassName()));
                continue;
            }
            hashtable.put(string, classDescriptor);
            this.getDescriptorMethodNames().put(classDescriptor, string);
        }
    }

    public void generate(boolean bl) throws ValidationException {
        if (this.getOutputWriter() == null) {
            try {
                this.setOutputWriter(new OutputStreamWriter(new FileOutputStream(this.getOutputPath() + this.getOutputFileName())));
            }
            catch (IOException iOException) {
                throw ValidationException.fileError(iOException);
            }
        }
        CodeGenerator codeGenerator = new CodeGenerator(bl);
        codeGenerator.setOutput(this.getOutputWriter());
        this.generateProjectClass().write(codeGenerator);
        try {
            this.getOutputWriter().flush();
            this.getOutputWriter().close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void generate() throws ValidationException {
        this.generate(true);
    }

    protected ClassDefinition generateProjectClass() {
        this.computeDescriptorMethodNames();
        ClassDefinition classDefinition = new ClassDefinition();
        classDefinition.setName(this.getClassName());
        classDefinition.setSuperClass("org.eclipse.persistence.sessions.Project");
        classDefinition.setPackageName(this.getPackageName());
        classDefinition.addImport("org.eclipse.persistence.sessions.*");
        classDefinition.addImport("org.eclipse.persistence.descriptors.*");
        classDefinition.addImport("org.eclipse.persistence.descriptors.invalidation.*");
        classDefinition.addImport("org.eclipse.persistence.mappings.*");
        classDefinition.addImport("org.eclipse.persistence.mappings.converters.*");
        classDefinition.addImport("org.eclipse.persistence.queries.*");
        classDefinition.addImport("org.eclipse.persistence.expressions.ExpressionBuilder");
        classDefinition.addImport("org.eclipse.persistence.history.HistoryPolicy");
        classDefinition.addImport("org.eclipse.persistence.sequencing.*");
        classDefinition.setComment("This class was generated by the TopLink project class generator." + Helper.cr() + "It stores the meta-data (descriptors) that define the TopLink mappings." + Helper.cr() + "## " + DatabaseLogin.getVersion() + " ##" + Helper.cr() + "@see org.eclipse.persistence.sessions.factories.ProjectClassGenerator");
        classDefinition.addMethod(this.buildConstructor());
        if (this.getProject().getDatasourceLogin() != null) {
            classDefinition.addMethod(this.buildLoginMethod(this.getProject().getDatasourceLogin()));
        }
        for (ClassDescriptor classDescriptor : this.buildSortedVectorOfDescriptors(this.getProject().getOrderedDescriptors())) {
            if (classDescriptor.isDescriptorForInterface() && classDescriptor.getInterfacePolicy().getImplementorDescriptor() != null) continue;
            classDefinition.addMethod(this.buildDescriptorMethod(classDescriptor));
        }
        return classDefinition;
    }

    public String getClassName() {
        return this.className;
    }

    protected Hashtable getDescriptorMethodNames() {
        return this.descriptorMethodNames;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public Writer getOutputWriter() {
        return this.outputWriter;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Project getProject() {
        return this.project;
    }

    protected String printString(Object object) {
        if (object == null || object == Helper.getNullWrapper()) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        if (object instanceof Character) {
            return "new Character('" + object + "')";
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return "new " + object.getClass().getName() + "(" + date.getTime() + "L)";
        }
        return "new " + object.getClass().getName() + "(" + object + ")";
    }

    protected String removeDots(String string) {
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        int n2 = string.indexOf(46, n);
        while (n2 >= 0) {
            stringWriter.write(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        stringWriter.write(string.substring(n, string.length()));
        return stringWriter.toString();
    }

    public void setClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            this.className = string.substring(n + 1, string.length());
            this.setPackageName(string.substring(0, n));
        } else {
            this.className = string;
        }
        this.setOutputFileName(string);
    }

    protected void setDescriptorMethodNames(Hashtable hashtable) {
        this.descriptorMethodNames = hashtable;
    }

    public void setOutputFileName(String string) {
        this.outputFileName = string.indexOf(".java") < 0 ? string + ".java" : string;
    }

    public void setOutputPath(String string) {
        this.outputPath = string;
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    protected Vector sortMappings(Vector vector) {
        DatabaseMapping databaseMapping;
        Vector<DatabaseMapping> vector2 = new Vector<DatabaseMapping>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.getClass().equals(DirectToFieldMapping.class)) continue;
            vector2.addElement(databaseMapping);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isTransformationMapping()) continue;
            vector2.addElement(databaseMapping);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isAggregateMapping()) continue;
            vector2.addElement(databaseMapping);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isDirectCollectionMapping()) continue;
            vector2.addElement(databaseMapping);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isObjectReferenceMapping()) continue;
            vector2.addElement(databaseMapping);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isOneToManyMapping()) continue;
            vector2.addElement(databaseMapping);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isManyToManyMapping()) continue;
            vector2.addElement(databaseMapping);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (vector2.contains(databaseMapping)) continue;
            vector2.addElement(databaseMapping);
        }
        return vector2;
    }

    public static void write(Project project, String string, Writer writer) {
        ProjectClassGenerator projectClassGenerator = new ProjectClassGenerator(project, string, writer);
        projectClassGenerator.generate();
    }

    public static void write(Project project, String string, String string2) {
        ProjectClassGenerator projectClassGenerator = new ProjectClassGenerator(project, string, string2);
        projectClassGenerator.generate();
    }
}

