/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.sessions.server.Server;

public class SessionFactory {
    private String sessionXMLPath;
    private String sessionName;

    public SessionFactory(String string, String string2) {
        this.sessionXMLPath = string;
        this.sessionName = string2;
    }

    public SessionFactory(String string) {
        this.sessionName = string;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getSessionXMLPath() {
        return this.sessionXMLPath;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public DatabaseSession getSharedSession() {
        return this.getSharedSession(true, false);
    }

    public DatabaseSession getSharedSession(boolean bl, boolean bl2) {
        XMLSessionConfigLoader xMLSessionConfigLoader = this.getSessionXMLPath() != null ? new XMLSessionConfigLoader(this.getSessionXMLPath()) : new XMLSessionConfigLoader();
        return (DatabaseSession)((Object)SessionManager.getManager().getSession(xMLSessionConfigLoader, this.getSessionName(), this.getClassLoader(), bl, bl2, true));
    }

    public Session acquireSession() {
        Session session;
        DatabaseSession databaseSession = this.getSharedSession();
        if (databaseSession.hasExternalTransactionController() && (session = databaseSession.getActiveUnitOfWork()) != null) {
            return session.getParent();
        }
        if (databaseSession.isServerSession()) {
            return ((Server)databaseSession).acquireClientSession();
        }
        if (databaseSession.isSessionBroker()) {
            session = (SessionBroker)databaseSession;
            if (((SessionBroker)session).isServerSessionBroker()) {
                return ((SessionBroker)session).acquireClientSessionBroker();
            }
            return session;
        }
        return databaseSession;
    }

    public UnitOfWork acquireUnitOfWork() {
        return this.acquireUnitOfWork(this.getSharedSession());
    }

    public UnitOfWork acquireUnitOfWork(Session session) {
        if (session.hasExternalTransactionController()) {
            return session.getActiveUnitOfWork();
        }
        return session.acquireUnitOfWork();
    }

    public Object detach(Object object) {
        UnitOfWorkImpl unitOfWorkImpl = ((AbstractSession)((Object)this.getSharedSession())).acquireNonSynchronizedUnitOfWork(null);
        Object object2 = unitOfWorkImpl.registerObject(object);
        unitOfWorkImpl.release();
        return object2;
    }

    public Collection detach(Collection collection) {
        UnitOfWorkImpl unitOfWorkImpl = ((AbstractSession)((Object)this.getSharedSession())).acquireNonSynchronizedUnitOfWork(null);
        Vector vector = unitOfWorkImpl.registerAllObjects(collection);
        unitOfWorkImpl.release();
        return vector;
    }
}

