/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.sessions.Login;

public class ConnectionPolicy
implements Cloneable,
Serializable {
    protected Login login;
    protected String poolName;
    protected boolean isLazy;
    protected ExclusiveMode exclusiveMode;
    protected Map properties;

    public ConnectionPolicy() {
        this.isLazy = true;
        this.exclusiveMode = ExclusiveMode.Transactional;
    }

    public ConnectionPolicy(String string) {
        this.isLazy = true;
        this.poolName = string;
        this.exclusiveMode = ExclusiveMode.Transactional;
    }

    public ConnectionPolicy(Login login) {
        this.isLazy = false;
        this.login = login;
        this.exclusiveMode = ExclusiveMode.Transactional;
    }

    public Object clone() {
        try {
            ConnectionPolicy connectionPolicy = (ConnectionPolicy)super.clone();
            if (connectionPolicy.hasLogin()) {
                connectionPolicy.setLogin((Login)connectionPolicy.getLogin().clone());
            }
            return connectionPolicy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dontUseLazyConnection() {
        this.setIsLazy(false);
    }

    public Login getLogin() {
        return this.login;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public Object getProperty(Object object) {
        if (this.hasProperties()) {
            return this.getProperties().get(object);
        }
        return null;
    }

    public boolean hasLogin() {
        return this.login != null;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public boolean isExclusiveIsolated() {
        return this.exclusiveMode == ExclusiveMode.Isolated;
    }

    public boolean isExclusiveAlways() {
        return this.exclusiveMode == ExclusiveMode.Always;
    }

    public boolean isExclusive() {
        return this.isExclusiveIsolated() || this.isExclusiveAlways();
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isPooled() {
        return this.poolName != null;
    }

    public boolean isUserDefinedConnection() {
        return this.poolName == null;
    }

    public Object removeProperty(Object object) {
        if (this.hasProperties()) {
            return this.getProperties().remove(object);
        }
        return null;
    }

    public void setIsLazy(boolean bl) {
        this.isLazy = bl;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setPoolName(String string) {
        this.poolName = string;
    }

    public void setProperty(Object object, Object object2) {
        this.getProperties().put(object, object2);
    }

    public ExclusiveMode getExclusiveMode() {
        return this.exclusiveMode;
    }

    public void setExclusiveMode(ExclusiveMode exclusiveMode) {
        this.exclusiveMode = exclusiveMode == null ? ExclusiveMode.Transactional : exclusiveMode;
    }

    public void setShouldUseExclusiveConnection(boolean bl) {
        this.exclusiveMode = bl ? ExclusiveMode.Isolated : ExclusiveMode.Transactional;
    }

    public boolean shouldUseExclusiveConnection() {
        return this.isExclusiveIsolated();
    }

    public String toString() {
        String string = "";
        string = this.isPooled() ? "(" + ToStringLocalization.buildMessage("pooled", null) + ": " + this.getPoolName() : "(" + ToStringLocalization.buildMessage("login", null) + ": " + this.getLogin();
        string = this.isLazy() ? string + "," + ToStringLocalization.buildMessage("lazy", null) + ")" : string + "," + ToStringLocalization.buildMessage("non-lazy", null) + ")";
        return Helper.getShortClassName(this.getClass()) + string;
    }

    public void useLazyConnection() {
        this.setIsLazy(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExclusiveMode {
        Transactional,
        Isolated,
        Always;

    }
}

