/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ssl.UnifiedX509KeyManager;
import com.sun.logging.LogDomains;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jvnet.hk2.component.Habitat;

public final class J2EEKeyManager
implements X509KeyManager {
    private static Logger _logger = null;
    private X509KeyManager mgr = null;
    private String alias = null;
    private Map tokenName2MgrMap = null;
    private boolean supportTokenAlias = false;
    private final Habitat habitat;
    private static final String CLIENT_JAAS_PASSWORD = "default";

    public J2EEKeyManager(Habitat habitat, X509KeyManager mgr, String alias) {
        this.habitat = habitat;
        this.mgr = mgr;
        this.alias = alias;
        if (mgr instanceof UnifiedX509KeyManager) {
            UnifiedX509KeyManager umgr = (UnifiedX509KeyManager)mgr;
            X509KeyManager[] mgrs = umgr.getX509KeyManagers();
            String[] tokenNames = umgr.getTokenNames();
            this.tokenName2MgrMap = new HashMap();
            for (int i = 0; i < mgrs.length; ++i) {
                if (tokenNames[i] == null) continue;
                this.tokenName2MgrMap.put(tokenNames[i], mgrs[i]);
            }
            this.supportTokenAlias = this.tokenName2MgrMap.size() > 0;
        }
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        if (this.alias == null) {
            if (Util.getInstance().isNotServerORACC()) {
                alias = this.mgr.chooseClientAlias(keyType, issuers, socket);
            } else if (Util.getInstance().isACC()) {
                ClientSecurityContext ctx = ClientSecurityContext.getCurrent();
                Subject s = ctx.getSubject();
                if (s == null) {
                    J2EEKeyManager.doClientLogin(2, Util.getInstance().getCallbackHandler());
                    s = ctx.getSubject();
                }
                for (Object o : s.getPrivateCredentials()) {
                    if (!(o instanceof X509CertificateCredential)) continue;
                    X509CertificateCredential crt = (X509CertificateCredential)o;
                    alias = crt.getAlias();
                    break;
                }
            }
        } else {
            alias = this.alias;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Choose client Alias :" + alias);
        }
        return alias;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String alias = null;
        alias = this.alias != null ? this.alias : this.mgr.chooseServerAlias(keyType, issuers, socket);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Choosing server alias :" + alias);
        }
        return alias;
    }

    public X509Certificate[] getCertificateChain(String alias) {
        X509KeyManager keyMgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting certificate chain");
        }
        if ((keyMgr = this.getManagerFromToken(alias)) != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getCertificateChain(aliasName);
        }
        return this.mgr.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting client aliases");
        }
        return this.mgr.getClientAliases(keyType, issuers);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting server aliases");
        }
        return this.mgr.getServerAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        X509KeyManager keyMgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Getting private key for alias:" + alias);
        }
        if ((keyMgr = this.getManagerFromToken(alias)) != null) {
            String aliasName = alias.substring(alias.indexOf(58) + 1);
            return keyMgr.getPrivateKey(aliasName);
        }
        return this.mgr.getPrivateKey(alias);
    }

    private X509KeyManager getManagerFromToken(String tokenAlias) {
        X509KeyManager keyMgr = null;
        int ind = -1;
        if (this.supportTokenAlias && tokenAlias != null && (ind = tokenAlias.indexOf(58)) != -1) {
            String tokenName = this.alias.substring(0, ind);
            keyMgr = (X509KeyManager)this.tokenName2MgrMap.get(tokenName);
        }
        return keyMgr;
    }

    public static Subject doClientLogin(int type, CallbackHandler jaasHandler) throws com.sun.enterprise.security.auth.login.common.LoginException {
        final CallbackHandler handler = jaasHandler;
        final Subject subject = new Subject();
        if (type == 1) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext(J2EEKeyManager.CLIENT_JAAS_PASSWORD, subject, handler);
                        lg.login();
                    }
                    catch (LoginException e) {
                        throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
            return subject;
        }
        if (type == 2) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lg = new LoginContext("certificate", subject, handler);
                        lg.login();
                    }
                    catch (LoginException e) {
                        throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            J2EEKeyManager.postClientAuth(subject, X509CertificateCredential.class);
            return subject;
        }
        if (type == 3) {
            AppservAccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        LoginContext lgup = new LoginContext(J2EEKeyManager.CLIENT_JAAS_PASSWORD, subject, handler);
                        LoginContext lgc = new LoginContext("certificate", subject, handler);
                        lgup.login();
                        J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
                        lgc.login();
                        J2EEKeyManager.postClientAuth(subject, X509CertificateCredential.class);
                    }
                    catch (LoginException e) {
                        throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                    }
                    return null;
                }
            });
            return subject;
        }
        AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    LoginContext lg = new LoginContext(J2EEKeyManager.CLIENT_JAAS_PASSWORD, subject, handler);
                    lg.login();
                    J2EEKeyManager.postClientAuth(subject, PasswordCredential.class);
                }
                catch (LoginException e) {
                    throw (com.sun.enterprise.security.auth.login.common.LoginException)new com.sun.enterprise.security.auth.login.common.LoginException(e.toString()).initCause(e);
                }
                return null;
            }
        });
        return subject;
    }

    private static void postClientAuth(Subject subject, Class clazz) {
        final Class clas = clazz;
        final Subject fs = subject;
        Set credset = (Set)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "LCD post login subject :" + fs);
                }
                return fs.getPrivateCredentials(clas);
            }
        });
        final Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            Object obj = null;
            try {
                obj = AppservAccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iter.next();
                    }
                });
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.accesscontroller_action_exception", e);
            }
            if (obj instanceof PasswordCredential) {
                PasswordCredential p = (PasswordCredential)obj;
                String user = p.getUser();
                if (_logger.isLoggable(Level.FINEST)) {
                    String realm = p.getRealm();
                    _logger.log(Level.FINEST, "In LCD user-pass login:" + user + " realm :" + realm);
                }
                J2EEKeyManager.setClientSecurityContext(user, fs);
                return;
            }
            if (!(obj instanceof X509CertificateCredential)) continue;
            X509CertificateCredential p = (X509CertificateCredential)obj;
            String user = p.getAlias();
            if (_logger.isLoggable(Level.FINEST)) {
                String realm = p.getRealm();
                _logger.log(Level.FINEST, "In LCD cert-login::" + user + " realm :" + realm);
            }
            J2EEKeyManager.setClientSecurityContext(user, fs);
            return;
        }
    }

    private static void setClientSecurityContext(String username, Subject subject) {
        ClientSecurityContext securityContext = new ClientSecurityContext(username, subject);
        ClientSecurityContext.setCurrent(securityContext);
    }

    static {
        _logger = LogDomains.getLogger(J2EEKeyManager.class, (String)"javax.enterprise.system.core.security");
    }
}

