/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.AttributesEx;
import org.xml.sax.Attributes;

final class AttributesExImpl
implements AttributesEx {
    private static final int MAX_ATTRS = 10000;
    int length;
    String[] data;
    private String idAttributeName;
    private static final String SPECIFIED_TRUE = "";

    public AttributesExImpl() {
        this.length = 0;
        this.data = null;
    }

    public AttributesExImpl(Attributes atts) {
        this.setAttributes(atts);
    }

    public int getLength() {
        return this.length;
    }

    public String getURI(int index) {
        if (index >= 0 && index < this.length) {
            return this.data[index * 7];
        }
        return null;
    }

    public String getLocalName(int index) {
        if (index >= 0 && index < this.length) {
            return this.data[index * 7 + 1];
        }
        return null;
    }

    public String getQName(int index) {
        if (index >= 0 && index < this.length) {
            return this.data[index * 7 + 2];
        }
        return null;
    }

    public String getType(int index) {
        if (index >= 0 && index < this.length) {
            return this.data[index * 7 + 3];
        }
        return null;
    }

    public String getValue(int index) {
        if (index >= 0 && index < this.length) {
            return this.data[index * 7 + 4];
        }
        return null;
    }

    public String getDefault(int index) {
        if (index >= 0 && index < this.length) {
            return this.data[index * 7 + 5];
        }
        return null;
    }

    public boolean isSpecified(int index) {
        if (index >= 0 && index < this.length) {
            return this.data[index * 7 + 6] == SPECIFIED_TRUE;
        }
        return false;
    }

    public int getIndex(String uri, String localName) {
        int max = this.length * 7;
        for (int i = 0; i < max; i += 7) {
            if (!this.data[i].equals(uri) || !this.data[i + 1].equals(localName)) continue;
            return i / 7;
        }
        return -1;
    }

    public int getIndex(String qName) {
        int max = this.length * 7;
        for (int i = 0; i < max; i += 7) {
            if (!this.data[i + 2].equals(qName)) continue;
            return i / 7;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        int max = this.length * 7;
        for (int i = 0; i < max; i += 7) {
            if (!this.data[i].equals(uri) || !this.data[i + 1].equals(localName)) continue;
            return this.data[i + 3];
        }
        return null;
    }

    public String getType(String qName) {
        int max = this.length * 7;
        for (int i = 0; i < max; i += 7) {
            if (!this.data[i + 2].equals(qName)) continue;
            return this.data[i + 3];
        }
        return null;
    }

    public String getValue(String uri, String localName) {
        int max = this.length * 7;
        for (int i = 0; i < max; i += 7) {
            if (!this.data[i].equals(uri) || !this.data[i + 1].equals(localName)) continue;
            return this.data[i + 4];
        }
        return null;
    }

    public String getValue(String qName) {
        int max = this.length * 7;
        for (int i = 0; i < max; i += 7) {
            if (!this.data[i + 2].equals(qName)) continue;
            return this.data[i + 4];
        }
        return null;
    }

    public void clear() {
        int max = this.length * 7;
        for (int i = 0; i < max; ++i) {
            this.data[i] = null;
        }
        this.length = 0;
    }

    public void setAttributes(Attributes atts) {
        this.clear();
        this.length = atts.getLength();
        if (this.length > 0) {
            this.data = new String[this.length * 7];
            for (int i = 0; i < this.length; ++i) {
                this.data[i * 7] = atts.getURI(i);
                this.data[i * 7 + 1] = atts.getLocalName(i);
                this.data[i * 7 + 2] = atts.getQName(i);
                this.data[i * 7 + 3] = atts.getType(i);
                this.data[i * 7 + 4] = atts.getValue(i);
            }
        }
    }

    public void addAttribute(String uri, String localName, String qName, String type, String value) {
        if (this.ensureCapacity(this.length + 1)) {
            this.data[this.length * 7] = uri;
            this.data[this.length * 7 + 1] = localName;
            this.data[this.length * 7 + 2] = qName;
            this.data[this.length * 7 + 3] = type;
            this.data[this.length * 7 + 4] = value;
            ++this.length;
        }
    }

    public void addAttribute(String uri, String localName, String qName, String type, String value, String defaultValue, boolean isSpecified) {
        if (this.ensureCapacity(this.length + 1)) {
            this.data[this.length * 7] = uri;
            this.data[this.length * 7 + 1] = localName;
            this.data[this.length * 7 + 2] = qName;
            this.data[this.length * 7 + 3] = type;
            this.data[this.length * 7 + 4] = value;
            this.data[this.length * 7 + 5] = defaultValue;
            this.data[this.length * 7 + 6] = isSpecified ? SPECIFIED_TRUE : null;
            ++this.length;
        }
    }

    public void setAttribute(int index, String uri, String localName, String qName, String type, String value) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7] = uri;
            this.data[index * 7 + 1] = localName;
            this.data[index * 7 + 2] = qName;
            this.data[index * 7 + 3] = type;
            this.data[index * 7 + 4] = value;
        } else {
            this.badIndex(index);
        }
    }

    public void setAttribute(int index, String uri, String localName, String qName, String type, String value, String defaultValue, boolean isSpecified) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7] = uri;
            this.data[index * 7 + 1] = localName;
            this.data[index * 7 + 2] = qName;
            this.data[index * 7 + 3] = type;
            this.data[index * 7 + 4] = value;
            this.data[index * 7 + 5] = defaultValue;
            this.data[index * 7 + 6] = isSpecified ? SPECIFIED_TRUE : null;
        } else {
            this.badIndex(index);
        }
    }

    public void removeAttribute(int index) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7] = null;
            this.data[index * 7 + 1] = null;
            this.data[index * 7 + 2] = null;
            this.data[index * 7 + 3] = null;
            this.data[index * 7 + 4] = null;
            this.data[index * 7 + 5] = null;
            this.data[index * 7 + 6] = null;
            if (index < this.length - 1) {
                System.arraycopy(this.data, (index + 1) * 7, this.data, index * 7, (this.length - index - 1) * 7);
            }
            --this.length;
        } else {
            this.badIndex(index);
        }
    }

    public void setURI(int index, String uri) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7] = uri;
        } else {
            this.badIndex(index);
        }
    }

    public void setLocalName(int index, String localName) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7 + 1] = localName;
        } else {
            this.badIndex(index);
        }
    }

    public void setQName(int index, String qName) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7 + 2] = qName;
        } else {
            this.badIndex(index);
        }
    }

    public void setType(int index, String type) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7 + 3] = type;
        } else {
            this.badIndex(index);
        }
    }

    public void setValue(int index, String value) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7 + 4] = value;
        } else {
            this.badIndex(index);
        }
    }

    public void setDefault(int index, String defaultValue) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7 + 5] = defaultValue;
        } else {
            this.badIndex(index);
        }
    }

    public void setSpecified(int index, boolean specified) {
        if (index >= 0 && index < this.length) {
            this.data[index * 7 + 6] = specified ? SPECIFIED_TRUE : null;
        } else {
            this.badIndex(index);
        }
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    void setIdAttributeName(String name) {
        this.idAttributeName = name;
    }

    private boolean ensureCapacity(int n) {
        int max;
        if (n <= 0) {
            return true;
        }
        if (n > 10000) {
            return false;
        }
        if (this.data == null || this.data.length == 0) {
            max = 35;
        } else {
            if (this.data.length >= n * 7) {
                return true;
            }
            max = this.data.length;
        }
        while (max < n * 7) {
            max *= 2;
        }
        String[] newData = new String[max];
        if (this.length > 0) {
            System.arraycopy(this.data, 0, newData, 0, this.length * 7);
        }
        this.data = newData;
        return true;
    }

    private void badIndex(int index) throws ArrayIndexOutOfBoundsException {
        String msg = "Attempt to modify attribute at illegal index: " + index;
        throw new ArrayIndexOutOfBoundsException(msg);
    }
}

