/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.commons.Logger;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.rx.RxConfiguration;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.Rm10PacketAdapter;
import com.sun.xml.ws.rx.rm.runtime.Rm11PacketAdapter;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PacketAdapter {
    private static final Logger LOGGER = Logger.getLogger(PacketAdapter.class);
    private static final String SEQUENCE_PROPERTY = "com.sun.xml.ws.sequence";
    private static final String MESSAGE_NUMBER_PROPERTY = "com.sun.xml.ws.messagenumber";
    Message message;
    private Packet packet;
    private boolean isSequenceDataInit;
    private boolean isAckRequestedHeaderDataInit;
    private String sequenceId;
    private String ackRequestedHeaderSequenceId;
    private long messageNumber;
    private boolean messageConsumed;
    private final RmVersion rmVersion;
    private final SOAPVersion soapVersion;
    private final AddressingVersion addressingVersion;
    private final Unmarshaller jaxbUnmarshaller;

    public static PacketAdapter getInstance(@NotNull RxConfiguration configuration, @NotNull Packet packet) {
        return PacketAdapter.getInstance(configuration.getRmVersion(), configuration.getSoapVersion(), configuration.getAddressingVersion(), packet);
    }

    public static PacketAdapter getInstance(@NotNull RmVersion rmVersion, @NotNull SOAPVersion soapVersion, @NotNull AddressingVersion addressingVersion, @NotNull Packet packet) {
        switch (rmVersion) {
            case WSRM200502: {
                return new Rm10PacketAdapter(soapVersion, addressingVersion, packet);
            }
            case WSRM200702: {
                return new Rm11PacketAdapter(soapVersion, addressingVersion, packet);
            }
        }
        throw new IllegalStateException(LocalizationMessages.WSRM_1104_RM_VERSION_NOT_SUPPORTED(rmVersion.namespaceUri));
    }

    PacketAdapter(@NotNull RmVersion rmVersion, @NotNull SOAPVersion soapVersion, @NotNull AddressingVersion addressingVersion, @NotNull Packet packet) {
        this.rmVersion = rmVersion;
        this.soapVersion = soapVersion;
        this.addressingVersion = addressingVersion;
        this.jaxbUnmarshaller = rmVersion.createUnmarshaller(addressingVersion);
        this.insertPacket(packet);
    }

    void setAckRequestdFlag() {
        this.checkPacketReadyState();
        this.packet.invocationProperties.put(RxConfiguration.ACK_REQUESTED_HEADER_SET, Boolean.TRUE);
    }

    void setExpectReply() {
        this.checkPacketReadyState();
        this.packet.expectReply = Boolean.TRUE;
    }

    private final void insertPacket(Packet packet) {
        this.packet = packet;
        if (packet.getMessage() != null) {
            this.message = packet.getMessage();
        }
    }

    public final void consume() {
        if (this.message != null && !this.messageConsumed) {
            this.messageConsumed = true;
            this.message.consume();
        }
    }

    public final Packet getPacket() {
        return this.packet;
    }

    public final Packet copyPacket(boolean copyMessage) {
        return this.packet.copy(copyMessage);
    }

    public final PacketAdapter createServerResponse(Object jaxbElement, String wsaAction) {
        return PacketAdapter.getInstance(this.rmVersion, this.soapVersion, this.addressingVersion, this.packet.createServerResponse(Messages.create(this.rmVersion.getJaxbContext(this.addressingVersion), jaxbElement, this.soapVersion), this.addressingVersion, this.soapVersion, wsaAction));
    }

    public final PacketAdapter createEmptyServerResponse(String wsaAction) {
        return PacketAdapter.getInstance(this.rmVersion, this.soapVersion, this.addressingVersion, this.packet.createServerResponse(Messages.createEmpty(this.soapVersion), this.addressingVersion, this.soapVersion, wsaAction));
    }

    public final PacketAdapter createAckResponse(Sequence sequence, String wsaAction) throws RxRuntimeException {
        PacketAdapter responseAdapter = this.createEmptyServerResponse(wsaAction);
        responseAdapter.appendSequenceAcknowledgementHeader(sequence);
        return responseAdapter;
    }

    public final PacketAdapter closeTransportAndReturnNull() {
        this.packet.transportBackChannel.close();
        Packet emptyReturnPacket = new Packet();
        emptyReturnPacket.invocationProperties.putAll(this.packet.invocationProperties);
        return PacketAdapter.getInstance(this.rmVersion, this.soapVersion, this.addressingVersion, emptyReturnPacket);
    }

    public final void appendHeader(Object jaxbHeaderContent) throws IllegalStateException {
        this.checkMessageReadyState();
        this.message.getHeaders().add(Headers.create(this.rmVersion.getJaxbContext(this.addressingVersion), jaxbHeaderContent));
    }

    public abstract void appendSequenceHeader(@NotNull String var1, long var2) throws RxRuntimeException;

    protected abstract void appendAckRequestedHeader(@NotNull String var1) throws RxRuntimeException;

    public abstract void appendSequenceAcknowledgementHeader(@NotNull Sequence var1) throws RxRuntimeException;

    public final PacketAdapter keepTransportBackChannelOpen() {
        this.packet.keepTransportBackChannelOpen();
        return this;
    }

    public final PacketAdapter setEmptyRequestMessage(String wsaAction) {
        return this.setRequestMessage(Messages.createEmpty(this.soapVersion), wsaAction);
    }

    public final PacketAdapter setEmptyResponseMessage(PacketAdapter requestAdapter, String wsaAction) {
        this.checkPacketReadyState();
        this.message = Messages.createEmpty(this.soapVersion);
        this.packet.setResponseMessage(requestAdapter.packet, this.message, this.addressingVersion, this.soapVersion, wsaAction);
        return this;
    }

    public final PacketAdapter setRequestMessage(Object jaxbElement, String wsaAction) {
        return this.setRequestMessage(Messages.create(this.rmVersion.getJaxbContext(this.addressingVersion), jaxbElement, this.soapVersion), wsaAction);
    }

    private final PacketAdapter setRequestMessage(Message newMessage, String wsaAction) {
        this.checkPacketReadyState();
        this.message = newMessage;
        this.packet.setMessage(this.message);
        this.message.assertOneWay(false);
        this.message.getHeaders().fillRequestAddressingHeaders(this.packet, this.addressingVersion, this.soapVersion, false, wsaAction);
        return this;
    }

    public final boolean isProtocolMessage() {
        return this.message == null ? false : this.rmVersion.isRmAction(this.getWsaAction());
    }

    public final boolean isProtocolRequest() {
        return this.message == null ? false : this.rmVersion.isRmProtocolRequest(this.getWsaAction());
    }

    public final boolean isProtocolResponse() {
        return this.message == null ? false : this.rmVersion.isRmProtocolResponse(this.getWsaAction());
    }

    public final boolean isRmFault() {
        return this.message == null ? false : this.rmVersion.isRmFault(this.getWsaAction());
    }

    public final boolean isFault() {
        return this.message == null ? false : this.message.isFault();
    }

    public final boolean containsMessage() {
        return this.message != null;
    }

    public final String getWsaAction() {
        this.checkMessageReadyState();
        return this.message.getHeaders().getAction(this.addressingVersion, this.soapVersion);
    }

    public final String getDestination() {
        this.checkMessageReadyState();
        return this.message.getHeaders().getTo(this.addressingVersion, this.soapVersion);
    }

    public final <T> T readHeaderAsUnderstood(String nsUri, String name) throws RxRuntimeException {
        this.checkMessageReadyState();
        Header header = this.message.getHeaders().get(nsUri, name, true);
        if (header == null) {
            return null;
        }
        try {
            Object result = header.readAsJAXB(this.jaxbUnmarshaller);
            return result;
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1122_ERROR_MARSHALLING_RM_HEADER(nsUri + "#" + name), ex));
        }
    }

    public final <T> T unmarshallMessage() throws RxRuntimeException {
        this.checkMessageReadyState();
        try {
            Object result;
            Object t = result = this.message.readPayloadAsJAXB(this.jaxbUnmarshaller);
            return t;
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1123_ERROR_UNMARSHALLING_MESSAGE(), e));
        }
        finally {
            this.messageConsumed = true;
        }
    }

    public final String getSequenceId() throws RxRuntimeException {
        if (!this.isSequenceDataInit) {
            this.initSequenceHeaderData();
            this.isSequenceDataInit = true;
        }
        return this.sequenceId;
    }

    public final long getMessageNumber() throws RxRuntimeException {
        if (!this.isSequenceDataInit) {
            this.initSequenceHeaderData();
            this.isSequenceDataInit = true;
        }
        return this.messageNumber;
    }

    abstract void initSequenceHeaderData() throws RxRuntimeException;

    public final void setSequenceData(String sequenceId, long messageNumber) {
        this.sequenceId = sequenceId;
        this.messageNumber = messageNumber;
    }

    abstract String initAckRequestedHeaderData() throws RxRuntimeException;

    public final String getAckRequestedHeaderSequenceId() throws RxRuntimeException {
        if (!this.isAckRequestedHeaderDataInit) {
            this.ackRequestedHeaderSequenceId = this.initAckRequestedHeaderData();
            this.isAckRequestedHeaderDataInit = true;
        }
        return this.ackRequestedHeaderSequenceId;
    }

    public abstract void processAcknowledgements(SequenceManager var1, String var2) throws RxRuntimeException;

    public Session getSession() {
        String sessionId = (String)this.packet.invocationProperties.get("com.sun.xml.ws.sessionid");
        if (sessionId == null) {
            return null;
        }
        return SessionManager.getSessionManager().getSession(sessionId);
    }

    public boolean hasSession() {
        return this.getSession() != null;
    }

    public void setSession(String sessionId) {
        this.packet.invocationProperties.put("com.sun.xml.ws.sessionid", sessionId);
        Session session = SessionManager.getSessionManager().getSession(sessionId);
        this.packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
    }

    public void exposeSequenceDataToUser() {
        this.packet.invocationProperties.put(SEQUENCE_PROPERTY, this.sequenceId);
        this.packet.invocationProperties.put(MESSAGE_NUMBER_PROPERTY, this.messageNumber);
    }

    public final String getSecurityContextTokenId() {
        Session session = this.getSession();
        return session != null ? session.getSecurityInfo().getIdentifier() : null;
    }

    public final void checkMessageReadyState() throws IllegalStateException {
        if (this.message == null) {
            throw new IllegalStateException("This PacketAdapter instance does not contain a packet with a non-null message");
        }
    }

    public final void checkPacketReadyState() throws IllegalStateException {
        if (this.packet == null) {
            throw new IllegalStateException("This PacketAdapter instance does not contain a packet with a non-null message");
        }
    }

    public final boolean isSecurityContextTokenIdValid(String expectedSctId) {
        String actualSctId = this.getSecurityContextTokenId();
        return expectedSctId != null ? expectedSctId.equals(actualSctId) : actualSctId == null;
    }
}

