/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.impl.policy.verifier.TargetResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetResolverImpl
implements TargetResolver {
    private ProcessingContext ctx = null;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public TargetResolverImpl(ProcessingContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void resolveAndVerifyTargets(List<Target> actualTargets, List<Target> inferredTargets, WSSPolicy actualPolicy) throws XWSSecurityException {
        SignaturePolicy.FeatureBinding fp;
        String policyType = PolicyTypeUtil.signaturePolicy(actualPolicy) ? "Signature" : "Encryption";
        boolean isEndorsing = false;
        if (PolicyTypeUtil.signaturePolicy(actualPolicy) && (fp = (SignaturePolicy.FeatureBinding)actualPolicy.getFeatureBinding()).isEndorsingSignature()) {
            isEndorsing = true;
        }
        for (Target actualTarget : actualTargets) {
            boolean found = false;
            String targetInPolicy = this.getTargetValue(actualTarget);
            for (Target inferredTarget : inferredTargets) {
                String targetInMessage = this.getTargetValue(inferredTarget);
                if (targetInPolicy == null || !targetInPolicy.equals(targetInMessage)) continue;
                found = true;
                break;
            }
            if (found || targetInPolicy == null || !this.presentInMessage(targetInPolicy)) continue;
            log.log(Level.SEVERE, "WSS0206.policy.violation.exception");
            log.log(Level.SEVERE, "Missing target : " + targetInPolicy + " for " + policyType);
            if (isEndorsing) {
                throw new XWSSecurityException("Policy verification error:Missing target " + targetInPolicy + " for Endorsing " + policyType);
            }
            throw new XWSSecurityException("Policy verification error:Missing target " + targetInPolicy + " for " + policyType);
        }
    }

    private String getTargetValue(Target target) {
        String targetInPolicy = null;
        if (target.getType() == "qname") {
            targetInPolicy = target.getQName().getLocalPart();
        } else if (target.getType() == "uri") {
            if (target.getPolicyQName() != null) {
                targetInPolicy = target.getPolicyQName().getLocalPart();
            } else {
                String val = target.getValue();
                String id = null;
                id = val.charAt(0) == '#' ? val.substring(1, val.length()) : val;
                targetInPolicy = this.getElementById(id);
            }
        }
        return targetInPolicy;
    }

    private String getElementById(String id) {
        SecurityContext sc = ((JAXBFilterProcessingContext)this.ctx).getSecurityContext();
        HeaderList headers = sc.getNonSecurityHeaders();
        if (headers != null && headers.size() > 0) {
            ListIterator listItr = headers.listIterator();
            while (listItr.hasNext()) {
                GenericSecuredHeader header = (GenericSecuredHeader)listItr.next();
                if (!header.hasID(id)) continue;
                return header.getLocalPart();
            }
        }
        ArrayList processedHeaders = sc.getProcessedSecurityHeaders();
        for (int j = 0; j < processedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)processedHeaders.get(j);
            if (!id.equals(header.getId())) continue;
            return header.getLocalPart();
        }
        ArrayList bufferedHeaders = sc.getBufferedSecurityHeaders();
        for (int j = 0; j < bufferedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)bufferedHeaders.get(j);
            if (!id.equals(header.getId())) continue;
            return header.getLocalPart();
        }
        return null;
    }

    private boolean presentInMessage(String targetInPolicy) {
        if ("Body".equals(targetInPolicy)) {
            return true;
        }
        SecurityContext sc = ((JAXBFilterProcessingContext)this.ctx).getSecurityContext();
        HeaderList headers = sc.getNonSecurityHeaders();
        if (headers != null && headers.size() > 0) {
            ListIterator listItr = headers.listIterator();
            while (listItr.hasNext()) {
                GenericSecuredHeader header = (GenericSecuredHeader)listItr.next();
                if (header == null || !header.getLocalPart().equals(targetInPolicy)) continue;
                return true;
            }
        }
        ArrayList processedHeaders = sc.getProcessedSecurityHeaders();
        for (int j = 0; j < processedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)processedHeaders.get(j);
            if (header == null || !header.getLocalPart().equals(targetInPolicy)) continue;
            return true;
        }
        ArrayList bufferedHeaders = sc.getBufferedSecurityHeaders();
        for (int j = 0; j < bufferedHeaders.size(); ++j) {
            SecurityHeaderElement header = (SecurityHeaderElement)bufferedHeaders.get(j);
            if (header == null || !header.getLocalPart().equals(targetInPolicy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTargetPresent(List<Target> actualTargets) throws XWSSecurityException {
        for (Target actualTarget : actualTargets) {
            String targetInPolicy = this.getTargetValue(actualTarget);
            if (!this.presentInMessage(targetInPolicy)) continue;
            return true;
        }
        return false;
    }
}

