/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.OneWayFeature;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.ws.tx.common.TxFault;
import com.sun.xml.ws.tx.common.TxLogger;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import org.w3c.dom.Node;

public class WsaHelper {
    private static final TxLogger logger = TxLogger.getLogger(WsaHelper.class);

    static HeaderList getInboundHeaderList(@NotNull WebServiceContext wsContext) {
        MessageContext msgContext = wsContext.getMessageContext();
        return (HeaderList)msgContext.get((Object)"com.sun.xml.ws.api.message.HeaderList");
    }

    public static String getMsgID(@NotNull WebServiceContext wsContext) {
        HeaderList headers = WsaHelper.getInboundHeaderList(wsContext);
        return headers.getMessageID(AddressingVersion.MEMBER, SOAPVersion.SOAP_11);
    }

    public static EndpointReference getReplyTo(@NotNull WebServiceContext wsContext) {
        HeaderList headers = WsaHelper.getInboundHeaderList(wsContext);
        return headers.getReplyTo(AddressingVersion.MEMBER, SOAPVersion.SOAP_11).toSpec();
    }

    public static WSEndpointReference getFaultTo(@NotNull WebServiceContext wsContext) {
        HeaderList headers = WsaHelper.getInboundHeaderList(wsContext);
        return headers.getFaultTo(AddressingVersion.MEMBER, SOAPVersion.SOAP_11);
    }

    @NotNull
    static SOAPFault createFault(@NotNull SOAPVersion soapVer, @NotNull TxFault fault, @NotNull String message) {
        try {
            SOAPFactory soapFactory = soapVer.saajSoapFactory;
            SOAPFault soapFault = soapFactory.createFault();
            if (soapVer == SOAPVersion.SOAP_11) {
                soapFault.setFaultCode(fault.subcode);
                soapFault.setFaultString(fault.reason + ": " + message, Locale.ENGLISH);
            } else {
                soapFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                soapFault.appendFaultSubcode(fault.subcode);
                soapFault.setFaultString(fault.reason + ": " + message, Locale.ENGLISH);
            }
            return soapFault;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static void sendFault(@Nullable WSEndpointReference faultTo, @NotNull EndpointReference replyTo, @NotNull SOAPVersion soapVer, @NotNull TxFault fault, @NotNull String message, @NotNull String msgID) {
        WSEndpointReference to = faultTo != null ? faultTo : new WSEndpointReference(replyTo);
        WSService s = WSService.create();
        QName port = new QName("foo", "bar");
        s.addPort(port, "http://schemas.xmlsoap.org/wsdl/soap/http", to.getAddress());
        OneWayFeature owf = new OneWayFeature();
        owf.setRelatesToID(msgID);
        MemberSubmissionAddressingFeature af = new MemberSubmissionAddressingFeature(true);
        Dispatch<Source> d = s.createDispatch(port, to, Source.class, Service.Mode.PAYLOAD, owf, af);
        d.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
        d.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", fault.actionURI);
        try {
            d.invokeOneWay((Object)new DOMSource((Node)WsaHelper.createFault(soapVer, fault, message)));
        }
        catch (WebServiceException e) {
            logger.finer("sendFault", e.getLocalizedMessage(), e);
        }
    }

    public static void sendFault(@NotNull WebServiceContext wsContext, @NotNull SOAPVersion soapVer, @NotNull TxFault fault, @NotNull String message) {
        String msgID = WsaHelper.getMsgID(wsContext);
        EndpointReference replyTo = WsaHelper.getReplyTo(wsContext);
        WSEndpointReference faultTo = WsaHelper.getFaultTo(wsContext);
        WsaHelper.sendFault(faultTo, replyTo, soapVer, fault, message, msgID);
    }
}

