/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.web;

import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.DirContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.naming.resources.FileDirContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.web.loader.WebappClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
public class WarHandler
extends AbstractArchiveHandler
implements ArchiveHandler {
    private static XMLInputFactory xmlIf = null;
    private static final Logger logger;
    private static final ResourceBundle rb;

    public String getArchiveType() {
        return "war";
    }

    public boolean handles(ReadableArchive archive) {
        if (DeploymentUtils.isEAR((ReadableArchive)archive)) {
            throw new RuntimeException("no container associated with application of type : ear");
        }
        return DeploymentUtils.isWebArchive((ReadableArchive)archive);
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        WebappClassLoader cloader = new WebappClassLoader(parent);
        try {
            FileDirContext r = new FileDirContext();
            File base = new File(context.getSource().getURI());
            r.setDocBase(base.getAbsolutePath());
            SunWebXmlParser sunWebXmlParser = new SunWebXmlParser(base.getAbsolutePath());
            cloader.setResources((DirContext)r);
            cloader.addRepository("WEB-INF/classes/", new File(base, "WEB-INF/classes/"));
            if (context.getArchiveHandler().getClass().getAnnotation(Service.class).name().equals("ear")) {
                for (URL url : this.getManifestLibraries(context)) {
                    cloader.addRepository(url.toString());
                }
            }
            this.configureLoaderAttributes(cloader, sunWebXmlParser, base);
            this.configureLoaderProperties(cloader, sunWebXmlParser, base);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, xse.getMessage());
            logger.log(Level.FINE, xse.getMessage(), xse);
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, fnfe.getMessage());
            logger.log(Level.FINE, fnfe.getMessage(), fnfe);
        }
        try {
            cloader.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cloader;
    }

    private void configureLoaderAttributes(WebappClassLoader cloader, SunWebXmlParser sunWebXmlParser, File base) {
        String[] pathElements;
        String extraClassPath;
        boolean delegate = sunWebXmlParser.isDelegate();
        cloader.setDelegate(delegate);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WebModule[" + sunWebXmlParser.getBase() + "]: Setting delegate to " + delegate);
        }
        if ((extraClassPath = sunWebXmlParser.getExtraClassPath()) != null && (pathElements = extraClassPath.split(";|((?<!\\\\):)")) != null) {
            for (String path : pathElements) {
                path = path.replace("\\:", ":");
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WarHandler[" + sunWebXmlParser.getBase() + "]: Adding " + path + " to the classpath");
                }
                try {
                    URL url = new URL(path);
                    cloader.addRepository(path);
                }
                catch (MalformedURLException mue1) {
                    mue1.printStackTrace();
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(base.getPath(), path);
                    }
                    try {
                        URL url = file.toURI().toURL();
                        cloader.addRepository(url.toString());
                    }
                    catch (MalformedURLException mue2) {
                        mue2.printStackTrace();
                        String msg = rb.getString("webcontainer.classpathError");
                        Object[] params = new Object[]{path};
                        msg = MessageFormat.format(msg, params);
                        logger.log(Level.SEVERE, msg, mue2);
                    }
                }
            }
        }
    }

    private void configureLoaderProperties(WebappClassLoader cloader, SunWebXmlParser sunWebXmlParser, File base) {
        cloader.setUseMyFaces(sunWebXmlParser.isUseBundledJSF());
        File libDir = new File(base, "WEB-INF/lib");
        if (libDir.exists()) {
            int baseFileLen = base.getPath().length();
            final boolean ignoreHiddenJarFiles = sunWebXmlParser.isIgnoreHiddenJarFiles();
            for (File file : libDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    String fileName = pathname.getName();
                    return !(!fileName.endsWith(".jar") && !fileName.endsWith(".zip") || ignoreHiddenJarFiles && fileName.startsWith("."));
                }
            })) {
                try {
                    cloader.addJar(file.getPath().substring(baseFileLen), new JarFile(file), file);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    static {
        xmlIf = XMLInputFactory.newInstance();
        xmlIf.setProperty("javax.xml.stream.supportDTD", false);
        logger = LogDomains.getLogger(WarHandler.class, (String)"javax.enterprise.system.container.web");
        rb = logger.getResourceBundle();
    }

    private class SunWebXmlParser {
        private String baseStr = null;
        private XMLStreamReader parser = null;
        private boolean delegate = true;
        private boolean ignoreHiddenJarFiles = false;
        private boolean useBundledJSF = false;
        private String extraClassPath = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SunWebXmlParser(String baseStr) throws XMLStreamException, FileNotFoundException {
            this.baseStr = baseStr;
            FileInputStream input = null;
            File f = new File(baseStr, "WEB-INF/sun-web.xml");
            if (f.exists()) {
                input = new FileInputStream(f);
                try {
                    this.read(input);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception ex) {}
                    }
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = xmlIf.createXMLStreamReader(input);
            int event = 0;
            boolean inClassLoader = false;
            this.skipRoot("sun-web-app");
            while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                if (event == 1) {
                    String attrName;
                    int i;
                    String value;
                    int count;
                    String name = this.parser.getLocalName();
                    if ("class-loader".equals(name)) {
                        count = this.parser.getAttributeCount();
                        for (int i2 = 0; i2 < count; ++i2) {
                            String attrName2 = this.parser.getAttributeName(i2).getLocalPart();
                            if ("delegate".equals(attrName2)) {
                                this.delegate = Boolean.valueOf(this.parser.getAttributeValue(i2));
                                continue;
                            }
                            if ("extra-class-path".equals(attrName2)) {
                                this.extraClassPath = this.parser.getAttributeValue(i2);
                                continue;
                            }
                            if (!"dynamic-reload-interval".equals(attrName2) || this.parser.getAttributeValue(i2) == null || !logger.isLoggable(Level.WARNING)) continue;
                            logger.log(Level.WARNING, "webcontainer.dynamicReloadInterval");
                        }
                        inClassLoader = true;
                        continue;
                    }
                    if (inClassLoader && "property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                        }
                        if ("ignoreHiddenJarFiles".equals(propName)) {
                            this.ignoreHiddenJarFiles = Boolean.valueOf(value);
                            continue;
                        }
                        Object[] params = new Object[]{propName, value};
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
                        continue;
                    }
                    if ("property".equals(name)) {
                        count = this.parser.getAttributeCount();
                        String propName = null;
                        value = null;
                        for (i = 0; i < count; ++i) {
                            attrName = this.parser.getAttributeName(i).getLocalPart();
                            if ("name".equals(attrName)) {
                                propName = this.parser.getAttributeValue(i);
                                continue;
                            }
                            if (!"value".equals(attrName)) continue;
                            value = this.parser.getAttributeValue(i);
                        }
                        if (propName == null || value == null) {
                            throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                        }
                        if ("useMyFaces".equalsIgnoreCase(propName)) {
                            this.useBundledJSF = Boolean.valueOf(value);
                            continue;
                        }
                        if (!"useBundledJsf".equalsIgnoreCase(propName)) continue;
                        this.useBundledJSF = Boolean.valueOf(value);
                        continue;
                    }
                    this.skipSubTree(name);
                    continue;
                }
                if (!inClassLoader || event != 2 || !"class-loader".equals(this.parser.getLocalName())) continue;
                inClassLoader = false;
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getBase() {
            return this.baseStr;
        }

        boolean isDelegate() {
            return this.delegate;
        }

        boolean isIgnoreHiddenJarFiles() {
            return this.ignoreHiddenJarFiles;
        }

        String getExtraClassPath() {
            return this.extraClassPath;
        }

        boolean isUseBundledJSF() {
            return this.useBundledJSF;
        }
    }
}

